/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.jul.handler.rotating;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tomee.jul.handler.rotating.BackgroundTaskRunner;
import org.apache.tomee.jul.handler.rotating.Duration;
import org.apache.tomee.jul.handler.rotating.Size;

public class LocalFileHandler
extends Handler {
    private static final int BUFFER_SIZE = 8102;
    private long limit = 0L;
    private int bufferSize = -1;
    private Pattern filenameRegex;
    private Pattern archiveFilenameRegex;
    private String filenamePattern = "${catalina.base}/logs/logs.%s.%03d.log";
    private String archiveFormat = "gzip";
    private long dateCheckInterval = TimeUnit.SECONDS.toMillis(5L);
    private long archiveExpiryDuration;
    private int compressionLevel;
    private long purgeExpiryDuration;
    private File archiveDir;
    private volatile int currentIndex;
    private volatile long lastTimestamp;
    private volatile String date;
    private volatile PrintWriter writer;
    private volatile int written;
    private final ReadWriteLock writerLock = new ReentrantReadWriteLock();
    private final Lock backgroundTaskLock = new ReentrantLock();
    private volatile boolean closed;

    public LocalFileHandler() {
        this.configure();
    }

    private void configure() {
        String formatterName;
        int indexIdxEnd2;
        this.date = this.currentDate();
        String className = this.getClass().getName();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        this.dateCheckInterval = new Duration(this.getProperty(className + ".dateCheckInterval", String.valueOf(this.dateCheckInterval))).asMillis();
        this.filenamePattern = LocalFileHandler.replace(this.getProperty(className + ".filenamePattern", this.filenamePattern));
        this.limit = new Size(this.getProperty(className + ".limit", String.valueOf("10 Mega"))).asBytes();
        int lastSep = Math.max(this.filenamePattern.lastIndexOf(47), this.filenamePattern.lastIndexOf(92));
        String fileNameReg = lastSep >= 0 ? this.filenamePattern.substring(lastSep + 1) : this.filenamePattern;
        int indexIdxStart22 = (fileNameReg = fileNameReg.replace("%s", "\\d{4}\\-\\d{2}\\-\\d{2}")).indexOf(37);
        if (indexIdxStart22 >= 0 && (indexIdxEnd2 = fileNameReg.indexOf(100, indexIdxStart22)) >= 0) {
            fileNameReg = fileNameReg.substring(0, indexIdxStart22) + "\\d*" + fileNameReg.substring(indexIdxEnd2 + 1, fileNameReg.length());
        }
        this.filenameRegex = Pattern.compile(fileNameReg);
        this.compressionLevel = Integer.parseInt(this.getProperty(className + ".compressionLevel", String.valueOf(-1)));
        this.archiveExpiryDuration = new Duration(this.getProperty(className + ".archiveOlderThan", String.valueOf("-1 days"))).asMillis();
        this.archiveDir = new File(LocalFileHandler.replace(this.getProperty(className + ".archiveDirectory", "${catalina.base}/logs/archives/")));
        this.archiveFormat = LocalFileHandler.replace(this.getProperty(className + ".archiveFormat", this.archiveFormat));
        this.archiveFilenameRegex = Pattern.compile(fileNameReg + "\\." + this.archiveFormat);
        this.purgeExpiryDuration = new Duration(this.getProperty(className + ".purgeOlderThan", String.valueOf("-1 days"))).asMillis();
        try {
            this.bufferSize = (int)new Size(this.getProperty(className + ".bufferSize", "-1 b")).asBytes();
        }
        catch (NumberFormatException indexIdxStart22) {
            // empty catch block
        }
        String encoding = this.getProperty(className + ".encoding", null);
        if (encoding != null && encoding.length() > 0) {
            try {
                this.setEncoding(encoding);
            }
            catch (UnsupportedEncodingException indexIdxEnd2) {
                // empty catch block
            }
        }
        this.setLevel(Level.parse(this.getProperty(className + ".level", "" + Level.ALL)));
        String filterName = this.getProperty(className + ".filter", null);
        if (filterName != null) {
            try {
                this.setFilter((Filter)Filter.class.cast(cl.loadClass(filterName).newInstance()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((formatterName = this.getProperty(className + ".formatter", null)) != null) {
            try {
                this.setFormatter((Formatter)Formatter.class.cast(cl.loadClass(formatterName).newInstance()));
            }
            catch (Exception e) {
                this.setFormatter(this.newSimpleFormatter(className));
            }
        } else {
            this.setFormatter(this.newSimpleFormatter(className));
        }
        this.setErrorManager(new ErrorManager());
        this.lastTimestamp = System.currentTimeMillis();
    }

    private Formatter newSimpleFormatter(String className) {
        String defaultFormat = System.getProperty("java.util.logging.SimpleFormatter.format", "%1$tb %1$td, %1$tY %1$tl:%1$tM:%1$tS %1$Tp %2$s%n%4$s: %5$s%6$s%n");
        String format = this.getProperty(className + ".formatterPattern", defaultFormat);
        String locale = this.getProperty(className + ".formatterLocale", null);
        return new PatternFormatter(format, locale == null ? Locale.getDefault() : this.newLocale(locale));
    }

    private Locale newLocale(String str) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return new Locale("", "");
        }
        if (str.contains("#")) {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        int len = str.length();
        if (len < 2) {
            throw new IllegalArgumentException("Invalid locale format: " + str);
        }
        char ch0 = str.charAt(0);
        if (ch0 == '_') {
            if (len < 3) {
                throw new IllegalArgumentException("Invalid locale format: " + str);
            }
            char ch1 = str.charAt(1);
            char ch2 = str.charAt(2);
            if (!Character.isUpperCase(ch1) || !Character.isUpperCase(ch2)) {
                throw new IllegalArgumentException("Invalid locale format: " + str);
            }
            if (len == 3) {
                return new Locale("", str.substring(1, 3));
            }
            if (len < 5) {
                throw new IllegalArgumentException("Invalid locale format: " + str);
            }
            if (str.charAt(3) != '_') {
                throw new IllegalArgumentException("Invalid locale format: " + str);
            }
            return new Locale("", str.substring(1, 3), str.substring(4));
        }
        String[] split = str.split("_", -1);
        int occurrences = split.length - 1;
        switch (occurrences) {
            case 0: {
                return new Locale(str.toUpperCase(Locale.ENGLISH));
            }
            case 1: {
                return new Locale(split[0], split[1]);
            }
            case 2: {
                return new Locale(split[0], split[1], split[2]);
            }
        }
        throw new IllegalArgumentException("Invalid locale format: " + str);
    }

    protected String currentDate() {
        return new Timestamp(System.currentTimeMillis()).toString().substring(0, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord record) {
        block13: {
            String tsDate;
            if (!this.isLoggable(record)) {
                return;
            }
            long now = System.currentTimeMillis();
            if (now - this.lastTimestamp > this.dateCheckInterval) {
                this.lastTimestamp = now;
                tsDate = this.currentDate();
            } else {
                tsDate = null;
            }
            try {
                String result;
                this.writerLock.readLock().lock();
                this.rotateIfNeeded(tsDate);
                try {
                    result = this.getFormatter().format(record);
                }
                catch (Exception e) {
                    this.reportError(null, e, 5);
                    this.writerLock.readLock().unlock();
                    return;
                }
                try {
                    if (this.writer != null) {
                        this.writer.write(result);
                        if (this.bufferSize < 0) {
                            this.writer.flush();
                        }
                        break block13;
                    }
                    this.reportError(this.getClass().getSimpleName() + " is closed or not yet initialized, unable to log [" + result + "]", null, 1);
                }
                catch (Exception e) {
                    this.reportError(null, e, 1);
                }
            }
            finally {
                this.writerLock.readLock().unlock();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void rotateIfNeeded(String currentDate) {
        if (!this.closed && this.writer == null) {
            try {
                this.writerLock.readLock().unlock();
                this.writerLock.writeLock().lock();
                if (this.closed || this.writer != null) return;
                this.openWriter();
                return;
            }
            finally {
                this.writerLock.writeLock().unlock();
                this.writerLock.readLock().lock();
            }
        }
        if (!this.shouldRotate(currentDate)) return;
        try {
            this.writerLock.readLock().unlock();
            this.writerLock.writeLock().lock();
            if (!this.shouldRotate(currentDate)) return;
            this.close();
            if (currentDate != null && !this.date.equals(currentDate)) {
                this.currentIndex = 0;
                this.date = currentDate;
            }
            this.openWriter();
            return;
        }
        finally {
            this.writerLock.writeLock().unlock();
            this.writerLock.readLock().lock();
        }
    }

    private boolean shouldRotate(String currentDate) {
        return currentDate != null && !this.date.equals(currentDate) || this.limit > 0L && (long)this.written >= this.limit;
    }

    @Override
    public void close() {
        this.closed = true;
        this.writerLock.writeLock().lock();
        try {
            if (this.writer == null) {
                return;
            }
            this.writer.write(this.getFormatter().getTail(this));
            this.writer.flush();
            this.writer.close();
            this.writer = null;
        }
        catch (Exception e) {
            this.reportError(null, e, 3);
        }
        finally {
            this.writerLock.writeLock().unlock();
        }
        this.backgroundTaskLock.lock();
        this.backgroundTaskLock.unlock();
    }

    @Override
    public void flush() {
        this.writerLock.readLock().lock();
        try {
            this.writer.flush();
        }
        catch (Exception e) {
            this.reportError(null, e, 2);
        }
        finally {
            this.writerLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openWriter() {
        final long beforeRotation = System.currentTimeMillis();
        this.writerLock.writeLock().lock();
        FileOutputStream fos = null;
        OutputStream os = null;
        try {
            File pathname;
            do {
                File parent;
                if (!(parent = (pathname = new File(this.formatFilename(this.filenamePattern, this.date, this.currentIndex))).getParentFile()).isDirectory() && !parent.mkdirs()) {
                    this.reportError("Unable to create [" + parent + "]", null, 4);
                    this.writer = null;
                    return;
                }
                ++this.currentIndex;
            } while (pathname.isFile());
            String encoding = this.getEncoding();
            fos = new FileOutputStream(pathname, true);
            os = new CountingStream(this.bufferSize > 0 ? new BufferedOutputStream(fos, this.bufferSize) : fos);
            this.writer = new PrintWriter((Writer)(encoding != null ? new OutputStreamWriter(os, encoding) : new OutputStreamWriter(os)), false);
            this.writer.write(this.getFormatter().getHead(this));
        }
        catch (Exception e) {
            this.reportError(null, e, 4);
            this.writer = null;
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.writerLock.writeLock().unlock();
        }
        BackgroundTaskRunner.push(new Runnable(){

            @Override
            public void run() {
                LocalFileHandler.this.backgroundTaskLock.lock();
                try {
                    LocalFileHandler.this.evict(beforeRotation);
                }
                catch (Exception e) {
                    LocalFileHandler.this.reportError("Can't do the log eviction", e, 0);
                }
                finally {
                    LocalFileHandler.this.backgroundTaskLock.unlock();
                }
            }
        });
    }

    private void evict(long now) {
        File[] logs;
        BasicFileAttributes attr;
        File[] archives;
        if (this.purgeExpiryDuration > 0L && (archives = this.archiveDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return LocalFileHandler.this.archiveFilenameRegex.matcher(name).matches();
            }
        })) != null) {
            for (File archive : archives) {
                try {
                    attr = Files.readAttributes(archive.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    if (now - attr.creationTime().toMillis() <= this.purgeExpiryDuration || Files.deleteIfExists(archive.toPath())) continue;
                    this.reportError("Can't delete " + archive.getAbsolutePath() + ".", null, 0);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        if (this.archiveExpiryDuration > 0L && (logs = new File(this.formatFilename(this.filenamePattern, "0000-00-00", 0)).getParentFile().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return LocalFileHandler.this.filenameRegex.matcher(name).matches();
            }
        })) != null) {
            for (File file : logs) {
                try {
                    attr = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                    if (attr.creationTime().toMillis() >= now || now - attr.lastModifiedTime().toMillis() <= this.archiveExpiryDuration) continue;
                    this.createArchive(file);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    private String formatFilename(String pattern, String date, int index) {
        return String.format(pattern, date, index);
    }

    private void createArchive(File source) {
        block62: {
            FilterOutputStream outputStream;
            File target = new File(this.archiveDir, source.getName() + "." + this.archiveFormat);
            if (target.isFile()) {
                return;
            }
            File parentFile = target.getParentFile();
            if (!parentFile.isDirectory() && !parentFile.mkdirs()) {
                throw new IllegalStateException("Can't create " + parentFile.getAbsolutePath());
            }
            if (this.archiveFormat.equalsIgnoreCase("gzip")) {
                try {
                    outputStream = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(target)));
                    Throwable throwable = null;
                    try {
                        byte[] buffer = new byte[8102];
                        try (FileInputStream inputStream = new FileInputStream(source);){
                            LocalFileHandler.copyStream(inputStream, outputStream, buffer);
                            break block62;
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    catch (Throwable buffer) {
                        throwable = buffer;
                        throw buffer;
                    }
                    finally {
                        if (outputStream != null) {
                            if (throwable != null) {
                                try {
                                    ((OutputStream)outputStream).close();
                                }
                                catch (Throwable buffer) {
                                    throwable.addSuppressed(buffer);
                                }
                            } else {
                                ((OutputStream)outputStream).close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            try {
                outputStream = new ZipOutputStream(new FileOutputStream(target));
                Throwable throwable = null;
                try {
                    ((ZipOutputStream)outputStream).setLevel(this.compressionLevel);
                    byte[] buffer = new byte[8102];
                    try (FileInputStream inputStream = new FileInputStream(source);){
                        ZipEntry zipEntry = new ZipEntry(source.getName());
                        ((ZipOutputStream)outputStream).putNextEntry(zipEntry);
                        LocalFileHandler.copyStream(inputStream, outputStream, buffer);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (outputStream != null) {
                        if (throwable != null) {
                            try {
                                ((ZipOutputStream)outputStream).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((ZipOutputStream)outputStream).close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        try {
            if (!Files.deleteIfExists(source.toPath())) {
                this.reportError("Can't delete " + source.getAbsolutePath() + ".", null, 0);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void copyStream(InputStream inputStream, OutputStream outputStream, byte[] buffer) throws IOException {
        int n;
        while ((n = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, n);
        }
    }

    protected String getProperty(String name, String defaultValue) {
        String value = LogManager.getLogManager().getProperty(name);
        value = value == null ? defaultValue : value.trim();
        return value;
    }

    protected static String replace(String str) {
        String result = str;
        int start = str.indexOf("${");
        if (start >= 0) {
            StringBuilder builder = new StringBuilder();
            int end = -1;
            while (start >= 0) {
                String replacement;
                builder.append(str, end + 1, start);
                end = str.indexOf(125, start + 2);
                if (end < 0) {
                    end = start - 1;
                    break;
                }
                String propName = str.substring(start + 2, end);
                String string = replacement = !propName.isEmpty() ? System.getProperty(propName) : null;
                if (replacement == null) {
                    replacement = System.getenv(propName);
                }
                if (replacement != null) {
                    builder.append(replacement);
                } else {
                    builder.append(str, start, end + 1);
                }
                start = str.indexOf("${", end + 1);
            }
            builder.append(str, end + 1, str.length());
            result = builder.toString();
        }
        return result;
    }

    public static class PatternFormatter
    extends Formatter {
        private final ThreadLocal<Date> date = new ThreadLocal<Date>(){

            @Override
            protected Date initialValue() {
                return new Date();
            }
        };
        private final String format;
        private final Locale locale;

        public PatternFormatter(String format, Locale locale) {
            this.format = format;
            this.locale = locale;
        }

        @Override
        public String format(LogRecord record) {
            String source;
            Date date = this.date.get();
            date.setTime(record.getMillis());
            String sourceClassName = record.getSourceClassName();
            String sourceMethodName = record.getSourceMethodName();
            if (sourceClassName != null) {
                source = sourceClassName;
                if (sourceMethodName != null) {
                    source = source + " " + sourceMethodName;
                }
            } else {
                source = record.getLoggerName();
            }
            String message = this.formatMessage(record);
            String throwable = "";
            Throwable thrown = record.getThrown();
            if (thrown != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println();
                thrown.printStackTrace(pw);
                pw.close();
                throwable = sw.toString();
            }
            return String.format(this.locale, this.format, date, source, record.getLoggerName(), Locale.ENGLISH == this.locale ? record.getLevel().getName() : record.getLevel().getLocalizedName(), message, throwable, sourceClassName == null ? source : sourceClassName, sourceMethodName == null ? source : sourceMethodName);
        }
    }

    private final class CountingStream
    extends OutputStream {
        private final OutputStream out;

        private CountingStream(OutputStream out) {
            this.out = out;
            LocalFileHandler.this.written = 0;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
            LocalFileHandler.this.written++;
        }

        @Override
        public void write(byte[] buff) throws IOException {
            this.out.write(buff);
            LocalFileHandler.this.written = LocalFileHandler.this.written + buff.length;
        }

        @Override
        public void write(byte[] buff, int off, int len) throws IOException {
            this.out.write(buff, off, len);
            LocalFileHandler.this.written = LocalFileHandler.this.written + len;
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

