/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.TypedQuery;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenRegistration;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.AbstractOAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.tokens.bearer.BearerAccessToken;
import org.apache.cxf.rs.security.oauth2.tokens.refresh.RefreshToken;

public class JPAOAuthDataProvider
extends AbstractOAuthDataProvider {
    private static final String CLIENT_QUERY = "SELECT client FROM Client client INNER JOIN client.resourceOwnerSubject ros";
    private EntityManagerFactory entityManagerFactory;

    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.entityManagerFactory = emf;
    }

    @Override
    public Client doGetClient(String clientId) throws OAuthServiceException {
        return (Client)this.execute(em -> (Client)em.find(Client.class, (Object)clientId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T execute(EntityManagerOperation<T> operation) {
        Object value;
        EntityManager em = this.getEntityManager();
        try {
            value = operation.apply(em);
        }
        finally {
            this.closeIfNeeded(em);
        }
        return (T)value;
    }

    protected <T> T executeInTransaction(EntityManagerOperation<T> operation) {
        Object value;
        EntityManager em = this.getEntityManager();
        EntityTransaction transaction = null;
        try {
            transaction = this.beginIfNeeded(em);
            value = operation.apply(em);
            this.flushIfNeeded(em);
            this.commitIfNeeded(em);
        }
        catch (RuntimeException e) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw e;
        }
        finally {
            this.closeIfNeeded(em);
        }
        return (T)value;
    }

    @Override
    public void setClient(Client client) {
        this.executeInTransaction(em -> {
            boolean clientExists;
            if (client.getResourceOwnerSubject() != null) {
                UserSubject sub = (UserSubject)em.find(UserSubject.class, (Object)client.getResourceOwnerSubject().getId());
                if (sub == null) {
                    em.persist((Object)client.getResourceOwnerSubject());
                } else {
                    client.setResourceOwnerSubject(sub);
                }
            }
            boolean bl = clientExists = (Long)em.createQuery("SELECT count(client) from Client client where client.clientId = :id", Long.class).setParameter("id", (Object)client.getClientId()).getSingleResult() > 0L;
            if (clientExists) {
                em.merge((Object)client);
            } else {
                em.persist((Object)client);
            }
            return null;
        });
    }

    @Override
    protected void doRemoveClient(Client c) {
        this.executeInTransaction(em -> {
            Client clientToRemove = (Client)em.getReference(Client.class, (Object)c.getClientId());
            em.remove((Object)clientToRemove);
            return null;
        });
    }

    @Override
    public List<Client> getClients(UserSubject resourceOwner) {
        return (List)this.execute(em -> this.getClientsQuery(resourceOwner, (EntityManager)em).getResultList());
    }

    @Override
    public List<ServerAccessToken> getAccessTokens(Client c, UserSubject sub) {
        return (List)this.execute(em -> CastUtils.cast(this.getTokensQuery(c, sub, (EntityManager)em).getResultList()));
    }

    @Override
    public List<RefreshToken> getRefreshTokens(Client c, UserSubject sub) {
        return (List)this.execute(em -> this.getRefreshTokensQuery(c, sub, (EntityManager)em).getResultList());
    }

    @Override
    public ServerAccessToken getAccessToken(String accessToken) throws OAuthServiceException {
        return (ServerAccessToken)this.execute(em -> {
            TypedQuery query = em.createQuery("SELECT t FROM BearerAccessToken t WHERE t.tokenKey = :tokenKey", BearerAccessToken.class).setParameter("tokenKey", (Object)accessToken);
            if (query.getResultList().isEmpty()) {
                return null;
            }
            return (BearerAccessToken)query.getSingleResult();
        });
    }

    @Override
    protected void doRevokeAccessToken(ServerAccessToken at) {
        this.executeInTransaction(em -> {
            ServerAccessToken tokenToRemove = (ServerAccessToken)em.getReference(at.getClass(), (Object)at.getTokenKey());
            em.remove((Object)tokenToRemove);
            return null;
        });
    }

    @Override
    protected void linkRefreshTokenToAccessToken(RefreshToken rt, ServerAccessToken at) {
        super.linkRefreshTokenToAccessToken(rt, at);
        this.executeInTransaction(em -> {
            em.merge((Object)at);
            return null;
        });
    }

    @Override
    protected RefreshToken getRefreshToken(String refreshTokenKey) {
        return (RefreshToken)this.execute(em -> (RefreshToken)em.find(RefreshToken.class, (Object)refreshTokenKey));
    }

    @Override
    protected void doRevokeRefreshToken(RefreshToken rt) {
        this.executeInTransaction(em -> {
            RefreshToken tokentoRemove = (RefreshToken)em.getReference(RefreshToken.class, (Object)rt.getTokenKey());
            em.remove((Object)tokentoRemove);
            return null;
        });
    }

    @Override
    protected ServerAccessToken doCreateAccessToken(AccessTokenRegistration atReg) {
        ServerAccessToken at = super.doCreateAccessToken(atReg);
        if (at.getAudiences() != null) {
            at.setAudiences(new ArrayList<String>(at.getAudiences()));
        }
        if (at.getExtraProperties() != null) {
            at.setExtraProperties(new HashMap<String, String>(at.getExtraProperties()));
        }
        if (at.getScopes() != null) {
            at.setScopes(new ArrayList<OAuthPermission>(at.getScopes()));
        }
        if (at.getParameters() != null) {
            at.setParameters(new HashMap<String, String>(at.getParameters()));
        }
        return at;
    }

    @Override
    protected void saveAccessToken(ServerAccessToken serverToken) {
        this.executeInTransaction(em -> {
            LinkedList<OAuthPermission> perms = new LinkedList<OAuthPermission>();
            for (OAuthPermission perm : serverToken.getScopes()) {
                OAuthPermission permSaved = (OAuthPermission)em.find(OAuthPermission.class, (Object)perm.getPermission());
                if (permSaved != null) {
                    perms.add(permSaved);
                    continue;
                }
                em.persist((Object)perm);
                perms.add(perm);
            }
            serverToken.setScopes(perms);
            if (serverToken.getSubject() != null) {
                UserSubject sub = (UserSubject)em.find(UserSubject.class, (Object)serverToken.getSubject().getId());
                if (sub == null) {
                    em.persist((Object)serverToken.getSubject());
                } else {
                    sub = (UserSubject)em.merge((Object)serverToken.getSubject());
                    serverToken.setSubject(sub);
                }
            }
            if (serverToken.getClient() != null) {
                serverToken.setClient((Client)em.find(Client.class, (Object)serverToken.getClient().getClientId()));
            }
            em.persist((Object)serverToken);
            return null;
        });
    }

    @Override
    protected void saveRefreshToken(RefreshToken refreshToken) {
        this.persistEntity(refreshToken);
    }

    protected void persistEntity(Object entity) {
        this.executeInTransaction(em -> {
            em.persist(entity);
            return null;
        });
    }

    protected void removeEntity(Object entity) {
        this.executeInTransaction(em -> {
            em.remove(entity);
            return null;
        });
    }

    protected TypedQuery<Client> getClientsQuery(UserSubject resourceOwnerSubject, EntityManager entityManager) {
        if (resourceOwnerSubject == null) {
            return entityManager.createQuery(CLIENT_QUERY, Client.class);
        }
        return entityManager.createQuery("SELECT client FROM Client client INNER JOIN client.resourceOwnerSubject ros WHERE ros.login = :login", Client.class).setParameter("login", (Object)resourceOwnerSubject.getLogin());
    }

    protected TypedQuery<BearerAccessToken> getTokensQuery(Client c, UserSubject resourceOwnerSubject, EntityManager entityManager) {
        return JPAOAuthDataProvider.getQuery("BearerAccessToken", c, resourceOwnerSubject, entityManager, BearerAccessToken.class);
    }

    protected TypedQuery<RefreshToken> getRefreshTokensQuery(Client c, UserSubject resourceOwnerSubject, EntityManager entityManager) {
        return JPAOAuthDataProvider.getQuery("RefreshToken", c, resourceOwnerSubject, entityManager, RefreshToken.class);
    }

    private static <T> TypedQuery<T> getQuery(String table, Client c, UserSubject resourceOwnerSubject, EntityManager entityManager, Class<T> resultClass) {
        StringBuilder query = new StringBuilder("SELECT t FROM ").append(table).append(" t");
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        if (c != null || resourceOwnerSubject != null) {
            query.append(" WHERE");
            if (c != null) {
                query.append(" t.client.clientId = :clientId");
                parameterMap.put("clientId", c.getClientId());
            }
            if (resourceOwnerSubject != null) {
                if (!parameterMap.isEmpty()) {
                    query.append(" AND");
                }
                query.append(" t.subject.login = :login");
                parameterMap.put("login", resourceOwnerSubject.getLogin());
            }
        }
        TypedQuery typedQuery = entityManager.createQuery(query.toString(), resultClass);
        for (Map.Entry entry : parameterMap.entrySet()) {
            typedQuery.setParameter((String)entry.getKey(), entry.getValue());
        }
        return typedQuery;
    }

    protected EntityManager getEntityManager() {
        return this.entityManagerFactory.createEntityManager();
    }

    protected EntityTransaction beginIfNeeded(EntityManager em) {
        EntityTransaction tx = em.getTransaction();
        tx.begin();
        return tx;
    }

    protected void flushIfNeeded(EntityManager em) {
        em.flush();
    }

    protected void commitIfNeeded(EntityManager em) {
        em.getTransaction().commit();
    }

    protected void closeIfNeeded(EntityManager em) {
        em.close();
    }

    public static interface EntityManagerOperation<T>
    extends Function<EntityManager, T> {
    }
}

