/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.openjpa.lib.jdbc.ConnectionDecorator;
import org.apache.openjpa.lib.jdbc.DelegatingConnection;

public class ConfiguringConnectionDecorator
implements ConnectionDecorator {
    private int _isolation = -1;
    private int _queryTimeout = -1;
    private Boolean _autoCommit = null;

    public int getQueryTimeout() {
        return this._queryTimeout;
    }

    public void setQueryTimeout(int timeout) {
        this._queryTimeout = timeout;
    }

    public int getTransactionIsolation() {
        return this._isolation;
    }

    public void setTransactionIsolation(int isolation) {
        this._isolation = isolation;
    }

    public Boolean getAutoCommit() {
        return this._autoCommit;
    }

    public void setAutoCommit(Boolean autoCommit) {
        this._autoCommit = autoCommit;
    }

    @Override
    public Connection decorate(Connection conn) throws SQLException {
        if (this._isolation == 0 || this._queryTimeout != -1 || this._autoCommit != null) {
            conn = new ConfiguringConnection(conn);
        }
        if (this._isolation != -1 && this._isolation != 0) {
            conn.setTransactionIsolation(this._isolation);
        }
        return conn;
    }

    public class ConfiguringConnection
    extends DelegatingConnection {
        private boolean _curAutoCommit;

        public ConfiguringConnection(Connection conn) throws SQLException {
            super(conn);
            this._curAutoCommit = false;
            if (ConfiguringConnectionDecorator.this._autoCommit != null) {
                this._curAutoCommit = this.getAutoCommit();
                if (this._curAutoCommit != ConfiguringConnectionDecorator.this._autoCommit) {
                    this.setAutoCommit(ConfiguringConnectionDecorator.this._autoCommit);
                }
            }
        }

        @Override
        public void setAutoCommit(boolean auto) throws SQLException {
            if (ConfiguringConnectionDecorator.this._isolation != 0) {
                super.setAutoCommit(auto);
                this._curAutoCommit = auto;
            }
        }

        @Override
        public void commit() throws SQLException {
            if (ConfiguringConnectionDecorator.this._isolation != 0) {
                super.commit();
            }
            if (ConfiguringConnectionDecorator.this._autoCommit != null && ConfiguringConnectionDecorator.this._autoCommit != this._curAutoCommit) {
                this.setAutoCommit(ConfiguringConnectionDecorator.this._autoCommit);
            }
        }

        @Override
        public void rollback() throws SQLException {
            if (ConfiguringConnectionDecorator.this._isolation != 0) {
                super.rollback();
            }
            if (ConfiguringConnectionDecorator.this._autoCommit != null && ConfiguringConnectionDecorator.this._autoCommit != this._curAutoCommit) {
                this.setAutoCommit(ConfiguringConnectionDecorator.this._autoCommit);
            }
        }

        @Override
        protected PreparedStatement prepareStatement(String sql2, boolean wrap) throws SQLException {
            PreparedStatement stmnt = super.prepareStatement(sql2, wrap);
            if (ConfiguringConnectionDecorator.this._queryTimeout != -1) {
                stmnt.setQueryTimeout(ConfiguringConnectionDecorator.this._queryTimeout);
            }
            return stmnt;
        }

        @Override
        protected PreparedStatement prepareStatement(String sql2, int rsType, int rsConcur, boolean wrap) throws SQLException {
            PreparedStatement stmnt = super.prepareStatement(sql2, rsType, rsConcur, wrap);
            if (ConfiguringConnectionDecorator.this._queryTimeout != -1) {
                stmnt.setQueryTimeout(ConfiguringConnectionDecorator.this._queryTimeout);
            }
            return stmnt;
        }

        @Override
        protected Statement createStatement(boolean wrap) throws SQLException {
            Statement stmnt = super.createStatement(wrap);
            if (ConfiguringConnectionDecorator.this._queryTimeout != -1) {
                stmnt.setQueryTimeout(ConfiguringConnectionDecorator.this._queryTimeout);
            }
            return stmnt;
        }

        @Override
        protected Statement createStatement(int rsType, int rsConcur, boolean wrap) throws SQLException {
            Statement stmnt = super.createStatement(rsType, rsConcur, wrap);
            if (ConfiguringConnectionDecorator.this._queryTimeout != -1) {
                stmnt.setQueryTimeout(ConfiguringConnectionDecorator.this._queryTimeout);
            }
            return stmnt;
        }
    }
}

