/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.jaxrs;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;

public class MPJWTSecurityAnnotationsInterceptor
implements ContainerRequestFilter {
    private final ResourceInfo resourceInfo;
    private final ConcurrentMap<Method, Set<String>> rolesAllowed;
    private final Set<Method> denyAll;
    private final Set<Method> permitAll;

    public MPJWTSecurityAnnotationsInterceptor(ResourceInfo resourceInfo, ConcurrentMap<Method, Set<String>> rolesAllowed, Set<Method> denyAll, Set<Method> permitAll) {
        this.resourceInfo = resourceInfo;
        this.rolesAllowed = rolesAllowed;
        this.denyAll = denyAll;
        this.permitAll = permitAll;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (this.permitAll.contains(this.resourceInfo.getResourceMethod())) {
            return;
        }
        if (this.denyAll.contains(this.resourceInfo.getResourceMethod())) {
            this.forbidden(requestContext);
            return;
        }
        Set roles = (Set)this.rolesAllowed.get(this.resourceInfo.getResourceMethod());
        if (roles != null && !roles.isEmpty()) {
            SecurityContext securityContext = requestContext.getSecurityContext();
            boolean hasAtLeasOneValidRole = false;
            for (String role : roles) {
                if (!securityContext.isUserInRole(role)) continue;
                hasAtLeasOneValidRole = true;
                break;
            }
            if (!hasAtLeasOneValidRole) {
                this.forbidden(requestContext);
            }
        }
    }

    private void forbidden(ContainerRequestContext requestContext) {
        requestContext.abortWith(Response.status((int)403).build());
    }
}

