/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.inject.spi.DeploymentException;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.stream.JsonParsingException;
import org.apache.tomee.microprofile.jwt.config.JWTAuthConfigurationProperties;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;

public class PublicKeyResolver {
    public Optional<Map<String, Key>> resolve(Optional<String> publicKeyContents, Optional<String> publicKeyLocation) {
        Stream<Supplier> possiblePublicKeys = Stream.of(() -> publicKeyContents.map(this::readPublicKeys), () -> publicKeyLocation.map(this::readPublicKeysFromLocation));
        return possiblePublicKeys.map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    public Map<String, Key> readPublicKeys(String publicKey) {
        Stream<Supplier> possiblePublicKeysParses = Stream.of(() -> this.parsePCKS8(publicKey), () -> this.parseJwk(publicKey), () -> this.parseJwkDecoded(publicKey), () -> this.parseJwks(publicKey), () -> this.parseJwksDecoded(publicKey));
        return possiblePublicKeysParses.map(Supplier::get).filter(keys -> !keys.isEmpty()).findFirst().orElseThrow(() -> new DeploymentException(": " + publicKey));
    }

    private Map<String, Key> readPublicKeysFromLocation(String publicKeyLocation) {
        Stream<Supplier> possiblePublicKeysLocations = Stream.of(() -> this.readPublicKeysFromClasspath(publicKeyLocation), () -> this.readPublicKeysFromFile(publicKeyLocation), () -> this.readPublicKeysFromHttp(publicKeyLocation), () -> this.readPublicKeysFromUrl(publicKeyLocation));
        return possiblePublicKeysLocations.map(Supplier::get).filter(Optional::isPresent).map(Optional::get).findFirst().map(this::readPublicKeys).orElseThrow(() -> new DeploymentException("Could not read MicroProfile Public Key from Location: " + publicKeyLocation));
    }

    private Optional<String> readPublicKeysFromClasspath(String publicKeyLocation) {
        try {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(publicKeyLocation);
            if (is == null) {
                return Optional.empty();
            }
            return Optional.of(this.readPublicKeyFromInputStream(is));
        }
        catch (IOException e) {
            throw new DeploymentException("Could not read MicroProfile Public Key from Location: " + publicKeyLocation, (Throwable)e);
        }
    }

    private Optional<String> readPublicKeysFromFile(String publicKeyLocation) {
        if (!publicKeyLocation.startsWith("file")) {
            return Optional.empty();
        }
        try {
            URL locationURL = new URL(publicKeyLocation);
            File publicKeyFile = new File(locationURL.toURI());
            if (!publicKeyFile.exists() || publicKeyFile.isDirectory()) {
                throw new DeploymentException("Could not read MicroProfile Public Key from Location: " + publicKeyLocation + ". File does not exist or it is a directory.");
            }
            return Optional.of(this.readPublicKeyFromInputStream(locationURL.openStream()));
        }
        catch (IOException | URISyntaxException e) {
            throw new DeploymentException("Could not read MicroProfile Public Key from Location: " + publicKeyLocation, (Throwable)e);
        }
    }

    private Optional<String> readPublicKeysFromHttp(String publicKeyLocation) {
        if (!publicKeyLocation.startsWith("http")) {
            return Optional.empty();
        }
        try {
            URL locationURL = new URL(publicKeyLocation);
            return Optional.of(this.readPublicKeyFromInputStream(locationURL.openStream()));
        }
        catch (IOException e) {
            throw new DeploymentException("Could not read MicroProfile Public Key from Location: " + publicKeyLocation, (Throwable)e);
        }
    }

    private Optional<String> readPublicKeysFromUrl(String publicKeyLocation) {
        try {
            URL locationURL = new URL(publicKeyLocation);
            return Optional.of(this.readPublicKeyFromInputStream(locationURL.openStream()));
        }
        catch (IOException e) {
            throw new DeploymentException("Could not read MicroProfile Public Key from Location: " + publicKeyLocation, (Throwable)e);
        }
    }

    private String readPublicKeyFromInputStream(InputStream publicKey) throws IOException {
        StringWriter content = new StringWriter();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(publicKey));){
            String line = reader.readLine();
            while (line != null) {
                content.write(line);
                content.write(10);
                line = reader.readLine();
            }
        }
        return content.toString();
    }

    private Map<String, Key> parsePCKS8(String publicKey) {
        try {
            X509EncodedKeySpec spec = new X509EncodedKeySpec(this.normalizeAndDecodePCKS8(publicKey));
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return Collections.singletonMap(null, kf.generatePublic(spec));
        }
        catch (IllegalArgumentException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            return Collections.emptyMap();
        }
    }

    private Map<String, Key> parseJwk(String publicKey) {
        JsonObject jwk;
        try {
            jwk = Json.createReader((Reader)new StringReader(publicKey)).readObject();
        }
        catch (JsonParsingException e) {
            return Collections.emptyMap();
        }
        if (jwk.containsKey((Object)"keys")) {
            return Collections.emptyMap();
        }
        this.validateJwk(jwk);
        try {
            JsonWebKey key = JsonWebKey.Factory.newJwk((String)publicKey);
            return Collections.singletonMap(key.getKeyId(), key.getKey());
        }
        catch (JoseException e) {
            throw new DeploymentException("Could not read MicroProfile Public Key JWK.", (Throwable)e);
        }
    }

    private Map<String, Key> parseJwkDecoded(String publicKey) {
        String publicKeyDecoded;
        try {
            publicKeyDecoded = new String(Base64.getDecoder().decode(publicKey));
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
        return this.parseJwk(publicKeyDecoded);
    }

    private Map<String, Key> parseJwks(String publicKey) {
        JsonObject jwks;
        try {
            jwks = Json.createReader((Reader)new StringReader(publicKey)).readObject();
        }
        catch (JsonParsingException e) {
            return Collections.emptyMap();
        }
        try {
            JsonArray keys = jwks.getJsonArray("keys");
            for (JsonValue key : keys) {
                this.validateJwk(key.asJsonObject());
            }
        }
        catch (Exception e) {
            throw new DeploymentException("MicroProfile Public Key JWKS invalid format.");
        }
        try {
            JsonWebKeySet keySet = new JsonWebKeySet(publicKey);
            Map<String, Key> keys = keySet.getJsonWebKeys().stream().collect(Collectors.toMap(JsonWebKey::getKeyId, JsonWebKey::getKey));
            return Collections.unmodifiableMap(keys);
        }
        catch (JoseException e) {
            throw new DeploymentException("Could not read MicroProfile Public Key JWK.", (Throwable)e);
        }
    }

    private Map<String, Key> parseJwksDecoded(String publicKey) {
        String publicKeyDecoded;
        try {
            publicKeyDecoded = new String(Base64.getDecoder().decode(publicKey));
        }
        catch (Exception e) {
            return Collections.emptyMap();
        }
        return this.parseJwks(publicKeyDecoded);
    }

    private void validateJwk(JsonObject jwk) {
        String keyType = jwk.getString("kty", null);
        if (keyType == null) {
            throw new DeploymentException("MicroProfile Public Key JWK kty field is missing.");
        }
        if (!JWTAuthConfigurationProperties.JWK_SUPPORTED_KEY_TYPES.contains(keyType)) {
            throw new DeploymentException("MicroProfile Public Key JWK kty not supported: " + keyType);
        }
    }

    private byte[] normalizeAndDecodePCKS8(String publicKey) {
        if (publicKey.contains("PRIVATE KEY")) {
            throw new DeploymentException("MicroProfile Public Key is Private.");
        }
        String normalizedKey = publicKey.replaceAll("-----BEGIN (.*)-----", "").replaceAll("-----END (.*)----", "").replaceAll("\r\n", "").replaceAll("\n", "");
        return Base64.getDecoder().decode(normalizedKey);
    }
}

