/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.bval;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.function.Supplier;
import javax.validation.ConstraintViolation;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Response;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.microprofile.jwt.JWTLogCategories;
import org.apache.tomee.microprofile.jwt.bval.ValidationConstraintException;
import org.apache.tomee.microprofile.jwt.bval.ValidationConstraints;
import org.eclipse.microprofile.jwt.JsonWebToken;

public class ValidationInterceptor
implements ContainerRequestFilter {
    private static final Logger CONSTRAINT = Logger.getInstance((LogCategory)JWTLogCategories.CONSTRAINT, ValidationInterceptor.class);
    private static final Logger VALIDATION = Logger.getInstance((LogCategory)JWTLogCategories.CONSTRAINT, ValidationInterceptor.class);
    public static final String JWT_SUPPLIER = JsonWebToken.class.getName() + ".Supplier";
    private final ResourceInfo resourceInfo;
    private final ValidationConstraints constraints;

    public ValidationInterceptor(ResourceInfo resourceInfo, ValidationConstraints constraints) {
        this.resourceInfo = resourceInfo;
        this.constraints = constraints;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        try {
            Set<ConstraintViolation<Object>> violations;
            Supplier tokenSupplier = (Supplier)requestContext.getProperty(JWT_SUPPLIER);
            if (tokenSupplier == null) {
                VALIDATION.debug("No JsonWebToken found in request attribute '" + JWT_SUPPLIER + "'");
                return;
            }
            JsonWebToken jsonWebToken = (JsonWebToken)tokenSupplier.get();
            if (jsonWebToken == null) {
                VALIDATION.error("No JsonWebToken returned from supplier");
                return;
            }
            String id = jsonWebToken.claim("jti").orElse("<jti missing>") + "";
            Method resourceMethod = this.resourceInfo.getResourceMethod();
            try {
                violations = this.constraints.validate(resourceMethod, jsonWebToken);
            }
            catch (Throwable e) {
                VALIDATION.error("Constraint Validation Error: " + e.getMessage(), e);
                throw new ValidationConstraintException(jsonWebToken, e);
            }
            if (violations.size() == 0) {
                VALIDATION.debug("Constraint Validation Passed: " + id);
                return;
            }
            for (ConstraintViolation<Object> violation : violations) {
                String message = violation.getMessage();
                Class<? extends Annotation> annotationType = violation.getConstraintDescriptor().getAnnotation().annotationType();
                CONSTRAINT.warning("@" + annotationType.getSimpleName() + ": " + message + " : '" + id + "'");
            }
            VALIDATION.warning("JWT '" + id + "' invalid, " + violations.size() + " constraints failed");
            this.forbidden(requestContext);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void forbidden(ContainerRequestContext requestContext) {
        requestContext.abortWith(Response.status((int)403).build());
    }
}

