/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.resource.ResourceException;
import javax.resource.spi.DissociatableManagedConnection;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.apache.commons.lang3.ClassUtils;
import org.apache.geronimo.connector.outbound.ConnectionInfo;
import org.apache.geronimo.connector.outbound.ConnectionReturnAction;
import org.apache.geronimo.connector.outbound.ConnectionTrackingInterceptor;
import org.apache.geronimo.connector.outbound.ManagedConnectionInfo;
import org.apache.geronimo.connector.outbound.connectiontracking.ConnectionTracker;
import org.apache.geronimo.transaction.manager.TransactionImpl;
import org.apache.openejb.dyni.DynamicSubclass;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.proxy.LocalBeanProxyFactory;

public class AutoConnectionTracker
implements ConnectionTracker {
    private static final String KEY = "AutoConnectionTracker_Connections";
    private final TransactionSynchronizationRegistry registry;
    private final TransactionManager txMgr;
    private final Logger logger = Logger.getInstance(LogCategory.OPENEJB_CONNECTOR, "org.apache.openejb.resource");
    private final ConcurrentMap<ManagedConnectionInfo, ProxyPhantomReference> references = new ConcurrentHashMap<ManagedConnectionInfo, ProxyPhantomReference>();
    private final ReferenceQueue referenceQueue = new ReferenceQueue();
    private final ConcurrentMap<Class<?>, Class<?>> proxies = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, Class<?>[]> interfaces = new ConcurrentHashMap();
    private final boolean cleanupLeakedConnections;

    public AutoConnectionTracker(boolean cleanupLeakedConnections) {
        this.cleanupLeakedConnections = cleanupLeakedConnections;
        this.registry = SystemInstance.get().getComponent(TransactionSynchronizationRegistry.class);
        this.txMgr = SystemInstance.get().getComponent(TransactionManager.class);
    }

    public Set<ManagedConnectionInfo> connections() {
        return this.references.keySet();
    }

    public void setEnvironment(ConnectionInfo connectionInfo, String key) {
        ProxyPhantomReference reference = (ProxyPhantomReference)this.referenceQueue.poll();
        while (reference != null) {
            reference.clear();
            this.references.remove(reference.managedConnectionInfo);
            if (this.cleanupLeakedConnections) {
                ConnectionInfo released = new ConnectionInfo(reference.managedConnectionInfo);
                reference.interceptor.returnConnection(released, ConnectionReturnAction.DESTROY);
            }
            this.logger.warning("Detected abandoned connection " + reference.managedConnectionInfo + " opened at " + AutoConnectionTracker.stackTraceToString(reference.stackTrace));
            reference = (ProxyPhantomReference)this.referenceQueue.poll();
        }
    }

    public void handleObtained(ConnectionTrackingInterceptor interceptor, ConnectionInfo connectionInfo, boolean reassociate) throws ResourceException {
        if (this.txMgr != null && this.registry != null) {
            try {
                final TransactionImpl currentTx = (TransactionImpl)this.txMgr.getTransaction();
                if (currentTx != null) {
                    HashMap<ConnectionInfo, Object> connectionObjects;
                    HashMap<ManagedConnectionInfo, HashMap<ConnectionInfo, Object>> txConnections = (HashMap<ManagedConnectionInfo, HashMap<ConnectionInfo, Object>>)this.registry.getResource((Object)KEY);
                    if (txConnections == null) {
                        txConnections = new HashMap<ManagedConnectionInfo, HashMap<ConnectionInfo, Object>>();
                        this.registry.putResource((Object)KEY, txConnections);
                    }
                    if ((connectionObjects = (HashMap<ConnectionInfo, Object>)txConnections.get(connectionInfo.getManagedConnectionInfo())) == null) {
                        connectionObjects = new HashMap<ConnectionInfo, Object>();
                        txConnections.put(connectionInfo.getManagedConnectionInfo(), connectionObjects);
                    }
                    connectionObjects.put(connectionInfo, connectionInfo.getConnectionProxy());
                    this.registry.registerInterposedSynchronization(new Synchronization(){

                        public void beforeCompletion() {
                        }

                        public void afterCompletion(int status) {
                            Map txConnections = (Map)currentTx.getResource((Object)AutoConnectionTracker.KEY);
                            if (txConnections != null && txConnections.size() > 0) {
                                for (ManagedConnectionInfo managedConnectionInfo : txConnections.keySet()) {
                                    StringBuilder sb = new StringBuilder();
                                    Set connectionInfos = ((Map)txConnections.get(managedConnectionInfo)).keySet();
                                    for (ConnectionInfo connectionInfo : connectionInfos) {
                                        sb.append("\n  ").append("Connection handle opened at ").append(AutoConnectionTracker.stackTraceToString(connectionInfo.getTrace().getStackTrace()));
                                    }
                                    AutoConnectionTracker.this.logger.warning("Transaction complete, but connection still has handles associated: " + managedConnectionInfo + "\nAbandoned connection information: " + sb.toString());
                                }
                            }
                        }
                    });
                }
            }
            catch (ClassCastException | SystemException throwable) {
                // empty catch block
            }
        }
        if (!reassociate) {
            this.proxyConnection(interceptor, connectionInfo);
        }
    }

    public void handleReleased(ConnectionTrackingInterceptor interceptor, ConnectionInfo connectionInfo, ConnectionReturnAction action) {
        PhantomReference phantomReference;
        TransactionImpl currentTx = null;
        try {
            currentTx = (TransactionImpl)this.txMgr.getTransaction();
        }
        catch (ClassCastException | SystemException throwable) {
            // empty catch block
        }
        if (currentTx != null) {
            HashMap<ManagedConnectionInfo, Map> txConnections = (HashMap<ManagedConnectionInfo, Map>)currentTx.getResource((Object)KEY);
            if (txConnections == null) {
                txConnections = new HashMap<ManagedConnectionInfo, Map>();
                this.registry.putResource((Object)KEY, txConnections);
            }
            Map connectionObjects = txConnections.computeIfAbsent(connectionInfo.getManagedConnectionInfo(), k -> new HashMap());
            connectionObjects.remove(connectionInfo);
            if (connectionObjects.size() == 0) {
                txConnections.remove(connectionInfo.getManagedConnectionInfo());
            }
        }
        if ((phantomReference = (PhantomReference)this.references.remove(connectionInfo.getManagedConnectionInfo())) != null) {
            phantomReference.clear();
        }
    }

    private void proxyConnection(ConnectionTrackingInterceptor interceptor, ConnectionInfo connectionInfo) throws ResourceException {
        if (connectionInfo.getConnectionProxy() != null) {
            return;
        }
        if (connectionInfo.getManagedConnectionInfo().getManagedConnection() instanceof DissociatableManagedConnection) {
            return;
        }
        try {
            Object handle = connectionInfo.getConnectionHandle();
            ConnectionInvocationHandler invocationHandler = new ConnectionInvocationHandler(handle);
            Object proxy = this.newProxy(handle, invocationHandler);
            connectionInfo.setConnectionProxy(proxy);
            ProxyPhantomReference reference = new ProxyPhantomReference(interceptor, connectionInfo.getManagedConnectionInfo(), invocationHandler, this.referenceQueue);
            this.references.put(connectionInfo.getManagedConnectionInfo(), reference);
        }
        catch (Throwable e) {
            throw new ResourceException("Unable to construct connection proxy", e);
        }
    }

    private Object newProxy(Object handle, InvocationHandler invocationHandler) {
        ClassLoader loader = handle.getClass().getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if (!Proxy.isProxyClass(handle.getClass())) {
            Object proxy = LocalBeanProxyFactory.Unsafe.allocateInstance(this.getProxy(handle.getClass(), loader));
            DynamicSubclass.setHandler(proxy, invocationHandler);
            return proxy;
        }
        return Proxy.newProxyInstance(loader, this.getAPi(handle.getClass()), invocationHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?>[] getAPi(Class<?> aClass) {
        Class[] found = (Class[])this.interfaces.get(aClass);
        if (found == null) {
            AutoConnectionTracker autoConnectionTracker = this;
            synchronized (autoConnectionTracker) {
                found = (Class[])this.interfaces.get(aClass);
                if (found == null) {
                    List allInterfaces = ClassUtils.getAllInterfaces(aClass);
                    Class[] asArray = allInterfaces.toArray(new Class[allInterfaces.size()]);
                    this.interfaces.put(aClass, asArray);
                    found = (Class[])this.interfaces.get(aClass);
                }
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> getProxy(Class<?> aClass, ClassLoader loader) {
        Class found = (Class)this.proxies.get(aClass);
        if (found == null) {
            AutoConnectionTracker autoConnectionTracker = this;
            synchronized (autoConnectionTracker) {
                found = (Class)this.proxies.get(aClass);
                if (found == null) {
                    this.proxies.put(aClass, DynamicSubclass.createSubclass(aClass, loader, true));
                    found = (Class)this.proxies.get(aClass);
                }
            }
        }
        return found;
    }

    public static String stackTraceToString(StackTraceElement[] stackTrace) {
        if (stackTrace == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement element = stackTrace[i];
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(element.toString());
        }
        return sb.toString();
    }

    private static class ProxyPhantomReference
    extends PhantomReference<ConnectionInvocationHandler> {
        private final ConnectionTrackingInterceptor interceptor;
        private final ManagedConnectionInfo managedConnectionInfo;
        private StackTraceElement[] stackTrace;

        public ProxyPhantomReference(ConnectionTrackingInterceptor interceptor, ManagedConnectionInfo managedConnectionInfo, ConnectionInvocationHandler handler, ReferenceQueue referenceQueue) {
            super(handler, referenceQueue);
            this.interceptor = interceptor;
            this.managedConnectionInfo = managedConnectionInfo;
            this.stackTrace = Thread.currentThread().getStackTrace();
        }
    }

    public static class ConnectionInvocationHandler
    implements InvocationHandler {
        private final Object handle;

        public ConnectionInvocationHandler(Object handle) {
            this.handle = handle;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                if (method.getName().equals("finalize")) {
                    return null;
                }
                if (method.getName().equals("clone")) {
                    throw new CloneNotSupportedException();
                }
            }
            try {
                return method.invoke(this.handle, args);
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getTargetException();
                if (AbstractMethodError.class.isInstance(t)) {
                    Logger.getInstance(LogCategory.OPENEJB, AutoConnectionTracker.class).error("Missing method: " + method + " on " + this.handle);
                }
                if (t != null) {
                    throw t;
                }
                throw ite;
            }
        }
    }
}

