/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership.cloud;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.catalina.tribes.membership.cloud.AbstractStreamProvider;
import org.apache.catalina.tribes.membership.cloud.InsecureStreamProvider;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class TokenStreamProvider
extends AbstractStreamProvider {
    private static final Log log = LogFactory.getLog(TokenStreamProvider.class);
    private String token;
    private String caCertFile;
    private SSLSocketFactory factory;

    TokenStreamProvider(String token, String caCertFile) throws Exception {
        this.token = token;
        this.caCertFile = caCertFile;
        TrustManager[] trustManagers = this.configureCaCert(this.caCertFile);
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, trustManagers, null);
        this.factory = context.getSocketFactory();
    }

    @Override
    protected SSLSocketFactory getSocketFactory() {
        return this.factory;
    }

    @Override
    public InputStream openStream(String url, Map<String, String> headers, int connectTimeout, int readTimeout) throws IOException {
        if (this.token != null) {
            headers.put("Authorization", "Bearer " + this.token);
        }
        try {
            return super.openStream(url, headers, connectTimeout, readTimeout);
        }
        catch (IOException e) {
            throw new IOException(sm.getString("tokenStream.failedConnection", url, this.token, this.caCertFile), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TrustManager[] configureCaCert(String caCertFile) throws Exception {
        if (caCertFile == null) {
            log.warn((Object)sm.getString("tokenStream.CACertUndefined"));
            return InsecureStreamProvider.INSECURE_TRUST_MANAGERS;
        }
        try (BufferedInputStream pemInputStream = new BufferedInputStream(new FileInputStream(caCertFile));){
            CertificateFactory certFactory = CertificateFactory.getInstance("X509");
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(pemInputStream);
            KeyStore trustStore = KeyStore.getInstance("JKS");
            trustStore.load(null);
            String alias = cert.getSubjectX500Principal().getName();
            trustStore.setCertificateEntry(alias, cert);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(trustStore);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            return trustManagerArray;
        }
        catch (FileNotFoundException fnfe) {
            log.error((Object)sm.getString("tokenStream.fileNotFound", caCertFile));
            throw fnfe;
        }
        catch (Exception e) {
            log.error((Object)sm.getString("tokenStream.trustManagerError", caCertFile), (Throwable)e);
            throw e;
        }
    }
}

