/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.descriptor.TaglibDescriptor;
import org.apache.jasper.compiler.JarScannerFactory;
import org.apache.jasper.compiler.Localizer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.JarScanType;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.descriptor.tld.TaglibXml;
import org.apache.tomcat.util.descriptor.tld.TldParser;
import org.apache.tomcat.util.descriptor.tld.TldResourcePath;
import org.apache.tomcat.util.scan.Jar;
import org.apache.tomcat.util.scan.JarFactory;
import org.xml.sax.SAXException;

public class TldScanner {
    private static final Log log = LogFactory.getLog(TldScanner.class);
    private static final String MSG = "org.apache.jasper.servlet.TldScanner";
    private static final String TLD_EXT = ".tld";
    private static final String WEB_INF = "/WEB-INF/";
    private final ServletContext context;
    private final TldParser tldParser;
    private final Map<String, TldResourcePath> taglibMap = new HashMap<String, TldResourcePath>();
    private final Map<TldResourcePath, TaglibXml> tldCache = new HashMap<TldResourcePath, TaglibXml>();
    private final List<String> listeners = new ArrayList<String>();

    public TldScanner(ServletContext context, boolean namespaceAware, boolean validation) {
        this.context = context;
        this.tldParser = new TldParser(namespaceAware, validation);
    }

    public void scan() throws IOException, SAXException {
        this.scanPlatform();
        this.scanJspConfig();
        this.scanResourcePaths(WEB_INF);
        this.scanJars();
    }

    public Map<String, TldResourcePath> getTaglibMap() {
        return this.taglibMap;
    }

    public List<String> getListeners() {
        return this.listeners;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.tldParser.setClassLoader(classLoader);
    }

    protected void scanPlatform() {
    }

    protected void scanJspConfig() throws IOException, SAXException {
        JspConfigDescriptor jspConfigDescriptor = this.context.getJspConfigDescriptor();
        if (jspConfigDescriptor == null) {
            return;
        }
        Collection descriptors = jspConfigDescriptor.getTaglibs();
        for (TaglibDescriptor descriptor : descriptors) {
            String taglibURI = descriptor.getTaglibURI();
            String resourcePath = descriptor.getTaglibLocation();
            if (!resourcePath.startsWith("/")) {
                resourcePath = WEB_INF + resourcePath;
            }
            if (this.taglibMap.containsKey(taglibURI)) {
                log.warn((Object)Localizer.getMessage("org.apache.jasper.servlet.TldScanner.webxmlSkip", resourcePath, taglibURI));
                continue;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)Localizer.getMessage("org.apache.jasper.servlet.TldScanner.webxmlAdd", resourcePath, taglibURI));
            }
            URL url = this.context.getResource(resourcePath);
            TldResourcePath tldResourcePath = resourcePath.endsWith(".jar") ? new TldResourcePath(url, "META-INF/taglib.tld") : new TldResourcePath(url);
            TaglibXml tld = this.tldParser.parse(tldResourcePath);
            this.taglibMap.put(taglibURI, tldResourcePath);
            this.tldCache.put(tldResourcePath, tld);
            if (tld.getListeners() == null) continue;
            this.listeners.addAll(tld.getListeners());
        }
    }

    protected void scanResourcePaths(String startPath) throws IOException, SAXException {
        Set dirList = this.context.getResourcePaths(startPath);
        if (dirList != null) {
            for (String path : dirList) {
                if (path.startsWith("/WEB-INF/classes/") || path.startsWith("/WEB-INF/lib/")) continue;
                if (path.endsWith("/")) {
                    this.scanResourcePaths(path);
                    continue;
                }
                if (path.startsWith("/WEB-INF/tags/")) {
                    if (!path.endsWith("/implicit.tld")) continue;
                    this.parseTld(path);
                    continue;
                }
                if (!path.endsWith(TLD_EXT)) continue;
                this.parseTld(path);
            }
        }
    }

    public void scanJars() {
        JarScanner scanner = JarScannerFactory.getJarScanner(this.context);
        TldScannerCallback callback = new TldScannerCallback();
        scanner.scan(JarScanType.TLD, this.context, (JarScannerCallback)callback);
        if (callback.scanFoundNoTLDs()) {
            log.info((Object)Localizer.getMessage("jsp.tldCache.noTldSummary"));
        }
    }

    private void parseTld(String resourcePath) throws IOException, SAXException {
        TldResourcePath tldResourcePath = new TldResourcePath(this.context.getResource(resourcePath));
        this.parseTld(tldResourcePath);
    }

    private void parseTld(TldResourcePath path) throws IOException, SAXException {
        TaglibXml tld = this.tldParser.parse(path);
        String uri = tld.getUri();
        if (uri != null && !this.taglibMap.containsKey(uri)) {
            this.taglibMap.put(uri, path);
        }
        this.tldCache.put(path, tld);
        if (tld.getListeners() != null) {
            this.listeners.addAll(tld.getListeners());
        }
    }

    private class TldScannerCallback
    implements JarScannerCallback {
        private boolean tldFound = false;
        private boolean jarFound = false;

        private TldScannerCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scan(JarURLConnection urlConn, boolean isWebapp) throws IOException {
            if (!this.jarFound) {
                this.jarFound = true;
            }
            boolean found = false;
            Jar jar = JarFactory.newInstance((URL)urlConn.getURL());
            URL jarURL = jar.getJarFileURL();
            try {
                jar.nextEntry();
                String entryName = jar.getEntryName();
                while (entryName != null) {
                    if (entryName.startsWith("META-INF/") && entryName.endsWith(TldScanner.TLD_EXT)) {
                        found = true;
                        TldResourcePath tldResourcePath = new TldResourcePath(jarURL, entryName);
                        try {
                            TldScanner.this.parseTld(tldResourcePath);
                        }
                        catch (SAXException e) {
                            throw new IOException(e);
                        }
                    }
                    jar.nextEntry();
                    entryName = jar.getEntryName();
                }
            }
            finally {
                jar.close();
            }
            if (found) {
                this.tldFound = true;
            } else if (log.isDebugEnabled()) {
                log.debug((Object)Localizer.getMessage("jsp.tldCache.noTldInJar", jarURL.toString()));
            }
        }

        public void scan(File file, boolean isWebapp) throws IOException {
            File metaInf;
            if (!this.jarFound) {
                this.jarFound = true;
            }
            if (!(metaInf = new File(file, "META-INF")).isDirectory()) {
                return;
            }
            Files.walkFileTree(metaInf.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!file.endsWith(TldScanner.TLD_EXT)) {
                        return FileVisitResult.CONTINUE;
                    }
                    try {
                        URL url = file.toUri().toURL();
                        TldResourcePath path = new TldResourcePath(url);
                        TldScanner.this.parseTld(path);
                        TldScannerCallback.this.tldFound = true;
                    }
                    catch (SAXException e) {
                        throw new IOException(e);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        public void scanWebInfClasses() throws IOException {
        }

        private boolean scanFoundNoTLDs() {
            return this.jarFound && !this.tldFound;
        }
    }
}

