/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.apache.jasper.Constants;
import org.apache.jasper.compiler.Localizer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.xml.sax.InputSource;

public class WebXml {
    private static final String FILE_PROTOCOL = "file:";
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private final Log log = LogFactory.getLog(WebXml.class);
    private InputStream is;
    private InputSource ip;
    private String systemId;

    public WebXml(ServletContext ctxt) throws IOException {
        String altDDName;
        String webXml = (String)ctxt.getAttribute("org.apache.tomcat.util.scan.MergedWebXml");
        if (webXml != null) {
            this.is = new ByteArrayInputStream(webXml.getBytes());
            this.systemId = "org.apache.tomcat.util.scan.MergedWebXml";
        }
        if (this.is == null && (altDDName = (String)ctxt.getAttribute(Constants.ALT_DD_ATTR)) != null) {
            try {
                URL uri = new URL(FILE_PROTOCOL + altDDName.replace('\\', '/'));
                this.is = uri.openStream();
                this.systemId = uri.toExternalForm();
            }
            catch (MalformedURLException e) {
                this.log.warn((Object)Localizer.getMessage("jsp.error.internal.filenotfound", altDDName));
            }
        }
        if (this.is == null) {
            URL uri = ctxt.getResource(WEB_XML);
            if (uri == null) {
                this.log.warn((Object)Localizer.getMessage("jsp.error.internal.filenotfound", WEB_XML));
            } else {
                this.is = uri.openStream();
                this.systemId = uri.toExternalForm();
            }
        }
        if (this.is == null) {
            this.systemId = null;
        } else {
            this.ip = new InputSource(this.is);
            this.ip.setSystemId(this.systemId);
        }
    }

    public String getSystemId() {
        return this.systemId;
    }

    public InputSource getInputSource() {
        return this.ip;
    }

    public void close() {
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException e) {
                this.log.error((Object)Localizer.getMessage("jsp.error.stream.close.failed"));
            }
        }
    }
}

