/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.maven.plugin.tomcat7.run;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import org.apache.catalina.loader.WebappLoader;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.filtering.MavenFileFilterRequest;
import org.apache.maven.shared.filtering.MavenFilteringException;
import org.apache.tomcat.maven.common.run.ClassLoaderEntriesCalculator;
import org.apache.tomcat.maven.common.run.ClassLoaderEntriesCalculatorRequest;
import org.apache.tomcat.maven.common.run.ClassLoaderEntriesCalculatorResult;
import org.apache.tomcat.maven.common.run.TomcatRunException;
import org.apache.tomcat.maven.plugin.tomcat7.run.AbstractRunMojo;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="run", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
@Execute(phase=LifecyclePhase.PROCESS_CLASSES)
public class RunMojo
extends AbstractRunMojo {
    @Parameter(defaultValue="${project.artifacts}", required=true, readonly=true)
    private Set<Artifact> dependencies;
    @Parameter(defaultValue="${basedir}/src/main/webapp", property="tomcat.warSourceDirectory")
    private File warSourceDirectory;
    @Parameter(property="tomcat.delegate", defaultValue="true")
    private boolean delegate = true;
    @Component
    private ClassLoaderEntriesCalculator classLoaderEntriesCalculator;
    @Parameter(property="maven.tomcat.addWarDependenciesInClassloader", defaultValue="true")
    private boolean addWarDependenciesInClassloader;
    @Parameter(property="maven.tomcat.useTestClasspath", defaultValue="false")
    private boolean useTestClasspath;
    @Parameter(alias="additionalClassesDirs")
    private List<String> additionalClasspathDirs;

    protected File getDocBase() throws IOException {
        if (!this.warSourceDirectory.exists()) {
            final File tempDocBase = RunMojo.createTempDirectory(new File(this.project.getBuild().getDirectory()));
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    try {
                        FileUtils.deleteDirectory((File)tempDocBase);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            return tempDocBase;
        }
        return this.warSourceDirectory;
    }

    private static File createTempDirectory(File baseTmpDirectory) throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()), baseTmpDirectory);
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected File getContextFile() throws MojoExecutionException {
        StringWriter sw;
        FileWriter fw;
        FileReader fr;
        File temporaryContextFile;
        block8: {
            File sb2222222;
            temporaryContextFile = null;
            fr = null;
            fw = null;
            sw = new StringWriter();
            try {
                temporaryContextFile = File.createTempFile("tomcat-maven-plugin", "temp-ctx-file");
                temporaryContextFile.deleteOnExit();
                if (this.contextFile != null && this.contextFile.exists()) {
                    MavenFileFilterRequest mavenFileFilterRequest = new MavenFileFilterRequest();
                    mavenFileFilterRequest.setFrom(this.contextFile);
                    mavenFileFilterRequest.setTo(temporaryContextFile);
                    mavenFileFilterRequest.setMavenProject(this.project);
                    mavenFileFilterRequest.setMavenSession(this.session);
                    mavenFileFilterRequest.setFiltering(true);
                    this.mavenFileFilter.copyFile(mavenFileFilterRequest);
                    fr = new FileReader(temporaryContextFile);
                    Xpp3Dom xpp3Dom = Xpp3DomBuilder.build((Reader)fr);
                    xpp3Dom.setAttribute("backgroundProcessorDelay", Integer.toString(this.backgroundProcessorDelay));
                    xpp3Dom.setAttribute("reloadable", Boolean.toString(this.isContextReloadable()));
                    fw = new FileWriter(temporaryContextFile);
                    Xpp3DomWriter.write((Writer)fw, (Xpp3Dom)xpp3Dom);
                    Xpp3DomWriter.write((Writer)sw, (Xpp3Dom)xpp3Dom);
                    this.getLog().debug((CharSequence)(" generated context file " + sw.toString()));
                    break block8;
                }
                if (this.contextReloadable) {
                    StringBuilder sb2222222 = new StringBuilder("<Context ").append("backgroundProcessorDelay=\"").append(Integer.toString(this.backgroundProcessorDelay)).append("\"").append(" reloadable=\"" + Boolean.toString(this.isContextReloadable()) + "\"/>");
                    this.getLog().debug((CharSequence)(" generated context file " + sb2222222.toString()));
                    fw = new FileWriter(temporaryContextFile);
                    fw.write(sb2222222.toString());
                    break block8;
                }
                sb2222222 = null;
            }
            catch (IOException e) {
                try {
                    this.getLog().error((CharSequence)("error creating fake context.xml : " + e.getMessage()), (Throwable)e);
                    throw new MojoExecutionException("error creating fake context.xml : " + e.getMessage(), (Exception)e);
                    catch (XmlPullParserException e2) {
                        this.getLog().error((CharSequence)("error creating fake context.xml : " + e2.getMessage()), (Throwable)e2);
                        throw new MojoExecutionException("error creating fake context.xml : " + e2.getMessage(), (Exception)((Object)e2));
                    }
                    catch (MavenFilteringException e3) {
                        this.getLog().error((CharSequence)("error filtering context.xml : " + e3.getMessage()), (Throwable)e3);
                        throw new MojoExecutionException("error filtering context.xml : " + e3.getMessage(), (Exception)((Object)e3));
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(fw);
                    IOUtil.close(fr);
                    IOUtil.close((Writer)sw);
                    throw throwable;
                }
            }
            IOUtil.close(fw);
            IOUtil.close(fr);
            IOUtil.close((Writer)sw);
            return sb2222222;
        }
        IOUtil.close((Writer)fw);
        IOUtil.close((Reader)fr);
        IOUtil.close((Writer)sw);
        return temporaryContextFile;
    }

    protected WebappLoader createWebappLoader() throws IOException, MojoExecutionException {
        WebappLoader loader = super.createWebappLoader();
        if (this.useSeparateTomcatClassLoader) {
            loader.setDelegate(this.delegate);
        }
        try {
            ClassLoaderEntriesCalculatorRequest request = new ClassLoaderEntriesCalculatorRequest().setDependencies(this.dependencies).setLog(this.getLog()).setMavenProject(this.project).setAddWarDependenciesInClassloader(this.addWarDependenciesInClassloader).setUseTestClassPath(this.useTestClasspath);
            ClassLoaderEntriesCalculatorResult classLoaderEntriesCalculatorResult = this.classLoaderEntriesCalculator.calculateClassPathEntries(request);
            List classLoaderEntries = classLoaderEntriesCalculatorResult.getClassPathEntries();
            final List tmpDirectories = classLoaderEntriesCalculatorResult.getTmpDirectories();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    for (File tmpDir : tmpDirectories) {
                        try {
                            FileUtils.deleteDirectory((File)tmpDir);
                        }
                        catch (IOException iOException) {}
                    }
                }
            });
            if (classLoaderEntries != null) {
                for (String classLoaderEntry : classLoaderEntries) {
                    loader.addRepository(classLoaderEntry);
                }
            }
            if (this.additionalClasspathDirs != null && !this.additionalClasspathDirs.isEmpty()) {
                for (String additionalClasspathDir : this.additionalClasspathDirs) {
                    File file;
                    if (!StringUtils.isNotBlank((String)additionalClasspathDir) || !(file = new File(additionalClasspathDir)).exists()) continue;
                    String fileUri = file.toURI().toString();
                    this.getLog().debug((CharSequence)("add file:" + fileUri + " as a additionalClasspathDir"));
                    loader.addRepository(fileUri);
                }
            }
        }
        catch (TomcatRunException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        return loader;
    }
}

