/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.tomcat.util;

final class XReflectionIntrospectionUtils {

    static boolean isEnabled() {
        return true;
    }

    private static java.net.InetAddress getInetAddress(String value) {
        try {
            return java.net.InetAddress.getByName(value);
        } catch (java.net.UnknownHostException x) { throw new RuntimeException(x); }
    }

    static Object getPropertyInternal(Object o, String name) {
        Class<?> checkThisClass = o.getClass();
        Object result = null;
        while (checkThisClass != Object.class && result == null) {
            switch (checkThisClass.getName()) {
                case "org.apache.catalina.authenticator.jaspic.SimpleAuthConfigProvider" : 
                    result = getPropertyForOrgApacheCatalinaAuthenticatorJaspicSimpleAuthConfigProvider(o, name);
                    break;
                case "org.apache.catalina.authenticator.jaspic.PersistentProviderRegistrations$Property" : 
                    result = getPropertyForOrgApacheCatalinaAuthenticatorJaspicPersistentProviderRegistrationsProperty(o, name);
                    break;
                case "org.apache.catalina.authenticator.jaspic.PersistentProviderRegistrations$Provider" : 
                    result = getPropertyForOrgApacheCatalinaAuthenticatorJaspicPersistentProviderRegistrationsProvider(o, name);
                    break;
                case "org.apache.catalina.connector.Connector" : 
                    result = getPropertyForOrgApacheCatalinaConnectorConnector(o, name);
                    break;
                case "org.apache.catalina.core.StandardContext" : 
                    result = getPropertyForOrgApacheCatalinaCoreStandardContext(o, name);
                    break;
                case "org.apache.catalina.core.StandardEngine" : 
                    result = getPropertyForOrgApacheCatalinaCoreStandardEngine(o, name);
                    break;
                case "org.apache.catalina.core.StandardHost" : 
                    result = getPropertyForOrgApacheCatalinaCoreStandardHost(o, name);
                    break;
                case "org.apache.catalina.core.StandardServer" : 
                    result = getPropertyForOrgApacheCatalinaCoreStandardServer(o, name);
                    break;
                case "org.apache.catalina.core.StandardService" : 
                    result = getPropertyForOrgApacheCatalinaCoreStandardService(o, name);
                    break;
                case "org.apache.catalina.realm.UserDatabaseRealm" : 
                    result = getPropertyForOrgApacheCatalinaRealmUserDatabaseRealm(o, name);
                    break;
                case "org.apache.catalina.valves.AccessLogValve" : 
                    result = getPropertyForOrgApacheCatalinaValvesAccessLogValve(o, name);
                    break;
                case "org.apache.catalina.filters.AddDefaultCharsetFilter" : 
                    result = getPropertyForOrgApacheCatalinaFiltersAddDefaultCharsetFilter(o, name);
                    break;
                case "org.apache.catalina.filters.RestCsrfPreventionFilter" : 
                    result = getPropertyForOrgApacheCatalinaFiltersRestCsrfPreventionFilter(o, name);
                    break;
                case "org.apache.catalina.loader.ParallelWebappClassLoader" : 
                    result = getPropertyForOrgApacheCatalinaLoaderParallelWebappClassLoader(o, name);
                    break;
                case "java.net.URLClassLoader" : 
                    result = getPropertyForJavaNetURLClassLoader(o, name);
                    break;
                case "java.security.SecureClassLoader" : 
                    result = getPropertyForJavaSecuritySecureClassLoader(o, name);
                    break;
                case "org.apache.coyote.ajp.AjpNio2Protocol" : 
                    result = getPropertyForOrgApacheCoyoteAjpAjpNio2Protocol(o, name);
                    break;
                case "org.apache.coyote.ajp.AjpNioProtocol" : 
                    result = getPropertyForOrgApacheCoyoteAjpAjpNioProtocol(o, name);
                    break;
                case "org.apache.coyote.http11.Http11Nio2Protocol" : 
                    result = getPropertyForOrgApacheCoyoteHttp11Http11Nio2Protocol(o, name);
                    break;
                case "org.apache.coyote.http11.Http11NioProtocol" : 
                    result = getPropertyForOrgApacheCoyoteHttp11Http11NioProtocol(o, name);
                    break;
                case "org.apache.tomcat.util.descriptor.web.ContextResource" : 
                    result = getPropertyForOrgApacheTomcatUtilDescriptorWebContextResource(o, name);
                    break;
                case "org.apache.tomcat.util.descriptor.web.ResourceBase" : 
                    result = getPropertyForOrgApacheTomcatUtilDescriptorWebResourceBase(o, name);
                    break;
                case "org.apache.tomcat.util.modeler.AttributeInfo" : 
                    result = getPropertyForOrgApacheTomcatUtilModelerAttributeInfo(o, name);
                    break;
                case "org.apache.tomcat.util.modeler.OperationInfo" : 
                    result = getPropertyForOrgApacheTomcatUtilModelerOperationInfo(o, name);
                    break;
                case "org.apache.tomcat.util.modeler.ParameterInfo" : 
                    result = getPropertyForOrgApacheTomcatUtilModelerParameterInfo(o, name);
                    break;
                case "org.apache.tomcat.util.modeler.FeatureInfo" : 
                    result = getPropertyForOrgApacheTomcatUtilModelerFeatureInfo(o, name);
                    break;
                case "org.apache.tomcat.util.modeler.ManagedBean" : 
                    result = getPropertyForOrgApacheTomcatUtilModelerManagedBean(o, name);
                    break;
                case "org.apache.tomcat.util.net.Nio2Endpoint" : 
                    result = getPropertyForOrgApacheTomcatUtilNetNio2Endpoint(o, name);
                    break;
                case "org.apache.tomcat.util.net.NioEndpoint" : 
                    result = getPropertyForOrgApacheTomcatUtilNetNioEndpoint(o, name);
                    break;
                case "org.apache.tomcat.util.net.SocketProperties" : 
                    result = getPropertyForOrgApacheTomcatUtilNetSocketProperties(o, name);
                    break;
            }
            checkThisClass = checkThisClass.getSuperclass();
        }
        return result;
    }
    private static Object getPropertyForOrgApacheCatalinaAuthenticatorJaspicSimpleAuthConfigProvider(Object o, String name) {
        Object result = null;
        switch (name) {
        }
        if (result == null) {
            result = null;
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCatalinaAuthenticatorJaspicPersistentProviderRegistrationsProperty(Object o, String name) {
        Object result = null;
        switch (name) {
            case "name" : 
                result = ((org.apache.catalina.authenticator.jaspic.PersistentProviderRegistrations.Property)o).getName();
                break;
            case "value" : 
                result = ((org.apache.catalina.authenticator.jaspic.PersistentProviderRegistrations.Property)o).getValue();
                break;
        }
        if (result == null) {
            result = null;
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCatalinaAuthenticatorJaspicPersistentProviderRegistrationsProvider(Object o, String name) {
        Object result = null;
        switch (name) {
            case "appContext" : 
                result = ((org.apache.catalina.authenticator.jaspic.PersistentProviderRegistrations.Provider)o).getAppContext();
                break;
            case "className" : 
                result = ((org.apache.catalina.authenticator.jaspic.PersistentProviderRegistrations.Provider)o).getClassName();
                break;
            case "description" : 
                result = ((org.apache.catalina.authenticator.jaspic.PersistentProviderRegistrations.Provider)o).getDescription();
                break;
            case "layer" : 
                result = ((org.apache.catalina.authenticator.jaspic.PersistentProviderRegistrations.Provider)o).getLayer();
                break;
        }
        if (result == null) {
            result = null;
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCatalinaConnectorConnector(Object o, String name) {
        Object result = null;
        switch (name) {
            case "URIEncoding" : 
                result = ((org.apache.catalina.connector.Connector)o).getURIEncoding();
                break;
            case "allowBackslash" : 
                result = ((org.apache.catalina.connector.Connector)o).getAllowBackslash();
                break;
            case "allowTrace" : 
                result = ((org.apache.catalina.connector.Connector)o).getAllowTrace();
                break;
            case "asyncTimeout" : 
                result = ((org.apache.catalina.connector.Connector)o).getAsyncTimeout();
                break;
            case "discardFacades" : 
                result = ((org.apache.catalina.connector.Connector)o).getDiscardFacades();
                break;
            //no getDomainInternal method found on this class
            case "enableLookups" : 
                result = ((org.apache.catalina.connector.Connector)o).getEnableLookups();
                break;
            case "encodedReverseSolidusHandling" : 
                result = ((org.apache.catalina.connector.Connector)o).getEncodedReverseSolidusHandling();
                break;
            case "encodedSolidusHandling" : 
                result = ((org.apache.catalina.connector.Connector)o).getEncodedSolidusHandling();
                break;
            case "enforceEncodingInGetWriter" : 
                result = ((org.apache.catalina.connector.Connector)o).getEnforceEncodingInGetWriter();
                break;
            case "executorName" : 
                result = ((org.apache.catalina.connector.Connector)o).getExecutorName();
                break;
            case "localPort" : 
                result = ((org.apache.catalina.connector.Connector)o).getLocalPort();
                break;
            case "maxCookieCount" : 
                result = ((org.apache.catalina.connector.Connector)o).getMaxCookieCount();
                break;
            case "maxParameterCount" : 
                result = ((org.apache.catalina.connector.Connector)o).getMaxParameterCount();
                break;
            case "maxPostSize" : 
                result = ((org.apache.catalina.connector.Connector)o).getMaxPostSize();
                break;
            case "maxSavePostSize" : 
                result = ((org.apache.catalina.connector.Connector)o).getMaxSavePostSize();
                break;
            //no getObjectNameKeyProperties method found on this class
            case "parseBodyMethods" : 
                result = ((org.apache.catalina.connector.Connector)o).getParseBodyMethods();
                break;
            case "port" : 
                result = ((org.apache.catalina.connector.Connector)o).getPort();
                break;
            case "portOffset" : 
                result = ((org.apache.catalina.connector.Connector)o).getPortOffset();
                break;
            case "portWithOffset" : 
                result = ((org.apache.catalina.connector.Connector)o).getPortWithOffset();
                break;
            case "protocol" : 
                result = ((org.apache.catalina.connector.Connector)o).getProtocol();
                break;
            case "protocolHandlerClassName" : 
                result = ((org.apache.catalina.connector.Connector)o).getProtocolHandlerClassName();
                break;
            case "proxyName" : 
                result = ((org.apache.catalina.connector.Connector)o).getProxyName();
                break;
            case "proxyPort" : 
                result = ((org.apache.catalina.connector.Connector)o).getProxyPort();
                break;
            case "redirectPort" : 
                result = ((org.apache.catalina.connector.Connector)o).getRedirectPort();
                break;
            case "redirectPortWithOffset" : 
                result = ((org.apache.catalina.connector.Connector)o).getRedirectPortWithOffset();
                break;
            case "rejectSuspiciousURIs" : 
                result = ((org.apache.catalina.connector.Connector)o).getRejectSuspiciousURIs();
                break;
            case "scheme" : 
                result = ((org.apache.catalina.connector.Connector)o).getScheme();
                break;
            case "secure" : 
                result = ((org.apache.catalina.connector.Connector)o).getSecure();
                break;
            case "useBodyEncodingForURI" : 
                result = ((org.apache.catalina.connector.Connector)o).getUseBodyEncodingForURI();
                break;
            case "useIPVHosts" : 
                result = ((org.apache.catalina.connector.Connector)o).getUseIPVHosts();
                break;
            case "xpoweredBy" : 
                result = ((org.apache.catalina.connector.Connector)o).getXpoweredBy();
                break;
        }
        if (result == null) {
            result = getPropertyForOrgApacheCatalinaUtilLifecycleMBeanBase(o, name);
        }
        if (result == null) {
            result = ((org.apache.catalina.connector.Connector)o).getProperty(name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCatalinaCoreStandardContext(Object o, String name) {
        Object result = null;
        switch (name) {
            case "addWebinfClassesResources" : 
                result = ((org.apache.catalina.core.StandardContext)o).getAddWebinfClassesResources();
                break;
            case "allowCasualMultipartParsing" : 
                result = ((org.apache.catalina.core.StandardContext)o).getAllowCasualMultipartParsing();
                break;
            case "allowMultipleLeadingForwardSlashInPath" : 
                result = ((org.apache.catalina.core.StandardContext)o).getAllowMultipleLeadingForwardSlashInPath();
                break;
            case "altDDName" : 
                result = ((org.apache.catalina.core.StandardContext)o).getAltDDName();
                break;
            case "alwaysAccessSession" : 
                result = ((org.apache.catalina.core.StandardContext)o).getAlwaysAccessSession();
                break;
            case "antiResourceLocking" : 
                result = ((org.apache.catalina.core.StandardContext)o).getAntiResourceLocking();
                break;
            case "baseName" : 
                result = ((org.apache.catalina.core.StandardContext)o).getBaseName();
                break;
            case "charsetMapperClass" : 
                result = ((org.apache.catalina.core.StandardContext)o).getCharsetMapperClass();
                break;
            case "clearReferencesHttpClientKeepAliveThread" : 
                result = ((org.apache.catalina.core.StandardContext)o).getClearReferencesHttpClientKeepAliveThread();
                break;
            case "clearReferencesRmiTargets" : 
                result = ((org.apache.catalina.core.StandardContext)o).getClearReferencesRmiTargets();
                break;
            case "clearReferencesStopThreads" : 
                result = ((org.apache.catalina.core.StandardContext)o).getClearReferencesStopThreads();
                break;
            case "clearReferencesStopTimerThreads" : 
                result = ((org.apache.catalina.core.StandardContext)o).getClearReferencesStopTimerThreads();
                break;
            case "clearReferencesThreadLocals" : 
                result = ((org.apache.catalina.core.StandardContext)o).getClearReferencesThreadLocals();
                break;
            //no getComputedFailCtxIfServletStartFails method found on this class
            case "configured" : 
                result = ((org.apache.catalina.core.StandardContext)o).getConfigured();
                break;
            case "containerSciFilter" : 
                result = ((org.apache.catalina.core.StandardContext)o).getContainerSciFilter();
                break;
            case "contextGetResourceRequiresSlash" : 
                result = ((org.apache.catalina.core.StandardContext)o).getContextGetResourceRequiresSlash();
                break;
            case "cookies" : 
                result = ((org.apache.catalina.core.StandardContext)o).getCookies();
                break;
            case "copyXML" : 
                result = ((org.apache.catalina.core.StandardContext)o).getCopyXML();
                break;
            case "createUploadTargets" : 
                result = ((org.apache.catalina.core.StandardContext)o).getCreateUploadTargets();
                break;
            case "crossContext" : 
                result = ((org.apache.catalina.core.StandardContext)o).getCrossContext();
                break;
            case "defaultContextXml" : 
                result = ((org.apache.catalina.core.StandardContext)o).getDefaultContextXml();
                break;
            case "defaultWebXml" : 
                result = ((org.apache.catalina.core.StandardContext)o).getDefaultWebXml();
                break;
            case "delegate" : 
                result = ((org.apache.catalina.core.StandardContext)o).getDelegate();
                break;
            case "denyUncoveredHttpMethods" : 
                result = ((org.apache.catalina.core.StandardContext)o).getDenyUncoveredHttpMethods();
                break;
            case "dispatcherWrapsSameObject" : 
                result = ((org.apache.catalina.core.StandardContext)o).getDispatcherWrapsSameObject();
                break;
            case "dispatchersUseEncodedPaths" : 
                result = ((org.apache.catalina.core.StandardContext)o).getDispatchersUseEncodedPaths();
                break;
            case "displayName" : 
                result = ((org.apache.catalina.core.StandardContext)o).getDisplayName();
                break;
            case "distributable" : 
                result = ((org.apache.catalina.core.StandardContext)o).getDistributable();
                break;
            case "docBase" : 
                result = ((org.apache.catalina.core.StandardContext)o).getDocBase();
                break;
            case "effectiveMajorVersion" : 
                result = ((org.apache.catalina.core.StandardContext)o).getEffectiveMajorVersion();
                break;
            case "effectiveMinorVersion" : 
                result = ((org.apache.catalina.core.StandardContext)o).getEffectiveMinorVersion();
                break;
            case "encodedPath" : 
                result = ((org.apache.catalina.core.StandardContext)o).getEncodedPath();
                break;
            case "encodedReverseSolidusHandling" : 
                result = ((org.apache.catalina.core.StandardContext)o).getEncodedReverseSolidusHandling();
                break;
            case "encodedSolidusHandling" : 
                result = ((org.apache.catalina.core.StandardContext)o).getEncodedSolidusHandling();
                break;
            case "errorCount" : 
                result = ((org.apache.catalina.core.StandardContext)o).getErrorCount();
                break;
            case "fireRequestListenersOnForwards" : 
                result = ((org.apache.catalina.core.StandardContext)o).getFireRequestListenersOnForwards();
                break;
            case "ignoreAnnotations" : 
                result = ((org.apache.catalina.core.StandardContext)o).getIgnoreAnnotations();
                break;
            case "inProgressAsyncCount" : 
                result = ((org.apache.catalina.core.StandardContext)o).getInProgressAsyncCount();
                break;
            case "j2EEApplication" : 
                result = ((org.apache.catalina.core.StandardContext)o).getJ2EEApplication();
                break;
            case "j2EEServer" : 
                result = ((org.apache.catalina.core.StandardContext)o).getJ2EEServer();
                break;
            case "jndiExceptionOnFailedWrite" : 
                result = ((org.apache.catalina.core.StandardContext)o).getJndiExceptionOnFailedWrite();
                break;
            case "logEffectiveWebXml" : 
                result = ((org.apache.catalina.core.StandardContext)o).getLogEffectiveWebXml();
                break;
            case "mapperContextRootRedirectEnabled" : 
                result = ((org.apache.catalina.core.StandardContext)o).getMapperContextRootRedirectEnabled();
                break;
            case "mapperDirectoryRedirectEnabled" : 
                result = ((org.apache.catalina.core.StandardContext)o).getMapperDirectoryRedirectEnabled();
                break;
            case "maxTime" : 
                result = ((org.apache.catalina.core.StandardContext)o).getMaxTime();
                break;
            case "metadataComplete" : 
                result = ((org.apache.catalina.core.StandardContext)o).getMetadataComplete();
                break;
            case "minTime" : 
                result = ((org.apache.catalina.core.StandardContext)o).getMinTime();
                break;
            //no getNamingContextName method found on this class
            case "notFoundClassResourceCacheSize" : 
                result = ((org.apache.catalina.core.StandardContext)o).getNotFoundClassResourceCacheSize();
                break;
            //no getObjectNameKeyProperties method found on this class
            case "originalDocBase" : 
                result = ((org.apache.catalina.core.StandardContext)o).getOriginalDocBase();
                break;
            case "override" : 
                result = ((org.apache.catalina.core.StandardContext)o).getOverride();
                break;
            case "parallelAnnotationScanning" : 
                result = ((org.apache.catalina.core.StandardContext)o).getParallelAnnotationScanning();
                break;
            case "path" : 
                result = ((org.apache.catalina.core.StandardContext)o).getPath();
                break;
            case "paused" : 
                result = ((org.apache.catalina.core.StandardContext)o).getPaused();
                break;
            case "preemptiveAuthentication" : 
                result = ((org.apache.catalina.core.StandardContext)o).getPreemptiveAuthentication();
                break;
            case "privileged" : 
                result = ((org.apache.catalina.core.StandardContext)o).getPrivileged();
                break;
            case "processingTime" : 
                result = ((org.apache.catalina.core.StandardContext)o).getProcessingTime();
                break;
            case "publicId" : 
                result = ((org.apache.catalina.core.StandardContext)o).getPublicId();
                break;
            case "reloadable" : 
                result = ((org.apache.catalina.core.StandardContext)o).getReloadable();
                break;
            case "renewThreadsWhenStoppingContext" : 
                result = ((org.apache.catalina.core.StandardContext)o).getRenewThreadsWhenStoppingContext();
                break;
            //no getReplaceWelcomeFiles method found on this class
            case "requestCharacterEncoding" : 
                result = ((org.apache.catalina.core.StandardContext)o).getRequestCharacterEncoding();
                break;
            case "requestCount" : 
                result = ((org.apache.catalina.core.StandardContext)o).getRequestCount();
                break;
            //no getRequestEncoding method found on this class
            case "resourceOnlyServlets" : 
                result = ((org.apache.catalina.core.StandardContext)o).getResourceOnlyServlets();
                break;
            case "responseCharacterEncoding" : 
                result = ((org.apache.catalina.core.StandardContext)o).getResponseCharacterEncoding();
                break;
            //no getResponseEncoding method found on this class
            case "sendRedirectBody" : 
                result = ((org.apache.catalina.core.StandardContext)o).getSendRedirectBody();
                break;
            case "server" : 
                result = ((org.apache.catalina.core.StandardContext)o).getServer();
                break;
            //no getServlet22 method found on this class
            case "sessionCookieDomain" : 
                result = ((org.apache.catalina.core.StandardContext)o).getSessionCookieDomain();
                break;
            case "sessionCookieName" : 
                result = ((org.apache.catalina.core.StandardContext)o).getSessionCookieName();
                break;
            case "sessionCookiePath" : 
                result = ((org.apache.catalina.core.StandardContext)o).getSessionCookiePath();
                break;
            case "sessionCookiePathUsesTrailingSlash" : 
                result = ((org.apache.catalina.core.StandardContext)o).getSessionCookiePathUsesTrailingSlash();
                break;
            case "sessionTimeout" : 
                result = ((org.apache.catalina.core.StandardContext)o).getSessionTimeout();
                break;
            case "skipMemoryLeakChecksOnJvmShutdown" : 
                result = ((org.apache.catalina.core.StandardContext)o).getSkipMemoryLeakChecksOnJvmShutdown();
                break;
            case "startTime" : 
                result = ((org.apache.catalina.core.StandardContext)o).getStartTime();
                break;
            case "startupTime" : 
                result = ((org.apache.catalina.core.StandardContext)o).getStartupTime();
                break;
            case "suspendWrappedResponseAfterForward" : 
                result = ((org.apache.catalina.core.StandardContext)o).getSuspendWrappedResponseAfterForward();
                break;
            case "swallowAbortedUploads" : 
                result = ((org.apache.catalina.core.StandardContext)o).getSwallowAbortedUploads();
                break;
            case "swallowOutput" : 
                result = ((org.apache.catalina.core.StandardContext)o).getSwallowOutput();
                break;
            case "tldScanTime" : 
                result = ((org.apache.catalina.core.StandardContext)o).getTldScanTime();
                break;
            case "tldValidation" : 
                result = ((org.apache.catalina.core.StandardContext)o).getTldValidation();
                break;
            case "unloadDelay" : 
                result = ((org.apache.catalina.core.StandardContext)o).getUnloadDelay();
                break;
            case "unpackWAR" : 
                result = ((org.apache.catalina.core.StandardContext)o).getUnpackWAR();
                break;
            case "useHttpOnly" : 
                result = ((org.apache.catalina.core.StandardContext)o).getUseHttpOnly();
                break;
            //no getUseNaming method found on this class
            case "usePartitioned" : 
                result = ((org.apache.catalina.core.StandardContext)o).getUsePartitioned();
                break;
            case "useRelativeRedirects" : 
                result = ((org.apache.catalina.core.StandardContext)o).getUseRelativeRedirects();
                break;
            case "validateClientProvidedNewSessionId" : 
                result = ((org.apache.catalina.core.StandardContext)o).getValidateClientProvidedNewSessionId();
                break;
            //no getWebXmlNamespaceAware method found on this class
            //no getWebXmlValidation method found on this class
            case "webappVersion" : 
                result = ((org.apache.catalina.core.StandardContext)o).getWebappVersion();
                break;
            case "workDir" : 
                result = ((org.apache.catalina.core.StandardContext)o).getWorkDir();
                break;
            case "workPath" : 
                result = ((org.apache.catalina.core.StandardContext)o).getWorkPath();
                break;
            case "wrapperClass" : 
                result = ((org.apache.catalina.core.StandardContext)o).getWrapperClass();
                break;
            //no getWrapperClassName method found on this class
            case "xmlBlockExternal" : 
                result = ((org.apache.catalina.core.StandardContext)o).getXmlBlockExternal();
                break;
            case "xmlNamespaceAware" : 
                result = ((org.apache.catalina.core.StandardContext)o).getXmlNamespaceAware();
                break;
            case "xmlValidation" : 
                result = ((org.apache.catalina.core.StandardContext)o).getXmlValidation();
                break;
        }
        if (result == null) {
            result = getPropertyForOrgApacheCatalinaCoreContainerBase(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCatalinaCoreStandardEngine(Object o, String name) {
        Object result = null;
        switch (name) {
            case "defaultHost" : 
                result = ((org.apache.catalina.core.StandardEngine)o).getDefaultHost();
                break;
            //no getDomainInternal method found on this class
            case "jvmRoute" : 
                result = ((org.apache.catalina.core.StandardEngine)o).getJvmRoute();
                break;
            //no getJvmRouteId method found on this class
            //no getObjectNameKeyProperties method found on this class
        }
        if (result == null) {
            result = getPropertyForOrgApacheCatalinaCoreContainerBase(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCatalinaCoreStandardHost(Object o, String name) {
        Object result = null;
        switch (name) {
            case "appBase" : 
                result = ((org.apache.catalina.core.StandardHost)o).getAppBase();
                break;
            case "autoDeploy" : 
                result = ((org.apache.catalina.core.StandardHost)o).getAutoDeploy();
                break;
            case "configClass" : 
                result = ((org.apache.catalina.core.StandardHost)o).getConfigClass();
                break;
            case "contextClass" : 
                result = ((org.apache.catalina.core.StandardHost)o).getContextClass();
                break;
            //no getCopyXML method found on this class
            case "createDirs" : 
                result = ((org.apache.catalina.core.StandardHost)o).getCreateDirs();
                break;
            case "deployIgnore" : 
                result = ((org.apache.catalina.core.StandardHost)o).getDeployIgnore();
                break;
            case "deployOnStartup" : 
                result = ((org.apache.catalina.core.StandardHost)o).getDeployOnStartup();
                break;
            //no getDeployXML method found on this class
            case "errorReportValveClass" : 
                result = ((org.apache.catalina.core.StandardHost)o).getErrorReportValveClass();
                break;
            //no getFailCtxIfServletStartFails method found on this class
            case "legacyAppBase" : 
                result = ((org.apache.catalina.core.StandardHost)o).getLegacyAppBase();
                break;
            case "name" : 
                result = ((org.apache.catalina.core.StandardHost)o).getName();
                break;
            //no getObjectNameKeyProperties method found on this class
            case "undeployOldVersions" : 
                result = ((org.apache.catalina.core.StandardHost)o).getUndeployOldVersions();
                break;
            //no getUnpackWARs method found on this class
            case "workDir" : 
                result = ((org.apache.catalina.core.StandardHost)o).getWorkDir();
                break;
            case "xmlBase" : 
                result = ((org.apache.catalina.core.StandardHost)o).getXmlBase();
                break;
        }
        if (result == null) {
            result = getPropertyForOrgApacheCatalinaCoreContainerBase(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCatalinaCoreContainerBase(Object o, String name) {
        Object result = null;
        switch (name) {
            case "MBeanKeyProperties" : 
                result = ((org.apache.catalina.core.ContainerBase)o).getMBeanKeyProperties();
                break;
            //no getAccessLogScanComplete method found on this class
            case "backgroundProcessorDelay" : 
                result = ((org.apache.catalina.core.ContainerBase)o).getBackgroundProcessorDelay();
                break;
            //no getDomainInternal method found on this class
            case "logName" : 
                result = ((org.apache.catalina.core.ContainerBase)o).getLogName();
                break;
            case "name" : 
                result = ((org.apache.catalina.core.ContainerBase)o).getName();
                break;
            case "startChildren" : 
                result = ((org.apache.catalina.core.ContainerBase)o).getStartChildren();
                break;
            case "startStopThreads" : 
                result = ((org.apache.catalina.core.ContainerBase)o).getStartStopThreads();
                break;
        }
        if (result == null) {
            result = getPropertyForOrgApacheCatalinaUtilLifecycleMBeanBase(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCatalinaCoreStandardServer(Object o, String name) {
        Object result = null;
        switch (name) {
            case "address" : 
                result = ((org.apache.catalina.core.StandardServer)o).getAddress();
                break;
            //no getDomainInternal method found on this class
            //no getObjectNameKeyProperties method found on this class
            case "periodicEventDelay" : 
                result = ((org.apache.catalina.core.StandardServer)o).getPeriodicEventDelay();
                break;
            case "port" : 
                result = ((org.apache.catalina.core.StandardServer)o).getPort();
                break;
            case "portOffset" : 
                result = ((org.apache.catalina.core.StandardServer)o).getPortOffset();
                break;
            case "portWithOffset" : 
                result = ((org.apache.catalina.core.StandardServer)o).getPortWithOffset();
                break;
            case "serverBuilt" : 
                result = ((org.apache.catalina.core.StandardServer)o).getServerBuilt();
                break;
            case "serverInfo" : 
                result = ((org.apache.catalina.core.StandardServer)o).getServerInfo();
                break;
            case "serverNumber" : 
                result = ((org.apache.catalina.core.StandardServer)o).getServerNumber();
                break;
            case "shutdown" : 
                result = ((org.apache.catalina.core.StandardServer)o).getShutdown();
                break;
            //no getStopAwait method found on this class
            case "utilityThreads" : 
                result = ((org.apache.catalina.core.StandardServer)o).getUtilityThreads();
                break;
            case "utilityThreadsAsDaemon" : 
                result = ((org.apache.catalina.core.StandardServer)o).getUtilityThreadsAsDaemon();
                break;
        }
        if (result == null) {
            result = getPropertyForOrgApacheCatalinaUtilLifecycleMBeanBase(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCatalinaCoreStandardService(Object o, String name) {
        Object result = null;
        switch (name) {
            //no getDomainInternal method found on this class
            case "gracefulStopAwaitMillis" : 
                result = ((org.apache.catalina.core.StandardService)o).getGracefulStopAwaitMillis();
                break;
            case "name" : 
                result = ((org.apache.catalina.core.StandardService)o).getName();
                break;
            case "objectNameKeyProperties" : 
                result = ((org.apache.catalina.core.StandardService)o).getObjectNameKeyProperties();
                break;
        }
        if (result == null) {
            result = getPropertyForOrgApacheCatalinaUtilLifecycleMBeanBase(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCatalinaRealmUserDatabaseRealm(Object o, String name) {
        Object result = null;
        switch (name) {
            //no getAvailable method found on this class
            case "localJndiResource" : 
                result = ((org.apache.catalina.realm.UserDatabaseRealm)o).getLocalJndiResource();
                break;
            case "resourceName" : 
                result = ((org.apache.catalina.realm.UserDatabaseRealm)o).getResourceName();
                break;
            case "useStaticPrincipal" : 
                result = ((org.apache.catalina.realm.UserDatabaseRealm)o).getUseStaticPrincipal();
                break;
        }
        if (result == null) {
            result = getPropertyForOrgApacheCatalinaRealmRealmBase(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCatalinaRealmRealmBase(Object o, String name) {
        Object result = null;
        switch (name) {
            case "allRolesMode" : 
                result = ((org.apache.catalina.realm.RealmBase)o).getAllRolesMode();
                break;
            case "domainInternal" : 
                result = ((org.apache.catalina.realm.RealmBase)o).getDomainInternal();
                break;
            case "objectNameKeyProperties" : 
                result = ((org.apache.catalina.realm.RealmBase)o).getObjectNameKeyProperties();
                break;
            case "realmPath" : 
                result = ((org.apache.catalina.realm.RealmBase)o).getRealmPath();
                break;
            //no getRealmSuffix method found on this class
            //no getStripRealmForGss method found on this class
            case "transportGuaranteeRedirectStatus" : 
                result = ((org.apache.catalina.realm.RealmBase)o).getTransportGuaranteeRedirectStatus();
                break;
            case "userAttributes" : 
                result = ((org.apache.catalina.realm.RealmBase)o).getUserAttributes();
                break;
            case "validate" : 
                result = ((org.apache.catalina.realm.RealmBase)o).getValidate();
                break;
            case "x509UsernameRetrieverClassName" : 
                result = ((org.apache.catalina.realm.RealmBase)o).getX509UsernameRetrieverClassName();
                break;
        }
        if (result == null) {
            result = getPropertyForOrgApacheCatalinaUtilLifecycleMBeanBase(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCatalinaValvesAccessLogValve(Object o, String name) {
        Object result = null;
        switch (name) {
            //no getBuffered method found on this class
            //no getCheckExists method found on this class
            //no getCheckForOldLogs method found on this class
            //no getDateStamp method found on this class
            case "directory" : 
                result = ((org.apache.catalina.valves.AccessLogValve)o).getDirectory();
                break;
            case "encoding" : 
                result = ((org.apache.catalina.valves.AccessLogValve)o).getEncoding();
                break;
            case "fileDateFormat" : 
                result = ((org.apache.catalina.valves.AccessLogValve)o).getFileDateFormat();
                break;
            case "maxDays" : 
                result = ((org.apache.catalina.valves.AccessLogValve)o).getMaxDays();
                break;
            case "prefix" : 
                result = ((org.apache.catalina.valves.AccessLogValve)o).getPrefix();
                break;
            //no getRenameOnRotate method found on this class
            //no getRotatable method found on this class
            //no getRotationLastChecked method found on this class
            case "suffix" : 
                result = ((org.apache.catalina.valves.AccessLogValve)o).getSuffix();
                break;
        }
        if (result == null) {
            result = getPropertyForOrgApacheCatalinaValvesAbstractAccessLogValve(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCatalinaValvesAbstractAccessLogValve(Object o, String name) {
        Object result = null;
        switch (name) {
            case "condition" : 
                result = ((org.apache.catalina.valves.AbstractAccessLogValve)o).getCondition();
                break;
            case "conditionIf" : 
                result = ((org.apache.catalina.valves.AbstractAccessLogValve)o).getConditionIf();
                break;
            case "conditionUnless" : 
                result = ((org.apache.catalina.valves.AbstractAccessLogValve)o).getConditionUnless();
                break;
            case "enabled" : 
                result = ((org.apache.catalina.valves.AbstractAccessLogValve)o).getEnabled();
                break;
            case "ipv6Canonical" : 
                result = ((org.apache.catalina.valves.AbstractAccessLogValve)o).getIpv6Canonical();
                break;
            case "locale" : 
                result = ((org.apache.catalina.valves.AbstractAccessLogValve)o).getLocale();
                break;
            //no getLocaleName method found on this class
            case "maxLogMessageBufferSize" : 
                result = ((org.apache.catalina.valves.AbstractAccessLogValve)o).getMaxLogMessageBufferSize();
                break;
            case "pattern" : 
                result = ((org.apache.catalina.valves.AbstractAccessLogValve)o).getPattern();
                break;
            case "requestAttributesEnabled" : 
                result = ((org.apache.catalina.valves.AbstractAccessLogValve)o).getRequestAttributesEnabled();
                break;
            //no getTlsAttributeRequired method found on this class
        }
        if (result == null) {
            result = getPropertyForOrgApacheCatalinaValvesValveBase(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCatalinaValvesValveBase(Object o, String name) {
        Object result = null;
        switch (name) {
            //no getAsyncSupported method found on this class
            case "domainInternal" : 
                result = ((org.apache.catalina.valves.ValveBase)o).getDomainInternal();
                break;
            case "objectNameKeyProperties" : 
                result = ((org.apache.catalina.valves.ValveBase)o).getObjectNameKeyProperties();
                break;
        }
        if (result == null) {
            result = getPropertyForOrgApacheCatalinaUtilLifecycleMBeanBase(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCatalinaUtilLifecycleMBeanBase(Object o, String name) {
        Object result = null;
        switch (name) {
            case "domain" : 
                result = ((org.apache.catalina.util.LifecycleMBeanBase)o).getDomain();
                break;
            //no getDomainInternal method found on this class
            //no getObjectNameKeyProperties method found on this class
        }
        if (result == null) {
            result = getPropertyForOrgApacheCatalinaUtilLifecycleBase(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCatalinaUtilLifecycleBase(Object o, String name) {
        Object result = null;
        switch (name) {
            case "stateName" : 
                result = ((org.apache.catalina.util.LifecycleBase)o).getStateName();
                break;
            case "throwOnFailure" : 
                result = ((org.apache.catalina.util.LifecycleBase)o).getThrowOnFailure();
                break;
        }
        if (result == null) {
            result = null;
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCatalinaFiltersAddDefaultCharsetFilter(Object o, String name) {
        Object result = null;
        switch (name) {
            //no getEncoding method found on this class
        }
        if (result == null) {
            result = getPropertyForOrgApacheCatalinaFiltersFilterBase(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCatalinaFiltersRestCsrfPreventionFilter(Object o, String name) {
        Object result = null;
        switch (name) {
            case "pathsAcceptingParams" : 
                result = ((org.apache.catalina.filters.RestCsrfPreventionFilter)o).getPathsAcceptingParams();
                break;
        }
        if (result == null) {
            result = getPropertyForOrgApacheCatalinaFiltersCsrfPreventionFilterBase(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCatalinaFiltersCsrfPreventionFilterBase(Object o, String name) {
        Object result = null;
        switch (name) {
            //no getConfigProblemFatal method found on this class
            case "denyStatus" : 
                result = ((org.apache.catalina.filters.CsrfPreventionFilterBase)o).getDenyStatus();
                break;
            //no getRandomClass method found on this class
        }
        if (result == null) {
            result = getPropertyForOrgApacheCatalinaFiltersFilterBase(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCatalinaFiltersFilterBase(Object o, String name) {
        Object result = null;
        switch (name) {
            //no getConfigProblemFatal method found on this class
        }
        if (result == null) {
            result = null;
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCatalinaLoaderParallelWebappClassLoader(Object o, String name) {
        Object result = null;
        switch (name) {
        }
        if (result == null) {
            result = getPropertyForOrgApacheCatalinaLoaderWebappClassLoaderBase(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCatalinaLoaderWebappClassLoaderBase(Object o, String name) {
        Object result = null;
        switch (name) {
            case "clearReferencesHttpClientKeepAliveThread" : 
                result = ((org.apache.catalina.loader.WebappClassLoaderBase)o).getClearReferencesHttpClientKeepAliveThread();
                break;
            case "clearReferencesLogFactoryRelease" : 
                result = ((org.apache.catalina.loader.WebappClassLoaderBase)o).getClearReferencesLogFactoryRelease();
                break;
            case "clearReferencesRmiTargets" : 
                result = ((org.apache.catalina.loader.WebappClassLoaderBase)o).getClearReferencesRmiTargets();
                break;
            case "clearReferencesStopThreads" : 
                result = ((org.apache.catalina.loader.WebappClassLoaderBase)o).getClearReferencesStopThreads();
                break;
            case "clearReferencesStopTimerThreads" : 
                result = ((org.apache.catalina.loader.WebappClassLoaderBase)o).getClearReferencesStopTimerThreads();
                break;
            case "clearReferencesThreadLocals" : 
                result = ((org.apache.catalina.loader.WebappClassLoaderBase)o).getClearReferencesThreadLocals();
                break;
            case "contextName" : 
                result = ((org.apache.catalina.loader.WebappClassLoaderBase)o).getContextName();
                break;
            case "delegate" : 
                result = ((org.apache.catalina.loader.WebappClassLoaderBase)o).getDelegate();
                break;
            //no getHasExternalRepositories method found on this class
            case "hostName" : 
                result = ((org.apache.catalina.loader.WebappClassLoaderBase)o).getHostName();
                break;
            case "notFoundClassResourceCacheSize" : 
                result = ((org.apache.catalina.loader.WebappClassLoaderBase)o).getNotFoundClassResourceCacheSize();
                break;
            case "serviceName" : 
                result = ((org.apache.catalina.loader.WebappClassLoaderBase)o).getServiceName();
                break;
            case "skipMemoryLeakChecksOnJvmShutdown" : 
                result = ((org.apache.catalina.loader.WebappClassLoaderBase)o).getSkipMemoryLeakChecksOnJvmShutdown();
                break;
            case "stateName" : 
                result = ((org.apache.catalina.loader.WebappClassLoaderBase)o).getStateName();
                break;
            case "webappName" : 
                result = ((org.apache.catalina.loader.WebappClassLoaderBase)o).getWebappName();
                break;
        }
        if (result == null) {
            result = getPropertyForJavaNetURLClassLoader(o, name);
        }
        return result;
    }


    private static Object getPropertyForJavaNetURLClassLoader(Object o, String name) {
        Object result = null;
        switch (name) {
        }
        if (result == null) {
            result = getPropertyForJavaSecuritySecureClassLoader(o, name);
        }
        return result;
    }


    private static Object getPropertyForJavaSecuritySecureClassLoader(Object o, String name) {
        Object result = null;
        switch (name) {
        }
        if (result == null) {
            result = getPropertyForJavaLangClassLoader(o, name);
        }
        return result;
    }


    private static Object getPropertyForJavaLangClassLoader(Object o, String name) {
        Object result = null;
        switch (name) {
            //no getDefaultAssertionStatus method found on this class
            case "name" : 
                result = ((java.lang.ClassLoader)o).getName();
                break;
            //no getRegisteredAsParallelCapable method found on this class
        }
        if (result == null) {
            result = null;
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCoyoteAjpAjpNio2Protocol(Object o, String name) {
        Object result = null;
        switch (name) {
            //no getNamePrefix method found on this class
        }
        if (result == null) {
            result = getPropertyForOrgApacheCoyoteAjpAbstractAjpProtocol(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCoyoteAjpAjpNioProtocol(Object o, String name) {
        Object result = null;
        switch (name) {
            //no getNamePrefix method found on this class
        }
        if (result == null) {
            result = getPropertyForOrgApacheCoyoteAjpAbstractAjpProtocol(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCoyoteAjpAbstractAjpProtocol(Object o, String name) {
        Object result = null;
        switch (name) {
            case "ajpFlush" : 
                result = ((org.apache.coyote.ajp.AbstractAjpProtocol)o).getAjpFlush();
                break;
            case "allowedRequestAttributesPattern" : 
                result = ((org.apache.coyote.ajp.AbstractAjpProtocol)o).getAllowedRequestAttributesPattern();
                break;
            case "desiredBufferSize" : 
                result = ((org.apache.coyote.ajp.AbstractAjpProtocol)o).getDesiredBufferSize();
                break;
            case "packetSize" : 
                result = ((org.apache.coyote.ajp.AbstractAjpProtocol)o).getPacketSize();
                break;
            //no getProtocolName method found on this class
            //no getSecret method found on this class
            case "secretRequired" : 
                result = ((org.apache.coyote.ajp.AbstractAjpProtocol)o).getSecretRequired();
                break;
            case "tomcatAuthentication" : 
                result = ((org.apache.coyote.ajp.AbstractAjpProtocol)o).getTomcatAuthentication();
                break;
            case "tomcatAuthorization" : 
                result = ((org.apache.coyote.ajp.AbstractAjpProtocol)o).getTomcatAuthorization();
                break;
        }
        if (result == null) {
            result = getPropertyForOrgApacheCoyoteAbstractProtocol(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCoyoteHttp11Http11Nio2Protocol(Object o, String name) {
        Object result = null;
        switch (name) {
            //no getNamePrefix method found on this class
        }
        if (result == null) {
            result = getPropertyForOrgApacheCoyoteHttp11AbstractHttp11Protocol(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCoyoteHttp11Http11NioProtocol(Object o, String name) {
        Object result = null;
        switch (name) {
            //no getNamePrefix method found on this class
            case "pollerThreadPriority" : 
                result = ((org.apache.coyote.http11.Http11NioProtocol)o).getPollerThreadPriority();
                break;
            case "selectorTimeout" : 
                result = ((org.apache.coyote.http11.Http11NioProtocol)o).getSelectorTimeout();
                break;
        }
        if (result == null) {
            result = getPropertyForOrgApacheCoyoteHttp11AbstractHttp11Protocol(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCoyoteHttp11AbstractHttp11Protocol(Object o, String name) {
        Object result = null;
        switch (name) {
            case "SSLEnabled" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).isSSLEnabled();
                break;
            case "allowedTrailerHeaders" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getAllowedTrailerHeaders();
                break;
            case "compressibleMimeType" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getCompressibleMimeType();
                break;
            case "compression" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getCompression();
                break;
            //no getCompressionLevel method found on this class
            case "compressionMinSize" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getCompressionMinSize();
                break;
            case "connectionUploadTimeout" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getConnectionUploadTimeout();
                break;
            case "continueResponseTiming" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getContinueResponseTiming();
                break;
            case "defaultSSLHostConfigName" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getDefaultSSLHostConfigName();
                break;
            case "disableUploadTimeout" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getDisableUploadTimeout();
                break;
            case "maxExtensionSize" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getMaxExtensionSize();
                break;
            case "maxHttpHeaderSize" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getMaxHttpHeaderSize();
                break;
            case "maxHttpRequestHeaderSize" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getMaxHttpRequestHeaderSize();
                break;
            case "maxHttpResponseHeaderSize" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getMaxHttpResponseHeaderSize();
                break;
            case "maxKeepAliveRequests" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getMaxKeepAliveRequests();
                break;
            case "maxSavePostSize" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getMaxSavePostSize();
                break;
            case "maxSwallowSize" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getMaxSwallowSize();
                break;
            case "maxTrailerSize" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getMaxTrailerSize();
                break;
            case "noCompressionUserAgents" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getNoCompressionUserAgents();
                break;
            //no getProtocolName method found on this class
            case "relaxedPathChars" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getRelaxedPathChars();
                break;
            case "relaxedQueryChars" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getRelaxedQueryChars();
                break;
            case "restrictedUserAgents" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getRestrictedUserAgents();
                break;
            case "secure" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getSecure();
                break;
            case "server" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getServer();
                break;
            case "serverRemoveAppProvidedValues" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getServerRemoveAppProvidedValues();
                break;
            case "sniParseLimit" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getSniParseLimit();
                break;
            case "sslImplementationName" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getSslImplementationName();
                break;
            //no getSslImplementationShortName method found on this class
            case "useKeepAliveResponseHeader" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getUseKeepAliveResponseHeader();
                break;
            case "useSendfile" : 
                result = ((org.apache.coyote.http11.AbstractHttp11Protocol)o).getUseSendfile();
                break;
        }
        if (result == null) {
            result = getPropertyForOrgApacheCoyoteAbstractProtocol(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheCoyoteAbstractProtocol(Object o, String name) {
        Object result = null;
        switch (name) {
            case "acceptCount" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getAcceptCount();
                break;
            case "acceptorThreadPriority" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getAcceptorThreadPriority();
                break;
            case "address" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getAddress();
                break;
            case "clientCertProvider" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getClientCertProvider();
                break;
            case "connectionCount" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getConnectionCount();
                break;
            case "connectionLinger" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getConnectionLinger();
                break;
            case "connectionTimeout" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getConnectionTimeout();
                break;
            case "domain" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getDomain();
                break;
            case "id" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getId();
                break;
            case "keepAliveTimeout" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getKeepAliveTimeout();
                break;
            case "localPort" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getLocalPort();
                break;
            case "maxConnections" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getMaxConnections();
                break;
            case "maxHeaderCount" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getMaxHeaderCount();
                break;
            case "maxQueueSize" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getMaxQueueSize();
                break;
            case "maxThreads" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getMaxThreads();
                break;
            case "minSpareThreads" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getMinSpareThreads();
                break;
            case "name" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getName();
                break;
            case "nameIndex" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getNameIndex();
                break;
            //no getNamePrefix method found on this class
            //no getPaused method found on this class
            case "port" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getPort();
                break;
            case "portOffset" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getPortOffset();
                break;
            case "portWithOffset" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getPortWithOffset();
                break;
            case "processorCache" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getProcessorCache();
                break;
            //no getProtocolName method found on this class
            //no getSendfileSupported method found on this class
            case "tcpNoDelay" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getTcpNoDelay();
                break;
            case "threadPriority" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getThreadPriority();
                break;
            case "waitingProcessorCount" : 
                result = ((org.apache.coyote.AbstractProtocol)o).getWaitingProcessorCount();
                break;
        }
        if (result == null) {
            result = null;
        }
        if (result == null) {
            result = ((org.apache.coyote.AbstractProtocol)o).getProperty(name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheTomcatUtilDescriptorWebContextResource(Object o, String name) {
        Object result = null;
        switch (name) {
            case "auth" : 
                result = ((org.apache.tomcat.util.descriptor.web.ContextResource)o).getAuth();
                break;
            case "closeMethod" : 
                result = ((org.apache.tomcat.util.descriptor.web.ContextResource)o).getCloseMethod();
                break;
            case "closeMethodConfigured" : 
                result = ((org.apache.tomcat.util.descriptor.web.ContextResource)o).getCloseMethodConfigured();
                break;
            case "scope" : 
                result = ((org.apache.tomcat.util.descriptor.web.ContextResource)o).getScope();
                break;
            case "singleton" : 
                result = ((org.apache.tomcat.util.descriptor.web.ContextResource)o).getSingleton();
                break;
        }
        if (result == null) {
            result = getPropertyForOrgApacheTomcatUtilDescriptorWebResourceBase(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheTomcatUtilDescriptorWebResourceBase(Object o, String name) {
        Object result = null;
        switch (name) {
            case "description" : 
                result = ((org.apache.tomcat.util.descriptor.web.ResourceBase)o).getDescription();
                break;
            case "lookupName" : 
                result = ((org.apache.tomcat.util.descriptor.web.ResourceBase)o).getLookupName();
                break;
            case "name" : 
                result = ((org.apache.tomcat.util.descriptor.web.ResourceBase)o).getName();
                break;
            case "type" : 
                result = ((org.apache.tomcat.util.descriptor.web.ResourceBase)o).getType();
                break;
        }
        if (result == null) {
            result = null;
        }
        if (result == null) {
            result = ((org.apache.tomcat.util.descriptor.web.ResourceBase)o).getProperty(name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheTomcatUtilModelerAttributeInfo(Object o, String name) {
        Object result = null;
        switch (name) {
            case "displayName" : 
                result = ((org.apache.tomcat.util.modeler.AttributeInfo)o).getDisplayName();
                break;
            case "getMethod" : 
                result = ((org.apache.tomcat.util.modeler.AttributeInfo)o).getGetMethod();
                break;
            //no getIs method found on this class
            //no getReadable method found on this class
            case "setMethod" : 
                result = ((org.apache.tomcat.util.modeler.AttributeInfo)o).getSetMethod();
                break;
            //no getWriteable method found on this class
        }
        if (result == null) {
            result = getPropertyForOrgApacheTomcatUtilModelerFeatureInfo(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheTomcatUtilModelerOperationInfo(Object o, String name) {
        Object result = null;
        switch (name) {
            case "impact" : 
                result = ((org.apache.tomcat.util.modeler.OperationInfo)o).getImpact();
                break;
            case "returnType" : 
                result = ((org.apache.tomcat.util.modeler.OperationInfo)o).getReturnType();
                break;
            case "role" : 
                result = ((org.apache.tomcat.util.modeler.OperationInfo)o).getRole();
                break;
        }
        if (result == null) {
            result = getPropertyForOrgApacheTomcatUtilModelerFeatureInfo(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheTomcatUtilModelerParameterInfo(Object o, String name) {
        Object result = null;
        switch (name) {
        }
        if (result == null) {
            result = getPropertyForOrgApacheTomcatUtilModelerFeatureInfo(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheTomcatUtilModelerFeatureInfo(Object o, String name) {
        Object result = null;
        switch (name) {
            case "description" : 
                result = ((org.apache.tomcat.util.modeler.FeatureInfo)o).getDescription();
                break;
            case "name" : 
                result = ((org.apache.tomcat.util.modeler.FeatureInfo)o).getName();
                break;
            case "type" : 
                result = ((org.apache.tomcat.util.modeler.FeatureInfo)o).getType();
                break;
        }
        if (result == null) {
            result = null;
        }
        return result;
    }


    private static Object getPropertyForOrgApacheTomcatUtilModelerManagedBean(Object o, String name) {
        Object result = null;
        switch (name) {
            case "className" : 
                result = ((org.apache.tomcat.util.modeler.ManagedBean)o).getClassName();
                break;
            case "description" : 
                result = ((org.apache.tomcat.util.modeler.ManagedBean)o).getDescription();
                break;
            case "domain" : 
                result = ((org.apache.tomcat.util.modeler.ManagedBean)o).getDomain();
                break;
            case "group" : 
                result = ((org.apache.tomcat.util.modeler.ManagedBean)o).getGroup();
                break;
            case "name" : 
                result = ((org.apache.tomcat.util.modeler.ManagedBean)o).getName();
                break;
            case "type" : 
                result = ((org.apache.tomcat.util.modeler.ManagedBean)o).getType();
                break;
        }
        if (result == null) {
            result = null;
        }
        return result;
    }


    private static Object getPropertyForOrgApacheTomcatUtilNetNio2Endpoint(Object o, String name) {
        Object result = null;
        switch (name) {
            //no getAllClosed method found on this class
            //no getInline method found on this class
            case "keepAliveCount" : 
                result = ((org.apache.tomcat.util.net.Nio2Endpoint)o).getKeepAliveCount();
                break;
            //no getPreviousAcceptedSocketNanoTime method found on this class
        }
        if (result == null) {
            result = getPropertyForOrgApacheTomcatUtilNetAbstractNetworkChannelEndpoint(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheTomcatUtilNetNioEndpoint(Object o, String name) {
        Object result = null;
        switch (name) {
            case "id" : 
                result = ((org.apache.tomcat.util.net.NioEndpoint)o).getId();
                break;
            case "keepAliveCount" : 
                result = ((org.apache.tomcat.util.net.NioEndpoint)o).getKeepAliveCount();
                break;
            case "pollerThreadPriority" : 
                result = ((org.apache.tomcat.util.net.NioEndpoint)o).getPollerThreadPriority();
                break;
            //no getPreviousAcceptedSocketNanoTime method found on this class
            case "selectorTimeout" : 
                result = ((org.apache.tomcat.util.net.NioEndpoint)o).getSelectorTimeout();
                break;
            case "unixDomainSocketPath" : 
                result = ((org.apache.tomcat.util.net.NioEndpoint)o).getUnixDomainSocketPath();
                break;
            case "unixDomainSocketPathPermissions" : 
                result = ((org.apache.tomcat.util.net.NioEndpoint)o).getUnixDomainSocketPathPermissions();
                break;
            case "useInheritedChannel" : 
                result = ((org.apache.tomcat.util.net.NioEndpoint)o).getUseInheritedChannel();
                break;
        }
        if (result == null) {
            result = getPropertyForOrgApacheTomcatUtilNetAbstractNetworkChannelEndpoint(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheTomcatUtilNetAbstractNetworkChannelEndpoint(Object o, String name) {
        Object result = null;
        switch (name) {
        }
        if (result == null) {
            result = getPropertyForOrgApacheTomcatUtilNetAbstractEndpoint(o, name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheTomcatUtilNetAbstractEndpoint(Object o, String name) {
        Object result = null;
        switch (name) {
            case "SSLEnabled" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).isSSLEnabled();
                break;
            case "acceptCount" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getAcceptCount();
                break;
            case "acceptorThreadPriority" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getAcceptorThreadPriority();
                break;
            case "address" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getAddress();
                break;
            case "bindOnInit" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getBindOnInit();
                break;
            case "connectionCount" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getConnectionCount();
                break;
            case "connectionLinger" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getConnectionLinger();
                break;
            case "connectionTimeout" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getConnectionTimeout();
                break;
            case "currentThreadCount" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getCurrentThreadCount();
                break;
            case "currentThreadsBusy" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getCurrentThreadsBusy();
                break;
            case "daemon" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getDaemon();
                break;
            case "defaultSSLHostConfigName" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getDefaultSSLHostConfigName();
                break;
            case "domain" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getDomain();
                break;
            case "executorTerminationTimeoutMillis" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getExecutorTerminationTimeoutMillis();
                break;
            case "id" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getId();
                break;
            //no getInternalExecutor method found on this class
            case "keepAliveTimeout" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getKeepAliveTimeout();
                break;
            case "localPort" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getLocalPort();
                break;
            case "maxConnections" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getMaxConnections();
                break;
            case "maxKeepAliveRequests" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getMaxKeepAliveRequests();
                break;
            case "maxQueueSize" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getMaxQueueSize();
                break;
            case "maxThreads" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getMaxThreads();
                break;
            case "minSpareThreads" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getMinSpareThreads();
                break;
            case "name" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getName();
                break;
            //no getPaused method found on this class
            case "port" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getPort();
                break;
            case "portOffset" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getPortOffset();
                break;
            case "portWithOffset" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getPortWithOffset();
                break;
            //no getRunning method found on this class
            case "sniParseLimit" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getSniParseLimit();
                break;
            case "sslImplementationName" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getSslImplementationName();
                break;
            case "tcpNoDelay" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getTcpNoDelay();
                break;
            case "threadPriority" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getThreadPriority();
                break;
            case "threadsMaxIdleTime" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getThreadsMaxIdleTime();
                break;
            case "useAsyncIO" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getUseAsyncIO();
                break;
            case "useSendfile" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getUseSendfile();
                break;
            case "useVirtualThreads" : 
                result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getUseVirtualThreads();
                break;
        }
        if (result == null) {
            result = null;
        }
        if (result == null) {
            result = ((org.apache.tomcat.util.net.AbstractEndpoint)o).getProperty(name);
        }
        return result;
    }


    private static Object getPropertyForOrgApacheTomcatUtilNetSocketProperties(Object o, String name) {
        Object result = null;
        switch (name) {
            case "appReadBufSize" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getAppReadBufSize();
                break;
            case "appWriteBufSize" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getAppWriteBufSize();
                break;
            case "bufferPool" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getBufferPool();
                break;
            case "bufferPoolSize" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getBufferPoolSize();
                break;
            case "directBuffer" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getDirectBuffer();
                break;
            case "directBufferPool" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getDirectBufferPool();
                break;
            case "directSslBuffer" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getDirectSslBuffer();
                break;
            case "eventCache" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getEventCache();
                break;
            case "ooBInline" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getOoBInline();
                break;
            case "performanceBandwidth" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getPerformanceBandwidth();
                break;
            case "performanceConnectionTime" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getPerformanceConnectionTime();
                break;
            case "performanceLatency" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getPerformanceLatency();
                break;
            case "processorCache" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getProcessorCache();
                break;
            case "rxBufSize" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getRxBufSize();
                break;
            case "soKeepAlive" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getSoKeepAlive();
                break;
            case "soLingerOn" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getSoLingerOn();
                break;
            case "soLingerTime" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getSoLingerTime();
                break;
            case "soReuseAddress" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getSoReuseAddress();
                break;
            case "soTimeout" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getSoTimeout();
                break;
            case "tcpNoDelay" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getTcpNoDelay();
                break;
            case "timeoutInterval" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getTimeoutInterval();
                break;
            case "txBufSize" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getTxBufSize();
                break;
            case "unlockTimeout" : 
                result = ((org.apache.tomcat.util.net.SocketProperties)o).getUnlockTimeout();
                break;
        }
        if (result == null) {
            result = null;
        }
        return result;
    }


    static boolean setPropertyInternal(Object o, String name, String value, boolean invokeSetProperty) {
        Class<?> checkThisClass = o.getClass();
        while (checkThisClass != Object.class) {
            switch (checkThisClass.getName()) {
                case "org.apache.catalina.authenticator.jaspic.SimpleAuthConfigProvider" : 
                    return setPropertyForOrgApacheCatalinaAuthenticatorJaspicSimpleAuthConfigProvider(o, name, value, invokeSetProperty);
                case "org.apache.catalina.authenticator.jaspic.PersistentProviderRegistrations$Property" : 
                    return setPropertyForOrgApacheCatalinaAuthenticatorJaspicPersistentProviderRegistrationsProperty(o, name, value, invokeSetProperty);
                case "org.apache.catalina.authenticator.jaspic.PersistentProviderRegistrations$Provider" : 
                    return setPropertyForOrgApacheCatalinaAuthenticatorJaspicPersistentProviderRegistrationsProvider(o, name, value, invokeSetProperty);
                case "org.apache.catalina.connector.Connector" : 
                    return setPropertyForOrgApacheCatalinaConnectorConnector(o, name, value, invokeSetProperty);
                case "org.apache.catalina.core.StandardContext" : 
                    return setPropertyForOrgApacheCatalinaCoreStandardContext(o, name, value, invokeSetProperty);
                case "org.apache.catalina.core.StandardEngine" : 
                    return setPropertyForOrgApacheCatalinaCoreStandardEngine(o, name, value, invokeSetProperty);
                case "org.apache.catalina.core.StandardHost" : 
                    return setPropertyForOrgApacheCatalinaCoreStandardHost(o, name, value, invokeSetProperty);
                case "org.apache.catalina.core.StandardServer" : 
                    return setPropertyForOrgApacheCatalinaCoreStandardServer(o, name, value, invokeSetProperty);
                case "org.apache.catalina.core.StandardService" : 
                    return setPropertyForOrgApacheCatalinaCoreStandardService(o, name, value, invokeSetProperty);
                case "org.apache.catalina.realm.UserDatabaseRealm" : 
                    return setPropertyForOrgApacheCatalinaRealmUserDatabaseRealm(o, name, value, invokeSetProperty);
                case "org.apache.catalina.valves.AccessLogValve" : 
                    return setPropertyForOrgApacheCatalinaValvesAccessLogValve(o, name, value, invokeSetProperty);
                case "org.apache.catalina.filters.AddDefaultCharsetFilter" : 
                    return setPropertyForOrgApacheCatalinaFiltersAddDefaultCharsetFilter(o, name, value, invokeSetProperty);
                case "org.apache.catalina.filters.RestCsrfPreventionFilter" : 
                    return setPropertyForOrgApacheCatalinaFiltersRestCsrfPreventionFilter(o, name, value, invokeSetProperty);
                case "org.apache.catalina.loader.ParallelWebappClassLoader" : 
                    return setPropertyForOrgApacheCatalinaLoaderParallelWebappClassLoader(o, name, value, invokeSetProperty);
                case "java.net.URLClassLoader" : 
                    return setPropertyForJavaNetURLClassLoader(o, name, value, invokeSetProperty);
                case "java.security.SecureClassLoader" : 
                    return setPropertyForJavaSecuritySecureClassLoader(o, name, value, invokeSetProperty);
                case "org.apache.coyote.ajp.AjpNio2Protocol" : 
                    return setPropertyForOrgApacheCoyoteAjpAjpNio2Protocol(o, name, value, invokeSetProperty);
                case "org.apache.coyote.ajp.AjpNioProtocol" : 
                    return setPropertyForOrgApacheCoyoteAjpAjpNioProtocol(o, name, value, invokeSetProperty);
                case "org.apache.coyote.http11.Http11Nio2Protocol" : 
                    return setPropertyForOrgApacheCoyoteHttp11Http11Nio2Protocol(o, name, value, invokeSetProperty);
                case "org.apache.coyote.http11.Http11NioProtocol" : 
                    return setPropertyForOrgApacheCoyoteHttp11Http11NioProtocol(o, name, value, invokeSetProperty);
                case "org.apache.tomcat.util.descriptor.web.ContextResource" : 
                    return setPropertyForOrgApacheTomcatUtilDescriptorWebContextResource(o, name, value, invokeSetProperty);
                case "org.apache.tomcat.util.descriptor.web.ResourceBase" : 
                    return setPropertyForOrgApacheTomcatUtilDescriptorWebResourceBase(o, name, value, invokeSetProperty);
                case "org.apache.tomcat.util.modeler.AttributeInfo" : 
                    return setPropertyForOrgApacheTomcatUtilModelerAttributeInfo(o, name, value, invokeSetProperty);
                case "org.apache.tomcat.util.modeler.OperationInfo" : 
                    return setPropertyForOrgApacheTomcatUtilModelerOperationInfo(o, name, value, invokeSetProperty);
                case "org.apache.tomcat.util.modeler.ParameterInfo" : 
                    return setPropertyForOrgApacheTomcatUtilModelerParameterInfo(o, name, value, invokeSetProperty);
                case "org.apache.tomcat.util.modeler.FeatureInfo" : 
                    return setPropertyForOrgApacheTomcatUtilModelerFeatureInfo(o, name, value, invokeSetProperty);
                case "org.apache.tomcat.util.modeler.ManagedBean" : 
                    return setPropertyForOrgApacheTomcatUtilModelerManagedBean(o, name, value, invokeSetProperty);
                case "org.apache.tomcat.util.net.Nio2Endpoint" : 
                    return setPropertyForOrgApacheTomcatUtilNetNio2Endpoint(o, name, value, invokeSetProperty);
                case "org.apache.tomcat.util.net.NioEndpoint" : 
                    return setPropertyForOrgApacheTomcatUtilNetNioEndpoint(o, name, value, invokeSetProperty);
                case "org.apache.tomcat.util.net.SocketProperties" : 
                    return setPropertyForOrgApacheTomcatUtilNetSocketProperties(o, name, value, invokeSetProperty);
            }
            checkThisClass = checkThisClass.getSuperclass();
        }
        return false;
    }
    private static boolean setPropertyForOrgApacheCatalinaAuthenticatorJaspicSimpleAuthConfigProvider(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
        }
        return false;
    }

    private static boolean setPropertyForOrgApacheCatalinaAuthenticatorJaspicPersistentProviderRegistrationsProperty(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "name" : 
                ((org.apache.catalina.authenticator.jaspic.PersistentProviderRegistrations.Property)o).setName(value);
                return true;
            case "value" : 
                ((org.apache.catalina.authenticator.jaspic.PersistentProviderRegistrations.Property)o).setValue(value);
                return true;
        }
        return false;
    }

    private static boolean setPropertyForOrgApacheCatalinaAuthenticatorJaspicPersistentProviderRegistrationsProvider(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "appContext" : 
                ((org.apache.catalina.authenticator.jaspic.PersistentProviderRegistrations.Provider)o).setAppContext(value);
                return true;
            case "className" : 
                ((org.apache.catalina.authenticator.jaspic.PersistentProviderRegistrations.Provider)o).setClassName(value);
                return true;
            case "description" : 
                ((org.apache.catalina.authenticator.jaspic.PersistentProviderRegistrations.Provider)o).setDescription(value);
                return true;
            case "layer" : 
                ((org.apache.catalina.authenticator.jaspic.PersistentProviderRegistrations.Provider)o).setLayer(value);
                return true;
        }
        if (invokeSetProperty) {
            ((org.apache.catalina.authenticator.jaspic.PersistentProviderRegistrations.Provider)o).setProperty(name, value);
            return true;
        }
        return true;
    }

    private static boolean setPropertyForOrgApacheCatalinaConnectorConnector(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "URIEncoding" : 
                ((org.apache.catalina.connector.Connector)o).setURIEncoding(value);
                return true;
            case "allowBackslash" : 
                ((org.apache.catalina.connector.Connector)o).setAllowBackslash(Boolean.valueOf(value));
                return true;
            case "allowTrace" : 
                ((org.apache.catalina.connector.Connector)o).setAllowTrace(Boolean.valueOf(value));
                return true;
            case "asyncTimeout" : 
                ((org.apache.catalina.connector.Connector)o).setAsyncTimeout(Long.valueOf(value));
                return true;
            case "discardFacades" : 
                ((org.apache.catalina.connector.Connector)o).setDiscardFacades(Boolean.valueOf(value));
                return true;
            case "domainInternal" : 
                ((org.apache.catalina.connector.Connector)o).setProperty(name, value);
                return true;
            case "enableLookups" : 
                ((org.apache.catalina.connector.Connector)o).setEnableLookups(Boolean.valueOf(value));
                return true;
            case "encodedReverseSolidusHandling" : 
                ((org.apache.catalina.connector.Connector)o).setEncodedReverseSolidusHandling(value);
                return true;
            case "encodedSolidusHandling" : 
                ((org.apache.catalina.connector.Connector)o).setEncodedSolidusHandling(value);
                return true;
            case "enforceEncodingInGetWriter" : 
                ((org.apache.catalina.connector.Connector)o).setEnforceEncodingInGetWriter(Boolean.valueOf(value));
                return true;
            case "executorName" : 
                ((org.apache.catalina.connector.Connector)o).setProperty(name, value);
                return true;
            case "localPort" : 
                ((org.apache.catalina.connector.Connector)o).setProperty(name, value);
                return true;
            case "maxCookieCount" : 
                ((org.apache.catalina.connector.Connector)o).setMaxCookieCount(Integer.valueOf(value));
                return true;
            case "maxParameterCount" : 
                ((org.apache.catalina.connector.Connector)o).setMaxParameterCount(Integer.valueOf(value));
                return true;
            case "maxPostSize" : 
                ((org.apache.catalina.connector.Connector)o).setMaxPostSize(Integer.valueOf(value));
                return true;
            case "maxSavePostSize" : 
                ((org.apache.catalina.connector.Connector)o).setMaxSavePostSize(Integer.valueOf(value));
                return true;
            case "objectNameKeyProperties" : 
                ((org.apache.catalina.connector.Connector)o).setProperty(name, value);
                return true;
            case "parseBodyMethods" : 
                ((org.apache.catalina.connector.Connector)o).setParseBodyMethods(value);
                return true;
            case "port" : 
                ((org.apache.catalina.connector.Connector)o).setPort(Integer.valueOf(value));
                return true;
            case "portOffset" : 
                ((org.apache.catalina.connector.Connector)o).setPortOffset(Integer.valueOf(value));
                return true;
            case "portWithOffset" : 
                ((org.apache.catalina.connector.Connector)o).setProperty(name, value);
                return true;
            case "protocol" : 
                ((org.apache.catalina.connector.Connector)o).setProperty(name, value);
                return true;
            case "protocolHandlerClassName" : 
                ((org.apache.catalina.connector.Connector)o).setProperty(name, value);
                return true;
            case "proxyName" : 
                ((org.apache.catalina.connector.Connector)o).setProxyName(value);
                return true;
            case "proxyPort" : 
                ((org.apache.catalina.connector.Connector)o).setProxyPort(Integer.valueOf(value));
                return true;
            case "redirectPort" : 
                ((org.apache.catalina.connector.Connector)o).setRedirectPort(Integer.valueOf(value));
                return true;
            case "redirectPortWithOffset" : 
                ((org.apache.catalina.connector.Connector)o).setProperty(name, value);
                return true;
            case "rejectSuspiciousURIs" : 
                ((org.apache.catalina.connector.Connector)o).setRejectSuspiciousURIs(Boolean.valueOf(value));
                return true;
            case "scheme" : 
                ((org.apache.catalina.connector.Connector)o).setScheme(value);
                return true;
            case "secure" : 
                ((org.apache.catalina.connector.Connector)o).setSecure(Boolean.valueOf(value));
                return true;
            case "useBodyEncodingForURI" : 
                ((org.apache.catalina.connector.Connector)o).setUseBodyEncodingForURI(Boolean.valueOf(value));
                return true;
            case "useIPVHosts" : 
                ((org.apache.catalina.connector.Connector)o).setUseIPVHosts(Boolean.valueOf(value));
                return true;
            case "xpoweredBy" : 
                ((org.apache.catalina.connector.Connector)o).setXpoweredBy(Boolean.valueOf(value));
                return true;
        }
        if (invokeSetProperty) {
            ((org.apache.catalina.connector.Connector)o).setProperty(name, value);
            return true;
        }
        return setPropertyForOrgApacheCatalinaUtilLifecycleMBeanBase(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCatalinaCoreStandardContext(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "addWebinfClassesResources" : 
                ((org.apache.catalina.core.StandardContext)o).setAddWebinfClassesResources(Boolean.valueOf(value));
                return true;
            case "allowCasualMultipartParsing" : 
                ((org.apache.catalina.core.StandardContext)o).setAllowCasualMultipartParsing(Boolean.valueOf(value));
                return true;
            case "allowMultipleLeadingForwardSlashInPath" : 
                ((org.apache.catalina.core.StandardContext)o).setAllowMultipleLeadingForwardSlashInPath(Boolean.valueOf(value));
                return true;
            case "altDDName" : 
                ((org.apache.catalina.core.StandardContext)o).setAltDDName(value);
                return true;
            case "alwaysAccessSession" : 
                ((org.apache.catalina.core.StandardContext)o).setAlwaysAccessSession(Boolean.valueOf(value));
                return true;
            case "antiResourceLocking" : 
                ((org.apache.catalina.core.StandardContext)o).setAntiResourceLocking(Boolean.valueOf(value));
                return true;
            //no setBaseName method found on this class
            case "charsetMapperClass" : 
                ((org.apache.catalina.core.StandardContext)o).setCharsetMapperClass(value);
                return true;
            case "clearReferencesHttpClientKeepAliveThread" : 
                ((org.apache.catalina.core.StandardContext)o).setClearReferencesHttpClientKeepAliveThread(Boolean.valueOf(value));
                return true;
            case "clearReferencesRmiTargets" : 
                ((org.apache.catalina.core.StandardContext)o).setClearReferencesRmiTargets(Boolean.valueOf(value));
                return true;
            case "clearReferencesStopThreads" : 
                ((org.apache.catalina.core.StandardContext)o).setClearReferencesStopThreads(Boolean.valueOf(value));
                return true;
            case "clearReferencesStopTimerThreads" : 
                ((org.apache.catalina.core.StandardContext)o).setClearReferencesStopTimerThreads(Boolean.valueOf(value));
                return true;
            case "clearReferencesThreadLocals" : 
                ((org.apache.catalina.core.StandardContext)o).setClearReferencesThreadLocals(Boolean.valueOf(value));
                return true;
            //no setComputedFailCtxIfServletStartFails method found on this class
            case "configured" : 
                ((org.apache.catalina.core.StandardContext)o).setConfigured(Boolean.valueOf(value));
                return true;
            case "containerSciFilter" : 
                ((org.apache.catalina.core.StandardContext)o).setContainerSciFilter(value);
                return true;
            case "contextGetResourceRequiresSlash" : 
                ((org.apache.catalina.core.StandardContext)o).setContextGetResourceRequiresSlash(Boolean.valueOf(value));
                return true;
            case "cookies" : 
                ((org.apache.catalina.core.StandardContext)o).setCookies(Boolean.valueOf(value));
                return true;
            case "copyXML" : 
                ((org.apache.catalina.core.StandardContext)o).setCopyXML(Boolean.valueOf(value));
                return true;
            case "createUploadTargets" : 
                ((org.apache.catalina.core.StandardContext)o).setCreateUploadTargets(Boolean.valueOf(value));
                return true;
            case "crossContext" : 
                ((org.apache.catalina.core.StandardContext)o).setCrossContext(Boolean.valueOf(value));
                return true;
            case "defaultContextXml" : 
                ((org.apache.catalina.core.StandardContext)o).setDefaultContextXml(value);
                return true;
            case "defaultWebXml" : 
                ((org.apache.catalina.core.StandardContext)o).setDefaultWebXml(value);
                return true;
            case "delegate" : 
                ((org.apache.catalina.core.StandardContext)o).setDelegate(Boolean.valueOf(value));
                return true;
            case "denyUncoveredHttpMethods" : 
                ((org.apache.catalina.core.StandardContext)o).setDenyUncoveredHttpMethods(Boolean.valueOf(value));
                return true;
            case "dispatcherWrapsSameObject" : 
                ((org.apache.catalina.core.StandardContext)o).setDispatcherWrapsSameObject(Boolean.valueOf(value));
                return true;
            case "dispatchersUseEncodedPaths" : 
                ((org.apache.catalina.core.StandardContext)o).setDispatchersUseEncodedPaths(Boolean.valueOf(value));
                return true;
            case "displayName" : 
                ((org.apache.catalina.core.StandardContext)o).setDisplayName(value);
                return true;
            case "distributable" : 
                ((org.apache.catalina.core.StandardContext)o).setDistributable(Boolean.valueOf(value));
                return true;
            case "docBase" : 
                ((org.apache.catalina.core.StandardContext)o).setDocBase(value);
                return true;
            case "effectiveMajorVersion" : 
                ((org.apache.catalina.core.StandardContext)o).setEffectiveMajorVersion(Integer.valueOf(value));
                return true;
            case "effectiveMinorVersion" : 
                ((org.apache.catalina.core.StandardContext)o).setEffectiveMinorVersion(Integer.valueOf(value));
                return true;
            //no setEncodedPath method found on this class
            case "encodedReverseSolidusHandling" : 
                ((org.apache.catalina.core.StandardContext)o).setEncodedReverseSolidusHandling(value);
                return true;
            case "encodedSolidusHandling" : 
                ((org.apache.catalina.core.StandardContext)o).setEncodedSolidusHandling(value);
                return true;
            //no setErrorCount method found on this class
            case "fireRequestListenersOnForwards" : 
                ((org.apache.catalina.core.StandardContext)o).setFireRequestListenersOnForwards(Boolean.valueOf(value));
                return true;
            case "ignoreAnnotations" : 
                ((org.apache.catalina.core.StandardContext)o).setIgnoreAnnotations(Boolean.valueOf(value));
                return true;
            //no setInProgressAsyncCount method found on this class
            case "j2EEApplication" : 
                ((org.apache.catalina.core.StandardContext)o).setJ2EEApplication(value);
                return true;
            case "j2EEServer" : 
                ((org.apache.catalina.core.StandardContext)o).setJ2EEServer(value);
                return true;
            case "jndiExceptionOnFailedWrite" : 
                ((org.apache.catalina.core.StandardContext)o).setJndiExceptionOnFailedWrite(Boolean.valueOf(value));
                return true;
            case "logEffectiveWebXml" : 
                ((org.apache.catalina.core.StandardContext)o).setLogEffectiveWebXml(Boolean.valueOf(value));
                return true;
            case "mapperContextRootRedirectEnabled" : 
                ((org.apache.catalina.core.StandardContext)o).setMapperContextRootRedirectEnabled(Boolean.valueOf(value));
                return true;
            case "mapperDirectoryRedirectEnabled" : 
                ((org.apache.catalina.core.StandardContext)o).setMapperDirectoryRedirectEnabled(Boolean.valueOf(value));
                return true;
            //no setMaxTime method found on this class
            case "metadataComplete" : 
                ((org.apache.catalina.core.StandardContext)o).setMetadataComplete(Boolean.valueOf(value));
                return true;
            //no setMinTime method found on this class
            //no setNamingContextName method found on this class
            case "notFoundClassResourceCacheSize" : 
                ((org.apache.catalina.core.StandardContext)o).setNotFoundClassResourceCacheSize(Integer.valueOf(value));
                return true;
            //no setObjectNameKeyProperties method found on this class
            case "originalDocBase" : 
                ((org.apache.catalina.core.StandardContext)o).setOriginalDocBase(value);
                return true;
            case "override" : 
                ((org.apache.catalina.core.StandardContext)o).setOverride(Boolean.valueOf(value));
                return true;
            case "parallelAnnotationScanning" : 
                ((org.apache.catalina.core.StandardContext)o).setParallelAnnotationScanning(Boolean.valueOf(value));
                return true;
            case "path" : 
                ((org.apache.catalina.core.StandardContext)o).setPath(value);
                return true;
            //no setPaused method found on this class
            case "preemptiveAuthentication" : 
                ((org.apache.catalina.core.StandardContext)o).setPreemptiveAuthentication(Boolean.valueOf(value));
                return true;
            case "privileged" : 
                ((org.apache.catalina.core.StandardContext)o).setPrivileged(Boolean.valueOf(value));
                return true;
            //no setProcessingTime method found on this class
            case "publicId" : 
                ((org.apache.catalina.core.StandardContext)o).setPublicId(value);
                return true;
            case "reloadable" : 
                ((org.apache.catalina.core.StandardContext)o).setReloadable(Boolean.valueOf(value));
                return true;
            case "renewThreadsWhenStoppingContext" : 
                ((org.apache.catalina.core.StandardContext)o).setRenewThreadsWhenStoppingContext(Boolean.valueOf(value));
                return true;
            case "replaceWelcomeFiles" : 
                ((org.apache.catalina.core.StandardContext)o).setReplaceWelcomeFiles(Boolean.valueOf(value));
                return true;
            case "requestCharacterEncoding" : 
                ((org.apache.catalina.core.StandardContext)o).setRequestCharacterEncoding(value);
                return true;
            //no setRequestCount method found on this class
            //no setRequestEncoding method found on this class
            case "resourceOnlyServlets" : 
                ((org.apache.catalina.core.StandardContext)o).setResourceOnlyServlets(value);
                return true;
            case "responseCharacterEncoding" : 
                ((org.apache.catalina.core.StandardContext)o).setResponseCharacterEncoding(value);
                return true;
            //no setResponseEncoding method found on this class
            case "sendRedirectBody" : 
                ((org.apache.catalina.core.StandardContext)o).setSendRedirectBody(Boolean.valueOf(value));
                return true;
            case "server" : 
                ((org.apache.catalina.core.StandardContext)o).setServer(value);
                return true;
            //no setServlet22 method found on this class
            case "sessionCookieDomain" : 
                ((org.apache.catalina.core.StandardContext)o).setSessionCookieDomain(value);
                return true;
            case "sessionCookieName" : 
                ((org.apache.catalina.core.StandardContext)o).setSessionCookieName(value);
                return true;
            case "sessionCookiePath" : 
                ((org.apache.catalina.core.StandardContext)o).setSessionCookiePath(value);
                return true;
            case "sessionCookiePathUsesTrailingSlash" : 
                ((org.apache.catalina.core.StandardContext)o).setSessionCookiePathUsesTrailingSlash(Boolean.valueOf(value));
                return true;
            case "sessionTimeout" : 
                ((org.apache.catalina.core.StandardContext)o).setSessionTimeout(Integer.valueOf(value));
                return true;
            case "skipMemoryLeakChecksOnJvmShutdown" : 
                ((org.apache.catalina.core.StandardContext)o).setSkipMemoryLeakChecksOnJvmShutdown(Boolean.valueOf(value));
                return true;
            //no setStartTime method found on this class
            case "startupTime" : 
                ((org.apache.catalina.core.StandardContext)o).setStartupTime(Long.valueOf(value));
                return true;
            case "suspendWrappedResponseAfterForward" : 
                ((org.apache.catalina.core.StandardContext)o).setSuspendWrappedResponseAfterForward(Boolean.valueOf(value));
                return true;
            case "swallowAbortedUploads" : 
                ((org.apache.catalina.core.StandardContext)o).setSwallowAbortedUploads(Boolean.valueOf(value));
                return true;
            case "swallowOutput" : 
                ((org.apache.catalina.core.StandardContext)o).setSwallowOutput(Boolean.valueOf(value));
                return true;
            case "tldScanTime" : 
                ((org.apache.catalina.core.StandardContext)o).setTldScanTime(Long.valueOf(value));
                return true;
            case "tldValidation" : 
                ((org.apache.catalina.core.StandardContext)o).setTldValidation(Boolean.valueOf(value));
                return true;
            case "unloadDelay" : 
                ((org.apache.catalina.core.StandardContext)o).setUnloadDelay(Long.valueOf(value));
                return true;
            case "unpackWAR" : 
                ((org.apache.catalina.core.StandardContext)o).setUnpackWAR(Boolean.valueOf(value));
                return true;
            case "useHttpOnly" : 
                ((org.apache.catalina.core.StandardContext)o).setUseHttpOnly(Boolean.valueOf(value));
                return true;
            case "useNaming" : 
                ((org.apache.catalina.core.StandardContext)o).setUseNaming(Boolean.valueOf(value));
                return true;
            case "usePartitioned" : 
                ((org.apache.catalina.core.StandardContext)o).setUsePartitioned(Boolean.valueOf(value));
                return true;
            case "useRelativeRedirects" : 
                ((org.apache.catalina.core.StandardContext)o).setUseRelativeRedirects(Boolean.valueOf(value));
                return true;
            case "validateClientProvidedNewSessionId" : 
                ((org.apache.catalina.core.StandardContext)o).setValidateClientProvidedNewSessionId(Boolean.valueOf(value));
                return true;
            //no setWebXmlNamespaceAware method found on this class
            //no setWebXmlValidation method found on this class
            case "webappVersion" : 
                ((org.apache.catalina.core.StandardContext)o).setWebappVersion(value);
                return true;
            case "workDir" : 
                ((org.apache.catalina.core.StandardContext)o).setWorkDir(value);
                return true;
            //no setWorkPath method found on this class
            case "wrapperClass" : 
                ((org.apache.catalina.core.StandardContext)o).setWrapperClass(value);
                return true;
            //no setWrapperClassName method found on this class
            case "xmlBlockExternal" : 
                ((org.apache.catalina.core.StandardContext)o).setXmlBlockExternal(Boolean.valueOf(value));
                return true;
            case "xmlNamespaceAware" : 
                ((org.apache.catalina.core.StandardContext)o).setXmlNamespaceAware(Boolean.valueOf(value));
                return true;
            case "xmlValidation" : 
                ((org.apache.catalina.core.StandardContext)o).setXmlValidation(Boolean.valueOf(value));
                return true;
        }
        return setPropertyForOrgApacheCatalinaCoreContainerBase(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCatalinaCoreStandardEngine(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "defaultHost" : 
                ((org.apache.catalina.core.StandardEngine)o).setDefaultHost(value);
                return true;
            //no setDomainInternal method found on this class
            case "jvmRoute" : 
                ((org.apache.catalina.core.StandardEngine)o).setJvmRoute(value);
                return true;
            //no setJvmRouteId method found on this class
            //no setObjectNameKeyProperties method found on this class
        }
        return setPropertyForOrgApacheCatalinaCoreContainerBase(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCatalinaCoreStandardHost(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "appBase" : 
                ((org.apache.catalina.core.StandardHost)o).setAppBase(value);
                return true;
            case "autoDeploy" : 
                ((org.apache.catalina.core.StandardHost)o).setAutoDeploy(Boolean.valueOf(value));
                return true;
            case "configClass" : 
                ((org.apache.catalina.core.StandardHost)o).setConfigClass(value);
                return true;
            case "contextClass" : 
                ((org.apache.catalina.core.StandardHost)o).setContextClass(value);
                return true;
            case "copyXML" : 
                ((org.apache.catalina.core.StandardHost)o).setCopyXML(Boolean.valueOf(value));
                return true;
            case "createDirs" : 
                ((org.apache.catalina.core.StandardHost)o).setCreateDirs(Boolean.valueOf(value));
                return true;
            case "deployIgnore" : 
                ((org.apache.catalina.core.StandardHost)o).setDeployIgnore(value);
                return true;
            case "deployOnStartup" : 
                ((org.apache.catalina.core.StandardHost)o).setDeployOnStartup(Boolean.valueOf(value));
                return true;
            case "deployXML" : 
                ((org.apache.catalina.core.StandardHost)o).setDeployXML(Boolean.valueOf(value));
                return true;
            case "errorReportValveClass" : 
                ((org.apache.catalina.core.StandardHost)o).setErrorReportValveClass(value);
                return true;
            case "failCtxIfServletStartFails" : 
                ((org.apache.catalina.core.StandardHost)o).setFailCtxIfServletStartFails(Boolean.valueOf(value));
                return true;
            case "legacyAppBase" : 
                ((org.apache.catalina.core.StandardHost)o).setLegacyAppBase(value);
                return true;
            case "name" : 
                ((org.apache.catalina.core.StandardHost)o).setName(value);
                return true;
            //no setObjectNameKeyProperties method found on this class
            case "undeployOldVersions" : 
                ((org.apache.catalina.core.StandardHost)o).setUndeployOldVersions(Boolean.valueOf(value));
                return true;
            case "unpackWARs" : 
                ((org.apache.catalina.core.StandardHost)o).setUnpackWARs(Boolean.valueOf(value));
                return true;
            case "workDir" : 
                ((org.apache.catalina.core.StandardHost)o).setWorkDir(value);
                return true;
            case "xmlBase" : 
                ((org.apache.catalina.core.StandardHost)o).setXmlBase(value);
                return true;
        }
        return setPropertyForOrgApacheCatalinaCoreContainerBase(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCatalinaCoreContainerBase(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            //no setMBeanKeyProperties method found on this class
            //no setAccessLogScanComplete method found on this class
            case "backgroundProcessorDelay" : 
                ((org.apache.catalina.core.ContainerBase)o).setBackgroundProcessorDelay(Integer.valueOf(value));
                return true;
            //no setDomainInternal method found on this class
            //no setLogName method found on this class
            case "name" : 
                ((org.apache.catalina.core.ContainerBase)o).setName(value);
                return true;
            case "startChildren" : 
                ((org.apache.catalina.core.ContainerBase)o).setStartChildren(Boolean.valueOf(value));
                return true;
            case "startStopThreads" : 
                ((org.apache.catalina.core.ContainerBase)o).setStartStopThreads(Integer.valueOf(value));
                return true;
        }
        return setPropertyForOrgApacheCatalinaUtilLifecycleMBeanBase(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCatalinaCoreStandardServer(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "address" : 
                ((org.apache.catalina.core.StandardServer)o).setAddress(value);
                return true;
            //no setDomainInternal method found on this class
            //no setObjectNameKeyProperties method found on this class
            case "periodicEventDelay" : 
                ((org.apache.catalina.core.StandardServer)o).setPeriodicEventDelay(Integer.valueOf(value));
                return true;
            case "port" : 
                ((org.apache.catalina.core.StandardServer)o).setPort(Integer.valueOf(value));
                return true;
            case "portOffset" : 
                ((org.apache.catalina.core.StandardServer)o).setPortOffset(Integer.valueOf(value));
                return true;
            //no setPortWithOffset method found on this class
            //no setServerBuilt method found on this class
            //no setServerInfo method found on this class
            //no setServerNumber method found on this class
            case "shutdown" : 
                ((org.apache.catalina.core.StandardServer)o).setShutdown(value);
                return true;
            //no setStopAwait method found on this class
            case "utilityThreads" : 
                ((org.apache.catalina.core.StandardServer)o).setUtilityThreads(Integer.valueOf(value));
                return true;
            case "utilityThreadsAsDaemon" : 
                ((org.apache.catalina.core.StandardServer)o).setUtilityThreadsAsDaemon(Boolean.valueOf(value));
                return true;
        }
        return setPropertyForOrgApacheCatalinaUtilLifecycleMBeanBase(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCatalinaCoreStandardService(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            //no setDomainInternal method found on this class
            case "gracefulStopAwaitMillis" : 
                ((org.apache.catalina.core.StandardService)o).setGracefulStopAwaitMillis(Long.valueOf(value));
                return true;
            case "name" : 
                ((org.apache.catalina.core.StandardService)o).setName(value);
                return true;
            //no setObjectNameKeyProperties method found on this class
        }
        return setPropertyForOrgApacheCatalinaUtilLifecycleMBeanBase(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCatalinaRealmUserDatabaseRealm(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            //no setAvailable method found on this class
            case "localJndiResource" : 
                ((org.apache.catalina.realm.UserDatabaseRealm)o).setLocalJndiResource(Boolean.valueOf(value));
                return true;
            case "resourceName" : 
                ((org.apache.catalina.realm.UserDatabaseRealm)o).setResourceName(value);
                return true;
            case "useStaticPrincipal" : 
                ((org.apache.catalina.realm.UserDatabaseRealm)o).setUseStaticPrincipal(Boolean.valueOf(value));
                return true;
        }
        return setPropertyForOrgApacheCatalinaRealmRealmBase(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCatalinaRealmRealmBase(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "allRolesMode" : 
                ((org.apache.catalina.realm.RealmBase)o).setAllRolesMode(value);
                return true;
            //no setDomainInternal method found on this class
            //no setObjectNameKeyProperties method found on this class
            case "realmPath" : 
                ((org.apache.catalina.realm.RealmBase)o).setRealmPath(value);
                return true;
            //no setRealmSuffix method found on this class
            case "stripRealmForGss" : 
                ((org.apache.catalina.realm.RealmBase)o).setStripRealmForGss(Boolean.valueOf(value));
                return true;
            case "transportGuaranteeRedirectStatus" : 
                ((org.apache.catalina.realm.RealmBase)o).setTransportGuaranteeRedirectStatus(Integer.valueOf(value));
                return true;
            case "userAttributes" : 
                ((org.apache.catalina.realm.RealmBase)o).setUserAttributes(value);
                return true;
            case "validate" : 
                ((org.apache.catalina.realm.RealmBase)o).setValidate(Boolean.valueOf(value));
                return true;
            case "x509UsernameRetrieverClassName" : 
                ((org.apache.catalina.realm.RealmBase)o).setX509UsernameRetrieverClassName(value);
                return true;
        }
        return setPropertyForOrgApacheCatalinaUtilLifecycleMBeanBase(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCatalinaValvesAccessLogValve(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "buffered" : 
                ((org.apache.catalina.valves.AccessLogValve)o).setBuffered(Boolean.valueOf(value));
                return true;
            case "checkExists" : 
                ((org.apache.catalina.valves.AccessLogValve)o).setCheckExists(Boolean.valueOf(value));
                return true;
            //no setCheckForOldLogs method found on this class
            //no setDateStamp method found on this class
            case "directory" : 
                ((org.apache.catalina.valves.AccessLogValve)o).setDirectory(value);
                return true;
            case "encoding" : 
                ((org.apache.catalina.valves.AccessLogValve)o).setEncoding(value);
                return true;
            case "fileDateFormat" : 
                ((org.apache.catalina.valves.AccessLogValve)o).setFileDateFormat(value);
                return true;
            case "maxDays" : 
                ((org.apache.catalina.valves.AccessLogValve)o).setMaxDays(Integer.valueOf(value));
                return true;
            case "prefix" : 
                ((org.apache.catalina.valves.AccessLogValve)o).setPrefix(value);
                return true;
            case "renameOnRotate" : 
                ((org.apache.catalina.valves.AccessLogValve)o).setRenameOnRotate(Boolean.valueOf(value));
                return true;
            case "rotatable" : 
                ((org.apache.catalina.valves.AccessLogValve)o).setRotatable(Boolean.valueOf(value));
                return true;
            //no setRotationLastChecked method found on this class
            case "suffix" : 
                ((org.apache.catalina.valves.AccessLogValve)o).setSuffix(value);
                return true;
        }
        return setPropertyForOrgApacheCatalinaValvesAbstractAccessLogValve(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCatalinaValvesAbstractAccessLogValve(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "condition" : 
                ((org.apache.catalina.valves.AbstractAccessLogValve)o).setCondition(value);
                return true;
            case "conditionIf" : 
                ((org.apache.catalina.valves.AbstractAccessLogValve)o).setConditionIf(value);
                return true;
            case "conditionUnless" : 
                ((org.apache.catalina.valves.AbstractAccessLogValve)o).setConditionUnless(value);
                return true;
            case "enabled" : 
                ((org.apache.catalina.valves.AbstractAccessLogValve)o).setEnabled(Boolean.valueOf(value));
                return true;
            case "ipv6Canonical" : 
                ((org.apache.catalina.valves.AbstractAccessLogValve)o).setIpv6Canonical(Boolean.valueOf(value));
                return true;
            case "locale" : 
                ((org.apache.catalina.valves.AbstractAccessLogValve)o).setLocale(value);
                return true;
            //no setLocaleName method found on this class
            case "maxLogMessageBufferSize" : 
                ((org.apache.catalina.valves.AbstractAccessLogValve)o).setMaxLogMessageBufferSize(Integer.valueOf(value));
                return true;
            case "pattern" : 
                ((org.apache.catalina.valves.AbstractAccessLogValve)o).setPattern(value);
                return true;
            case "requestAttributesEnabled" : 
                ((org.apache.catalina.valves.AbstractAccessLogValve)o).setRequestAttributesEnabled(Boolean.valueOf(value));
                return true;
            //no setTlsAttributeRequired method found on this class
        }
        return setPropertyForOrgApacheCatalinaValvesValveBase(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCatalinaValvesValveBase(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "asyncSupported" : 
                ((org.apache.catalina.valves.ValveBase)o).setAsyncSupported(Boolean.valueOf(value));
                return true;
            //no setDomainInternal method found on this class
            //no setObjectNameKeyProperties method found on this class
        }
        return setPropertyForOrgApacheCatalinaUtilLifecycleMBeanBase(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCatalinaUtilLifecycleMBeanBase(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "domain" : 
                ((org.apache.catalina.util.LifecycleMBeanBase)o).setDomain(value);
                return true;
            //no setDomainInternal method found on this class
            //no setObjectNameKeyProperties method found on this class
        }
        return setPropertyForOrgApacheCatalinaUtilLifecycleBase(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCatalinaUtilLifecycleBase(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            //no setStateName method found on this class
            case "throwOnFailure" : 
                ((org.apache.catalina.util.LifecycleBase)o).setThrowOnFailure(Boolean.valueOf(value));
                return true;
        }
        return false;
    }

    private static boolean setPropertyForOrgApacheCatalinaFiltersAddDefaultCharsetFilter(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "encoding" : 
                ((org.apache.catalina.filters.AddDefaultCharsetFilter)o).setEncoding(value);
                return true;
        }
        return setPropertyForOrgApacheCatalinaFiltersFilterBase(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCatalinaFiltersRestCsrfPreventionFilter(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "pathsAcceptingParams" : 
                ((org.apache.catalina.filters.RestCsrfPreventionFilter)o).setPathsAcceptingParams(value);
                return true;
        }
        return setPropertyForOrgApacheCatalinaFiltersCsrfPreventionFilterBase(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCatalinaFiltersCsrfPreventionFilterBase(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            //no setConfigProblemFatal method found on this class
            case "denyStatus" : 
                ((org.apache.catalina.filters.CsrfPreventionFilterBase)o).setDenyStatus(Integer.valueOf(value));
                return true;
            case "randomClass" : 
                ((org.apache.catalina.filters.CsrfPreventionFilterBase)o).setRandomClass(value);
                return true;
        }
        return setPropertyForOrgApacheCatalinaFiltersFilterBase(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCatalinaFiltersFilterBase(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            //no setConfigProblemFatal method found on this class
        }
        return false;
    }

    private static boolean setPropertyForOrgApacheCatalinaLoaderParallelWebappClassLoader(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
        }
        return setPropertyForOrgApacheCatalinaLoaderWebappClassLoaderBase(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCatalinaLoaderWebappClassLoaderBase(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "clearReferencesHttpClientKeepAliveThread" : 
                ((org.apache.catalina.loader.WebappClassLoaderBase)o).setClearReferencesHttpClientKeepAliveThread(Boolean.valueOf(value));
                return true;
            case "clearReferencesLogFactoryRelease" : 
                ((org.apache.catalina.loader.WebappClassLoaderBase)o).setClearReferencesLogFactoryRelease(Boolean.valueOf(value));
                return true;
            case "clearReferencesRmiTargets" : 
                ((org.apache.catalina.loader.WebappClassLoaderBase)o).setClearReferencesRmiTargets(Boolean.valueOf(value));
                return true;
            case "clearReferencesStopThreads" : 
                ((org.apache.catalina.loader.WebappClassLoaderBase)o).setClearReferencesStopThreads(Boolean.valueOf(value));
                return true;
            case "clearReferencesStopTimerThreads" : 
                ((org.apache.catalina.loader.WebappClassLoaderBase)o).setClearReferencesStopTimerThreads(Boolean.valueOf(value));
                return true;
            case "clearReferencesThreadLocals" : 
                ((org.apache.catalina.loader.WebappClassLoaderBase)o).setClearReferencesThreadLocals(Boolean.valueOf(value));
                return true;
            //no setContextName method found on this class
            case "delegate" : 
                ((org.apache.catalina.loader.WebappClassLoaderBase)o).setDelegate(Boolean.valueOf(value));
                return true;
            //no setHasExternalRepositories method found on this class
            //no setHostName method found on this class
            case "notFoundClassResourceCacheSize" : 
                ((org.apache.catalina.loader.WebappClassLoaderBase)o).setNotFoundClassResourceCacheSize(Integer.valueOf(value));
                return true;
            //no setServiceName method found on this class
            case "skipMemoryLeakChecksOnJvmShutdown" : 
                ((org.apache.catalina.loader.WebappClassLoaderBase)o).setSkipMemoryLeakChecksOnJvmShutdown(Boolean.valueOf(value));
                return true;
            //no setStateName method found on this class
            //no setWebappName method found on this class
        }
        return setPropertyForJavaNetURLClassLoader(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForJavaNetURLClassLoader(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
        }
        return setPropertyForJavaSecuritySecureClassLoader(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForJavaSecuritySecureClassLoader(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
        }
        return setPropertyForJavaLangClassLoader(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForJavaLangClassLoader(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "defaultAssertionStatus" : 
                ((java.lang.ClassLoader)o).setDefaultAssertionStatus(Boolean.valueOf(value));
                return true;
            //no setName method found on this class
            //no setRegisteredAsParallelCapable method found on this class
        }
        return false;
    }

    private static boolean setPropertyForOrgApacheCoyoteAjpAjpNio2Protocol(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "namePrefix" : 
                ((org.apache.coyote.ajp.AjpNio2Protocol)o).setProperty(name, value);
                return true;
        }
        return setPropertyForOrgApacheCoyoteAjpAbstractAjpProtocol(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCoyoteAjpAjpNioProtocol(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "namePrefix" : 
                ((org.apache.coyote.ajp.AjpNioProtocol)o).setProperty(name, value);
                return true;
        }
        return setPropertyForOrgApacheCoyoteAjpAbstractAjpProtocol(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCoyoteAjpAbstractAjpProtocol(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "ajpFlush" : 
                ((org.apache.coyote.ajp.AbstractAjpProtocol)o).setAjpFlush(Boolean.valueOf(value));
                return true;
            case "allowedRequestAttributesPattern" : 
                ((org.apache.coyote.ajp.AbstractAjpProtocol)o).setAllowedRequestAttributesPattern(value);
                return true;
            case "desiredBufferSize" : 
                ((org.apache.coyote.ajp.AbstractAjpProtocol)o).setProperty(name, value);
                return true;
            case "packetSize" : 
                ((org.apache.coyote.ajp.AbstractAjpProtocol)o).setPacketSize(Integer.valueOf(value));
                return true;
            case "protocolName" : 
                ((org.apache.coyote.ajp.AbstractAjpProtocol)o).setProperty(name, value);
                return true;
            case "secret" : 
                ((org.apache.coyote.ajp.AbstractAjpProtocol)o).setSecret(value);
                return true;
            case "secretRequired" : 
                ((org.apache.coyote.ajp.AbstractAjpProtocol)o).setSecretRequired(Boolean.valueOf(value));
                return true;
            case "tomcatAuthentication" : 
                ((org.apache.coyote.ajp.AbstractAjpProtocol)o).setTomcatAuthentication(Boolean.valueOf(value));
                return true;
            case "tomcatAuthorization" : 
                ((org.apache.coyote.ajp.AbstractAjpProtocol)o).setTomcatAuthorization(Boolean.valueOf(value));
                return true;
        }
        return setPropertyForOrgApacheCoyoteAbstractProtocol(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCoyoteHttp11Http11Nio2Protocol(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "namePrefix" : 
                ((org.apache.coyote.http11.Http11Nio2Protocol)o).setProperty(name, value);
                return true;
        }
        return setPropertyForOrgApacheCoyoteHttp11AbstractHttp11Protocol(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCoyoteHttp11Http11NioProtocol(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "namePrefix" : 
                ((org.apache.coyote.http11.Http11NioProtocol)o).setProperty(name, value);
                return true;
            case "pollerThreadPriority" : 
                ((org.apache.coyote.http11.Http11NioProtocol)o).setPollerThreadPriority(Integer.valueOf(value));
                return true;
            case "selectorTimeout" : 
                ((org.apache.coyote.http11.Http11NioProtocol)o).setSelectorTimeout(Long.valueOf(value));
                return true;
        }
        return setPropertyForOrgApacheCoyoteHttp11AbstractHttp11Protocol(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCoyoteHttp11AbstractHttp11Protocol(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "SSLEnabled" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setSSLEnabled(Boolean.valueOf(value));
                return true;
            case "allowedTrailerHeaders" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setAllowedTrailerHeaders(value);
                return true;
            case "compressibleMimeType" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setCompressibleMimeType(value);
                return true;
            case "compression" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setCompression(value);
                return true;
            case "compressionLevel" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setProperty(name, value);
                return true;
            case "compressionMinSize" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setCompressionMinSize(Integer.valueOf(value));
                return true;
            case "connectionUploadTimeout" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setConnectionUploadTimeout(Integer.valueOf(value));
                return true;
            case "continueResponseTiming" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setContinueResponseTiming(value);
                return true;
            case "defaultSSLHostConfigName" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setDefaultSSLHostConfigName(value);
                return true;
            case "disableUploadTimeout" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setDisableUploadTimeout(Boolean.valueOf(value));
                return true;
            case "maxExtensionSize" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setMaxExtensionSize(Integer.valueOf(value));
                return true;
            case "maxHttpHeaderSize" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setMaxHttpHeaderSize(Integer.valueOf(value));
                return true;
            case "maxHttpRequestHeaderSize" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setMaxHttpRequestHeaderSize(Integer.valueOf(value));
                return true;
            case "maxHttpResponseHeaderSize" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setMaxHttpResponseHeaderSize(Integer.valueOf(value));
                return true;
            case "maxKeepAliveRequests" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setMaxKeepAliveRequests(Integer.valueOf(value));
                return true;
            case "maxSavePostSize" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setMaxSavePostSize(Integer.valueOf(value));
                return true;
            case "maxSwallowSize" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setMaxSwallowSize(Integer.valueOf(value));
                return true;
            case "maxTrailerSize" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setMaxTrailerSize(Integer.valueOf(value));
                return true;
            case "noCompressionUserAgents" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setNoCompressionUserAgents(value);
                return true;
            case "protocolName" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setProperty(name, value);
                return true;
            case "relaxedPathChars" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setRelaxedPathChars(value);
                return true;
            case "relaxedQueryChars" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setRelaxedQueryChars(value);
                return true;
            case "restrictedUserAgents" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setRestrictedUserAgents(value);
                return true;
            case "secure" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setSecure(Boolean.valueOf(value));
                return true;
            case "server" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setServer(value);
                return true;
            case "serverRemoveAppProvidedValues" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setServerRemoveAppProvidedValues(Boolean.valueOf(value));
                return true;
            case "sniParseLimit" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setSniParseLimit(Integer.valueOf(value));
                return true;
            case "sslImplementationName" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setSslImplementationName(value);
                return true;
            case "sslImplementationShortName" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setProperty(name, value);
                return true;
            case "useKeepAliveResponseHeader" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setUseKeepAliveResponseHeader(Boolean.valueOf(value));
                return true;
            case "useSendfile" : 
                ((org.apache.coyote.http11.AbstractHttp11Protocol)o).setUseSendfile(Boolean.valueOf(value));
                return true;
        }
        return setPropertyForOrgApacheCoyoteAbstractProtocol(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheCoyoteAbstractProtocol(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "acceptCount" : 
                ((org.apache.coyote.AbstractProtocol)o).setAcceptCount(Integer.valueOf(value));
                return true;
            case "acceptorThreadPriority" : 
                ((org.apache.coyote.AbstractProtocol)o).setAcceptorThreadPriority(Integer.valueOf(value));
                return true;
            case "address" : 
                ((org.apache.coyote.AbstractProtocol)o).setAddress(getInetAddress(value));
                return true;
            case "clientCertProvider" : 
                ((org.apache.coyote.AbstractProtocol)o).setClientCertProvider(value);
                return true;
            case "connectionCount" : 
                ((org.apache.coyote.AbstractProtocol)o).setProperty(name, value);
                return true;
            case "connectionLinger" : 
                ((org.apache.coyote.AbstractProtocol)o).setConnectionLinger(Integer.valueOf(value));
                return true;
            case "connectionTimeout" : 
                ((org.apache.coyote.AbstractProtocol)o).setConnectionTimeout(Integer.valueOf(value));
                return true;
            case "domain" : 
                ((org.apache.coyote.AbstractProtocol)o).setProperty(name, value);
                return true;
            case "id" : 
                ((org.apache.coyote.AbstractProtocol)o).setProperty(name, value);
                return true;
            case "keepAliveTimeout" : 
                ((org.apache.coyote.AbstractProtocol)o).setKeepAliveTimeout(Integer.valueOf(value));
                return true;
            case "localPort" : 
                ((org.apache.coyote.AbstractProtocol)o).setProperty(name, value);
                return true;
            case "maxConnections" : 
                ((org.apache.coyote.AbstractProtocol)o).setMaxConnections(Integer.valueOf(value));
                return true;
            case "maxHeaderCount" : 
                ((org.apache.coyote.AbstractProtocol)o).setMaxHeaderCount(Integer.valueOf(value));
                return true;
            case "maxQueueSize" : 
                ((org.apache.coyote.AbstractProtocol)o).setMaxQueueSize(Integer.valueOf(value));
                return true;
            case "maxThreads" : 
                ((org.apache.coyote.AbstractProtocol)o).setMaxThreads(Integer.valueOf(value));
                return true;
            case "minSpareThreads" : 
                ((org.apache.coyote.AbstractProtocol)o).setMinSpareThreads(Integer.valueOf(value));
                return true;
            case "name" : 
                ((org.apache.coyote.AbstractProtocol)o).setProperty(name, value);
                return true;
            case "nameIndex" : 
                ((org.apache.coyote.AbstractProtocol)o).setProperty(name, value);
                return true;
            case "namePrefix" : 
                ((org.apache.coyote.AbstractProtocol)o).setProperty(name, value);
                return true;
            case "paused" : 
                ((org.apache.coyote.AbstractProtocol)o).setProperty(name, value);
                return true;
            case "port" : 
                ((org.apache.coyote.AbstractProtocol)o).setPort(Integer.valueOf(value));
                return true;
            case "portOffset" : 
                ((org.apache.coyote.AbstractProtocol)o).setPortOffset(Integer.valueOf(value));
                return true;
            case "portWithOffset" : 
                ((org.apache.coyote.AbstractProtocol)o).setProperty(name, value);
                return true;
            case "processorCache" : 
                ((org.apache.coyote.AbstractProtocol)o).setProcessorCache(Integer.valueOf(value));
                return true;
            case "protocolName" : 
                ((org.apache.coyote.AbstractProtocol)o).setProperty(name, value);
                return true;
            case "sendfileSupported" : 
                ((org.apache.coyote.AbstractProtocol)o).setProperty(name, value);
                return true;
            case "tcpNoDelay" : 
                ((org.apache.coyote.AbstractProtocol)o).setTcpNoDelay(Boolean.valueOf(value));
                return true;
            case "threadPriority" : 
                ((org.apache.coyote.AbstractProtocol)o).setThreadPriority(Integer.valueOf(value));
                return true;
            case "waitingProcessorCount" : 
                ((org.apache.coyote.AbstractProtocol)o).setProperty(name, value);
                return true;
        }
        if (invokeSetProperty) {
            ((org.apache.coyote.AbstractProtocol)o).setProperty(name, value);
            return true;
        }
        return true;
    }

    private static boolean setPropertyForOrgApacheTomcatUtilDescriptorWebContextResource(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "auth" : 
                ((org.apache.tomcat.util.descriptor.web.ContextResource)o).setAuth(value);
                return true;
            case "closeMethod" : 
                ((org.apache.tomcat.util.descriptor.web.ContextResource)o).setCloseMethod(value);
                return true;
            //no setCloseMethodConfigured method found on this class
            case "scope" : 
                ((org.apache.tomcat.util.descriptor.web.ContextResource)o).setScope(value);
                return true;
            case "singleton" : 
                ((org.apache.tomcat.util.descriptor.web.ContextResource)o).setSingleton(Boolean.valueOf(value));
                return true;
        }
        return setPropertyForOrgApacheTomcatUtilDescriptorWebResourceBase(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheTomcatUtilDescriptorWebResourceBase(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "description" : 
                ((org.apache.tomcat.util.descriptor.web.ResourceBase)o).setDescription(value);
                return true;
            case "lookupName" : 
                ((org.apache.tomcat.util.descriptor.web.ResourceBase)o).setLookupName(value);
                return true;
            case "name" : 
                ((org.apache.tomcat.util.descriptor.web.ResourceBase)o).setName(value);
                return true;
            case "type" : 
                ((org.apache.tomcat.util.descriptor.web.ResourceBase)o).setType(value);
                return true;
        }
        if (invokeSetProperty) {
            ((org.apache.tomcat.util.descriptor.web.ResourceBase)o).setProperty(name, value);
            return true;
        }
        return true;
    }

    private static boolean setPropertyForOrgApacheTomcatUtilModelerAttributeInfo(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "displayName" : 
                ((org.apache.tomcat.util.modeler.AttributeInfo)o).setDisplayName(value);
                return true;
            case "getMethod" : 
                ((org.apache.tomcat.util.modeler.AttributeInfo)o).setGetMethod(value);
                return true;
            case "is" : 
                ((org.apache.tomcat.util.modeler.AttributeInfo)o).setIs(Boolean.valueOf(value));
                return true;
            case "readable" : 
                ((org.apache.tomcat.util.modeler.AttributeInfo)o).setReadable(Boolean.valueOf(value));
                return true;
            case "setMethod" : 
                ((org.apache.tomcat.util.modeler.AttributeInfo)o).setSetMethod(value);
                return true;
            case "writeable" : 
                ((org.apache.tomcat.util.modeler.AttributeInfo)o).setWriteable(Boolean.valueOf(value));
                return true;
        }
        return setPropertyForOrgApacheTomcatUtilModelerFeatureInfo(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheTomcatUtilModelerOperationInfo(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "impact" : 
                ((org.apache.tomcat.util.modeler.OperationInfo)o).setImpact(value);
                return true;
            case "returnType" : 
                ((org.apache.tomcat.util.modeler.OperationInfo)o).setReturnType(value);
                return true;
            case "role" : 
                ((org.apache.tomcat.util.modeler.OperationInfo)o).setRole(value);
                return true;
        }
        return setPropertyForOrgApacheTomcatUtilModelerFeatureInfo(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheTomcatUtilModelerParameterInfo(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
        }
        return setPropertyForOrgApacheTomcatUtilModelerFeatureInfo(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheTomcatUtilModelerFeatureInfo(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "description" : 
                ((org.apache.tomcat.util.modeler.FeatureInfo)o).setDescription(value);
                return true;
            case "name" : 
                ((org.apache.tomcat.util.modeler.FeatureInfo)o).setName(value);
                return true;
            case "type" : 
                ((org.apache.tomcat.util.modeler.FeatureInfo)o).setType(value);
                return true;
        }
        return false;
    }

    private static boolean setPropertyForOrgApacheTomcatUtilModelerManagedBean(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "className" : 
                ((org.apache.tomcat.util.modeler.ManagedBean)o).setClassName(value);
                return true;
            case "description" : 
                ((org.apache.tomcat.util.modeler.ManagedBean)o).setDescription(value);
                return true;
            case "domain" : 
                ((org.apache.tomcat.util.modeler.ManagedBean)o).setDomain(value);
                return true;
            case "group" : 
                ((org.apache.tomcat.util.modeler.ManagedBean)o).setGroup(value);
                return true;
            case "name" : 
                ((org.apache.tomcat.util.modeler.ManagedBean)o).setName(value);
                return true;
            case "type" : 
                ((org.apache.tomcat.util.modeler.ManagedBean)o).setType(value);
                return true;
        }
        return false;
    }

    private static boolean setPropertyForOrgApacheTomcatUtilNetNio2Endpoint(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "allClosed" : 
                ((org.apache.tomcat.util.net.Nio2Endpoint)o).setProperty(name, value);
                return true;
            case "inline" : 
                ((org.apache.tomcat.util.net.Nio2Endpoint)o).setProperty(name, value);
                return true;
            case "keepAliveCount" : 
                ((org.apache.tomcat.util.net.Nio2Endpoint)o).setProperty(name, value);
                return true;
            case "previousAcceptedSocketNanoTime" : 
                ((org.apache.tomcat.util.net.Nio2Endpoint)o).setProperty(name, value);
                return true;
        }
        return setPropertyForOrgApacheTomcatUtilNetAbstractNetworkChannelEndpoint(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheTomcatUtilNetNioEndpoint(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "id" : 
                ((org.apache.tomcat.util.net.NioEndpoint)o).setProperty(name, value);
                return true;
            case "keepAliveCount" : 
                ((org.apache.tomcat.util.net.NioEndpoint)o).setProperty(name, value);
                return true;
            case "pollerThreadPriority" : 
                ((org.apache.tomcat.util.net.NioEndpoint)o).setPollerThreadPriority(Integer.valueOf(value));
                return true;
            case "previousAcceptedSocketNanoTime" : 
                ((org.apache.tomcat.util.net.NioEndpoint)o).setProperty(name, value);
                return true;
            case "selectorTimeout" : 
                ((org.apache.tomcat.util.net.NioEndpoint)o).setSelectorTimeout(Long.valueOf(value));
                return true;
            case "unixDomainSocketPath" : 
                ((org.apache.tomcat.util.net.NioEndpoint)o).setUnixDomainSocketPath(value);
                return true;
            case "unixDomainSocketPathPermissions" : 
                ((org.apache.tomcat.util.net.NioEndpoint)o).setUnixDomainSocketPathPermissions(value);
                return true;
            case "useInheritedChannel" : 
                ((org.apache.tomcat.util.net.NioEndpoint)o).setUseInheritedChannel(Boolean.valueOf(value));
                return true;
        }
        return setPropertyForOrgApacheTomcatUtilNetAbstractNetworkChannelEndpoint(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheTomcatUtilNetAbstractNetworkChannelEndpoint(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
        }
        return setPropertyForOrgApacheTomcatUtilNetAbstractEndpoint(o, name, value, invokeSetProperty);
    }

    private static boolean setPropertyForOrgApacheTomcatUtilNetAbstractEndpoint(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "SSLEnabled" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setSSLEnabled(Boolean.valueOf(value));
                return true;
            case "acceptCount" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setAcceptCount(Integer.valueOf(value));
                return true;
            case "acceptorThreadPriority" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setAcceptorThreadPriority(Integer.valueOf(value));
                return true;
            case "address" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setAddress(getInetAddress(value));
                return true;
            case "bindOnInit" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setBindOnInit(Boolean.valueOf(value));
                return true;
            case "connectionCount" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setProperty(name, value);
                return true;
            case "connectionLinger" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setConnectionLinger(Integer.valueOf(value));
                return true;
            case "connectionTimeout" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setConnectionTimeout(Integer.valueOf(value));
                return true;
            case "currentThreadCount" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setProperty(name, value);
                return true;
            case "currentThreadsBusy" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setProperty(name, value);
                return true;
            case "daemon" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setDaemon(Boolean.valueOf(value));
                return true;
            case "defaultSSLHostConfigName" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setDefaultSSLHostConfigName(value);
                return true;
            case "domain" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setDomain(value);
                return true;
            case "executorTerminationTimeoutMillis" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setExecutorTerminationTimeoutMillis(Long.valueOf(value));
                return true;
            case "id" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setProperty(name, value);
                return true;
            case "internalExecutor" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setProperty(name, value);
                return true;
            case "keepAliveTimeout" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setKeepAliveTimeout(Integer.valueOf(value));
                return true;
            case "localPort" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setProperty(name, value);
                return true;
            case "maxConnections" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setMaxConnections(Integer.valueOf(value));
                return true;
            case "maxKeepAliveRequests" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setMaxKeepAliveRequests(Integer.valueOf(value));
                return true;
            case "maxQueueSize" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setMaxQueueSize(Integer.valueOf(value));
                return true;
            case "maxThreads" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setMaxThreads(Integer.valueOf(value));
                return true;
            case "minSpareThreads" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setMinSpareThreads(Integer.valueOf(value));
                return true;
            case "name" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setName(value);
                return true;
            case "paused" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setProperty(name, value);
                return true;
            case "port" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setPort(Integer.valueOf(value));
                return true;
            case "portOffset" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setPortOffset(Integer.valueOf(value));
                return true;
            case "portWithOffset" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setProperty(name, value);
                return true;
            case "running" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setProperty(name, value);
                return true;
            case "sniParseLimit" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setSniParseLimit(Integer.valueOf(value));
                return true;
            case "sslImplementationName" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setSslImplementationName(value);
                return true;
            case "tcpNoDelay" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setTcpNoDelay(Boolean.valueOf(value));
                return true;
            case "threadPriority" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setThreadPriority(Integer.valueOf(value));
                return true;
            case "threadsMaxIdleTime" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setThreadsMaxIdleTime(Integer.valueOf(value));
                return true;
            case "useAsyncIO" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setUseAsyncIO(Boolean.valueOf(value));
                return true;
            case "useSendfile" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setUseSendfile(Boolean.valueOf(value));
                return true;
            case "useVirtualThreads" : 
                ((org.apache.tomcat.util.net.AbstractEndpoint)o).setUseVirtualThreads(Boolean.valueOf(value));
                return true;
        }
        if (invokeSetProperty) {
            ((org.apache.tomcat.util.net.AbstractEndpoint)o).setProperty(name, value);
            return true;
        }
        return true;
    }

    private static boolean setPropertyForOrgApacheTomcatUtilNetSocketProperties(Object o, String name, String value, boolean invokeSetProperty) {
        switch (name) {
            case "appReadBufSize" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setAppReadBufSize(Integer.valueOf(value));
                return true;
            case "appWriteBufSize" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setAppWriteBufSize(Integer.valueOf(value));
                return true;
            case "bufferPool" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setBufferPool(Integer.valueOf(value));
                return true;
            case "bufferPoolSize" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setBufferPoolSize(Integer.valueOf(value));
                return true;
            case "directBuffer" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setDirectBuffer(Boolean.valueOf(value));
                return true;
            case "directBufferPool" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setDirectBufferPool(Integer.valueOf(value));
                return true;
            case "directSslBuffer" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setDirectSslBuffer(Boolean.valueOf(value));
                return true;
            case "eventCache" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setEventCache(Integer.valueOf(value));
                return true;
            case "ooBInline" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setOoBInline(Boolean.valueOf(value));
                return true;
            case "performanceBandwidth" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setPerformanceBandwidth(Integer.valueOf(value));
                return true;
            case "performanceConnectionTime" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setPerformanceConnectionTime(Integer.valueOf(value));
                return true;
            case "performanceLatency" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setPerformanceLatency(Integer.valueOf(value));
                return true;
            case "processorCache" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setProcessorCache(Integer.valueOf(value));
                return true;
            case "rxBufSize" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setRxBufSize(Integer.valueOf(value));
                return true;
            case "soKeepAlive" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setSoKeepAlive(Boolean.valueOf(value));
                return true;
            case "soLingerOn" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setSoLingerOn(Boolean.valueOf(value));
                return true;
            case "soLingerTime" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setSoLingerTime(Integer.valueOf(value));
                return true;
            case "soReuseAddress" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setSoReuseAddress(Boolean.valueOf(value));
                return true;
            case "soTimeout" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setSoTimeout(Integer.valueOf(value));
                return true;
            case "tcpNoDelay" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setTcpNoDelay(Boolean.valueOf(value));
                return true;
            case "timeoutInterval" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setTimeoutInterval(Long.valueOf(value));
                return true;
            case "txBufSize" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setTxBufSize(Integer.valueOf(value));
                return true;
            case "unlockTimeout" : 
                ((org.apache.tomcat.util.net.SocketProperties)o).setUnlockTimeout(Integer.valueOf(value));
                return true;
        }
        return false;
    }

}
