/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.tinkergraph.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerEdge;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerElement;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerHelper;
import org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerVertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class TinkerVertex
extends TinkerElement
implements Vertex {
    protected Map<String, List<VertexProperty>> properties;
    protected Map<String, Set<Edge>> outEdges;
    protected Map<String, Set<Edge>> inEdges;
    private final TinkerGraph graph;

    protected TinkerVertex(Object id, String label, TinkerGraph graph) {
        super(id, label);
        this.graph = graph;
    }

    public Graph graph() {
        return this.graph;
    }

    public <V> VertexProperty<V> property(String key) {
        if (this.removed) {
            throw Element.Exceptions.elementAlreadyRemoved(Vertex.class, (Object)this.id);
        }
        if (TinkerHelper.inComputerMode(this.graph)) {
            List<VertexProperty<?>> list = this.graph.graphComputerView.getProperty(this, key);
            if (list.size() == 0) {
                return VertexProperty.empty();
            }
            if (list.size() == 1) {
                return list.get(0);
            }
            throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey((String)key);
        }
        if (this.properties != null && this.properties.containsKey(key)) {
            List<VertexProperty> list = this.properties.get(key);
            if (list.size() > 1) {
                throw Vertex.Exceptions.multiplePropertiesExistForProvidedKey((String)key);
            }
            return list.get(0);
        }
        return VertexProperty.empty();
    }

    public <V> VertexProperty<V> property(VertexProperty.Cardinality cardinality, String key, V value, Object ... keyValues) {
        if (this.removed) {
            throw Element.Exceptions.elementAlreadyRemoved(Vertex.class, (Object)this.id);
        }
        ElementHelper.legalPropertyKeyValueArray((Object[])keyValues);
        ElementHelper.validateProperty((String)key, value);
        Optional optionalId = ElementHelper.getIdValue((Object[])keyValues);
        Optional optionalVertexProperty = ElementHelper.stageVertexProperty((Vertex)this, (VertexProperty.Cardinality)cardinality, (String)key, value, (Object[])keyValues);
        if (optionalVertexProperty.isPresent()) {
            return (VertexProperty)optionalVertexProperty.get();
        }
        if (TinkerHelper.inComputerMode(this.graph)) {
            VertexProperty vertexProperty = (VertexProperty)this.graph.graphComputerView.addProperty(this, key, value);
            ElementHelper.attachProperties((Element)vertexProperty, (Object[])keyValues);
            return vertexProperty;
        }
        Object idValue = optionalId.isPresent() ? this.graph.vertexPropertyIdManager.convert(optionalId.get()) : this.graph.vertexPropertyIdManager.getNextId(this.graph);
        TinkerVertexProperty<V> vertexProperty = new TinkerVertexProperty<V>(idValue, this, key, value, new Object[0]);
        if (null == this.properties) {
            this.properties = new HashMap<String, List<VertexProperty>>();
        }
        List list = this.properties.getOrDefault(key, new ArrayList());
        list.add(vertexProperty);
        this.properties.put(key, list);
        TinkerHelper.autoUpdateIndex(this, key, value, null);
        ElementHelper.attachProperties(vertexProperty, (Object[])keyValues);
        return vertexProperty;
    }

    public Set<String> keys() {
        if (null == this.properties) {
            return Collections.emptySet();
        }
        return TinkerHelper.inComputerMode((TinkerGraph)this.graph()) ? super.keys() : this.properties.keySet();
    }

    public Edge addEdge(String label, Vertex vertex, Object ... keyValues) {
        if (null == vertex) {
            throw Graph.Exceptions.argumentCanNotBeNull((String)"vertex");
        }
        if (this.removed) {
            throw Element.Exceptions.elementAlreadyRemoved(Vertex.class, (Object)this.id);
        }
        return TinkerHelper.addEdge(this.graph, this, (TinkerVertex)vertex, label, keyValues);
    }

    public void remove() {
        if (this.removed) {
            throw Element.Exceptions.elementAlreadyRemoved(Vertex.class, (Object)this.id);
        }
        ArrayList edges = new ArrayList();
        this.edges(Direction.BOTH, new String[0]).forEachRemaining(edges::add);
        edges.stream().filter(edge -> !((TinkerEdge)edge).removed).forEach(Element::remove);
        this.properties = null;
        TinkerHelper.removeElementIndex(this);
        this.graph.vertices.remove(this.id);
        this.removed = true;
    }

    public String toString() {
        return StringFactory.vertexString((Vertex)this);
    }

    public Iterator<Edge> edges(Direction direction, String ... edgeLabels) {
        return TinkerHelper.getEdges(this, direction, edgeLabels);
    }

    public Iterator<Vertex> vertices(Direction direction, String ... edgeLabels) {
        return TinkerHelper.getVertices(this, direction, edgeLabels);
    }

    public <V> Iterator<VertexProperty<V>> properties(String ... propertyKeys) {
        if (TinkerHelper.inComputerMode((TinkerGraph)this.graph())) {
            return ((TinkerGraph)this.graph()).graphComputerView.getProperties(this).stream().filter(p -> ElementHelper.keyExists((String)p.key(), (String[])propertyKeys)).iterator();
        }
        if (null == this.properties) {
            return Collections.emptyIterator();
        }
        if (propertyKeys.length == 1) {
            List properties = this.properties.getOrDefault(propertyKeys[0], Collections.emptyList());
            if (properties.size() == 1) {
                return IteratorUtils.of(properties.get(0));
            }
            if (properties.isEmpty()) {
                return Collections.emptyIterator();
            }
            return new ArrayList(properties).iterator();
        }
        return this.properties.entrySet().stream().filter(entry -> ElementHelper.keyExists((String)((String)entry.getKey()), (String[])propertyKeys)).flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList()).iterator();
    }
}

