/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.process.computer;

import org.apache.spark.util.AccumulatorV2;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.ObjectWritable;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;

public final class MemoryAccumulator<A>
extends AccumulatorV2<ObjectWritable<A>, ObjectWritable<A>> {
    private final MemoryComputeKey<A> memoryComputeKey;
    private ObjectWritable<A> value;

    MemoryAccumulator(MemoryComputeKey<A> memoryComputeKey) {
        this(memoryComputeKey, ObjectWritable.empty());
    }

    private MemoryAccumulator(MemoryComputeKey<A> memoryComputeKey, ObjectWritable<A> initial) {
        this.memoryComputeKey = memoryComputeKey;
        this.value = initial;
    }

    public boolean isZero() {
        return ObjectWritable.empty().equals(this.value);
    }

    public AccumulatorV2<ObjectWritable<A>, ObjectWritable<A>> copy() {
        return new MemoryAccumulator<A>(this.memoryComputeKey, this.value);
    }

    public void reset() {
        this.value = ObjectWritable.empty();
    }

    public void add(ObjectWritable<A> v) {
        if (this.value.isEmpty()) {
            this.value = v;
        } else if (!v.isEmpty()) {
            this.value = new ObjectWritable(this.memoryComputeKey.getReducer().apply(this.value.get(), v.get()));
        }
    }

    public void merge(AccumulatorV2<ObjectWritable<A>, ObjectWritable<A>> other) {
        this.add((ObjectWritable)other.value());
    }

    public ObjectWritable<A> value() {
        return this.value;
    }
}

