/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.neo4j.process.util;

import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jEdge;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jGraph;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jVertex;
import org.neo4j.tinkerpop.api.Neo4jNode;
import org.neo4j.tinkerpop.api.Neo4jRelationship;

public final class Neo4jCypherIterator<T>
implements Iterator<Map<String, T>> {
    private final Iterator<Map<String, T>> iterator;
    private final Neo4jGraph graph;

    public Neo4jCypherIterator(Iterator<Map<String, T>> iterator, Neo4jGraph graph) {
        this.iterator = iterator;
        this.graph = graph;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Map<String, T> next() {
        return this.iterator.next().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            Object val = entry.getValue();
            if (Neo4jNode.class.isAssignableFrom(val.getClass())) {
                return new Neo4jVertex((Neo4jNode)val, this.graph);
            }
            if (Neo4jRelationship.class.isAssignableFrom(val.getClass())) {
                return new Neo4jEdge((Neo4jRelationship)val, this.graph);
            }
            return val;
        }));
    }
}

