/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.neo4j.structure;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.tinkerpop.gremlin.neo4j.structure.Neo4jGraph;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.wrapped.WrappedElement;
import org.neo4j.tinkerpop.api.Neo4jEntity;

public abstract class Neo4jElement
implements Element,
WrappedElement<Neo4jEntity> {
    protected final Neo4jGraph graph;
    protected final Neo4jEntity baseElement;

    public Neo4jElement(Neo4jEntity baseElement, Neo4jGraph graph) {
        this.baseElement = baseElement;
        this.graph = graph;
    }

    public Graph graph() {
        return this.graph;
    }

    public Object id() {
        this.graph.tx().readWrite();
        return this.baseElement.getId();
    }

    public Set<String> keys() {
        this.graph.tx().readWrite();
        HashSet<String> keys = new HashSet<String>();
        for (String key : this.baseElement.getKeys()) {
            if (Graph.Hidden.isHidden((String)key)) continue;
            keys.add(key);
        }
        return Collections.unmodifiableSet(keys);
    }

    public boolean equals(Object object) {
        return ElementHelper.areEqual((Element)this, (Object)object);
    }

    public int hashCode() {
        return ElementHelper.hashCode((Element)this);
    }

    public Neo4jEntity getBaseElement() {
        return this.baseElement;
    }
}

