/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.neo4j.process.traversal.strategy.optimization;

import org.apache.tinkerpop.gremlin.neo4j.process.traversal.step.sideEffect.Neo4jGraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.step.HasContainerHolder;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.GraphStep;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.AbstractTraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;

public final class Neo4jGraphStepStrategy
extends AbstractTraversalStrategy<TraversalStrategy.ProviderOptimizationStrategy> {
    private static final Neo4jGraphStepStrategy INSTANCE = new Neo4jGraphStepStrategy();

    private Neo4jGraphStepStrategy() {
    }

    public void apply(Traversal.Admin<?, ?> traversal) {
        if (traversal.getEngine().isComputer()) {
            return;
        }
        TraversalHelper.getStepsOfClass(GraphStep.class, traversal).forEach(originalGraphStep -> {
            Neo4jGraphStep neo4jGraphStep = new Neo4jGraphStep(originalGraphStep);
            TraversalHelper.replaceStep((Step)originalGraphStep, neo4jGraphStep, (Traversal.Admin)traversal);
            Step currentStep = neo4jGraphStep.getNextStep();
            while (currentStep instanceof HasContainerHolder) {
                ((HasContainerHolder)currentStep).getHasContainers().forEach(neo4jGraphStep::addHasContainer);
                currentStep.getLabels().forEach(arg_0 -> neo4jGraphStep.addLabel(arg_0));
                traversal.removeStep(currentStep);
                currentStep = currentStep.getNextStep();
            }
        });
    }

    public static Neo4jGraphStepStrategy instance() {
        return INSTANCE;
    }
}

