/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure.io.graphson;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.LineRecordReader;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONMapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONReader;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONVersion;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TypeInfo;
import org.apache.tinkerpop.gremlin.structure.io.util.IoRegistryHelper;
import org.apache.tinkerpop.gremlin.structure.util.Attachable;

public final class GraphSONRecordReader
extends RecordReader<NullWritable, VertexWritable> {
    private GraphSONReader graphsonReader;
    private final VertexWritable vertexWritable = new VertexWritable();
    private final LineRecordReader lineRecordReader = new LineRecordReader();
    private boolean hasEdges;

    public void initialize(InputSplit genericSplit, TaskAttemptContext context) throws IOException {
        this.lineRecordReader.initialize(genericSplit, context);
        this.hasEdges = context.getConfiguration().getBoolean("gremlin.hadoop.graphReader.hasEdges", true);
        this.graphsonReader = GraphSONReader.build().mapper((Mapper)((GraphSONMapper.Builder)GraphSONMapper.build().version(GraphSONVersion.valueOf((String)context.getConfiguration().get("gremlin.hadoop.graphSONVersion", "V3_0"))).typeInfo(TypeInfo.PARTIAL_TYPES).addRegistries(IoRegistryHelper.createRegistries((Configuration)ConfUtil.makeApacheConfiguration(context.getConfiguration())))).create()).create();
    }

    public boolean nextKeyValue() throws IOException {
        if (!this.lineRecordReader.nextKeyValue()) {
            return false;
        }
        try (ByteArrayInputStream in = new ByteArrayInputStream(this.lineRecordReader.getCurrentValue().getBytes());){
            this.vertexWritable.set(this.hasEdges ? this.graphsonReader.readVertex((InputStream)in, Attachable::get, Attachable::get, Direction.BOTH) : this.graphsonReader.readVertex((InputStream)in, Attachable::get));
            boolean bl = true;
            return bl;
        }
    }

    public NullWritable getCurrentKey() {
        return NullWritable.get();
    }

    public VertexWritable getCurrentValue() {
        return this.vertexWritable;
    }

    public float getProgress() throws IOException {
        return this.lineRecordReader.getProgress();
    }

    public synchronized void close() throws IOException {
        this.lineRecordReader.close();
        this.graphsonReader = null;
    }
}

