/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.process.computer.util;

import com.google.common.base.Function;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;

public final class ComputerSubmissionHelper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Future<ComputerResult> runWithBackgroundThread(Function<Executor, Future<ComputerResult>> closure, String threadNameSuffix) {
        Thread callingThread = Thread.currentThread();
        ClassLoader classLoader = callingThread.getContextClassLoader();
        ThreadGroup threadGroup = callingThread.getThreadGroup();
        String threadName = callingThread.getName();
        ExecutorService submissionExecutor = null;
        try {
            submissionExecutor = Executors.newSingleThreadExecutor(runnable -> {
                Thread t = new Thread(threadGroup, runnable, threadName + "-TP-" + threadNameSuffix);
                t.setContextClassLoader(classLoader);
                return t;
            });
            Future future = (Future)closure.apply((Object)submissionExecutor);
            return future;
        }
        finally {
            if (null != submissionExecutor) {
                submissionExecutor.shutdown();
            }
        }
    }
}

