/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure.io;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.HadoopPools;
import org.apache.tinkerpop.gremlin.structure.io.gryo.kryoshim.KryoShimService;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;

public class HadoopPoolShimService
implements KryoShimService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readClassAndObject(InputStream source) {
        Kryo k = null;
        try {
            k = HadoopPools.getGryoPool().takeKryo();
            Object object = k.readClassAndObject(new Input(source));
            return object;
        }
        finally {
            if (null != k) {
                HadoopPools.getGryoPool().offerKryo(k);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeClassAndObject(Object o, OutputStream sink) {
        Kryo k = null;
        try {
            k = HadoopPools.getGryoPool().takeKryo();
            Output output = new Output(sink);
            k.writeClassAndObject(output, o);
            output.flush();
        }
        finally {
            if (null != k) {
                HadoopPools.getGryoPool().offerKryo(k);
            }
        }
    }

    public int getPriority() {
        return 0;
    }

    public void applyConfiguration(Configuration conf) {
        HadoopPools.initialize(conf);
    }
}

