/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.hadoop.structure.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.tinkerpop.gremlin.hadoop.process.computer.PersistResultGraphAware;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;

public abstract class CommonFileOutputFormat
extends FileOutputFormat<NullWritable, VertexWritable>
implements PersistResultGraphAware {
    protected DataOutputStream getDataOutputStream(TaskAttemptContext job) throws IOException, InterruptedException {
        Configuration conf = job.getConfiguration();
        boolean isCompressed = CommonFileOutputFormat.getCompressOutput((JobContext)job);
        CompressionCodec codec = null;
        String extension = "";
        if (isCompressed) {
            Class codecClass = CommonFileOutputFormat.getOutputCompressorClass((JobContext)job, DefaultCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)conf);
            extension = codec.getDefaultExtension();
        }
        Path file = super.getDefaultWorkFile(job, extension);
        FileSystem fs = file.getFileSystem(conf);
        if (!isCompressed) {
            return new DataOutputStream((OutputStream)fs.create(file, false));
        }
        return new DataOutputStream((OutputStream)codec.createOutputStream((OutputStream)fs.create(file, false)));
    }

    @Override
    public boolean supportsResultGraphPersistCombination(GraphComputer.ResultGraph resultGraph, GraphComputer.Persist persist) {
        return persist.equals((Object)GraphComputer.Persist.NOTHING) || resultGraph.equals((Object)GraphComputer.ResultGraph.NEW);
    }
}

