/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.features;

import com.google.inject.Inject;
import io.cucumber.datatable.DataTable;
import io.cucumber.guice.ScenarioScoped;
import io.cucumber.java.After;
import io.cucumber.java.Before;
import io.cucumber.java.Scenario;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.features.IsInMatcher;
import org.apache.tinkerpop.gremlin.features.IsPathEqualToMatcher;
import org.apache.tinkerpop.gremlin.features.World;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinAntlrToJava;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinLexer;
import org.apache.tinkerpop.gremlin.language.grammar.GremlinParser;
import org.apache.tinkerpop.gremlin.process.traversal.Merge;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ImmutablePath;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.DatetimeHelper;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.tinkerpop.shaded.jackson.databind.JsonNode;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.hamcrest.core.Every;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.StringContains;
import org.hamcrest.core.StringEndsWith;
import org.hamcrest.core.StringStartsWith;
import org.javatuples.Pair;
import org.javatuples.Triplet;
import org.junit.Assert;
import org.junit.AssumptionViolatedException;

@ScenarioScoped
public final class StepDefinition {
    private static final ObjectMapper mapper = new ObjectMapper();
    private World world;
    private GraphTraversalSource g;
    private final Map<String, String> stringParameters = new HashMap<String, String>();
    private Traversal traversal;
    private Object result;
    private Throwable error;
    private static final Pattern edgeTripletPattern = Pattern.compile("(.+)-(.+)->(.+)");
    private static final Pattern ioPattern = Pattern.compile("g\\.io\\(\"(.*)\"\\).*");
    private List<Pair<Pattern, Function<String, String>>> stringMatcherConverters = new ArrayList<Pair<Pattern, Function<String, String>>>(){
        {
            this.add(Pair.with((Object)Pattern.compile("m\\[(.*)\\]"), s -> {
                String[] items = s.replace("{", "").replace("}", "").split(",");
                String listItems = Stream.of(items).map(String::trim).map(x -> {
                    String[] pair = x.split(":");
                    String convertedKey = StepDefinition.this.convertToString(pair[0].trim().replace("\"", ""));
                    String convertedValue = StepDefinition.this.convertToString(pair[1].trim().replace("\"", ""));
                    return String.format("%s:%s", convertedKey, convertedValue);
                }).collect(Collectors.joining(","));
                return String.format("[%s]", listItems);
            }));
            this.add(Pair.with((Object)Pattern.compile("l\\[\\]"), s -> "[]"));
            this.add(Pair.with((Object)Pattern.compile("l\\[(.*)\\]"), s -> {
                String[] items = s.split(",");
                String listItems = Stream.of(items).map(String::trim).map(x -> StepDefinition.this.convertToString(x)).collect(Collectors.joining(","));
                return String.format("[%s]", listItems);
            }));
            this.add(Pair.with((Object)Pattern.compile("d\\[(NaN)\\]"), s -> "NaN"));
            this.add(Pair.with((Object)Pattern.compile("d\\[(Infinity)\\]"), s -> "Infinity"));
            this.add(Pair.with((Object)Pattern.compile("d\\[(-Infinity)\\]"), s -> "-Infinity"));
            this.add(Pair.with((Object)Pattern.compile("d\\[(.*)\\]\\.b"), s -> s + "b"));
            this.add(Pair.with((Object)Pattern.compile("d\\[(.*)\\]\\.s"), s -> s + "s"));
            this.add(Pair.with((Object)Pattern.compile("d\\[(.*)\\]\\.i"), s -> s + "i"));
            this.add(Pair.with((Object)Pattern.compile("d\\[(.*)\\]\\.l"), s -> s + "l"));
            this.add(Pair.with((Object)Pattern.compile("d\\[(.*)\\]\\.f"), s -> s + "f"));
            this.add(Pair.with((Object)Pattern.compile("d\\[(.*)\\]\\.d"), s -> s + "d"));
            this.add(Pair.with((Object)Pattern.compile("d\\[(.*)\\]\\.m"), s -> s + "m"));
            this.add(Pair.with((Object)Pattern.compile("d\\[(.*)\\]\\.n"), s -> s + "n"));
            this.add(Pair.with((Object)Pattern.compile("dt\\[(.*)\\]"), s -> String.format("datetime('%s')", s)));
            this.add(Pair.with((Object)Pattern.compile("v\\[(.+)\\]\\.id"), s -> StepDefinition.this.world.convertIdToScript(StepDefinition.this.g.V(new Object[0]).has("name", s).id().next(), Vertex.class)));
            this.add(Pair.with((Object)Pattern.compile("v\\[(.+)\\]\\.sid"), s -> StepDefinition.this.world.convertIdToScript(StepDefinition.this.g.V(new Object[0]).has("name", s).id().next(), Vertex.class)));
            this.add(Pair.with((Object)Pattern.compile("v\\[(.+)\\]"), s -> {
                GraphTraversal itty = StepDefinition.this.g.V(new Object[0]).has("name", s).id();
                return String.format("new Vertex(%s,\"%s\")", itty.hasNext() ? StepDefinition.this.world.convertIdToScript(itty.next(), Vertex.class) : s, "vertex");
            }));
            this.add(Pair.with((Object)Pattern.compile("e\\[(.+)\\]\\.id"), s -> StepDefinition.this.world.convertIdToScript(StepDefinition.getEdgeId(StepDefinition.this.g, s), Edge.class)));
            this.add(Pair.with((Object)Pattern.compile("e\\[(.+)\\]\\.sid"), s -> StepDefinition.this.world.convertIdToScript(StepDefinition.getEdgeId(StepDefinition.this.g, s), Edge.class)));
            this.add(Pair.with((Object)Pattern.compile("t\\[(.*)\\]"), s -> String.format("T.%s", s)));
            this.add(Pair.with((Object)Pattern.compile("D\\[(.*)\\]"), s -> String.format("Direction.%s", s)));
            this.add(Pair.with((Object)Pattern.compile("M\\[(.*)\\]"), s -> String.format("Merge.%s", s)));
            this.add(Pair.with((Object)Pattern.compile("c\\[(.*)\\]"), s -> {
                throw new AssumptionViolatedException("This test uses a lambda as a parameter which is not supported by gremlin-language");
            }));
            this.add(Pair.with((Object)Pattern.compile("e\\[(.+)\\]"), s -> {
                throw new AssumptionViolatedException("This test uses a Edge as a parameter which is not supported by gremlin-language");
            }));
            this.add(Pair.with((Object)Pattern.compile("p\\[(.*)\\]"), s -> {
                throw new AssumptionViolatedException("This test uses a Path as a parameter which is not supported by gremlin-language");
            }));
            this.add(Pair.with((Object)Pattern.compile("s\\[\\]"), s -> {
                throw new AssumptionViolatedException("This test uses a empty Set as a parameter which is not supported by gremlin-language");
            }));
            this.add(Pair.with((Object)Pattern.compile("s\\[(.*)\\]"), s -> {
                throw new AssumptionViolatedException("This test uses a Set as a parameter which is not supported by gremlin-language");
            }));
            this.add(Pair.with((Object)Pattern.compile("(null)"), s -> "null"));
            this.add(Pair.with((Object)Pattern.compile("(true)"), s -> "true"));
            this.add(Pair.with((Object)Pattern.compile("(false)"), s -> "false"));
        }
    };
    private List<Pair<Pattern, Function<String, Object>>> objectMatcherConverters = new ArrayList<Pair<Pattern, Function<String, Object>>>(){
        {
            this.add(Pair.with((Object)Pattern.compile("m\\[(.*)\\]"), s -> {
                try {
                    return StepDefinition.this.convertToObject(mapper.readTree(s));
                }
                catch (Exception ex) {
                    throw new IllegalStateException(String.format("Can't parse JSON to map for %s", s), ex);
                }
            }));
            this.add(Pair.with((Object)Pattern.compile("l\\[\\]"), s -> Collections.emptyList()));
            this.add(Pair.with((Object)Pattern.compile("l\\[(.*)\\]"), s -> {
                String[] items = s.split(",");
                return Stream.of(items).map(String::trim).map(x -> StepDefinition.this.convertToObject(x)).collect(Collectors.toList());
            }));
            this.add(Pair.with((Object)Pattern.compile("s\\[\\]"), s -> Collections.emptySet()));
            this.add(Pair.with((Object)Pattern.compile("s\\[(.*)\\]"), s -> {
                String[] items = s.split(",");
                return Stream.of(items).map(String::trim).map(x -> StepDefinition.this.convertToObject(x)).collect(Collectors.toSet());
            }));
            this.add(Pair.with((Object)Pattern.compile("str\\[(.*)\\]"), String::valueOf));
            this.add(Pair.with((Object)Pattern.compile("vp\\[(.+)\\]"), s -> StepDefinition.this.getVertexProperty(StepDefinition.this.g, s)));
            this.add(Pair.with((Object)Pattern.compile("p\\[(.*)\\]"), s -> {
                String[] items = s.split(",");
                Path path = ImmutablePath.make();
                List pathObjects = Stream.of(items).map(String::trim).map(x -> StepDefinition.this.convertToObject(x)).collect(Collectors.toList());
                for (Object o : pathObjects) {
                    path = path.extend(o, Collections.emptySet());
                }
                return path;
            }));
            this.add(Pair.with((Object)Pattern.compile("d\\[(NaN)\\]"), s -> Double.NaN));
            this.add(Pair.with((Object)Pattern.compile("d\\[(Infinity)\\]"), s -> Double.POSITIVE_INFINITY));
            this.add(Pair.with((Object)Pattern.compile("d\\[(-Infinity)\\]"), s -> Double.NEGATIVE_INFINITY));
            this.add(Pair.with((Object)Pattern.compile("d\\[(.*)\\]\\.b"), Byte::parseByte));
            this.add(Pair.with((Object)Pattern.compile("d\\[(.*)\\]\\.s"), Short::parseShort));
            this.add(Pair.with((Object)Pattern.compile("d\\[(.*)\\]\\.i"), Integer::parseInt));
            this.add(Pair.with((Object)Pattern.compile("d\\[(.*)\\]\\.l"), Long::parseLong));
            this.add(Pair.with((Object)Pattern.compile("d\\[(.*)\\]\\.f"), Float::parseFloat));
            this.add(Pair.with((Object)Pattern.compile("d\\[(.*)\\]\\.d"), Double::parseDouble));
            this.add(Pair.with((Object)Pattern.compile("d\\[(.*)\\]\\.m"), BigDecimal::new));
            this.add(Pair.with((Object)Pattern.compile("d\\[(.*)\\]\\.n"), BigInteger::new));
            this.add(Pair.with((Object)Pattern.compile("dt\\[(.*)\\]"), s -> DatetimeHelper.parse((String)s)));
            this.add(Pair.with((Object)Pattern.compile("v\\[(.+)\\]\\.id"), s -> StepDefinition.this.g.V(new Object[0]).has("name", s).id().next()));
            this.add(Pair.with((Object)Pattern.compile("v\\[(.+)\\]\\.sid"), s -> StepDefinition.this.g.V(new Object[0]).has("name", s).id().next().toString()));
            this.add(Pair.with((Object)Pattern.compile("v\\[(.+)\\]"), s -> StepDefinition.this.g.V(new Object[0]).has("name", s).next()));
            this.add(Pair.with((Object)Pattern.compile("e\\[(.+)\\]\\.id"), s -> StepDefinition.getEdgeId(StepDefinition.this.g, s)));
            this.add(Pair.with((Object)Pattern.compile("e\\[(.+)\\]\\.sid"), s -> StepDefinition.getEdgeIdString(StepDefinition.this.g, s)));
            this.add(Pair.with((Object)Pattern.compile("e\\[(.+)\\]"), s -> StepDefinition.getEdge(StepDefinition.this.g, s)));
            this.add(Pair.with((Object)Pattern.compile("t\\[(.*)\\]"), T::valueOf));
            this.add(Pair.with((Object)Pattern.compile("D\\[(.*)\\]"), Direction::valueOf));
            this.add(Pair.with((Object)Pattern.compile("M\\[(.*)\\]"), Merge::valueOf));
            this.add(Pair.with((Object)Pattern.compile("c\\[(.*)\\]"), s -> {
                throw new AssumptionViolatedException("This test uses a lambda as a parameter which is not supported by gremlin-language");
            }));
            this.add(Pair.with((Object)Pattern.compile("(null)"), s -> null));
            this.add(Pair.with((Object)Pattern.compile("(true)"), s -> true));
            this.add(Pair.with((Object)Pattern.compile("(false)"), s -> false));
        }
    };

    @Inject
    public StepDefinition(World world) {
        this.world = Objects.requireNonNull(world, "world must not be null");
    }

    @Before
    public void beforeEachScenario(Scenario scenario) throws Exception {
        this.world.beforeEachScenario(scenario);
        this.stringParameters.clear();
        if (this.traversal != null) {
            this.traversal.close();
            this.traversal = null;
        }
        if (this.result != null) {
            this.result = null;
        }
        if (this.error != null) {
            this.error = null;
        }
    }

    @After
    public void afterEachScenario() throws Exception {
        this.world.afterEachScenario();
        if (this.g != null) {
            this.g.close();
        }
    }

    @Given(value="the {word} graph")
    public void givenTheXGraph(String graphName) {
        this.g = graphName.equals("empty") ? this.world.getGraphTraversalSource(null) : this.world.getGraphTraversalSource(LoadGraphWith.GraphData.valueOf(graphName.toUpperCase()));
    }

    @Given(value="the graph initializer of")
    public void theGraphInitializerOf(String gremlin) {
        this.parseGremlin(gremlin).iterate();
    }

    @Given(value="using the parameter {word} defined as {string}")
    public void usingTheParameterXDefinedAsX(String key, String value) {
        this.stringParameters.put(key, this.convertToString(value));
    }

    @Given(value="using the parameter {word} of P.{word}\\({string})")
    public void usingTheParameterXOfPX(String key, String pval, String string) {
        this.stringParameters.put(key, String.format("P.%s(%s)", pval, this.convertToString(string)));
    }

    @Given(value="the traversal of")
    public void theTraversalOf(String docString) {
        try {
            String gremlin = this.tryUpdateDataFilePath(docString);
            this.traversal = this.parseGremlin(this.applyParameters(gremlin));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.error = ex;
        }
    }

    @When(value="iterated to list")
    public void iteratedToList() {
        try {
            this.result = this.traversal.toList();
        }
        catch (Exception ex) {
            this.error = ex;
        }
    }

    @When(value="iterated next")
    public void iteratedNext() {
        try {
            this.result = this.traversal.next();
        }
        catch (Exception ex) {
            this.error = ex;
        }
    }

    @Then(value="the result should be unordered")
    public void theResultShouldBeUnordered(DataTable dataTable) {
        this.assertThatNoErrorWasThrown();
        List<Object> actual = this.translateResultsToActual();
        Assert.assertEquals((long)(dataTable.height() - 1), (long)actual.size());
        Object[] expected = dataTable.asList().stream().skip(1L).map(this::convertToObject).toArray();
        MatcherAssert.assertThat(actual, StepDefinition.containsInAnyOrder(expected));
    }

    @Then(value="the result should be ordered")
    public void theResultShouldBeOrdered(DataTable dataTable) {
        this.assertThatNoErrorWasThrown();
        List<Object> actual = this.translateResultsToActual();
        Assert.assertEquals((long)(dataTable.height() - 1), (long)actual.size());
        Object[] expected = dataTable.asList().stream().skip(1L).map(this::convertToObject).toArray();
        MatcherAssert.assertThat(actual, StepDefinition.contains(expected));
    }

    @Then(value="the result should be of")
    public void theResultShouldBeOf(DataTable dataTable) {
        this.assertThatNoErrorWasThrown();
        List<Object> actual = this.translateResultsToActual();
        Object[] expected = dataTable.asList().stream().skip(1L).map(this::convertToObject).toArray();
        MatcherAssert.assertThat(actual, (org.hamcrest.Matcher)Every.everyItem(StepDefinition.in(expected)));
    }

    @Then(value="the result should have a count of {int}")
    public void theResultShouldHaveACountOf(Integer val) {
        this.assertThatNoErrorWasThrown();
        if (this.result instanceof Iterable) {
            Assert.assertEquals((long)val.intValue(), (long)IteratorUtils.count((Iterable)((Iterable)this.result)));
        } else if (this.result instanceof Map) {
            Assert.assertEquals((long)val.intValue(), (long)((Map)this.result).size());
        } else {
            Assert.fail((String)String.format("Missing an assert for this type", this.result.getClass()));
        }
    }

    @Then(value="the graph should return {int} for count of {string}")
    public void theGraphShouldReturnForCountOf(Integer count, String gremlin) {
        this.assertThatNoErrorWasThrown();
        Assert.assertEquals((Object)count.longValue(), (Object)((GraphTraversal)this.parseGremlin(this.applyParameters(gremlin))).count().next());
    }

    @Then(value="debug the graph should return {int} for count of {string}")
    public void debugTheGraphShouldReturnForCountOf(Integer count, String gremlin) {
        this.assertThatNoErrorWasThrown();
        Assert.assertEquals((Object)count.longValue(), (Object)((GraphTraversal)this.parseGremlin(this.applyParameters(gremlin))).count().next());
    }

    @Then(value="the result should be empty")
    public void theResultShouldBeEmpty() {
        this.assertThatNoErrorWasThrown();
        MatcherAssert.assertThat((Object)this.result, (org.hamcrest.Matcher)IsInstanceOf.instanceOf(Collection.class));
        Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterable)((Collection)this.result)));
    }

    @Then(value="the traversal will raise an error")
    public void theTraversalWillRaiseAnError() {
        Assert.assertNotNull((Object)this.error);
        this.error = null;
    }

    @Then(value="the traversal will raise an error with message {word} text of {string}")
    public void theTraversalWillRaiseAnErrorWithMessage(String comparison, String expectedMessage) {
        Assert.assertNotNull((Object)this.error);
        switch (comparison) {
            case "containing": {
                MatcherAssert.assertThat((Object)this.error.getMessage(), (org.hamcrest.Matcher)StringContains.containsString((String)expectedMessage));
                break;
            }
            case "starting": {
                MatcherAssert.assertThat((Object)this.error.getMessage(), (org.hamcrest.Matcher)StringStartsWith.startsWith((String)expectedMessage));
                break;
            }
            case "ending": {
                MatcherAssert.assertThat((Object)this.error.getMessage(), (org.hamcrest.Matcher)StringEndsWith.endsWith((String)expectedMessage));
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unknown comparison of %s - must be one of: containing, starting or ending", comparison));
            }
        }
        this.error = null;
    }

    @Given(value="an unsupported test")
    public void anUnsupportedTest() {
    }

    @Then(value="nothing should happen because")
    public void nothingShouldHappenBecause(String message) {
        throw new AssumptionViolatedException(String.format("This test is not supported by Gherkin because: %s", message));
    }

    private void assertThatNoErrorWasThrown() {
        if (this.error != null) {
            throw new RuntimeException(this.error);
        }
    }

    private Traversal parseGremlin(String script) {
        GremlinLexer lexer = new GremlinLexer((CharStream)CharStreams.fromString((String)script));
        GremlinParser parser = new GremlinParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        GremlinParser.QueryContext ctx = parser.query();
        return (Traversal)new GremlinAntlrToJava(this.g).visitQuery(ctx);
    }

    private List<Object> translateResultsToActual() {
        List r = this.result instanceof List ? (List)this.result : IteratorUtils.asList((Object)this.result);
        List<Object> actual = r.stream().map(o -> {
            if (o instanceof Map.Entry) {
                return new LinkedHashMap(){
                    {
                        this.put(((Map.Entry)o).getKey(), ((Map.Entry)o).getValue());
                    }
                };
            }
            return o;
        }).collect(Collectors.toList());
        return actual;
    }

    private String convertToString(String pvalue) {
        return this.convertToString(null, pvalue);
    }

    private String convertToString(String pkey, String pvalue) {
        for (Pair<Pattern, Function<String, String>> matcherConverter : this.stringMatcherConverters) {
            Pattern pattern = (Pattern)matcherConverter.getValue0();
            Matcher matcher = pattern.matcher(pvalue);
            if (!matcher.find()) continue;
            Function converter = (Function)matcherConverter.getValue1();
            return (String)converter.apply(matcher.groupCount() == 0 ? "" : matcher.group(1));
        }
        return String.format("\"%s\"", pvalue);
    }

    private Object convertToObject(Object pvalue) {
        Object v;
        if (pvalue instanceof JsonNode) {
            JsonNode n = (JsonNode)pvalue;
            if (n.isNull()) {
                v = null;
            } else if (n.isArray()) {
                v = IteratorUtils.stream((Iterator)n.elements()).map(this::convertToObject).collect(Collectors.toList());
            } else if (n.isObject()) {
                HashMap m = new HashMap(n.size());
                n.fields().forEachRemaining(e -> m.put(this.convertToObject(e.getKey()), this.convertToObject(e.getValue())));
                v = m;
            } else {
                v = n.isNumber() ? n.numberValue() : (n.isBoolean() ? Boolean.valueOf(n.booleanValue()) : n.textValue());
            }
        } else {
            v = pvalue;
        }
        if (!(v instanceof String)) {
            return v;
        }
        for (Pair<Pattern, Function<String, Object>> matcherConverter : this.objectMatcherConverters) {
            Pattern pattern = (Pattern)matcherConverter.getValue0();
            Matcher matcher = pattern.matcher((String)v);
            if (!matcher.find()) continue;
            Function converter = (Function)matcherConverter.getValue1();
            return converter.apply(matcher.groupCount() == 0 ? "" : matcher.group(1));
        }
        return String.format("%s", v);
    }

    private static Triplet<String, String, String> getEdgeTriplet(String e) {
        Matcher m = edgeTripletPattern.matcher(e);
        if (m.matches()) {
            return Triplet.with((Object)m.group(1), (Object)m.group(2), (Object)m.group(3));
        }
        throw new IllegalStateException(String.format("Invalid edge identifier: %s", e));
    }

    private static Edge getEdge(GraphTraversalSource g, String e) {
        Triplet<String, String, String> t = StepDefinition.getEdgeTriplet(e);
        return g.V(new Object[0]).has("name", t.getValue0()).outE(new String[]{(String)t.getValue1()}).toStream().filter(edge -> g.V(new Object[]{edge.inVertex().id()}).has("name", t.getValue2()).hasNext()).findFirst().get();
    }

    private VertexProperty getVertexProperty(GraphTraversalSource g, String e) {
        Triplet<String, String, String> t = StepDefinition.getEdgeTriplet(e);
        return g.V(new Object[0]).has("name", t.getValue0()).properties(new String[]{(String)t.getValue1()}).hasValue(this.convertToObject(t.getValue2()), new Object[0]).tryNext().orElse(null);
    }

    private static Object getEdgeId(GraphTraversalSource g, String e) {
        return StepDefinition.getEdge(g, e).id();
    }

    private static String getEdgeIdString(GraphTraversalSource g, String e) {
        return StepDefinition.getEdgeId(g, e).toString();
    }

    private String applyParameters(String docString) {
        String replaced = docString;
        ArrayList<String> paramNames = new ArrayList<String>(this.stringParameters.keySet());
        paramNames.sort((a, b) -> b.length() - a.length());
        for (String k : paramNames) {
            replaced = replaced.replace(k, this.stringParameters.get(k));
        }
        return replaced;
    }

    private String tryUpdateDataFilePath(String docString) {
        Matcher matcher = ioPattern.matcher(docString);
        if (!matcher.matches()) {
            return docString;
        }
        String relPath = matcher.group(1);
        String absPath = this.world.changePathToDataFile(relPath);
        return docString.replace(relPath, StringEscapeUtils.escapeJava((String)absPath));
    }

    @SafeVarargs
    public static <T> org.hamcrest.Matcher<Iterable<? extends T>> containsInAnyOrder(T ... items) {
        return new IsIterableContainingInAnyOrder(StepDefinition.getMatchers(items));
    }

    @SafeVarargs
    public static <T> org.hamcrest.Matcher<Iterable<? extends T>> contains(T ... items) {
        return new IsIterableContainingInOrder(StepDefinition.getMatchers(items));
    }

    public static <T> org.hamcrest.Matcher<T> in(Collection<T> collection) {
        return new IsInMatcher<T>(collection);
    }

    public static <T> org.hamcrest.Matcher<T> in(T[] elements) {
        return new IsInMatcher<T>(elements);
    }

    private static <T> List<org.hamcrest.Matcher<? super T>> getMatchers(T[] items) {
        ArrayList<org.hamcrest.Matcher<T>> matchers = new ArrayList<org.hamcrest.Matcher<T>>();
        for (int ix = 0; ix < items.length; ++ix) {
            T item = items[ix];
            if (item instanceof Path) {
                matchers.add((org.hamcrest.Matcher<T>)new IsPathEqualToMatcher((Path)item));
                continue;
            }
            matchers.add(IsEqual.equalTo(item));
        }
        return matchers;
    }
}

