/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.configuration2.Configuration;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.GraphManager;
import org.apache.tinkerpop.gremlin.GraphProvider;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.apache.tinkerpop.gremlin.util.iterator.StoreIteratorCounter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGremlinTest {
    private static final Logger logger = LoggerFactory.getLogger(AbstractGremlinTest.class);
    protected static final boolean shouldTestIteratorLeak = Boolean.valueOf(System.getProperty("testIteratorLeaks", "true"));
    protected Graph graph;
    protected GraphTraversalSource g;
    protected Configuration config;
    protected GraphProvider graphProvider;
    @Rule
    public TestName name = new TestName();

    @Before
    public void setup() throws Exception {
        Method testMethod = this.getClass().getMethod(AbstractGremlinTest.cleanMethodName(this.name.getMethodName()), new Class[0]);
        LoadGraphWith[] loadGraphWiths = (LoadGraphWith[])testMethod.getAnnotationsByType(LoadGraphWith.class);
        LoadGraphWith loadGraphWith = loadGraphWiths.length == 0 ? null : loadGraphWiths[0];
        LoadGraphWith.GraphData loadGraphWithData = null == loadGraphWith ? null : loadGraphWith.value();
        Set<FeatureRequirement> featureRequirementSet = AbstractGremlinTest.getFeatureRequirementsForTest(testMethod, loadGraphWiths);
        this.graphProvider = GraphManager.getGraphProvider();
        Optional<Graph.Features> staticFeatures = this.graphProvider.getStaticFeatures();
        if (staticFeatures.isPresent()) {
            AbstractGremlinTest.assumeRequirementsAreMetForTest(featureRequirementSet, staticFeatures.get(), true);
        }
        this.graphProvider.getTestListener().ifPresent(l -> l.onTestStart(this.getClass(), this.name.getMethodName()));
        StoreIteratorCounter.INSTANCE.reset();
        this.config = this.graphProvider.standardGraphConfiguration(this.getClass(), this.name.getMethodName(), loadGraphWithData);
        this.graphProvider.clear(this.config);
        this.graph = this.graphProvider.openTestGraph(this.config);
        this.g = this.graphProvider.traversal(this.graph);
        AbstractGremlinTest.assumeRequirementsAreMetForTest(featureRequirementSet, this.graph.features(), false);
        this.beforeLoadGraphWith(this.graph);
        this.graphProvider.loadGraphData(this.graph, loadGraphWith, this.getClass(), this.name.getMethodName());
        this.afterLoadGraphWith(this.graph);
    }

    private static void assumeRequirementsAreMetForTest(Set<FeatureRequirement> featureRequirementSet, Graph.Features features, boolean staticCheck) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        for (FeatureRequirement fr : featureRequirementSet) {
            try {
                Assume.assumeThat((String)String.format("Features of the graph do not support all of the features required by this test so it will be ignored: %s.%s=%s", fr.featureClass().getSimpleName(), fr.feature(), fr.supported()), (Object)features.supports(fr.featureClass(), fr.feature()), (Matcher)CoreMatchers.is((Object)fr.supported()));
            }
            catch (NoSuchMethodException nsme) {
                throw new NoSuchMethodException(String.format("[supports%s] is not a valid feature on %s", fr.feature(), fr.featureClass()));
            }
            catch (UnsupportedOperationException uoe) {
                if (!staticCheck) continue;
                throw uoe;
            }
        }
    }

    protected void beforeLoadGraphWith(Graph g) throws Exception {
    }

    protected void afterLoadGraphWith(Graph g) throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        if (null != this.graphProvider) {
            this.graphProvider.getTestListener().ifPresent(l -> l.onTestEnd(this.getClass(), this.name.getMethodName()));
            this.graphProvider.clear(this.graph, this.config);
            if (this.graphProvider instanceof GraphManager.ManagedGraphProvider) {
                ((GraphManager.ManagedGraphProvider)this.graphProvider).tryClearGraphs();
            } else {
                logger.warn("The {} is not of type ManagedGraphProvider and therefore graph instances may leak between test cases.", this.graphProvider.getClass());
            }
            if (shouldTestIteratorLeak) {
                long wait = 300L;
                long[] tries = new long[]{1L, 3L, 5L, 7L, 9L, 18L, 27L, 36L, 72L, 144L, 256L, 512L};
                long openItrCount = StoreIteratorCounter.INSTANCE.getOpenIteratorCount();
                for (int ix = 0; ix < tries.length && openItrCount > 0L; ++ix) {
                    Thread.sleep(300L * tries[ix]);
                    openItrCount = StoreIteratorCounter.INSTANCE.getOpenIteratorCount();
                }
                Assert.assertEquals((String)("Iterator leak detected. Open iterator count=" + openItrCount), (long)0L, (long)openItrCount);
            }
            this.g = null;
            this.graph = null;
            this.config = null;
            this.graphProvider = null;
        }
    }

    public Object convertToVertexId(String vertexName) {
        return this.convertToVertexId(this.graph, vertexName);
    }

    public Object convertToVertexId(Graph graph, String vertexName) {
        return this.convertToVertex(graph, vertexName).id();
    }

    public Vertex convertToVertex(String vertexName) {
        return this.convertToVertex(this.graph, vertexName);
    }

    public Vertex convertToVertex(Graph graph, String vertexName) {
        return (Vertex)this.graphProvider.traversal(graph).V(new Object[0]).has("name", (Object)vertexName).toList().get(0);
    }

    public GraphTraversal<Vertex, Object> convertToVertexPropertyId(String vertexName, String vertexPropertyKey) {
        return this.convertToVertexPropertyId(this.graph, vertexName, vertexPropertyKey);
    }

    public GraphTraversal<Vertex, Object> convertToVertexPropertyId(Graph graph, String vertexName, String vertexPropertyKey) {
        return this.convertToVertexProperty(graph, vertexName, vertexPropertyKey).id();
    }

    public GraphTraversal<Vertex, VertexProperty<Object>> convertToVertexProperty(Graph graph, String vertexName, String vertexPropertyKey) {
        return this.graphProvider.traversal(graph).V(new Object[0]).has("name", (Object)vertexName).properties(new String[]{vertexPropertyKey});
    }

    public VertexProperty convertToVertexProperty(String vertexName, String propertyKey, Object propertyValue) {
        return (VertexProperty)this.convertToVertexProperty(this.graph, vertexName, propertyKey).hasValue(propertyValue, new Object[0]).toList().get(0);
    }

    public Edge convertToEdge(String outVertexName, String edgeLabel, String inVertexName) {
        return this.convertToEdge(this.graph, outVertexName, edgeLabel, inVertexName);
    }

    public Edge convertToEdge(Graph graph, String outVertexName, String edgeLabel, String inVertexName) {
        return (Edge)this.graphProvider.traversal(graph).V(new Object[0]).has("name", (Object)outVertexName).outE(new String[]{edgeLabel}).as("e", new String[0]).inV().has("name", (Object)inVertexName).select("e").toList().get(0);
    }

    public Object convertToEdgeId(String outVertexName, String edgeLabel, String inVertexName) {
        return this.convertToEdgeId(this.graph, outVertexName, edgeLabel, inVertexName);
    }

    public Object convertToEdgeId(Graph graph, String outVertexName, String edgeLabel, String inVertexName) {
        return this.convertToEdge(graph, outVertexName, edgeLabel, inVertexName).id();
    }

    public void tryCommit(Graph graph) {
        if (graph.features().graph().supportsTransactions()) {
            graph.tx().commit();
        }
    }

    public void tryCommit(Graph graph, Consumer<Graph> assertFunction) {
        assertFunction.accept(graph);
        if (graph.features().graph().supportsTransactions()) {
            graph.tx().commit();
            assertFunction.accept(graph);
        }
    }

    public void tryRollback(Graph graph) {
        if (graph.features().graph().supportsTransactions()) {
            graph.tx().rollback();
        }
    }

    private static String cleanMethodName(String methodName) {
        if (methodName.endsWith("]")) {
            return methodName.substring(0, methodName.indexOf("["));
        }
        return methodName;
    }

    public void printTraversalForm(Traversal traversal) {
        logger.info(String.format("Testing: %s", this.name.getMethodName()));
        logger.info("   pre-strategy:" + traversal);
        if (!traversal.asAdmin().isLocked()) {
            traversal.asAdmin().applyStrategies();
        }
        logger.info("  post-strategy:" + traversal);
        AbstractGremlinTest.verifyUniqueStepIds(traversal.asAdmin());
        AbstractGremlinTest.verifyRootIdentification(traversal.asAdmin(), true);
    }

    public static void assertVertexEdgeCounts(Graph graph, int expectedVertexCount, int expectedEdgeCount) {
        AbstractGremlinTest.getAssertVertexEdgeCounts(expectedVertexCount, expectedEdgeCount).accept(graph);
    }

    public static Consumer<Graph> getAssertVertexEdgeCounts(int expectedVertexCount, int expectedEdgeCount) {
        return g -> {
            Assert.assertEquals((long)expectedVertexCount, (long)IteratorUtils.count((Iterator)g.vertices(new Object[0])));
            Assert.assertEquals((long)expectedEdgeCount, (long)IteratorUtils.count((Iterator)g.edges(new Object[0])));
        };
    }

    public static void validateException(Throwable expected, Throwable actual) {
        MatcherAssert.assertThat((Object)actual, (Matcher)CoreMatchers.instanceOf(expected.getClass()));
    }

    public static void verifyUniqueStepIds(Traversal.Admin<?, ?> traversal) {
        AbstractGremlinTest.verifyUniqueStepIds(traversal, 0, new HashSet<String>());
    }

    public static void verifyRootIdentification(Traversal.Admin<?, ?> traversal, boolean expectRoot) {
        MatcherAssert.assertThat((Object)traversal.isRoot(), (Matcher)CoreMatchers.is((Object)expectRoot));
        for (Step step : traversal.getSteps()) {
            if (!(step instanceof TraversalParent)) continue;
            for (Traversal.Admin globalTraversal : ((TraversalParent)step).getGlobalChildren()) {
                AbstractGremlinTest.verifyRootIdentification(globalTraversal, false);
            }
            for (Traversal.Admin localTraversal : ((TraversalParent)step).getLocalChildren()) {
                AbstractGremlinTest.verifyRootIdentification(localTraversal, false);
            }
        }
    }

    private static Set<FeatureRequirement> getFeatureRequirementsForTest(Method testMethod, LoadGraphWith[] loadGraphWiths) {
        FeatureRequirementSet[] featureRequirementSets;
        FeatureRequirement[] featureRequirement = (FeatureRequirement[])testMethod.getAnnotationsByType(FeatureRequirement.class);
        ArrayList<FeatureRequirement> frs = new ArrayList<FeatureRequirement>(Arrays.asList(featureRequirement));
        if (loadGraphWiths.length > 0) {
            frs.addAll(loadGraphWiths[0].value().featuresRequired());
        }
        if ((featureRequirementSets = (FeatureRequirementSet[])testMethod.getAnnotationsByType(FeatureRequirementSet.class)).length > 0) {
            frs.addAll(Arrays.stream(featureRequirementSets).flatMap(f -> f.value().featuresRequired().stream()).collect(Collectors.toList()));
        }
        return new HashSet<FeatureRequirement>(frs);
    }

    private static void verifyUniqueStepIds(Traversal.Admin<?, ?> traversal, int depth, Set<String> ids) {
        for (Step step : traversal.asAdmin().getSteps()) {
            if (!ids.add(step.getId())) {
                Assert.fail((String)("The following step id already exists: " + step.getId() + "---" + step));
            }
            if (!(step instanceof TraversalParent)) continue;
            for (Traversal.Admin globalTraversal : ((TraversalParent)step).getGlobalChildren()) {
                AbstractGremlinTest.verifyUniqueStepIds(globalTraversal, depth + 1, ids);
            }
            for (Traversal.Admin localTraversal : ((TraversalParent)step).getLocalChildren()) {
                AbstractGremlinTest.verifyUniqueStepIds(localTraversal, depth + 1, ids);
            }
        }
    }
}

