/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin;

import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.Comparators;
import org.apache.tinkerpop.gremlin.util.TestSupport;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TestHelper
extends TestSupport {
    private static final Logger logger = LoggerFactory.getLogger(TestSupport.class);
    public static final Random RANDOM;

    private TestHelper() {
    }

    public static String convertToRelative(Class clazz, File f) {
        File root = TestHelper.getRootOfBuildDirectory((Class)clazz).getParentFile();
        return root.toURI().relativize(f.toURI()).toString();
    }

    public static void assumeNonDeterministic() {
        Assume.assumeThat((String)"Set the 'assertNonDeterministic' property to true to execute this test", (Object)System.getProperty("assertNonDeterministic"), (Matcher)CoreMatchers.is((Object)"true"));
    }

    public static void validateVertexEquality(Vertex originalVertex, Vertex otherVertex, boolean testEdges) {
        Assert.assertEquals((Object)originalVertex, (Object)otherVertex);
        Assert.assertEquals((Object)otherVertex, (Object)originalVertex);
        Assert.assertEquals((Object)originalVertex.id(), (Object)otherVertex.id());
        Assert.assertEquals((Object)originalVertex.label(), (Object)otherVertex.label());
        Assert.assertEquals((long)originalVertex.keys().size(), (long)otherVertex.keys().size());
        for (String key : originalVertex.keys()) {
            List originalVertexProperties = IteratorUtils.list((Iterator)originalVertex.properties(new String[]{key}));
            List otherVertexProperties = IteratorUtils.list((Iterator)otherVertex.properties(new String[]{key}));
            Assert.assertEquals((long)originalVertexProperties.size(), (long)otherVertexProperties.size());
            for (VertexProperty originalVertexProperty : originalVertexProperties) {
                VertexProperty otherVertexProperty = otherVertexProperties.parallelStream().filter(vp -> vp.equals(originalVertexProperty)).findAny().get();
                TestHelper.validateVertexPropertyEquality(originalVertexProperty, otherVertexProperty);
            }
        }
        if (testEdges) {
            Iterator originalEdges = IteratorUtils.list((Iterator)originalVertex.edges(Direction.OUT, new String[0]), (Comparator)Comparators.ELEMENT_COMPARATOR).iterator();
            Iterator otherEdges = IteratorUtils.list((Iterator)otherVertex.edges(Direction.OUT, new String[0]), (Comparator)Comparators.ELEMENT_COMPARATOR).iterator();
            while (originalEdges.hasNext()) {
                TestHelper.validateEdgeEquality((Edge)originalEdges.next(), (Edge)otherEdges.next());
            }
            Assert.assertFalse((boolean)otherEdges.hasNext());
            originalEdges = IteratorUtils.list((Iterator)originalVertex.edges(Direction.IN, new String[0]), (Comparator)Comparators.ELEMENT_COMPARATOR).iterator();
            otherEdges = IteratorUtils.list((Iterator)otherVertex.edges(Direction.IN, new String[0]), (Comparator)Comparators.ELEMENT_COMPARATOR).iterator();
            while (originalEdges.hasNext()) {
                TestHelper.validateEdgeEquality((Edge)originalEdges.next(), (Edge)otherEdges.next());
            }
            Assert.assertFalse((boolean)otherEdges.hasNext());
        }
    }

    public static void validateVertexPropertyEquality(VertexProperty originalVertexProperty, VertexProperty otherVertexProperty) {
        Assert.assertEquals((Object)originalVertexProperty, (Object)otherVertexProperty);
        Assert.assertEquals((Object)otherVertexProperty, (Object)originalVertexProperty);
        if (originalVertexProperty.isPresent()) {
            Assert.assertEquals((Object)originalVertexProperty.key(), (Object)otherVertexProperty.key());
            Assert.assertEquals((Object)originalVertexProperty.value(), (Object)otherVertexProperty.value());
            Assert.assertEquals((Object)originalVertexProperty.element(), (Object)otherVertexProperty.element());
            boolean originalSupportsMetaProperties = originalVertexProperty.graph().features().vertex().supportsMetaProperties();
            boolean otherSupportsMetaProperties = otherVertexProperty.graph().features().vertex().supportsMetaProperties();
            if (originalSupportsMetaProperties && !otherSupportsMetaProperties) {
                Assert.assertEquals((long)0L, (long)originalVertexProperty.keys().size());
            } else if (!originalSupportsMetaProperties && otherSupportsMetaProperties) {
                Assert.assertEquals((long)0L, (long)otherVertexProperty.keys().size());
            } else {
                Assert.assertEquals((long)originalVertexProperty.keys().size(), (long)otherVertexProperty.keys().size());
                for (String key : originalVertexProperty.keys()) {
                    TestHelper.validatePropertyEquality(originalVertexProperty.property(key), otherVertexProperty.property(key));
                }
            }
        }
    }

    public static void validatePropertyEquality(Property originalProperty, Property otherProperty) {
        Assert.assertEquals((Object)originalProperty, (Object)otherProperty);
        Assert.assertEquals((Object)otherProperty, (Object)originalProperty);
        if (originalProperty.isPresent()) {
            Assert.assertEquals((Object)originalProperty.key(), (Object)otherProperty.key());
            Assert.assertEquals((Object)originalProperty.value(), (Object)otherProperty.value());
            Assert.assertEquals((Object)originalProperty.element(), (Object)otherProperty.element());
        }
    }

    public static void validateEdgeEquality(Edge originalEdge, Edge otherEdge) {
        Assert.assertEquals((Object)originalEdge, (Object)otherEdge);
        Assert.assertEquals((Object)otherEdge, (Object)originalEdge);
        Assert.assertEquals((Object)originalEdge.id(), (Object)otherEdge.id());
        Assert.assertEquals((Object)originalEdge.label(), (Object)otherEdge.label());
        Assert.assertEquals((Object)originalEdge.inVertex(), (Object)otherEdge.inVertex());
        Assert.assertEquals((Object)originalEdge.outVertex(), (Object)otherEdge.outVertex());
        Assert.assertEquals((long)originalEdge.keys().size(), (long)otherEdge.keys().size());
        for (String key : originalEdge.keys()) {
            TestHelper.validatePropertyEquality(originalEdge.property(key), otherEdge.property(key));
        }
    }

    public static void validateEquality(Object original, Object other) {
        if (original instanceof Vertex) {
            TestHelper.validateVertexEquality((Vertex)original, (Vertex)other, true);
        } else if (original instanceof VertexProperty) {
            TestHelper.validateVertexPropertyEquality((VertexProperty)original, (VertexProperty)other);
        } else if (original instanceof Edge) {
            TestHelper.validateEdgeEquality((Edge)original, (Edge)other);
        } else if (original instanceof Property) {
            TestHelper.validatePropertyEquality((Property)original, (Property)other);
        } else {
            throw new IllegalArgumentException("The provided object must be a graph object: " + original.getClass().getCanonicalName());
        }
    }

    public static void createRandomGraph(Graph graph, int numberOfVertices, int maxNumberOfEdgesPerVertex) {
        Random random = new Random();
        for (int i = 0; i < numberOfVertices; ++i) {
            graph.addVertex(new Object[]{T.id, i});
        }
        graph.vertices(new Object[0]).forEachRemaining(vertex -> {
            for (int i = 0; i < random.nextInt(maxNumberOfEdgesPerVertex); ++i) {
                Vertex other = (Vertex)graph.vertices(new Object[]{random.nextInt(numberOfVertices)}).next();
                vertex.addEdge("link", other, new Object[0]);
            }
        });
    }

    static {
        long seed = Long.parseLong(System.getProperty("testSeed", String.valueOf(System.currentTimeMillis())));
        logger.info("*** THE RANDOM TEST SEED IS {} ***", (Object)seed);
        RANDOM = new Random(seed);
    }
}

