/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.ExceptionCoverage;
import org.apache.tinkerpop.gremlin.ExceptionCoverageSet;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.MockSerializable;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class PropertyTest {

    @RunWith(value=Parameterized.class)
    public static class PropertyFeatureSupportTest
    extends AbstractGremlinTest {
        private static final Map<String, Object> testMap = new HashMap<String, Object>();
        private static final ArrayList<Object> mixedList = new ArrayList();
        private static final ArrayList<String> uniformStringList = new ArrayList();
        private static final ArrayList<Integer> uniformIntegerList = new ArrayList();
        @Parameterized.Parameter(value=0)
        public String featureName;
        @Parameterized.Parameter(value=1)
        public Object value;

        @Parameterized.Parameters(name="supports{0}({1})")
        public static Iterable<Object[]> data() {
            return Arrays.asList({"BooleanValues", true}, {"BooleanValues", false}, {"DoubleValues", Double.MIN_VALUE}, {"DoubleValues", Double.MAX_VALUE}, {"DoubleValues", 0.0}, {"DoubleValues", 0.5}, {"DoubleValues", -0.5}, {"FloatValues", Float.valueOf(Float.MIN_VALUE)}, {"FloatValues", Float.valueOf(Float.MAX_VALUE)}, {"FloatValues", Float.valueOf(0.0f)}, {"FloatValues", Float.valueOf(0.5f)}, {"FloatValues", Float.valueOf(-0.5f)}, {"IntegerValues", Integer.MIN_VALUE}, {"IntegerValues", Integer.MAX_VALUE}, {"IntegerValues", 0}, {"IntegerValues", 10000}, {"IntegerValues", -10000}, {"LongValues", Long.MIN_VALUE}, {"LongValues", Long.MAX_VALUE}, {"LongValues", 0L}, {"LongValues", 10000L}, {"LongValues", -10000L}, {"MapValues", testMap}, {"MixedListValues", mixedList}, {"BooleanArrayValues", new boolean[]{true, false}}, {"DoubleArrayValues", new double[]{1.0, 2.0}}, {"FloatArrayValues", new float[]{1.0f, 2.0f}}, {"IntegerArrayValues", new int[]{1, 2}}, {"LongArrayValues", new long[]{1L, 2L}}, {"StringArrayValues", new String[]{"try1", "try2"}}, {"IntegerArrayValues", new int[1]}, {"SerializableValues", new MockSerializable("testing")}, {"StringValues", "short string"}, {"UniformListValues", uniformIntegerList}, {"UniformListValues", uniformStringList});
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddProperty")})
        public void shouldSetValueOnEdge() throws Exception {
            Assume.assumeThat((Object)this.graph.features().supports(Graph.Features.EdgePropertyFeatures.class, this.featureName), (Matcher)CoreMatchers.is((Object)true));
            Edge edge = this.createEdgeForPropertyFeatureTests();
            edge.property("aKey", this.value);
            this.assertPropertyValue((Element)edge);
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddProperty")})
        public void shouldSetValueOnVertex() throws Exception {
            Assume.assumeThat((Object)this.graph.features().supports(Graph.Features.VertexPropertyFeatures.class, this.featureName), (Matcher)CoreMatchers.is((Object)true));
            Vertex vertex = this.graph.addVertex(new Object[0]);
            vertex.property(VertexProperty.Cardinality.single, "aKey", this.value, new Object[0]);
            this.assertPropertyValue((Element)vertex);
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
        public void shouldSetValueOnEdgeOnAdd() throws Exception {
            Assume.assumeThat((Object)this.graph.features().supports(Graph.Features.EdgePropertyFeatures.class, this.featureName), (Matcher)CoreMatchers.is((Object)true));
            Edge edge = this.createEdgeForPropertyFeatureTests("aKey", this.value);
            this.assertPropertyValue((Element)edge);
        }

        @Test
        @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")
        public void shouldSetValueOnVertexOnAdd() throws Exception {
            Assume.assumeThat((Object)this.graph.features().supports(Graph.Features.VertexPropertyFeatures.class, this.featureName), (Matcher)CoreMatchers.is((Object)true));
            Vertex vertex = this.graph.addVertex(new Object[]{"aKey", this.value});
            this.assertPropertyValue((Element)vertex);
        }

        private void assertPropertyValue(Element element) {
            if (this.value instanceof Map) {
                this.tryCommit(this.graph, graph -> {
                    Map map = (Map)element.property("aKey").value();
                    Assert.assertEquals((long)((Map)this.value).size(), (long)map.size());
                    ((Map)this.value).keySet().forEach(k -> Assert.assertEquals(((Map)this.value).get(k), map.get(k)));
                });
            } else if (this.value instanceof List) {
                this.tryCommit(this.graph, graph -> {
                    List l = (List)element.property("aKey").value();
                    Assert.assertEquals((long)((List)this.value).size(), (long)l.size());
                    for (int ix = 0; ix < ((List)this.value).size(); ++ix) {
                        Assert.assertEquals(((List)this.value).get(ix), l.get(ix));
                    }
                });
            } else if (this.value instanceof MockSerializable) {
                this.tryCommit(this.graph, graph -> {
                    MockSerializable mock = (MockSerializable)element.property("aKey").value();
                    Assert.assertEquals((Object)((MockSerializable)this.value).getTestField(), (Object)mock.getTestField());
                });
            } else if (this.value instanceof boolean[]) {
                this.tryCommit(this.graph, graph -> {
                    boolean[] l = (boolean[])element.property("aKey").value();
                    Assert.assertEquals((long)((boolean[])this.value).length, (long)l.length);
                    for (int ix = 0; ix < ((boolean[])this.value).length; ++ix) {
                        Assert.assertEquals((Object)((boolean[])this.value)[ix], (Object)l[ix]);
                    }
                });
            } else if (this.value instanceof double[]) {
                this.tryCommit(this.graph, graph -> {
                    double[] l = (double[])element.property("aKey").value();
                    Assert.assertEquals((long)((double[])this.value).length, (long)l.length);
                    for (int ix = 0; ix < ((double[])this.value).length; ++ix) {
                        Assert.assertEquals((double)((double[])this.value)[ix], (double)l[ix], (double)0.0);
                    }
                });
            } else if (this.value instanceof float[]) {
                this.tryCommit(this.graph, graph -> {
                    float[] l = (float[])element.property("aKey").value();
                    Assert.assertEquals((long)((float[])this.value).length, (long)l.length);
                    for (int ix = 0; ix < ((float[])this.value).length; ++ix) {
                        Assert.assertEquals((float)((float[])this.value)[ix], (float)l[ix], (float)0.0f);
                    }
                });
            } else if (this.value instanceof int[]) {
                this.tryCommit(this.graph, graph -> {
                    int[] l = (int[])element.property("aKey").value();
                    Assert.assertEquals((long)((int[])this.value).length, (long)l.length);
                    for (int ix = 0; ix < ((int[])this.value).length; ++ix) {
                        Assert.assertEquals((long)((int[])this.value)[ix], (long)l[ix]);
                    }
                });
            } else if (this.value instanceof long[]) {
                this.tryCommit(this.graph, graph -> {
                    long[] l = (long[])element.property("aKey").value();
                    Assert.assertEquals((long)((long[])this.value).length, (long)l.length);
                    for (int ix = 0; ix < ((long[])this.value).length; ++ix) {
                        Assert.assertEquals((long)((long[])this.value)[ix], (long)l[ix]);
                    }
                });
            } else if (this.value instanceof String[]) {
                this.tryCommit(this.graph, graph -> {
                    String[] l = (String[])element.property("aKey").value();
                    Assert.assertEquals((long)((String[])this.value).length, (long)l.length);
                    for (int ix = 0; ix < ((String[])this.value).length; ++ix) {
                        Assert.assertEquals((Object)((String[])this.value)[ix], (Object)l[ix]);
                    }
                });
            } else {
                this.tryCommit(this.graph, graph -> Assert.assertEquals((Object)this.value, (Object)element.property("aKey").value()));
            }
        }

        private Edge createEdgeForPropertyFeatureTests() {
            Vertex vertexA = this.graph.addVertex(new Object[0]);
            Vertex vertexB = this.graph.addVertex(new Object[0]);
            return vertexA.addEdge(this.graphProvider.convertLabel("knows"), vertexB, new Object[0]);
        }

        private Edge createEdgeForPropertyFeatureTests(String k, Object v) {
            Vertex vertexA = this.graph.addVertex(new Object[0]);
            Vertex vertexB = this.graph.addVertex(new Object[0]);
            return vertexA.addEdge(this.graphProvider.convertLabel("knows"), vertexB, new Object[]{k, v});
        }

        static {
            testMap.put("testString", "try");
            testMap.put("testInteger", 123);
            mixedList.add("try1");
            mixedList.add(2);
            uniformStringList.add("try1");
            uniformStringList.add("try2");
            uniformIntegerList.add(100);
            uniformIntegerList.add(200);
            uniformIntegerList.add(300);
        }
    }

    @RunWith(value=Parameterized.class)
    @ExceptionCoverage(exceptionClass=Property.Exceptions.class, methods={"propertyValueCanNotBeNull", "propertyKeyCanNotBeNull", "propertyKeyCanNotBeEmpty", "propertyKeyCanNotBeAHiddenKey"})
    public static class PropertyValidationOnSetExceptionConsistencyTest
    extends AbstractGremlinTest {
        @Parameterized.Parameter(value=0)
        public String name;
        @Parameterized.Parameter(value=1)
        public String key;
        @Parameterized.Parameter(value=2)
        public String val;
        @Parameterized.Parameter(value=3)
        public Exception expectedException;

        @Parameterized.Parameters(name="expect({0})")
        public static Iterable<Object[]> data() {
            return Arrays.asList({"propertyValueCanNotBeNull", "k", null, Property.Exceptions.propertyValueCanNotBeNull()}, {"propertyKeyCanNotBeNull", null, "v", Property.Exceptions.propertyKeyCanNotBeNull()}, {"propertyKeyCanNotBeEmpty", "", "v", Property.Exceptions.propertyKeyCanNotBeEmpty()}, {"propertyKeyCanNotBeAHiddenKey", Graph.Hidden.hide((String)"systemKey"), "value", Property.Exceptions.propertyKeyCanNotBeAHiddenKey((String)Graph.Hidden.hide((String)"systemKey"))});
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="Properties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddProperty")})
        public void testGraphVertexSetPropertyStandard() throws Exception {
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                v.property(VertexProperty.Cardinality.single, this.key, (Object)this.val, new Object[0]);
                Assert.fail((String)String.format("Call to Vertex.setProperty should have thrown an exception with these arguments [%s, %s]", this.key, this.val));
            }
            catch (Exception ex) {
                PropertyValidationOnSetExceptionConsistencyTest.validateException(this.expectedException, ex);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="Properties"), @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddProperty")})
        public void shouldThrowOnGraphEdgeSetPropertyStandard() throws Exception {
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                v.addEdge("self", v, new Object[0]).property(this.key, (Object)this.val);
                Assert.fail((String)String.format("Call to Edge.setProperty should have thrown an exception with these arguments [%s, %s]", this.key, this.val));
            }
            catch (Exception ex) {
                PropertyValidationOnSetExceptionConsistencyTest.validateException(this.expectedException, ex);
            }
        }
    }

    @ExceptionCoverage(exceptionClass=Property.Exceptions.class, methods={"propertyDoesNotExist"})
    public static class ElementGetValueExceptionConsistencyTest
    extends AbstractGremlinTest {
        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="Properties")})
        public void shouldGetValueThatIsNotPresentOnVertex() {
            Vertex v = this.graph.addVertex(new Object[0]);
            try {
                v.value("doesnotexist");
                Assert.fail((String)"Call to Element.value() with a key that is not present should throw an exception");
            }
            catch (Exception ex) {
                ElementGetValueExceptionConsistencyTest.validateException(Property.Exceptions.propertyDoesNotExist((Element)v, (String)"doesnotexist"), ex);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="Properties")})
        public void shouldGetValueThatIsNotPresentOnEdge() {
            Vertex v = this.graph.addVertex(new Object[0]);
            Edge e = v.addEdge("self", v, new Object[0]);
            try {
                e.value("doesnotexist");
                Assert.fail((String)"Call to Element.value() with a key that is not present should throw an exception");
            }
            catch (Exception ex) {
                ElementGetValueExceptionConsistencyTest.validateException(Property.Exceptions.propertyDoesNotExist((Element)e, (String)"doesnotexist"), ex);
            }
        }
    }

    @RunWith(value=Parameterized.class)
    @ExceptionCoverageSet(value={@ExceptionCoverage(exceptionClass=Element.Exceptions.class, methods={"providedKeyValuesMustBeAMultipleOfTwo", "providedKeyValuesMustHaveALegalKeyOnEvenIndices"}), @ExceptionCoverage(exceptionClass=Property.Exceptions.class, methods={"propertyValueCanNotBeNull", "propertyKeyCanNotBeEmpty"})})
    public static class PropertyValidationOnAddExceptionConsistencyTest
    extends AbstractGremlinTest {
        @Parameterized.Parameter(value=0)
        public String name;
        @Parameterized.Parameter(value=1)
        public Object[] arguments;
        @Parameterized.Parameter(value=2)
        public Exception expectedException;

        @Parameterized.Parameters(name="expect({0})")
        public static Iterable<Object[]> data() {
            return Arrays.asList({"providedKeyValuesMustBeAMultipleOfTwo", new Object[]{"odd", "number", "arguments"}, Element.Exceptions.providedKeyValuesMustBeAMultipleOfTwo()}, {"providedKeyValuesMustBeAMultipleOfTwo", new Object[]{"odd"}, Element.Exceptions.providedKeyValuesMustBeAMultipleOfTwo()}, {"providedKeyValuesMustHaveALegalKeyOnEvenIndices", new Object[]{"odd", "number", 123, "test"}, Element.Exceptions.providedKeyValuesMustHaveALegalKeyOnEvenIndices()}, {"propertyValueCanNotBeNull", new Object[]{"odd", null}, Property.Exceptions.propertyValueCanNotBeNull()}, {"providedKeyValuesMustHaveALegalKeyOnEvenIndices", new Object[]{null, "val"}, Element.Exceptions.providedKeyValuesMustHaveALegalKeyOnEvenIndices()}, {"propertyKeyCanNotBeEmpty", new Object[]{"", "val"}, Property.Exceptions.propertyKeyCanNotBeEmpty()});
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.VertexPropertyFeatures.class, feature="Properties")})
        public void shouldThrowOnGraphAddVertex() throws Exception {
            try {
                this.graph.addVertex(this.arguments);
                Assert.fail((String)String.format("Call to addVertex should have thrown an exception with these arguments [%s]", this.arguments));
            }
            catch (Exception ex) {
                PropertyValidationOnAddExceptionConsistencyTest.validateException(this.expectedException, ex);
            }
        }

        @Test
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="Properties")})
        public void shouldThrowOnGraphAddEdge() throws Exception {
            try {
                Vertex v = this.graph.addVertex(new Object[0]);
                v.addEdge("self", v, this.arguments);
                Assert.fail((String)String.format("Call to addVertex should have thrown an exception with these arguments [%s]", this.arguments));
            }
            catch (Exception ex) {
                PropertyValidationOnAddExceptionConsistencyTest.validateException(this.expectedException, ex);
            }
        }
    }

    public static class BasicPropertyTest
    extends AbstractGremlinTest {
        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        public void shouldHaveStandardStringRepresentationForVertexProperty() {
            Vertex v = this.graph.addVertex(new Object[]{"name", "marko"});
            VertexProperty p = v.property("name");
            Assert.assertEquals((Object)StringFactory.propertyString((Property)p), (Object)p.toString());
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        public void shouldHaveTruncatedStringRepresentationForVertexProperty() {
            Vertex v = this.graph.addVertex(new Object[]{"name", "maria de la santa cruz rosalina agnelia rodriguez cuellar rene"});
            VertexProperty p = v.property("name");
            Assert.assertEquals((Object)StringFactory.propertyString((Property)p), (Object)p.toString());
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        public void shouldHaveStandardStringRepresentationForEdgeProperty() {
            Vertex v = this.graph.addVertex(new Object[0]);
            Edge e = v.addEdge("self", v, new Object[]{"short", "s"});
            Property p = e.property("short");
            Assert.assertEquals((Object)StringFactory.propertyString((Property)p), (Object)p.toString());
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        public void shouldHaveTruncatedStringRepresentationForEdgeProperty() {
            Vertex v = this.graph.addVertex(new Object[0]);
            Edge e = v.addEdge("self", v, new Object[]{"long", "s"});
            Property p = e.property("long", (Object)"this is a really long property to truncate");
            Assert.assertEquals((Object)StringFactory.propertyString((Property)p), (Object)p.toString());
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        public void shouldReturnEmptyPropertyIfKeyNonExistent() {
            Vertex v = this.graph.addVertex(new Object[]{"name", "marko"});
            this.tryCommit(this.graph, graph -> {
                Vertex v1 = (Vertex)graph.vertices(new Object[]{v.id()}).next();
                VertexProperty p = v1.property("nonexistentkey");
                Assert.assertEquals((Object)VertexProperty.empty(), (Object)p);
            });
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
        @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="RemoveProperty")
        public void shouldAllowRemovalFromVertexWhenAlreadyRemoved() {
            Vertex v = this.graph.addVertex(new Object[]{"name", "marko"});
            this.tryCommit(this.graph);
            Vertex v1 = (Vertex)this.graph.vertices(new Object[]{v.id()}).next();
            try {
                VertexProperty p = v1.property("name");
                p.remove();
                p.remove();
                v1.property("name").remove();
                v1.property("name").remove();
            }
            catch (Exception ex) {
                Assert.fail((String)"Removing a vertex property that was already removed should not throw an exception");
            }
        }

        @Test
        @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
        @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="RemoveProperty"), @FeatureRequirement(featureClass=Graph.Features.EdgePropertyFeatures.class, feature="IntegerValues")})
        public void shouldAllowRemovalFromEdgeWhenAlreadyRemoved() {
            Vertex v = this.graph.addVertex(new Object[]{"name", "marko"});
            this.tryCommit(this.graph);
            Vertex v1 = (Vertex)this.graph.vertices(new Object[]{v.id()}).next();
            try {
                Edge edge = v1.addEdge("knows", this.graph.addVertex(new Object[0]), new Object[0]);
                Property p = edge.property("stars", (Object)5);
                p.remove();
                p.remove();
                edge.property("stars").remove();
                edge.property("stars").remove();
            }
            catch (Exception ex) {
                Assert.fail((String)"Removing an edge property that was already removed should not throw an exception");
            }
        }
    }
}

