/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.structure.Graph;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD})
@Repeatable(value=FeatureRequirements.class)
public @interface FeatureRequirement {
    public String feature();

    public Class<? extends Graph.Features.FeatureSet> featureClass();

    public boolean supported() default true;

    public static class Factory {
        public static FeatureRequirement create(String feature, Class<? extends Graph.Features.FeatureSet> featureClass) {
            return Factory.create(feature, featureClass, true);
        }

        public static FeatureRequirement create(final String feature, final Class<? extends Graph.Features.FeatureSet> featureClass, final boolean supported) {
            return new FeatureRequirement(){

                @Override
                public String feature() {
                    return feature;
                }

                @Override
                public Class<? extends Graph.Features.FeatureSet> featureClass() {
                    return featureClass;
                }

                @Override
                public boolean supported() {
                    return supported;
                }

                @Override
                public Class<? extends Annotation> annotationType() {
                    return FeatureRequirement.class;
                }
            };
        }
    }
}

