/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class AddEdgeTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, Edge> get_g_VX1X_asXaX_outXcreatedX_addEXcreatedByX_toXaX(Object var1);

    public abstract Traversal<Vertex, Edge> get_g_VX1X_asXaX_outXcreatedX_addEXcreatedByX_toXaX_propertyXweight_2X(Object var1);

    public abstract Traversal<Vertex, Edge> get_g_V_aggregateXxX_asXaX_selectXxX_unfold_addEXexistsWithX_toXaX_propertyXtime_nowX();

    public abstract Traversal<Vertex, Edge> get_g_V_asXaX_outXcreatedX_inXcreatedX_whereXneqXaXX_asXbX_addEXcodeveloperX_fromXaX_toXbX_propertyXyear_2009X();

    public abstract Traversal<Vertex, Edge> get_g_V_asXaX_inXcreatedX_addEXcreatedByX_fromXaX_propertyXyear_2009X_propertyXacl_publicX();

    public abstract Traversal<Vertex, Edge> get_g_addV_asXfirstX_repeatXaddEXnextX_toXaddVX_inVX_timesX5X_addEXnextX_toXselectXfirstXX();

    public abstract Traversal<Vertex, Edge> get_g_withSideEffectXb_bX_VXaX_addEXknowsX_toXbX_propertyXweight_0_5X(Vertex var1, Vertex var2);

    public abstract Traversal<Vertex, Edge> get_g_VXaX_addEXknowsX_toXbX_propertyXweight_0_1X(Vertex var1, Vertex var2);

    public abstract Traversal<Edge, Edge> get_g_addEXknowsX_fromXaX_toXbX_propertyXweight_0_1X(Vertex var1, Vertex var2);

    public abstract Traversal<Vertex, Edge> get_g_V_hasXname_markoX_asXaX_outEXcreatedX_asXbX_inV_addEXselectXbX_labelX_toXaX();

    public abstract Traversal<Edge, Edge> get_g_addEXV_outE_label_groupCount_orderXlocalX_byXvalues_descX_selectXkeysX_unfold_limitX1XX_fromXV_hasXname_vadasXX_toXV_hasXname_lopXX();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void g_VX1X_asXaX_outXcreatedX_addEXcreatedByX_toXaX() {
        Traversal<Vertex, Edge> traversal = this.get_g_VX1X_asXaX_outXcreatedX_addEXcreatedByX_toXaX(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        int count = 0;
        while (traversal.hasNext()) {
            Edge edge = (Edge)traversal.next();
            Assert.assertEquals((Object)"createdBy", (Object)edge.label());
            Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)edge.properties(new String[0])));
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
        Assert.assertEquals((long)7L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[0])));
        Assert.assertEquals((long)6L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[0])));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void g_VX1X_asXaX_outXcreatedX_addEXcreatedByX_toXaX_propertyXweight_2X() {
        Traversal<Vertex, Edge> traversal = this.get_g_VX1X_asXaX_outXcreatedX_addEXcreatedByX_toXaX_propertyXweight_2X(this.convertToVertexId("marko"));
        this.printTraversalForm(traversal);
        int count = 0;
        while (traversal.hasNext()) {
            Edge edge = (Edge)traversal.next();
            Assert.assertEquals((Object)"createdBy", (Object)edge.label());
            Assert.assertEquals((double)2.0, (double)((Double)this.g.E(new Object[]{edge}).values(new String[]{"weight"}).next()), (double)1.0E-5);
            Assert.assertEquals((long)1L, (long)((Long)this.g.E(new Object[]{edge}).properties(new String[0]).count().next()).intValue());
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
        Assert.assertEquals((long)7L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[0])));
        Assert.assertEquals((long)6L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[0])));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void g_V_aggregateXxX_asXaX_selectXxX_unfold_addEXexistsWithX_toXaX_propertyXtime_nowX() {
        Traversal<Vertex, Edge> traversal = this.get_g_V_aggregateXxX_asXaX_selectXxX_unfold_addEXexistsWithX_toXaX_propertyXtime_nowX();
        this.printTraversalForm(traversal);
        int count = 0;
        while (traversal.hasNext()) {
            Edge edge = (Edge)traversal.next();
            Assert.assertEquals((Object)"existsWith", (Object)edge.label());
            Assert.assertEquals((Object)"now", (Object)this.g.E(new Object[]{edge}).values(new String[]{"time"}).next());
            Assert.assertEquals((long)1L, (long)((Long)this.g.E(new Object[]{edge}).properties(new String[0]).count().next()).intValue());
            ++count;
        }
        Assert.assertEquals((long)36L, (long)count);
        Assert.assertEquals((long)42L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[0])));
        for (Vertex vertex : IteratorUtils.list((Iterator)this.g.V(new Object[0]))) {
            Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[]{vertex}).out(new String[]{"existsWith"}).count().next()).intValue());
            Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[]{vertex}).in(new String[]{"existsWith"}).count().next()).intValue());
        }
        Assert.assertEquals((long)6L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[0])));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void g_V_asXaX_outXcreatedX_inXcreatedX_whereXneqXaXX_asXbX_addEXcodeveloperX_fromXaX_toXbX_propertyXyear_2009X() {
        Traversal<Vertex, Edge> traversal = this.get_g_V_asXaX_outXcreatedX_inXcreatedX_whereXneqXaXX_asXbX_addEXcodeveloperX_fromXaX_toXbX_propertyXyear_2009X();
        this.printTraversalForm(traversal);
        int count = 0;
        while (traversal.hasNext()) {
            Edge edge = (Edge)traversal.next();
            Assert.assertEquals((Object)"codeveloper", (Object)edge.label());
            Assert.assertEquals((Object)2009, (Object)this.g.E(new Object[]{edge}).values(new String[]{"year"}).next());
            Assert.assertEquals((long)1L, (long)((Long)this.g.E(new Object[]{edge}).properties(new String[0]).count().next()).intValue());
            Assert.assertEquals((Object)"person", (Object)this.g.E(new Object[]{edge}).inV().label().next());
            Assert.assertEquals((Object)"person", (Object)this.g.E(new Object[]{edge}).outV().label().next());
            Assert.assertFalse((boolean)this.g.E(new Object[]{edge}).inV().values(new String[]{"name"}).next().equals("vadas"));
            Assert.assertFalse((boolean)this.g.E(new Object[]{edge}).outV().values(new String[]{"name"}).next().equals("vadas"));
            Assert.assertFalse((boolean)((Vertex)this.g.E(new Object[]{edge}).inV().next()).equals(this.g.E(new Object[]{edge}).outV().next()));
            ++count;
        }
        Assert.assertEquals((long)6L, (long)count);
        Assert.assertEquals((long)12L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[0])));
        Assert.assertEquals((long)6L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[0])));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void g_withSideEffectXb_bX_VXaX_addEXknowsX_toXbX_propertyXweight_0_5X() {
        Vertex a = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Vertex b = (Vertex)this.g.V(new Object[0]).has("name", (Object)"peter").next();
        Traversal<Vertex, Edge> traversal = this.get_g_withSideEffectXb_bX_VXaX_addEXknowsX_toXbX_propertyXweight_0_5X(a, b);
        Edge edge = (Edge)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((Object)edge.outVertex(), (Object)this.convertToVertex(this.graph, "marko"));
        Assert.assertEquals((Object)edge.inVertex(), (Object)this.convertToVertex(this.graph, "peter"));
        Assert.assertEquals((Object)"knows", (Object)edge.label());
        Assert.assertEquals((long)1L, (long)((Long)this.g.E(new Object[]{edge}).properties(new String[0]).count().next()).intValue());
        Assert.assertEquals((double)0.5, (double)((Double)this.g.E(new Object[]{edge}).values(new String[]{"weight"}).next()), (double)0.1);
        Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[0]).count().next()));
        Assert.assertEquals((long)7L, (long)((Long)this.g.E(new Object[0]).count().next()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void g_V_asXaX_inXcreatedX_addEXcreatedByX_fromXaX_propertyXyear_2009X_propertyXacl_publicX() {
        Traversal<Vertex, Edge> traversal = this.get_g_V_asXaX_inXcreatedX_addEXcreatedByX_fromXaX_propertyXyear_2009X_propertyXacl_publicX();
        this.printTraversalForm(traversal);
        int count = 0;
        while (traversal.hasNext()) {
            Edge edge = (Edge)traversal.next();
            Assert.assertEquals((Object)"createdBy", (Object)edge.label());
            Assert.assertEquals((Object)2009, (Object)this.g.E(new Object[]{edge}).values(new String[]{"year"}).next());
            Assert.assertEquals((Object)"public", (Object)this.g.E(new Object[]{edge}).values(new String[]{"acl"}).next());
            Assert.assertEquals((long)2L, (long)((Long)this.g.E(new Object[]{edge}).properties(new String[0]).count().next()).intValue());
            Assert.assertEquals((Object)"person", (Object)this.g.E(new Object[]{edge}).inV().label().next());
            Assert.assertEquals((Object)"software", (Object)this.g.E(new Object[]{edge}).outV().label().next());
            if (this.g.E(new Object[]{edge}).outV().values(new String[]{"name"}).next().equals("ripple")) {
                Assert.assertEquals((Object)"josh", (Object)this.g.E(new Object[]{edge}).inV().values(new String[]{"name"}).next());
            }
            ++count;
        }
        Assert.assertEquals((long)4L, (long)count);
        Assert.assertEquals((long)10L, (long)IteratorUtils.count((Iterator)this.g.E(new Object[0])));
        Assert.assertEquals((long)6L, (long)IteratorUtils.count((Iterator)this.g.V(new Object[0])));
    }

    @Test
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void g_addV_asXfirstX_repeatXaddEXnextX_toXaddVX_inVX_timesX5X_addEXnextX_toXselectXfirstXX() {
        Traversal<Vertex, Edge> traversal = this.get_g_addV_asXfirstX_repeatXaddEXnextX_toXaddVX_inVX_timesX5X_addEXnextX_toXselectXfirstXX();
        this.printTraversalForm(traversal);
        Assert.assertEquals((Object)"next", (Object)((Edge)traversal.next()).label());
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[0]).count().next()));
        Assert.assertEquals((long)6L, (long)((Long)this.g.E(new Object[0]).count().next()));
        Assert.assertEquals(Arrays.asList(2L, 2L, 2L, 2L, 2L, 2L), (Object)this.g.V(new Object[0]).map((Traversal)__.bothE((String[])new String[0]).count()).toList());
        Assert.assertEquals(Arrays.asList(1L, 1L, 1L, 1L, 1L, 1L), (Object)this.g.V(new Object[0]).map((Traversal)__.inE((String[])new String[0]).count()).toList());
        Assert.assertEquals(Arrays.asList(1L, 1L, 1L, 1L, 1L, 1L), (Object)this.g.V(new Object[0]).map((Traversal)__.outE((String[])new String[0]).count()).toList());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void g_VXaX_addEXknowsX_toXbX_propertyXweight_0_1X() {
        Vertex a = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Vertex b = (Vertex)this.g.V(new Object[0]).has("name", (Object)"peter").next();
        Traversal<Vertex, Edge> traversal = this.get_g_VXaX_addEXknowsX_toXbX_propertyXweight_0_1X(a, b);
        this.printTraversalForm(traversal);
        Edge edge = (Edge)traversal.next();
        Assert.assertEquals((Object)edge.outVertex(), (Object)this.convertToVertex(this.graph, "marko"));
        Assert.assertEquals((Object)edge.inVertex(), (Object)this.convertToVertex(this.graph, "peter"));
        Assert.assertEquals((Object)"knows", (Object)edge.label());
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)edge.properties(new String[0])));
        Assert.assertEquals((double)0.1, (double)((Double)edge.value("weight")), (double)0.1);
        Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[0]).count().next()));
        Assert.assertEquals((long)7L, (long)((Long)this.g.E(new Object[0]).count().next()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void g_addEXknowsX_fromXaX_toXbX_propertyXweight_0_1X() {
        Vertex a = (Vertex)this.g.V(new Object[0]).has("name", (Object)"marko").next();
        Vertex b = (Vertex)this.g.V(new Object[0]).has("name", (Object)"peter").next();
        Traversal<Edge, Edge> traversal = this.get_g_addEXknowsX_fromXaX_toXbX_propertyXweight_0_1X(a, b);
        this.printTraversalForm(traversal);
        Edge edge = (Edge)traversal.next();
        Assert.assertEquals((Object)edge.outVertex(), (Object)this.convertToVertex(this.graph, "marko"));
        Assert.assertEquals((Object)edge.inVertex(), (Object)this.convertToVertex(this.graph, "peter"));
        Assert.assertEquals((Object)"knows", (Object)edge.label());
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)edge.properties(new String[0])));
        Assert.assertEquals((double)0.1, (double)((Double)edge.value("weight")), (double)0.1);
        Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[0]).count().next()));
        Assert.assertEquals((long)7L, (long)((Long)this.g.E(new Object[0]).count().next()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void g_V_hasXname_markoX_asXaX_outEXcreatedX_asXbX_inV_addEXselectXbX_labelX_toXaX() {
        Traversal<Vertex, Edge> traversal = this.get_g_V_hasXname_markoX_asXaX_outEXcreatedX_asXbX_inV_addEXselectXbX_labelX_toXaX();
        this.printTraversalForm(traversal);
        Edge edge = (Edge)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((Object)"created", (Object)edge.label());
        Assert.assertEquals((Object)this.convertToVertexId("marko"), (Object)edge.inVertex().id());
        Assert.assertEquals((Object)this.convertToVertexId("lop"), (Object)edge.outVertex().id());
        Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[0]).count().next()));
        Assert.assertEquals((long)7L, (long)((Long)this.g.E(new Object[0]).count().next()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges")
    public void g_addEXV_outE_label_groupCount_orderXlocalX_byXvalues_descX_selectXkeysX_unfold_limitX1XX_fromXV_hasXname_vadasXX_toXV_hasXname_lopXX() {
        Traversal<Edge, Edge> traversal = this.get_g_addEXV_outE_label_groupCount_orderXlocalX_byXvalues_descX_selectXkeysX_unfold_limitX1XX_fromXV_hasXname_vadasXX_toXV_hasXname_lopXX();
        this.printTraversalForm(traversal);
        Edge edge = (Edge)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        Assert.assertEquals((Object)"created", (Object)edge.label());
        Assert.assertEquals((Object)this.convertToVertexId("vadas"), (Object)edge.outVertex().id());
        Assert.assertEquals((Object)this.convertToVertexId("lop"), (Object)edge.inVertex().id());
        Assert.assertEquals((long)6L, (long)((Long)this.g.V(new Object[0]).count().next()));
        Assert.assertEquals((long)7L, (long)((Long)this.g.E(new Object[0]).count().next()));
    }

    public static class Traversals
    extends AddEdgeTest {
        @Override
        public Traversal<Vertex, Edge> get_g_VX1X_asXaX_outXcreatedX_addEXcreatedByX_toXaX(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).as("a", new String[0]).out(new String[]{"created"}).addE("createdBy").to("a");
        }

        @Override
        public Traversal<Vertex, Edge> get_g_VX1X_asXaX_outXcreatedX_addEXcreatedByX_toXaX_propertyXweight_2X(Object v1Id) {
            return this.g.V(new Object[]{v1Id}).as("a", new String[0]).out(new String[]{"created"}).addE("createdBy").to("a").property((Object)"weight", (Object)2.0, new Object[0]);
        }

        @Override
        public Traversal<Vertex, Edge> get_g_V_aggregateXxX_asXaX_selectXxX_unfold_addEXexistsWithX_toXaX_propertyXtime_nowX() {
            return this.g.V(new Object[0]).aggregate("x").as("a", new String[0]).select("x").unfold().addE("existsWith").to("a").property((Object)"time", (Object)"now", new Object[0]);
        }

        @Override
        public Traversal<Vertex, Edge> get_g_V_asXaX_outXcreatedX_inXcreatedX_whereXneqXaXX_asXbX_addEXcodeveloperX_fromXaX_toXbX_propertyXyear_2009X() {
            return this.g.V(new Object[0]).as("a", new String[0]).out(new String[]{"created"}).in(new String[]{"created"}).where(P.neq((Object)"a")).as("b", new String[0]).addE("codeveloper").from("a").to("b").property((Object)"year", (Object)2009, new Object[0]);
        }

        @Override
        public Traversal<Vertex, Edge> get_g_V_asXaX_inXcreatedX_addEXcreatedByX_fromXaX_propertyXyear_2009X_propertyXacl_publicX() {
            return this.g.V(new Object[0]).as("a", new String[0]).in(new String[]{"created"}).addE("createdBy").from("a").property((Object)"year", (Object)2009, new Object[0]).property((Object)"acl", (Object)"public", new Object[0]);
        }

        @Override
        public Traversal<Vertex, Edge> get_g_withSideEffectXb_bX_VXaX_addEXknowsX_toXbX_propertyXweight_0_5X(Vertex a, Vertex b) {
            return this.g.withSideEffect("b", (Object)b).V(new Object[]{a}).addE("knows").to("b").property((Object)"weight", (Object)0.5, new Object[0]);
        }

        @Override
        public Traversal<Vertex, Edge> get_g_addV_asXfirstX_repeatXaddEXnextX_toXaddVX_inVX_timesX5X_addEXnextX_toXselectXfirstXX() {
            return this.g.addV().as("first", new String[0]).repeat((Traversal)__.addE((String)"next").to((Traversal)__.addV()).inV()).times(5).addE("next").to((Traversal)__.select((String)"first"));
        }

        @Override
        public Traversal<Vertex, Edge> get_g_VXaX_addEXknowsX_toXbX_propertyXweight_0_1X(Vertex a, Vertex b) {
            return this.g.V(new Object[]{a}).addE("knows").to(b).property((Object)"weight", (Object)0.1, new Object[0]);
        }

        @Override
        public Traversal<Edge, Edge> get_g_addEXknowsX_fromXaX_toXbX_propertyXweight_0_1X(Vertex a, Vertex b) {
            return this.g.addE("knows").from(a).to(b).property((Object)"weight", (Object)0.1, new Object[0]);
        }

        @Override
        public Traversal<Vertex, Edge> get_g_V_hasXname_markoX_asXaX_outEXcreatedX_asXbX_inV_addEXselectXbX_labelX_toXaX() {
            return this.g.V(new Object[0]).has("name", (Object)"marko").as("a", new String[0]).outE(new String[]{"created"}).as("b", new String[0]).inV().addE((Traversal)__.select((String)"b").label()).to("a");
        }

        @Override
        public Traversal<Edge, Edge> get_g_addEXV_outE_label_groupCount_orderXlocalX_byXvalues_descX_selectXkeysX_unfold_limitX1XX_fromXV_hasXname_vadasXX_toXV_hasXname_lopXX() {
            return this.g.addE((Traversal)__.V((Object[])new Object[0]).outE(new String[0]).label().groupCount().order(Scope.local).by((Function)Column.values, (Comparator)Order.desc).select(Column.keys).unfold().limit(1L)).from((Traversal)__.V((Object[])new Object[0]).has("name", (Object)"vadas")).to((Traversal)__.V((Object[])new Object[0]).has("name", (Object)"lop"));
        }
    }
}

