/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.sideEffect;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.GremlinProcessRunner;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.BulkSet;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.MapHelper;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=GremlinProcessRunner.class)
public abstract class AggregateTest
extends AbstractGremlinProcessTest {
    public abstract Traversal<Vertex, List<String>> get_g_V_name_aggregateXxX_capXxX();

    public abstract Traversal<Vertex, List<String>> get_g_V_aggregateXxX_byXnameX_capXxX();

    public abstract Traversal<Vertex, Path> get_g_V_out_aggregateXaX_path();

    public abstract Traversal<Vertex, Collection<Integer>> get_g_V_hasLabelXpersonX_aggregateXxX_byXageX_capXxX_asXyX_selectXyX();

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_valueXnameX_aggregateXxX_capXxX() {
        Traversal<Vertex, List<String>> traversal = this.get_g_V_name_aggregateXxX_capXxX();
        this.printTraversalForm(traversal);
        Collection names = (Collection)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        this.checkListOfNames(names);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_aggregateXxX_byXnameX_capXxX() {
        Traversal<Vertex, List<String>> traversal = this.get_g_V_aggregateXxX_byXnameX_capXxX();
        this.printTraversalForm(traversal);
        Collection names = (Collection)traversal.next();
        Assert.assertFalse((boolean)traversal.hasNext());
        this.checkListOfNames(names);
    }

    private void checkListOfNames(Collection<String> names) {
        Assert.assertEquals((long)6L, (long)names.size());
        Assert.assertTrue((boolean)names.contains("marko"));
        Assert.assertTrue((boolean)names.contains("josh"));
        Assert.assertTrue((boolean)names.contains("peter"));
        Assert.assertTrue((boolean)names.contains("lop"));
        Assert.assertTrue((boolean)names.contains("vadas"));
        Assert.assertTrue((boolean)names.contains("ripple"));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_out_aggregateXaX_path() {
        Traversal<Vertex, Path> traversal = this.get_g_V_out_aggregateXaX_path();
        this.printTraversalForm(traversal);
        int count = 0;
        HashMap firstStepCounts = new HashMap();
        HashMap secondStepCounts = new HashMap();
        while (traversal.hasNext()) {
            ++count;
            Path path = (Path)traversal.next();
            String first = path.get(0).toString();
            String second = path.get(1).toString();
            Assert.assertThat((Object)first, (Matcher)CoreMatchers.not((Object)second));
            MapHelper.incr(firstStepCounts, (Object)first, (Long)1L);
            MapHelper.incr(secondStepCounts, (Object)second, (Long)1L);
        }
        Assert.assertEquals((long)6L, (long)count);
        Assert.assertEquals((long)3L, (long)firstStepCounts.size());
        Assert.assertEquals((long)4L, (long)secondStepCounts.size());
        Assert.assertTrue((boolean)firstStepCounts.values().contains(3L));
        Assert.assertTrue((boolean)firstStepCounts.values().contains(2L));
        Assert.assertTrue((boolean)firstStepCounts.values().contains(1L));
        Assert.assertTrue((boolean)secondStepCounts.values().contains(3L));
        Assert.assertTrue((boolean)secondStepCounts.values().contains(1L));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void g_V_hasLabelXpersonX_aggregateXxX_byXageX_capXxX_asXyX_selectXyX() {
        Traversal<Vertex, Collection<Integer>> traversal = this.get_g_V_hasLabelXpersonX_aggregateXxX_byXageX_capXxX_asXyX_selectXyX();
        Collection ages = (Collection)traversal.next();
        Assert.assertTrue((boolean)(ages instanceof BulkSet));
        Assert.assertEquals((long)4L, (long)ages.size());
        Assert.assertTrue((boolean)ages.contains(29));
        Assert.assertTrue((boolean)ages.contains(27));
        Assert.assertTrue((boolean)ages.contains(32));
        Assert.assertTrue((boolean)ages.contains(35));
        BulkSet bulkSet = new BulkSet();
        bulkSet.add((Object)29);
        bulkSet.add((Object)27);
        bulkSet.add((Object)32);
        bulkSet.add((Object)35);
        Assert.assertEquals((Object)bulkSet, (Object)ages);
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    public static class Traversals
    extends AggregateTest {
        @Override
        public Traversal<Vertex, List<String>> get_g_V_name_aggregateXxX_capXxX() {
            return this.g.V(new Object[0]).values(new String[]{"name"}).aggregate("x").cap("x", new String[0]);
        }

        @Override
        public Traversal<Vertex, List<String>> get_g_V_aggregateXxX_byXnameX_capXxX() {
            return this.g.V(new Object[0]).aggregate("x").by("name").cap("x", new String[0]);
        }

        @Override
        public Traversal<Vertex, Path> get_g_V_out_aggregateXaX_path() {
            return this.g.V(new Object[0]).out(new String[0]).aggregate("a").path();
        }

        @Override
        public Traversal<Vertex, Collection<Integer>> get_g_V_hasLabelXpersonX_aggregateXxX_byXageX_capXxX_asXyX_selectXyX() {
            return this.g.V(new Object[0]).hasLabel("person", new String[0]).aggregate("x").by("age").cap("x", new String[0]).as("y", new String[0]).select("y");
        }
    }
}

