/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.TestHelper;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.io.GraphMigrator;
import org.apache.tinkerpop.gremlin.structure.io.GraphReader;
import org.apache.tinkerpop.gremlin.structure.io.GraphWriter;
import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.apache.tinkerpop.gremlin.structure.io.IoCore;
import org.apache.tinkerpop.gremlin.structure.io.IoTest;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONVersion;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNot;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class IoGraphTest
extends AbstractGremlinTest {
    @Parameterized.Parameter(value=0)
    public String ioType;
    @Parameterized.Parameter(value=1)
    public Io.Builder ioBuilderToTest;
    @Parameterized.Parameter(value=2)
    public boolean assertDouble;
    @Parameterized.Parameter(value=3)
    public boolean lossyForId;
    @Parameterized.Parameter(value=4)
    public String fileExtension;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({"graphml", IoCore.graphml(), false, true, ".xml"}, {"graphsonv1d0", IoCore.graphson(), true, true, ".json"}, {"graphsonv2d0", GraphSONIo.build((GraphSONVersion)GraphSONVersion.V2_0), true, true, ".json"}, {"graphsonv3d0", GraphSONIo.build((GraphSONVersion)GraphSONVersion.V3_0), true, true, ".json"}, {"gryo", IoCore.gryo(), false, false, ".kryo"});
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CLASSIC)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldReadWriteClassic() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphWriter writer = this.graph.io(this.ioBuilderToTest).writer().create();
            writer.writeGraph((OutputStream)os, this.graph);
            Configuration configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), LoadGraphWith.GraphData.CLASSIC);
            this.graphProvider.clear(configuration);
            Graph g1 = this.graphProvider.openTestGraph(configuration);
            GraphReader reader = this.graph.io(this.ioBuilderToTest).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readGraph((InputStream)bais, g1);
            }
            IoTest.assertClassicGraph(g1, this.assertDouble, this.lossyForId);
            this.graphProvider.clear(g1, configuration);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CLASSIC)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldReadWriteClassicToFileWithHelpers() throws Exception {
        File f = TestHelper.generateTempFile(this.graph.getClass(), this.name.getMethodName(), this.fileExtension);
        try {
            this.graph.io(this.ioBuilderToTest).writeGraph(f.getAbsolutePath());
            Configuration configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), LoadGraphWith.GraphData.CLASSIC);
            Graph g1 = this.graphProvider.openTestGraph(configuration);
            g1.io(this.ioBuilderToTest).readGraph(f.getAbsolutePath());
            IoTest.assertClassicGraph(g1, this.assertDouble, this.lossyForId);
            this.graphProvider.clear(g1, configuration);
        }
        catch (Exception ex) {
            f.delete();
            throw ex;
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CLASSIC)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldMigrateClassicGraph() throws Exception {
        Configuration configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), LoadGraphWith.GraphData.CLASSIC);
        this.graphProvider.clear(configuration);
        Graph g1 = this.graphProvider.openTestGraph(configuration);
        GraphReader reader = this.graph.io(this.ioBuilderToTest).reader().create();
        GraphWriter writer = this.graph.io(this.ioBuilderToTest).writer().create();
        GraphMigrator.migrateGraph((Graph)this.graph, (Graph)g1, (GraphReader)reader, (GraphWriter)writer);
        IoTest.assertClassicGraph(g1, this.assertDouble, this.lossyForId);
        this.graphProvider.clear(g1, configuration);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldReadWriteModern() throws Exception {
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphWriter writer = this.graph.io(this.ioBuilderToTest).writer().create();
            writer.writeGraph((OutputStream)os, this.graph);
            Configuration configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), LoadGraphWith.GraphData.MODERN);
            this.graphProvider.clear(configuration);
            Graph g1 = this.graphProvider.openTestGraph(configuration);
            GraphReader reader = this.graph.io(this.ioBuilderToTest).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readGraph((InputStream)bais, g1);
            }
            IoTest.assertModernGraph(g1, true, this.lossyForId);
            this.graphProvider.clear(g1, configuration);
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldReadWriteModernToFileWithHelpers() throws Exception {
        File f = TestHelper.generateTempFile(this.graph.getClass(), this.name.getMethodName(), this.fileExtension);
        try {
            this.graph.io(this.ioBuilderToTest).writeGraph(f.getAbsolutePath());
            Configuration configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), LoadGraphWith.GraphData.MODERN);
            Graph g1 = this.graphProvider.openTestGraph(configuration);
            g1.io(this.ioBuilderToTest).readGraph(f.getAbsolutePath());
            IoTest.assertModernGraph(g1, true, this.lossyForId);
            this.graphProvider.clear(g1, configuration);
        }
        catch (Exception ex) {
            f.delete();
            throw ex;
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldMigrateModernGraph() throws Exception {
        Configuration configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), LoadGraphWith.GraphData.MODERN);
        this.graphProvider.clear(configuration);
        Graph g1 = this.graphProvider.openTestGraph(configuration);
        GraphReader reader = this.graph.io(this.ioBuilderToTest).reader().create();
        GraphWriter writer = this.graph.io(this.ioBuilderToTest).writer().create();
        GraphMigrator.migrateGraph((Graph)this.graph, (Graph)g1, (GraphReader)reader, (GraphWriter)writer);
        IoTest.assertModernGraph(g1, true, this.lossyForId);
        this.graphProvider.clear(g1, configuration);
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.CREW)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.EdgeFeatures.class, feature="AddEdges"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="AddVertices")})
    public void shouldReadWriteCrew() throws Exception {
        Assume.assumeThat((String)"GraphML does not support multi/metaproperties", (Object)this.ioType, (Matcher)IsNot.not((Object)"graphml"));
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            GraphWriter writer = this.graph.io(this.ioBuilderToTest).writer().create();
            writer.writeGraph((OutputStream)os, this.graph);
            Configuration configuration = this.graphProvider.newGraphConfiguration("readGraph", this.getClass(), this.name.getMethodName(), LoadGraphWith.GraphData.CREW);
            this.graphProvider.clear(configuration);
            Graph g1 = this.graphProvider.openTestGraph(configuration);
            GraphReader reader = this.graph.io(this.ioBuilderToTest).reader().create();
            try (ByteArrayInputStream bais = new ByteArrayInputStream(os.toByteArray());){
                reader.readGraph((InputStream)bais, g1);
            }
            IoTest.assertCrewGraph(g1, this.lossyForId);
            this.graphProvider.clear(g1, configuration);
        }
    }
}

