/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.computer.bulkloading;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.function.Function;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.TestHelper;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.IgnoreEngine;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.bulkloading.BulkLoader;
import org.apache.tinkerpop.gremlin.process.computer.bulkloading.BulkLoaderVertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.bulkloading.IncrementalBulkLoader;
import org.apache.tinkerpop.gremlin.process.computer.bulkloading.OneTimeBulkLoader;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class BulkLoaderVertexProgramTest
extends AbstractGremlinProcessTest {
    static final String TINKERGRAPH_LOCATION = TestHelper.makeTestDataDirectory(BulkLoaderVertexProgramTest.class, new String[0]) + "tinkertest.kryo";

    private BulkLoader getBulkLoader(BulkLoaderVertexProgram blvp) throws Exception {
        Field field = BulkLoaderVertexProgram.class.getDeclaredField("bulkLoader");
        field.setAccessible(true);
        return (BulkLoader)field.get(blvp);
    }

    private Configuration getWriteGraphConfiguration() {
        BaseConfiguration configuration = new BaseConfiguration();
        configuration.setProperty("gremlin.graph", (Object)"org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerGraph");
        configuration.setProperty("gremlin.tinkergraph.graphLocation", (Object)TINKERGRAPH_LOCATION);
        configuration.setProperty("gremlin.tinkergraph.graphFormat", (Object)"gryo");
        return configuration;
    }

    private Graph getWriteGraph() {
        return GraphFactory.open((Configuration)this.getWriteGraphConfiguration());
    }

    @After
    public void cleanup() {
        File graph = new File(TINKERGRAPH_LOCATION);
        Assert.assertTrue((!graph.exists() || graph.delete() ? 1 : 0) != 0);
    }

    @Test
    public void shouldUseIncrementalBulkLoaderByDefault() throws Exception {
        BulkLoader loader = this.getBulkLoader(BulkLoaderVertexProgram.build().create(this.graph));
        Assert.assertTrue((boolean)(loader instanceof IncrementalBulkLoader));
        Assert.assertTrue((boolean)loader.keepOriginalIds());
        Assert.assertFalse((boolean)loader.useUserSuppliedIds());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldStoreOriginalIds() throws Exception {
        BulkLoaderVertexProgram blvp = BulkLoaderVertexProgram.build().userSuppliedIds(false).writeGraph(this.getWriteGraphConfiguration()).create(this.graph);
        BulkLoader loader = this.getBulkLoader(blvp);
        Assert.assertFalse((boolean)loader.useUserSuppliedIds());
        this.graph.compute((Class)this.graphComputerClass.get()).workers(1).program((VertexProgram)blvp).submit().get();
        BulkLoaderVertexProgramTest.assertGraphEquality(this.graph, this.getWriteGraph(), v -> v.value(loader.getVertexIdProperty()));
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldNotStoreOriginalIds() throws Exception {
        BulkLoaderVertexProgram blvp = BulkLoaderVertexProgram.build().userSuppliedIds(true).writeGraph(this.getWriteGraphConfiguration()).create(this.graph);
        BulkLoader loader = this.getBulkLoader(blvp);
        Assert.assertTrue((boolean)loader.useUserSuppliedIds());
        this.graph.compute((Class)this.graphComputerClass.get()).workers(1).program((VertexProgram)blvp).submit().get();
        BulkLoaderVertexProgramTest.assertGraphEquality(this.graph, this.getWriteGraph());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldOverwriteExistingElements() throws Exception {
        BulkLoaderVertexProgram blvp = BulkLoaderVertexProgram.build().userSuppliedIds(true).writeGraph(this.getWriteGraphConfiguration()).create(this.graph);
        this.graph.compute((Class)this.graphComputerClass.get()).workers(1).program((VertexProgram)blvp).submit().get();
        this.graph.compute((Class)this.graphComputerClass.get()).workers(1).program((VertexProgram)blvp).submit().get();
        BulkLoaderVertexProgramTest.assertGraphEquality(this.graph, this.getWriteGraph());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    @IgnoreEngine(value=TraversalEngine.Type.COMPUTER)
    public void shouldProperlyHandleMetaProperties() throws Exception {
        this.graph.traversal().V(new Object[0]).has("name", (Object)"marko").properties(new String[]{"name"}).property((Object)"alias", (Object)"okram", new Object[0]).iterate();
        BulkLoaderVertexProgram blvp = BulkLoaderVertexProgram.build().userSuppliedIds(true).writeGraph(this.getWriteGraphConfiguration()).create(this.graph);
        this.graph.compute((Class)this.graphComputerClass.get()).workers(1).program((VertexProgram)blvp).submit().get();
        BulkLoaderVertexProgramTest.assertGraphEquality(this.graph, this.getWriteGraph());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldUseOneTimeBulkLoader() throws Exception {
        for (int iteration = 1; iteration <= 2; ++iteration) {
            BulkLoaderVertexProgram blvp = BulkLoaderVertexProgram.build().bulkLoader(OneTimeBulkLoader.class).writeGraph(this.getWriteGraphConfiguration()).create(this.graph);
            BulkLoader loader = this.getBulkLoader(blvp);
            Assert.assertTrue((boolean)(loader instanceof OneTimeBulkLoader));
            this.graph.compute((Class)this.graphComputerClass.get()).workers(1).program((VertexProgram)blvp).submit().get();
            Graph result = this.getWriteGraph();
            Assert.assertEquals((long)(6 * iteration), (long)IteratorUtils.count((Iterator)result.vertices(new Object[0])));
            Assert.assertEquals((long)(6 * iteration), (long)IteratorUtils.count((Iterator)result.edges(new Object[0])));
            result.close();
        }
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldUseOneTimeBulkLoaderWithUserSuppliedIds() throws Exception {
        BulkLoaderVertexProgram blvp = BulkLoaderVertexProgram.build().bulkLoader(OneTimeBulkLoader.class).userSuppliedIds(true).writeGraph(this.getWriteGraphConfiguration()).create(this.graph);
        BulkLoader loader = this.getBulkLoader(blvp);
        Assert.assertTrue((boolean)(loader instanceof OneTimeBulkLoader));
        this.graph.compute((Class)this.graphComputerClass.get()).workers(1).program((VertexProgram)blvp).submit().get();
        Graph result = this.getWriteGraph();
        Assert.assertEquals((long)6L, (long)IteratorUtils.count((Iterator)result.vertices(new Object[0])));
        Assert.assertEquals((long)6L, (long)IteratorUtils.count((Iterator)result.edges(new Object[0])));
        result.close();
    }

    private static void assertGraphEquality(Graph source, Graph target) {
        BulkLoaderVertexProgramTest.assertGraphEquality(source, target, Element::id);
    }

    private static void assertGraphEquality(Graph source, Graph target, Function<Vertex, Object> idAccessor) {
        GraphTraversalSource tg = target.traversal();
        Assert.assertEquals((long)IteratorUtils.count((Iterator)source.vertices(new Object[0])), (long)IteratorUtils.count((Iterator)target.vertices(new Object[0])));
        Assert.assertEquals((long)IteratorUtils.count((Iterator)target.edges(new Object[0])), (long)IteratorUtils.count((Iterator)target.edges(new Object[0])));
        source.vertices(new Object[0]).forEachRemaining(originalVertex -> {
            Vertex tmpVertex = null;
            Iterator vertexIterator = target.vertices(new Object[0]);
            while (vertexIterator.hasNext()) {
                Vertex v = (Vertex)vertexIterator.next();
                if (!idAccessor.apply(v).toString().equals(originalVertex.id().toString())) continue;
                tmpVertex = v;
                break;
            }
            Assert.assertNotNull(tmpVertex);
            Vertex clonedVertex = tmpVertex;
            Assert.assertEquals((long)IteratorUtils.count((Iterator)originalVertex.edges(Direction.IN, new String[0])), (long)IteratorUtils.count((Iterator)clonedVertex.edges(Direction.IN, new String[0])));
            Assert.assertEquals((long)IteratorUtils.count((Iterator)originalVertex.edges(Direction.OUT, new String[0])), (long)IteratorUtils.count((Iterator)clonedVertex.edges(Direction.OUT, new String[0])));
            Assert.assertEquals((Object)originalVertex.label(), (Object)clonedVertex.label());
            originalVertex.properties(new String[0]).forEachRemaining(originalProperty -> {
                VertexProperty clonedProperty = null;
                Iterator vertexPropertyIterator = clonedVertex.properties(new String[]{originalProperty.key()});
                while (vertexPropertyIterator.hasNext()) {
                    VertexProperty p = (VertexProperty)vertexPropertyIterator.next();
                    if (!p.value().equals(originalProperty.value())) continue;
                    clonedProperty = p;
                    break;
                }
                Assert.assertNotNull(clonedProperty);
                Assert.assertEquals((Object)originalProperty.isPresent(), (Object)clonedProperty.isPresent());
                Assert.assertEquals((Object)originalProperty.value(), (Object)clonedProperty.value());
            });
            originalVertex.edges(Direction.OUT, new String[0]).forEachRemaining(originalEdge -> {
                GraphTraversal t = tg.V(new Object[]{clonedVertex}).outE(new String[]{originalEdge.label()});
                originalEdge.properties(new String[0]).forEachRemaining(p -> t.has(p.key(), p.value()));
                Assert.assertTrue((boolean)t.hasNext());
            });
        });
    }
}

