/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.FeatureRequirements;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.PartitionStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class PartitionStrategyProcessTest
extends AbstractGremlinProcessTest {
    private static final String partition = "gremlin.partitionGraphStrategy.partition";

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldAppendPartitionToVertex() {
        PartitionStrategy partitionStrategy = PartitionStrategy.build().partitionKey(partition).writePartition("A").addReadPartition("A").create();
        Vertex v = (Vertex)this.create(partitionStrategy).addV().property((Object)"any", (Object)"thing", new Object[0]).next();
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"thing", (Object)v.property("any").value());
        Assert.assertEquals((Object)"A", (Object)v.property(partition).value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldAppendPartitionToVertexProperty() {
        PartitionStrategy partitionStrategy = PartitionStrategy.build().includeMetaProperties(true).partitionKey(partition).writePartition("A").addReadPartition("A").create();
        Vertex v = (Vertex)this.create(partitionStrategy).addV().property((Object)"any", (Object)"thing", new Object[0]).next();
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"thing", (Object)v.property("any").value());
        Assert.assertEquals((Object)"A", (Object)v.property(partition).value());
        Assert.assertEquals((Object)"A", (Object)v.property("any").value(partition));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirements(value={@FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties"), @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MultiProperties")})
    public void shouldAppendPartitionToVertexPropertyOverMultiProperty() {
        PartitionStrategy partitionStrategy = PartitionStrategy.build().includeMetaProperties(true).partitionKey(partition).writePartition("A").addReadPartition("A").create();
        Vertex v = (Vertex)this.create(partitionStrategy).addV().property(VertexProperty.Cardinality.list, (Object)"any", (Object)"thing", new Object[0]).property(VertexProperty.Cardinality.list, (Object)"any", (Object)"more", new Object[0]).next();
        Assert.assertNotNull((Object)v);
        Assert.assertThat(IteratorUtils.asList((Object)v.properties(new String[]{"any"})).stream().map(p -> ((VertexProperty)p).value()).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"thing", "more"}));
        Assert.assertEquals((Object)"A", (Object)v.property(partition).value());
        Assert.assertThat(IteratorUtils.asList((Object)v.properties(new String[]{"any"})).stream().map(p -> ((VertexProperty)p).value(partition)).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"A", "A"}));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldNotAppendPartitionToVertexProperty() {
        PartitionStrategy partitionStrategy = PartitionStrategy.build().includeMetaProperties(false).partitionKey(partition).writePartition("A").addReadPartition("A").create();
        Vertex v = (Vertex)this.create(partitionStrategy).addV().property((Object)"any", (Object)"thing", new Object[0]).next();
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"thing", (Object)v.property("any").value());
        Assert.assertEquals((Object)"A", (Object)v.property(partition).value());
        Assert.assertThat((Object)v.property("any").properties(new String[0]).hasNext(), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldAppendPartitionToAllVertexProperties() {
        GraphTraversalSource gOverA = this.create(PartitionStrategy.build().includeMetaProperties(true).partitionKey(partition).writePartition("A").addReadPartition("A").create());
        GraphTraversalSource gOverB = this.create(PartitionStrategy.build().includeMetaProperties(true).partitionKey(partition).writePartition("B").addReadPartition("B").create());
        GraphTraversalSource gOverAB = this.create(PartitionStrategy.build().includeMetaProperties(true).partitionKey(partition).writePartition("B").addReadPartition("B").addReadPartition("A").create());
        Vertex v = (Vertex)gOverA.addV().property((Object)"any", (Object)"thing", new Object[0]).property((Object)"some", (Object)"thing", new Object[0]).next();
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"thing", (Object)v.property("any").value());
        Assert.assertEquals((Object)"A", (Object)v.property(partition).value());
        Assert.assertEquals((Object)"A", (Object)v.property("any").value(partition));
        Assert.assertEquals((Object)"thing", (Object)v.property("some").value());
        Assert.assertEquals((Object)"A", (Object)v.property("some").value(partition));
        gOverAB.V(new Object[]{v}).property((Object)"that", (Object)"thing", new Object[0]).iterate();
        Assert.assertEquals((Object)"thing", (Object)v.property("that").value());
        Assert.assertEquals((Object)"B", (Object)v.property("that").value(partition));
        Assert.assertThat((Object)gOverAB.V(new Object[]{v}).properties(new String[]{"any"}).hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)gOverAB.V(new Object[]{v}).properties(new String[]{"that"}).hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)gOverA.V(new Object[]{v}).properties(new String[]{"that"}).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)gOverA.V(new Object[]{v}).properties(new String[]{"any"}).hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)gOverB.V(new Object[]{v}).properties(new String[]{"any"}).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)gOverB.V(new Object[]{v}).properties(new String[]{"that"}).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)gOverAB.V(new Object[]{v}).properties(new String[]{"partitionKey"}).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)gOverAB.V(new Object[]{v}).values(new String[]{"any"}).hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)gOverAB.V(new Object[]{v}).values(new String[]{"that"}).hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)gOverA.V(new Object[]{v}).values(new String[]{"that"}).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)gOverA.V(new Object[]{v}).values(new String[]{"any"}).hasNext(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)gOverB.V(new Object[]{v}).values(new String[]{"any"}).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)gOverB.V(new Object[]{v}).values(new String[]{"that"}).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)gOverAB.V(new Object[]{v}).values(new String[]{"partitionKey"}).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)((Map)gOverAB.V(new Object[]{v}).propertyMap(new String[0]).next()).containsKey("any"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((Map)gOverAB.V(new Object[]{v}).propertyMap(new String[0]).next()).containsKey("that"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((Map)gOverA.V(new Object[]{v}).propertyMap(new String[0]).next()).containsKey("that"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)((Map)gOverA.V(new Object[]{v}).propertyMap(new String[0]).next()).containsKey("any"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)gOverB.V(new Object[]{v}).propertyMap(new String[0]).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)gOverB.V(new Object[]{v}).propertyMap(new String[0]).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)((Map)gOverAB.V(new Object[]{v}).propertyMap(new String[0]).next()).containsKey(partition), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)((Map)gOverAB.V(new Object[]{v}).valueMap(new String[0]).next()).containsKey("any"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((Map)gOverAB.V(new Object[]{v}).valueMap(new String[0]).next()).containsKey("that"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((Map)gOverA.V(new Object[]{v}).valueMap(new String[0]).next()).containsKey("that"), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)((Map)gOverA.V(new Object[]{v}).valueMap(new String[0]).next()).containsKey("any"), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)gOverB.V(new Object[]{v}).valueMap(new String[0]).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)gOverB.V(new Object[]{v}).valueMap(new String[0]).hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)((Map)gOverAB.V(new Object[]{v}).valueMap(new String[0]).next()).containsKey(partition), (Matcher)CoreMatchers.is((Object)false));
    }

    @Test(expected=IllegalStateException.class)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldHidePartitionKeyForValues() {
        GraphTraversalSource gOverA = this.create(PartitionStrategy.build().includeMetaProperties(true).partitionKey(partition).writePartition("A").addReadPartition("A").create());
        Vertex v = (Vertex)gOverA.addV().property((Object)"any", (Object)"thing", new Object[0]).next();
        gOverA.V(new Object[]{v}).values(new String[]{partition}).next();
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldHidePartitionKeyForValuesWithEmptyKeys() {
        GraphTraversalSource gOverA = this.create(PartitionStrategy.build().includeMetaProperties(true).partitionKey(partition).writePartition("A").addReadPartition("A").create());
        Vertex v = (Vertex)gOverA.addV().property((Object)"any", (Object)"thing", new Object[0]).next();
        Assert.assertEquals((long)1L, (long)((Long)gOverA.V(new Object[]{v}).values(new String[0]).count().next()));
        Assert.assertEquals((Object)"thing", (Object)gOverA.V(new Object[]{v}).values(new String[0]).next());
    }

    @Test(expected=IllegalStateException.class)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldHidePartitionKeyForProperties() {
        GraphTraversalSource gOverA = this.create(PartitionStrategy.build().includeMetaProperties(true).partitionKey(partition).writePartition("A").addReadPartition("A").create());
        Vertex v = (Vertex)gOverA.addV().property((Object)"any", (Object)"thing", new Object[0]).next();
        gOverA.V(new Object[]{v}).properties(new String[]{partition}).next();
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldHidePartitionKeyForPropertiesWithEmptyKeys() {
        GraphTraversalSource gOverA = this.create(PartitionStrategy.build().includeMetaProperties(true).partitionKey(partition).writePartition("A").addReadPartition("A").create());
        Vertex v = (Vertex)gOverA.addV().property((Object)"any", (Object)"thing", new Object[0]).next();
        Assert.assertEquals((long)1L, (long)((Long)gOverA.V(new Object[]{v}).properties(new String[0]).count().next()));
        Assert.assertEquals((Object)"thing", (Object)gOverA.V(new Object[]{v}).properties(new String[0]).value().next());
    }

    @Test(expected=IllegalStateException.class)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldHidePartitionKeyForPropertyMap() {
        GraphTraversalSource gOverA = this.create(PartitionStrategy.build().includeMetaProperties(true).partitionKey(partition).writePartition("A").addReadPartition("A").create());
        Vertex v = (Vertex)gOverA.addV().property((Object)"any", (Object)"thing", new Object[0]).next();
        gOverA.V(new Object[]{v}).propertyMap(new String[]{partition}).next();
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldHidePartitionKeyForPropertyMapWithEmptyKeys() {
        GraphTraversalSource gOverA = this.create(PartitionStrategy.build().includeMetaProperties(true).partitionKey(partition).writePartition("A").addReadPartition("A").create());
        Vertex v = (Vertex)gOverA.addV().property((Object)"any", (Object)"thing", new Object[0]).next();
        Assert.assertEquals((long)1L, (long)((Long)gOverA.V(new Object[]{v}).propertyMap(new String[0]).count().next()));
        Assert.assertEquals((Object)"thing", (Object)((VertexProperty)((List)((Map)gOverA.V(new Object[]{v}).propertyMap(new String[0]).next()).get("any")).get(0)).value());
    }

    @Test(expected=IllegalStateException.class)
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldHidePartitionKeyForValueMap() {
        GraphTraversalSource gOverA = this.create(PartitionStrategy.build().includeMetaProperties(true).partitionKey(partition).writePartition("A").addReadPartition("A").create());
        Vertex v = (Vertex)gOverA.addV().property((Object)"any", (Object)"thing", new Object[0]).next();
        gOverA.V(new Object[]{v}).valueMap(new String[]{partition}).next();
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldHidePartitionKeyForValueMapWithEmptyKeys() {
        GraphTraversalSource gOverA = this.create(PartitionStrategy.build().includeMetaProperties(true).partitionKey(partition).writePartition("A").addReadPartition("A").create());
        Vertex v = (Vertex)gOverA.addV().property((Object)"any", (Object)"thing", new Object[0]).next();
        Assert.assertEquals((long)1L, (long)((Long)gOverA.V(new Object[]{v}).valueMap(new String[0]).count().next()));
        Assert.assertEquals((Object)"thing", ((List)((Map)gOverA.V(new Object[]{v}).valueMap(new String[0]).next()).get("any")).get(0));
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldAppendPartitionToEdge() {
        PartitionStrategy partitionStrategy = PartitionStrategy.build().partitionKey(partition).writePartition("A").addReadPartition("A").create();
        GraphTraversalSource source = this.create(partitionStrategy);
        Vertex v1 = (Vertex)source.addV().property((Object)"any", (Object)"thing", new Object[0]).next();
        Vertex v2 = (Vertex)source.addV().property((Object)"some", (Object)"thing", new Object[0]).next();
        Edge e = (Edge)source.withSideEffect("v2", (Object)v2).V(new Object[]{v1.id()}).addE("connectsTo").from("v2").property((Object)"every", (Object)"thing", new Object[0]).next();
        Assert.assertNotNull((Object)v1);
        Assert.assertEquals((Object)"thing", (Object)v1.property("any").value());
        Assert.assertEquals((Object)"A", (Object)v2.property(partition).value());
        Assert.assertNotNull((Object)v2);
        Assert.assertEquals((Object)"thing", (Object)v2.property("some").value());
        Assert.assertEquals((Object)"A", (Object)v2.property(partition).value());
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)"thing", (Object)e.property("every").value());
        Assert.assertEquals((Object)"connectsTo", (Object)e.label());
        Assert.assertEquals((Object)"A", (Object)e.property(partition).value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldWriteVerticesToMultiplePartitions() {
        PartitionStrategy partitionStrategyAA = PartitionStrategy.build().partitionKey(partition).writePartition("A").addReadPartition("A").create();
        GraphTraversalSource sourceAA = this.create(partitionStrategyAA);
        PartitionStrategy partitionStrategyBA = PartitionStrategy.build().partitionKey(partition).writePartition("B").addReadPartition("A").create();
        GraphTraversalSource sourceBA = this.create(partitionStrategyBA);
        PartitionStrategy partitionStrategyBB = PartitionStrategy.build().partitionKey(partition).writePartition("B").addReadPartition("B").create();
        GraphTraversalSource sourceBB = this.create(partitionStrategyBB);
        PartitionStrategy partitionStrategyBAB = PartitionStrategy.build().partitionKey(partition).writePartition("B").addReadPartition("A").addReadPartition("B").create();
        GraphTraversalSource sourceBAB = this.create(partitionStrategyBAB);
        Vertex vA = (Vertex)sourceAA.addV().property((Object)"any", (Object)"a", new Object[0]).next();
        Vertex vB = (Vertex)sourceBA.addV().property((Object)"any", (Object)"b", new Object[0]).next();
        Assert.assertNotNull((Object)vA);
        Assert.assertEquals((Object)"a", (Object)vA.property("any").value());
        Assert.assertEquals((Object)"A", (Object)vA.property(partition).value());
        Assert.assertNotNull((Object)vB);
        Assert.assertEquals((Object)"b", (Object)vB.property("any").value());
        Assert.assertEquals((Object)"B", (Object)vB.property(partition).value());
        sourceBA.V(new Object[0]).forEachRemaining(v -> Assert.assertEquals((Object)"a", (Object)v.property("any").value()));
        sourceBB.V(new Object[0]).forEachRemaining(v -> Assert.assertEquals((Object)"b", (Object)v.property("any").value()));
        Assert.assertEquals((Object)new Long(2L), (Object)sourceBAB.V(new Object[0]).count().next());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldThrowExceptionOnVInDifferentPartition() {
        PartitionStrategy partitionStrategyAA = PartitionStrategy.build().partitionKey(partition).writePartition("A").addReadPartition("A").create();
        GraphTraversalSource sourceAA = this.create(partitionStrategyAA);
        PartitionStrategy partitionStrategyA = PartitionStrategy.build().partitionKey(partition).writePartition("A").create();
        GraphTraversalSource sourceA = this.create(partitionStrategyA);
        Vertex vA = (Vertex)sourceAA.addV().property((Object)"any", (Object)"a", new Object[0]).next();
        Assert.assertEquals((Object)vA.id(), (Object)sourceAA.V(new Object[]{vA.id()}).id().next());
        try {
            sourceA.V(new Object[]{vA.id()}).next();
            Assert.fail((String)"Vertex should not be in this partition");
        }
        catch (Exception ex) {
            NoSuchElementException expected = FastNoSuchElementException.instance();
            Assert.assertEquals(expected.getClass(), ex.getClass());
        }
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldThrowExceptionOnEInDifferentPartition() {
        PartitionStrategy partitionStrategyAA = PartitionStrategy.build().partitionKey(partition).writePartition("A").addReadPartition("A").create();
        GraphTraversalSource sourceAA = this.create(partitionStrategyAA);
        PartitionStrategy partitionStrategyA = PartitionStrategy.build().partitionKey(partition).writePartition("A").create();
        GraphTraversalSource sourceA = this.create(partitionStrategyA);
        Vertex vA = (Vertex)sourceAA.addV().property((Object)"any", (Object)"a", new Object[0]).next();
        Edge e = (Edge)sourceAA.withSideEffect("vA", (Object)vA).V(new Object[]{vA.id()}).addE("knows").to("vA").next();
        Assert.assertEquals((Object)e.id(), (Object)this.g.E(new Object[]{e.id()}).id().next());
        try {
            sourceA.E(new Object[]{e.id()}).next();
            Assert.fail((String)"Edge should not be in this partition");
        }
        catch (Exception ex) {
            NoSuchElementException expected = FastNoSuchElementException.instance();
            Assert.assertEquals(expected.getClass(), ex.getClass());
        }
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldWriteToMultiplePartitions() {
        PartitionStrategy partitionStrategyAA = PartitionStrategy.build().partitionKey(partition).writePartition("A").addReadPartition("A").create();
        GraphTraversalSource sourceAA = this.create(partitionStrategyAA);
        PartitionStrategy partitionStrategyBA = PartitionStrategy.build().partitionKey(partition).writePartition("B").addReadPartition("A").create();
        GraphTraversalSource sourceBA = this.create(partitionStrategyBA);
        PartitionStrategy partitionStrategyCAB = PartitionStrategy.build().partitionKey(partition).writePartition("C").addReadPartition("A").addReadPartition("B").create();
        GraphTraversalSource sourceCAB = this.create(partitionStrategyCAB);
        PartitionStrategy partitionStrategyC = PartitionStrategy.build().partitionKey(partition).writePartition("C").create();
        GraphTraversalSource sourceC = this.create(partitionStrategyC);
        PartitionStrategy partitionStrategyCA = PartitionStrategy.build().partitionKey(partition).writePartition("C").addReadPartition("A").create();
        GraphTraversalSource sourceCA = this.create(partitionStrategyCA);
        PartitionStrategy partitionStrategyCABC = PartitionStrategy.build().partitionKey(partition).writePartition("C").addReadPartition("A").addReadPartition("B").addReadPartition("C").create();
        GraphTraversalSource sourceCABC = this.create(partitionStrategyCABC);
        PartitionStrategy partitionStrategyCC = PartitionStrategy.build().partitionKey(partition).writePartition("C").addReadPartition("C").create();
        GraphTraversalSource sourceCC = this.create(partitionStrategyCC);
        PartitionStrategy partitionStrategyCBC = PartitionStrategy.build().partitionKey(partition).writePartition("C").addReadPartition("C").addReadPartition("B").create();
        GraphTraversalSource sourceCBC = this.create(partitionStrategyCBC);
        Vertex vA = (Vertex)sourceAA.addV().property((Object)"any", (Object)"a", new Object[0]).next();
        Vertex vAA = (Vertex)sourceAA.addV().property((Object)"any", (Object)"aa", new Object[0]).next();
        Edge eAtoAA = (Edge)sourceAA.withSideEffect("vAA", (Object)vAA).V(new Object[]{vA.id()}).addE("a->a").to("vAA").next();
        Vertex vB = (Vertex)sourceBA.addV().property((Object)"any", (Object)"b", new Object[0]).next();
        sourceBA.withSideEffect("vB", (Object)vB).V(new Object[]{vA.id()}).addE("a->b").to("vB").next();
        Vertex vC = (Vertex)sourceCAB.addV().property((Object)"any", (Object)"c", new Object[0]).next();
        Edge eBtovC = (Edge)sourceCAB.withSideEffect("vC", (Object)vC).V(new Object[]{vB.id()}).addE("b->c").to("vC").next();
        Edge eAtovC = (Edge)sourceCAB.withSideEffect("vC", (Object)vC).V(new Object[]{vA.id()}).addE("a->c").to("vC").next();
        Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)sourceC.V(new Object[0])));
        Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)sourceC.E(new Object[0])));
        Assert.assertEquals((Object)new Long(2L), (Object)sourceCA.V(new Object[0]).count().next());
        Assert.assertEquals((Object)new Long(1L), (Object)sourceCA.E(new Object[0]).count().next());
        Assert.assertEquals((Object)new Long(1L), (Object)sourceCA.V(new Object[]{vA.id()}).outE(new String[0]).count().next());
        Assert.assertEquals((Object)eAtoAA.id(), (Object)((Edge)sourceCA.V(new Object[]{vA.id()}).outE(new String[0]).next()).id());
        Assert.assertEquals((Object)new Long(1L), (Object)sourceCA.V(new Object[]{vA.id()}).out(new String[0]).count().next());
        Assert.assertEquals((Object)vAA.id(), (Object)((Vertex)sourceCA.V(new Object[]{vA.id()}).out(new String[0]).next()).id());
        Vertex vA1 = (Vertex)sourceCA.V(new Object[]{vA.id()}).next();
        Assert.assertEquals((Object)new Long(1L), (Object)sourceCA.V(new Object[]{vA1}).outE(new String[0]).count().next());
        Assert.assertEquals((Object)eAtoAA.id(), (Object)((Edge)sourceCA.V(new Object[]{vA1}).outE(new String[0]).next()).id());
        Assert.assertEquals((Object)new Long(1L), (Object)sourceCA.V(new Object[]{vA1}).out(new String[0]).count().next());
        Assert.assertEquals((Object)vAA.id(), (Object)((Vertex)sourceCA.V(new Object[]{vA1}).out(new String[0]).next()).id());
        Assert.assertEquals((Object)new Long(3L), (Object)sourceCAB.V(new Object[0]).count().next());
        Assert.assertEquals((Object)new Long(2L), (Object)sourceCAB.E(new Object[0]).count().next());
        Assert.assertEquals((Object)new Long(4L), (Object)sourceCABC.V(new Object[0]).count().next());
        Assert.assertEquals((Object)new Long(4L), (Object)sourceCABC.E(new Object[0]).count().next());
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)sourceCC.V(new Object[0])));
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)sourceCC.E(new Object[0])));
        Assert.assertEquals((Object)new Long(2L), (Object)sourceCC.V(new Object[]{vC.id()}).inE(new String[0]).count().next());
        Assert.assertEquals((Object)new Long(0L), (Object)sourceCC.V(new Object[]{vC.id()}).in(new String[0]).count().next());
        Assert.assertEquals((Object)new Long(2L), (Object)sourceCBC.V(new Object[]{vC.id()}).inE(new String[0]).count().next());
        Assert.assertEquals((Object)new Long(1L), (Object)sourceCBC.V(new Object[]{vC.id()}).in(new String[0]).count().next());
        Assert.assertEquals((Object)vC.id(), (Object)sourceCBC.E(new Object[]{eBtovC.id()}).inV().id().next());
        Assert.assertEquals((Object)vB.id(), (Object)sourceCBC.E(new Object[]{eBtovC.id()}).outV().id().next());
        Assert.assertEquals((Object)vC.id(), (Object)sourceCBC.E(new Object[]{eAtovC.id()}).inV().id().next());
        Assert.assertFalse((boolean)sourceCBC.E(new Object[]{eAtovC.id()}).outV().hasNext());
    }

    private GraphTraversalSource create(PartitionStrategy strategy) {
        return this.graphProvider.traversal(this.graph, new TraversalStrategy[]{strategy});
    }
}

