/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.PartitionStrategy;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.junit.Assert;
import org.junit.Test;

public class PartitionStrategyProcessTest
extends AbstractGremlinProcessTest {
    private static final String partition = "gremlin.partitionGraphStrategy.partition";

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldAppendPartitionToVertex() {
        PartitionStrategy partitionStrategy = PartitionStrategy.build().partitionKey(partition).writePartition("A").addReadPartition("A").create();
        Vertex v = (Vertex)this.create(partitionStrategy).addV(new Object[]{"any", "thing"}).next();
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"thing", (Object)v.property("any").value());
        Assert.assertEquals((Object)"A", (Object)v.property(partition).value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldAppendPartitionToEdge() {
        PartitionStrategy partitionStrategy = PartitionStrategy.build().partitionKey(partition).writePartition("A").addReadPartition("A").create();
        GraphTraversalSource source = this.create(partitionStrategy);
        Vertex v1 = (Vertex)source.addV(new Object[]{"any", "thing"}).next();
        Vertex v2 = (Vertex)source.addV(new Object[]{"some", "thing"}).next();
        Edge e = (Edge)source.withSideEffect("v2", (Object)v2).V(new Object[]{v1.id()}).addInE("connectsTo", "v2", new Object[]{"every", "thing"}).next();
        Assert.assertNotNull((Object)v1);
        Assert.assertEquals((Object)"thing", (Object)v1.property("any").value());
        Assert.assertEquals((Object)"A", (Object)v2.property(partition).value());
        Assert.assertNotNull((Object)v2);
        Assert.assertEquals((Object)"thing", (Object)v2.property("some").value());
        Assert.assertEquals((Object)"A", (Object)v2.property(partition).value());
        Assert.assertNotNull((Object)e);
        Assert.assertEquals((Object)"thing", (Object)e.property("every").value());
        Assert.assertEquals((Object)"connectsTo", (Object)e.label());
        Assert.assertEquals((Object)"A", (Object)e.property(partition).value());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldWriteVerticesToMultiplePartitions() {
        PartitionStrategy partitionStrategyAA = PartitionStrategy.build().partitionKey(partition).writePartition("A").addReadPartition("A").create();
        GraphTraversalSource sourceAA = this.create(partitionStrategyAA);
        PartitionStrategy partitionStrategyBA = PartitionStrategy.build().partitionKey(partition).writePartition("B").addReadPartition("A").create();
        GraphTraversalSource sourceBA = this.create(partitionStrategyBA);
        PartitionStrategy partitionStrategyBB = PartitionStrategy.build().partitionKey(partition).writePartition("B").addReadPartition("B").create();
        GraphTraversalSource sourceBB = this.create(partitionStrategyBB);
        PartitionStrategy partitionStrategyBAB = PartitionStrategy.build().partitionKey(partition).writePartition("B").addReadPartition("A").addReadPartition("B").create();
        GraphTraversalSource sourceBAB = this.create(partitionStrategyBAB);
        Vertex vA = (Vertex)sourceAA.addV(new Object[]{"any", "a"}).next();
        Vertex vB = (Vertex)sourceBA.addV(new Object[]{"any", "b"}).next();
        Assert.assertNotNull((Object)vA);
        Assert.assertEquals((Object)"a", (Object)vA.property("any").value());
        Assert.assertEquals((Object)"A", (Object)vA.property(partition).value());
        Assert.assertNotNull((Object)vB);
        Assert.assertEquals((Object)"b", (Object)vB.property("any").value());
        Assert.assertEquals((Object)"B", (Object)vB.property(partition).value());
        sourceBA.V(new Object[0]).forEachRemaining(v -> Assert.assertEquals((Object)"a", (Object)v.property("any").value()));
        sourceBB.V(new Object[0]).forEachRemaining(v -> Assert.assertEquals((Object)"b", (Object)v.property("any").value()));
        Assert.assertEquals((Object)new Long(2L), (Object)sourceBAB.V(new Object[0]).count().next());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldThrowExceptionOnVInDifferentPartition() {
        PartitionStrategy partitionStrategyAA = PartitionStrategy.build().partitionKey(partition).writePartition("A").addReadPartition("A").create();
        GraphTraversalSource sourceAA = this.create(partitionStrategyAA);
        PartitionStrategy partitionStrategyA = PartitionStrategy.build().partitionKey(partition).writePartition("A").create();
        GraphTraversalSource sourceA = this.create(partitionStrategyA);
        Vertex vA = (Vertex)sourceAA.addV(new Object[]{"any", "a"}).next();
        Assert.assertEquals((Object)vA.id(), (Object)sourceAA.V(new Object[]{vA.id()}).id().next());
        try {
            sourceA.V(new Object[]{vA.id()});
        }
        catch (Exception ex) {
            NoSuchElementException expected = Graph.Exceptions.elementNotFound(Vertex.class, (Object)vA.id());
            Assert.assertEquals(expected.getClass(), ex.getClass());
            Assert.assertEquals((Object)expected.getMessage(), (Object)ex.getMessage());
        }
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldThrowExceptionOnEInDifferentPartition() {
        PartitionStrategy partitionStrategyAA = PartitionStrategy.build().partitionKey(partition).writePartition("A").addReadPartition("A").create();
        GraphTraversalSource sourceAA = this.create(partitionStrategyAA);
        PartitionStrategy partitionStrategyA = PartitionStrategy.build().partitionKey(partition).writePartition("A").create();
        GraphTraversalSource sourceA = this.create(partitionStrategyA);
        Vertex vA = (Vertex)sourceAA.addV(new Object[]{"any", "a"}).next();
        Edge e = (Edge)sourceAA.withSideEffect("vA", (Object)vA).V(new Object[]{vA.id()}).addOutE("knows", "vA", new Object[0]).next();
        Assert.assertEquals((Object)e.id(), (Object)this.g.E(new Object[]{e.id()}).id().next());
        try {
            sourceA.E(new Object[]{e.id()});
        }
        catch (Exception ex) {
            NoSuchElementException expected = Graph.Exceptions.elementNotFound(Edge.class, (Object)e.id());
            Assert.assertEquals(expected.getClass(), ex.getClass());
            Assert.assertEquals((Object)expected.getMessage(), (Object)ex.getMessage());
        }
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldWriteToMultiplePartitions() {
        PartitionStrategy partitionStrategyAA = PartitionStrategy.build().partitionKey(partition).writePartition("A").addReadPartition("A").create();
        GraphTraversalSource sourceAA = this.create(partitionStrategyAA);
        PartitionStrategy partitionStrategyBA = PartitionStrategy.build().partitionKey(partition).writePartition("B").addReadPartition("A").create();
        GraphTraversalSource sourceBA = this.create(partitionStrategyBA);
        PartitionStrategy partitionStrategyCAB = PartitionStrategy.build().partitionKey(partition).writePartition("C").addReadPartition("A").addReadPartition("B").create();
        GraphTraversalSource sourceCAB = this.create(partitionStrategyCAB);
        PartitionStrategy partitionStrategyC = PartitionStrategy.build().partitionKey(partition).writePartition("C").create();
        GraphTraversalSource sourceC = this.create(partitionStrategyC);
        PartitionStrategy partitionStrategyCA = PartitionStrategy.build().partitionKey(partition).writePartition("C").addReadPartition("A").create();
        GraphTraversalSource sourceCA = this.create(partitionStrategyCA);
        PartitionStrategy partitionStrategyCABC = PartitionStrategy.build().partitionKey(partition).writePartition("C").addReadPartition("A").addReadPartition("B").addReadPartition("C").create();
        GraphTraversalSource sourceCABC = this.create(partitionStrategyCABC);
        PartitionStrategy partitionStrategyCC = PartitionStrategy.build().partitionKey(partition).writePartition("C").addReadPartition("C").create();
        GraphTraversalSource sourceCC = this.create(partitionStrategyCC);
        PartitionStrategy partitionStrategyCBC = PartitionStrategy.build().partitionKey(partition).writePartition("C").addReadPartition("C").addReadPartition("B").create();
        GraphTraversalSource sourceCBC = this.create(partitionStrategyCBC);
        Vertex vA = (Vertex)sourceAA.addV(new Object[]{"any", "a"}).next();
        Vertex vAA = (Vertex)sourceAA.addV(new Object[]{"any", "aa"}).next();
        Edge eAtoAA = (Edge)sourceAA.withSideEffect("vAA", (Object)vAA).V(new Object[]{vA.id()}).addOutE("a->a", "vAA", new Object[0]).next();
        Vertex vB = (Vertex)sourceBA.addV(new Object[]{"any", "b"}).next();
        sourceBA.withSideEffect("vB", (Object)vB).V(new Object[]{vA.id()}).addOutE("a->b", "vB", new Object[0]).next();
        Vertex vC = (Vertex)sourceCAB.addV(new Object[]{"any", "c"}).next();
        Edge eBtovC = (Edge)sourceCAB.withSideEffect("vC", (Object)vC).V(new Object[]{vB.id()}).addOutE("b->c", "vC", new Object[0]).next();
        Edge eAtovC = (Edge)sourceCAB.withSideEffect("vC", (Object)vC).V(new Object[]{vA.id()}).addOutE("a->c", "vC", new Object[0]).next();
        Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)sourceC.V(new Object[0])));
        Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)sourceC.E(new Object[0])));
        Assert.assertEquals((Object)new Long(2L), (Object)sourceCA.V(new Object[0]).count().next());
        Assert.assertEquals((Object)new Long(1L), (Object)sourceCA.E(new Object[0]).count().next());
        Assert.assertEquals((Object)new Long(1L), (Object)sourceCA.V(new Object[]{vA.id()}).outE(new String[0]).count().next());
        Assert.assertEquals((Object)eAtoAA.id(), (Object)((Edge)sourceCA.V(new Object[]{vA.id()}).outE(new String[0]).next()).id());
        Assert.assertEquals((Object)new Long(1L), (Object)sourceCA.V(new Object[]{vA.id()}).out(new String[0]).count().next());
        Assert.assertEquals((Object)vAA.id(), (Object)((Vertex)sourceCA.V(new Object[]{vA.id()}).out(new String[0]).next()).id());
        Vertex vA1 = (Vertex)sourceCA.V(new Object[]{vA.id()}).next();
        Assert.assertEquals((Object)new Long(1L), (Object)sourceCA.V(new Object[]{vA1}).outE(new String[0]).count().next());
        Assert.assertEquals((Object)eAtoAA.id(), (Object)((Edge)sourceCA.V(new Object[]{vA1}).outE(new String[0]).next()).id());
        Assert.assertEquals((Object)new Long(1L), (Object)sourceCA.V(new Object[]{vA1}).out(new String[0]).count().next());
        Assert.assertEquals((Object)vAA.id(), (Object)((Vertex)sourceCA.V(new Object[]{vA1}).out(new String[0]).next()).id());
        Assert.assertEquals((Object)new Long(3L), (Object)sourceCAB.V(new Object[0]).count().next());
        Assert.assertEquals((Object)new Long(2L), (Object)sourceCAB.E(new Object[0]).count().next());
        Assert.assertEquals((Object)new Long(4L), (Object)sourceCABC.V(new Object[0]).count().next());
        Assert.assertEquals((Object)new Long(4L), (Object)sourceCABC.E(new Object[0]).count().next());
        Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)sourceCC.V(new Object[0])));
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)sourceCC.E(new Object[0])));
        Assert.assertEquals((Object)new Long(2L), (Object)sourceCC.V(new Object[]{vC.id()}).inE(new String[0]).count().next());
        Assert.assertEquals((Object)new Long(0L), (Object)sourceCC.V(new Object[]{vC.id()}).in(new String[0]).count().next());
        Assert.assertEquals((Object)new Long(2L), (Object)sourceCBC.V(new Object[]{vC.id()}).inE(new String[0]).count().next());
        Assert.assertEquals((Object)new Long(1L), (Object)sourceCBC.V(new Object[]{vC.id()}).in(new String[0]).count().next());
        Assert.assertEquals((Object)vC.id(), (Object)sourceCBC.E(new Object[]{eBtovC.id()}).inV().id().next());
        Assert.assertEquals((Object)vB.id(), (Object)sourceCBC.E(new Object[]{eBtovC.id()}).outV().id().next());
        Assert.assertEquals((Object)vC.id(), (Object)sourceCBC.E(new Object[]{eAtovC.id()}).inV().id().next());
        Assert.assertFalse((boolean)sourceCBC.E(new Object[]{eAtovC.id()}).outV().hasNext());
    }

    private GraphTraversalSource create(PartitionStrategy strategy) {
        return this.graphProvider.traversal(this.graph, new TraversalStrategy[]{strategy});
    }
}

