/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.tinkerpop.gremlin.FeatureRequirement;
import org.apache.tinkerpop.gremlin.FeatureRequirementSet;
import org.apache.tinkerpop.gremlin.process.AbstractGremlinProcessTest;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.MutationListener;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.EventStrategy;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;

public class EventStrategyProcessTest
extends AbstractGremlinProcessTest {
    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldTriggerAddVertex() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        this.graph.addVertex(new Object[]{"some", "thing"});
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[0]).addV(new Object[]{"any", "thing"}).next();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)gts.V(new Object[0]).has("any", (Object)"thing"))));
        Assert.assertEquals((long)1L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.addVertexEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldTriggerAddVertexFromStart() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        this.graph.addVertex(new Object[]{"some", "thing"});
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.addV(new Object[]{"any", "thing"}).next();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)gts.V(new Object[0]).has("any", (Object)"thing"))));
        Assert.assertEquals((long)1L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.addVertexEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldTriggerAddEdge() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        Vertex v = this.graph.addVertex(new Object[0]);
        v.addEdge("self", v, new Object[0]);
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.withSideEffect("v", () -> v).V(new Object[]{v}).addOutE("self", "v", new Object[0]).next();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)gts.E(new Object[0]))));
        Assert.assertEquals((long)0L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)0L, (long)listener2.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener1.addEdgeEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.addEdgeEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldTriggerAddEdgeByPath() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        Vertex v = this.graph.addVertex(new Object[0]);
        v.addEdge("self", v, new Object[0]);
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[]{v}).as("a", new String[0]).addOutE("self", "a", new Object[0]).next();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)gts.E(new Object[0]))));
        Assert.assertEquals((long)0L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)0L, (long)listener2.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener1.addEdgeEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.addEdgeEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldTriggerAddVertexPropertyAdded() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        Vertex vSome = this.graph.addVertex(new Object[]{"some", "thing"});
        vSome.property(VertexProperty.Cardinality.single, "that", (Object)"thing", new Object[0]);
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[0]).addV(new Object[0]).property("this", (Object)"thing", new Object[0]).next();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)gts.V(new Object[0]).has("this", (Object)"thing"))));
        Assert.assertEquals((long)1L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.vertexPropertyChangedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener1.vertexPropertyChangedEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldTriggerAddVertexWithPropertyThenPropertyAdded() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        Vertex vSome = this.graph.addVertex(new Object[]{"some", "thing"});
        vSome.property(VertexProperty.Cardinality.single, "that", (Object)"thing", new Object[0]);
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[0]).addV(new Object[]{"any", "thing"}).property(VertexProperty.Cardinality.single, "this", (Object)"thing", new Object[0]).next();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)gts.V(new Object[0]).has("this", (Object)"thing"))));
        Assert.assertEquals((long)1L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.vertexPropertyChangedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener1.vertexPropertyChangedEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldTriggerAddVertexPropertyChanged() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        Vertex vSome = this.graph.addVertex(new Object[]{"some", "thing"});
        vSome.property(VertexProperty.Cardinality.single, "that", (Object)"thing", new Object[0]);
        GraphTraversalSource gts = this.create(eventStrategy);
        Vertex vAny = (Vertex)gts.V(new Object[0]).addV(new Object[]{"any", "thing"}).next();
        gts.V(new Object[]{vAny}).property(VertexProperty.Cardinality.single, "any", (Object)"thing else", new Object[0]).next();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)gts.V(new Object[0]).has("any", (Object)"thing else"))));
        Assert.assertEquals((long)1L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.vertexPropertyChangedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener1.vertexPropertyChangedEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldTriggerAddVertexPropertyPropertyChanged() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        Vertex vSome = this.graph.addVertex(new Object[]{"some", "thing"});
        vSome.property(VertexProperty.Cardinality.single, "that", (Object)"thing", new Object[]{"is", "good"});
        GraphTraversalSource gts = this.create(eventStrategy);
        Vertex vAny = (Vertex)gts.V(new Object[0]).addV(new Object[]{"any", "thing"}).next();
        gts.V(new Object[]{vAny}).properties(new String[]{"any"}).property("is", (Object)"bad", new Object[0]).next();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)gts.V(new Object[0]).has("any", (Object)"thing"))));
        Assert.assertEquals((long)1L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.vertexPropertyPropertyChangedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener1.vertexPropertyPropertyChangedEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldTriggerAddEdgePropertyAdded() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        Vertex v = this.graph.addVertex(new Object[0]);
        v.addEdge("self", v, new Object[0]);
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.withSideEffect("v", (Object)v).V(new Object[]{v}).addOutE("self", "v", new Object[0]).property("some", (Object)"thing", new Object[0]).next();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)gts.E(new Object[0]).has("some", (Object)"thing"))));
        Assert.assertEquals((long)0L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)0L, (long)listener2.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener1.addEdgeEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.addEdgeEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.edgePropertyChangedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener1.edgePropertyChangedEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldTriggerEdgePropertyChanged() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        Vertex v = this.graph.addVertex(new Object[0]);
        Edge e = v.addEdge("self", v, new Object[0]);
        e.property("some", (Object)"thing");
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.E(new Object[]{e}).property("some", (Object)"other thing", new Object[0]).next();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)gts.E(new Object[0]).has("some", (Object)"other thing"))));
        Assert.assertEquals((long)0L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)0L, (long)listener2.addVertexEventRecorded());
        Assert.assertEquals((long)0L, (long)listener1.addEdgeEventRecorded());
        Assert.assertEquals((long)0L, (long)listener2.addEdgeEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.edgePropertyChangedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener1.edgePropertyChangedEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldTriggerRemoveVertex() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        this.graph.addVertex(new Object[]{"some", "thing"});
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[0]).drop().iterate();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)gts.V(new Object[0]))));
        Assert.assertEquals((long)1L, (long)listener1.vertexRemovedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.vertexRemovedEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldTriggerRemoveEdge() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        Vertex v = this.graph.addVertex(new Object[]{"some", "thing"});
        v.addEdge("self", v, new Object[0]);
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.E(new Object[0]).drop().iterate();
        this.tryCommit(this.graph);
        Assert.assertEquals((long)1L, (long)listener1.edgeRemovedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.edgeRemovedEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    public void shouldTriggerRemoveVertexProperty() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        this.graph.addVertex(new Object[]{"some", "thing"});
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[0]).properties(new String[0]).drop().iterate();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)gts.V(new Object[0]).properties(new String[0]))));
        Assert.assertEquals((long)1L, (long)listener1.vertexPropertyRemovedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.vertexPropertyRemovedEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.SIMPLE)
    public void shouldTriggerRemoveEdgeProperty() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        Vertex v = this.graph.addVertex(new Object[0]);
        v.addEdge("self", v, new Object[]{"some", "thing"});
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.E(new Object[0]).properties(new String[0]).drop().iterate();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)0L, (long)IteratorUtils.count((Iterator)gts.E(new Object[0]).properties(new String[0]))));
        Assert.assertEquals((long)1L, (long)listener1.edgePropertyRemovedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.edgePropertyRemovedEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.VertexFeatures.class, feature="MetaProperties")
    public void shouldTriggerAddVertexPropertyPropertyRemoved() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        if (this.graph.features().graph().supportsTransactions()) {
            builder.eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph));
        }
        EventStrategy eventStrategy = builder.create();
        Vertex vSome = this.graph.addVertex(new Object[]{"some", "thing"});
        vSome.property(VertexProperty.Cardinality.single, "that", (Object)"thing", new Object[]{"is", "good"});
        GraphTraversalSource gts = this.create(eventStrategy);
        Vertex vAny = (Vertex)gts.V(new Object[0]).addV(new Object[]{"any", "thing"}).next();
        gts.V(new Object[]{vAny}).properties(new String[]{"any"}).property("is", (Object)"bad", new Object[0]).next();
        gts.V(new Object[]{vAny}).properties(new String[]{"any"}).properties(new String[]{"is"}).drop().iterate();
        this.tryCommit(this.graph, g -> Assert.assertEquals((long)1L, (long)IteratorUtils.count((Iterator)gts.V(new Object[0]).has("any", (Object)"thing"))));
        Assert.assertEquals((long)1L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.addVertexEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.vertexPropertyPropertyChangedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener1.vertexPropertyPropertyChangedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener2.vertexPropertyPropertyRemovedEventRecorded());
        Assert.assertEquals((long)1L, (long)listener1.vertexPropertyPropertyRemovedEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldTriggerAfterCommit() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph)).addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        EventStrategy eventStrategy = builder.create();
        this.graph.addVertex(new Object[]{"some", "thing"});
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[0]).addV(new Object[]{"any", "thing"}).next();
        gts.V(new Object[0]).addV(new Object[]{"any", "one"}).next();
        Assert.assertEquals((long)0L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)0L, (long)listener2.addVertexEventRecorded());
        gts.tx().commit();
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)gts.V(new Object[0]).has("any")));
        Assert.assertEquals((long)2L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)2L, (long)listener2.addVertexEventRecorded());
    }

    @Test
    @FeatureRequirementSet(value=FeatureRequirementSet.Package.VERTICES_ONLY)
    @FeatureRequirement(featureClass=Graph.Features.GraphFeatures.class, feature="Transactions")
    public void shouldResetAfterRollback() {
        StubMutationListener listener1 = new StubMutationListener();
        StubMutationListener listener2 = new StubMutationListener();
        EventStrategy.Builder builder = EventStrategy.build().eventQueue((EventStrategy.EventQueue)new EventStrategy.TransactionalEventQueue(this.graph)).addListener((MutationListener)listener1).addListener((MutationListener)listener2);
        EventStrategy eventStrategy = builder.create();
        this.graph.addVertex(new Object[]{"some", "thing"});
        GraphTraversalSource gts = this.create(eventStrategy);
        gts.V(new Object[0]).addV(new Object[]{"any", "thing"}).next();
        gts.V(new Object[0]).addV(new Object[]{"any", "one"}).next();
        Assert.assertEquals((long)0L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)0L, (long)listener2.addVertexEventRecorded());
        gts.tx().rollback();
        MatcherAssert.assertThat((Object)gts.V(new Object[0]).has("any").hasNext(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertEquals((long)0L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)0L, (long)listener2.addVertexEventRecorded());
        this.graph.addVertex(new Object[]{"some", "thing"});
        gts.V(new Object[0]).addV(new Object[]{"any", "thing"}).next();
        gts.V(new Object[0]).addV(new Object[]{"any", "one"}).next();
        Assert.assertEquals((long)0L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)0L, (long)listener2.addVertexEventRecorded());
        gts.tx().commit();
        Assert.assertEquals((long)2L, (long)IteratorUtils.count((Iterator)gts.V(new Object[0]).has("any")));
        Assert.assertEquals((long)2L, (long)listener1.addVertexEventRecorded());
        Assert.assertEquals((long)2L, (long)listener2.addVertexEventRecorded());
    }

    private GraphTraversalSource create(EventStrategy strategy) {
        return this.graphProvider.traversal(this.graph, new TraversalStrategy[]{strategy});
    }

    public static class StubMutationListener
    implements MutationListener {
        private final AtomicLong addEdgeEvent = new AtomicLong(0L);
        private final AtomicLong addVertexEvent = new AtomicLong(0L);
        private final AtomicLong vertexRemovedEvent = new AtomicLong(0L);
        private final AtomicLong edgePropertyChangedEvent = new AtomicLong(0L);
        private final AtomicLong vertexPropertyChangedEvent = new AtomicLong(0L);
        private final AtomicLong vertexPropertyPropertyChangedEvent = new AtomicLong(0L);
        private final AtomicLong edgePropertyRemovedEvent = new AtomicLong(0L);
        private final AtomicLong vertexPropertyPropertyRemovedEvent = new AtomicLong(0L);
        private final AtomicLong edgeRemovedEvent = new AtomicLong(0L);
        private final AtomicLong vertexPropertyRemovedEvent = new AtomicLong(0L);
        private final ConcurrentLinkedQueue<String> order = new ConcurrentLinkedQueue();

        public void reset() {
            this.addEdgeEvent.set(0L);
            this.addVertexEvent.set(0L);
            this.vertexRemovedEvent.set(0L);
            this.edgePropertyChangedEvent.set(0L);
            this.vertexPropertyChangedEvent.set(0L);
            this.vertexPropertyPropertyChangedEvent.set(0L);
            this.vertexPropertyPropertyRemovedEvent.set(0L);
            this.edgePropertyRemovedEvent.set(0L);
            this.edgeRemovedEvent.set(0L);
            this.vertexPropertyRemovedEvent.set(0L);
            this.order.clear();
        }

        public List<String> getOrder() {
            return new ArrayList<String>(this.order);
        }

        public void vertexAdded(Vertex vertex) {
            this.addVertexEvent.incrementAndGet();
            this.order.add("v-added-" + vertex.id());
        }

        public void vertexRemoved(Vertex vertex) {
            this.vertexRemovedEvent.incrementAndGet();
            this.order.add("v-removed-" + vertex.id());
        }

        public void edgeAdded(Edge edge) {
            this.addEdgeEvent.incrementAndGet();
            this.order.add("e-added-" + edge.id());
        }

        public void edgePropertyRemoved(Edge element, Property o) {
            this.edgePropertyRemovedEvent.incrementAndGet();
            this.order.add("e-property-removed-" + element.id() + "-" + o);
        }

        public void vertexPropertyPropertyRemoved(VertexProperty element, Property o) {
            this.vertexPropertyPropertyRemovedEvent.incrementAndGet();
            this.order.add("vp-property-removed-" + element.id() + "-" + o);
        }

        public void edgeRemoved(Edge edge) {
            this.edgeRemovedEvent.incrementAndGet();
            this.order.add("e-removed-" + edge.id());
        }

        public void vertexPropertyRemoved(VertexProperty vertexProperty) {
            this.vertexPropertyRemovedEvent.incrementAndGet();
            this.order.add("vp-property-removed-" + vertexProperty.id());
        }

        public void edgePropertyChanged(Edge element, Property oldValue, Object setValue) {
            this.edgePropertyChangedEvent.incrementAndGet();
            this.order.add("e-property-chanaged-" + element.id());
        }

        public void vertexPropertyPropertyChanged(VertexProperty element, Property oldValue, Object setValue) {
            this.vertexPropertyPropertyChangedEvent.incrementAndGet();
            this.order.add("vp-property-changed-" + element.id());
        }

        public void vertexPropertyChanged(Vertex element, Property oldValue, Object setValue, Object ... vertexPropertyKeyValues) {
            this.vertexPropertyChangedEvent.incrementAndGet();
            this.order.add("v-property-changed-" + element.id());
        }

        public long addEdgeEventRecorded() {
            return this.addEdgeEvent.get();
        }

        public long addVertexEventRecorded() {
            return this.addVertexEvent.get();
        }

        public long vertexRemovedEventRecorded() {
            return this.vertexRemovedEvent.get();
        }

        public long edgeRemovedEventRecorded() {
            return this.edgeRemovedEvent.get();
        }

        public long edgePropertyRemovedEventRecorded() {
            return this.edgePropertyRemovedEvent.get();
        }

        public long vertexPropertyRemovedEventRecorded() {
            return this.vertexPropertyRemovedEvent.get();
        }

        public long vertexPropertyPropertyRemovedEventRecorded() {
            return this.vertexPropertyPropertyRemovedEvent.get();
        }

        public long edgePropertyChangedEventRecorded() {
            return this.edgePropertyChangedEvent.get();
        }

        public long vertexPropertyChangedEventRecorded() {
            return this.vertexPropertyChangedEvent.get();
        }

        public long vertexPropertyPropertyChangedEventRecorded() {
            return this.vertexPropertyPropertyChangedEvent.get();
        }
    }
}

