/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.shaded.jackson.databind.util;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.tinkerpop.shaded.jackson.databind.AnnotationIntrospector;

public class EnumResolver<T extends Enum<T>>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Class<T> _enumClass;
    protected final T[] _enums;
    protected final HashMap<String, T> _enumsById;

    protected EnumResolver(Class<T> enumClass, T[] enums, HashMap<String, T> map) {
        this._enumClass = enumClass;
        this._enums = enums;
        this._enumsById = map;
    }

    public static <ET extends Enum<ET>> EnumResolver<ET> constructFor(Class<ET> enumCls, AnnotationIntrospector ai) {
        Enum[] enumValues = (Enum[])enumCls.getEnumConstants();
        if (enumValues == null) {
            throw new IllegalArgumentException("No enum constants for class " + enumCls.getName());
        }
        HashMap<String, Enum> map = new HashMap<String, Enum>();
        for (Enum e : enumValues) {
            map.put(ai.findEnumValue(e), e);
        }
        return new EnumResolver(enumCls, enumValues, map);
    }

    public static <ET extends Enum<ET>> EnumResolver<ET> constructUsingToString(Class<ET> enumCls) {
        Enum[] enumValues = (Enum[])enumCls.getEnumConstants();
        HashMap<String, Enum> map = new HashMap<String, Enum>();
        int i = enumValues.length;
        while (--i >= 0) {
            Enum e = enumValues[i];
            map.put(e.toString(), e);
        }
        return new EnumResolver(enumCls, enumValues, map);
    }

    public static <ET extends Enum<ET>> EnumResolver<ET> constructUsingMethod(Class<ET> enumCls, Method accessor) {
        Enum[] enumValues = (Enum[])enumCls.getEnumConstants();
        HashMap<String, Enum> map = new HashMap<String, Enum>();
        int i = enumValues.length;
        while (--i >= 0) {
            Enum en = enumValues[i];
            try {
                Object o = accessor.invoke((Object)en, new Object[0]);
                if (o == null) continue;
                map.put(o.toString(), en);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to access @JsonValue of Enum value " + en + ": " + e.getMessage());
            }
        }
        return new EnumResolver(enumCls, enumValues, map);
    }

    public static EnumResolver<?> constructUnsafe(Class<?> rawEnumCls, AnnotationIntrospector ai) {
        Class<?> enumCls = rawEnumCls;
        return EnumResolver.constructFor(enumCls, ai);
    }

    public static EnumResolver<?> constructUnsafeUsingToString(Class<?> rawEnumCls) {
        Class<?> enumCls = rawEnumCls;
        return EnumResolver.constructUsingToString(enumCls);
    }

    public static EnumResolver<?> constructUnsafeUsingMethod(Class<?> rawEnumCls, Method accessor) {
        Class<?> enumCls = rawEnumCls;
        return EnumResolver.constructUsingMethod(enumCls, accessor);
    }

    public T findEnum(String key) {
        return (T)((Enum)this._enumsById.get(key));
    }

    public T getEnum(int index) {
        if (index < 0 || index >= this._enums.length) {
            return null;
        }
        return this._enums[index];
    }

    public List<T> getEnums() {
        ArrayList<T> enums = new ArrayList<T>(this._enums.length);
        for (T e : this._enums) {
            enums.add(e);
        }
        return enums;
    }

    public Class<T> getEnumClass() {
        return this._enumClass;
    }

    public int lastValidIndex() {
        return this._enums.length - 1;
    }
}

