/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.shaded.jackson.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.databind.JavaType;
import org.apache.tinkerpop.shaded.jackson.databind.JsonMappingException;
import org.apache.tinkerpop.shaded.jackson.databind.JsonNode;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.annotation.JacksonStdImpl;
import org.apache.tinkerpop.shaded.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.apache.tinkerpop.shaded.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import org.apache.tinkerpop.shaded.jackson.databind.jsonFormatVisitors.JsonNumberFormatVisitor;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdScalarSerializer;

@JacksonStdImpl
public class NumberSerializer
extends StdScalarSerializer<Number> {
    public static final NumberSerializer instance = new NumberSerializer((Class<? extends Number>)Number.class);
    protected final boolean _isInt;

    @Deprecated
    public NumberSerializer() {
        super(Number.class);
        this._isInt = false;
    }

    public NumberSerializer(Class<? extends Number> rawType) {
        super(rawType, false);
        this._isInt = rawType == BigInteger.class;
    }

    @Override
    public void serialize(Number value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value instanceof BigDecimal) {
            jgen.writeNumber((BigDecimal)value);
        } else if (value instanceof BigInteger) {
            jgen.writeNumber((BigInteger)value);
        } else if (value instanceof Integer) {
            jgen.writeNumber(value.intValue());
        } else if (value instanceof Long) {
            jgen.writeNumber(value.longValue());
        } else if (value instanceof Double) {
            jgen.writeNumber(value.doubleValue());
        } else if (value instanceof Float) {
            jgen.writeNumber(value.floatValue());
        } else if (value instanceof Byte || value instanceof Short) {
            jgen.writeNumber(value.intValue());
        } else {
            jgen.writeNumber(value.toString());
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode(this._isInt ? "integer" : "number", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (this._isInt) {
            JsonIntegerFormatVisitor v2 = visitor.expectIntegerFormat(typeHint);
            if (v2 != null) {
                v2.numberType(JsonParser.NumberType.BIG_INTEGER);
            }
        } else {
            Class h;
            JsonNumberFormatVisitor v2 = visitor.expectNumberFormat(typeHint);
            if (v2 != null && (h = this.handledType()) == BigDecimal.class) {
                v2.numberType(JsonParser.NumberType.BIG_DECIMAL);
            }
        }
    }
}

