/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.op.standard;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.op.AbstractEvalOpProcessor;
import org.apache.tinkerpop.gremlin.server.op.OpProcessorException;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardOpProcessor
extends AbstractEvalOpProcessor {
    private static final Logger logger = LoggerFactory.getLogger(StandardOpProcessor.class);
    public static final String OP_PROCESSOR_NAME = "";
    protected final Function<Context, AbstractEvalOpProcessor.BindingSupplier> bindingMaker = this.getBindingMaker();
    static final Settings.ProcessorSettings DEFAULT_SETTINGS = new Settings.ProcessorSettings();

    public StandardOpProcessor() {
        super(true);
    }

    @Override
    public String getName() {
        return OP_PROCESSOR_NAME;
    }

    @Override
    public void init(Settings settings) {
        this.maxParameters = (Integer)settings.optionalProcessor(StandardOpProcessor.class).orElse((Settings.ProcessorSettings)StandardOpProcessor.DEFAULT_SETTINGS).config.getOrDefault("maxParameters", 16);
    }

    @Override
    public ThrowingConsumer<Context> getEvalOp() {
        return this::evalOp;
    }

    @Override
    public Optional<ThrowingConsumer<Context>> selectOther(Context ctx) throws OpProcessorException {
        return Optional.empty();
    }

    @Override
    public void close() throws Exception {
    }

    private void evalOp(Context context) throws OpProcessorException {
        if (logger.isDebugEnabled()) {
            RequestMessage msg = context.getRequestMessage();
            logger.debug("Sessionless request {} for eval in thread {}", (Object)msg.getRequestId(), (Object)Thread.currentThread().getName());
        }
        this.evalOpInternal(context, context::getGremlinExecutor, this.bindingMaker.apply(context));
    }

    protected Function<Context, AbstractEvalOpProcessor.BindingSupplier> getBindingMaker() {
        return context -> () -> {
            RequestMessage msg = context.getRequestMessage();
            SimpleBindings bindings = new SimpleBindings();
            if (msg.getArgs().containsKey("aliases")) {
                Map aliases = (Map)msg.getArgs().get("aliases");
                for (Map.Entry aliasKv : aliases.entrySet()) {
                    TraversalSource ts;
                    boolean found = false;
                    Graph graph = context.getGraphManager().getGraph((String)aliasKv.getValue());
                    if (null != graph) {
                        bindings.put((String)aliasKv.getKey(), (Object)graph);
                        found = true;
                    }
                    if (!found && null != (ts = context.getGraphManager().getTraversalSource((String)aliasKv.getValue()))) {
                        bindings.put((String)aliasKv.getKey(), (Object)ts);
                        found = true;
                    }
                    if (found) continue;
                    String error = String.format("Could not alias [%s] to [%s] as [%s] not in the Graph or TraversalSource global bindings", aliasKv.getKey(), aliasKv.getValue(), aliasKv.getValue());
                    throw new OpProcessorException(error, ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(error).create());
                }
            } else if (context.getSettings().strictTransactionManagement) {
                String error = "Gremlin Server is configured with strictTransactionManagement as 'true' - the 'aliases' arguments must be provided";
                throw new OpProcessorException("Gremlin Server is configured with strictTransactionManagement as 'true' - the 'aliases' arguments must be provided", ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage("Gremlin Server is configured with strictTransactionManagement as 'true' - the 'aliases' arguments must be provided").create());
            }
            Optional.ofNullable((Map)msg.getArgs().get("bindings")).ifPresent(bindings::putAll);
            return bindings;
        };
    }

    static {
        StandardOpProcessor.DEFAULT_SETTINGS.className = StandardOpProcessor.class.getCanonicalName();
        StandardOpProcessor.DEFAULT_SETTINGS.config = new HashMap<String, Object>(){
            {
                this.put("maxParameters", 16);
            }
        };
    }
}

