/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.op.session;

import com.codahale.metrics.MetricRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.script.Bindings;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.GremlinServer;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;
import org.apache.tinkerpop.gremlin.server.op.AbstractEvalOpProcessor;
import org.apache.tinkerpop.gremlin.server.op.OpProcessorException;
import org.apache.tinkerpop.gremlin.server.op.session.Session;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionOpProcessor
extends AbstractEvalOpProcessor {
    private static final Logger logger = LoggerFactory.getLogger(SessionOpProcessor.class);
    public static final String OP_PROCESSOR_NAME = "session";
    protected static ConcurrentHashMap<String, Session> sessions = new ConcurrentHashMap();
    public static final String CONFIG_SESSION_TIMEOUT = "sessionTimeout";
    public static final String CONFIG_PER_GRAPH_CLOSE_TIMEOUT = "perGraphCloseTimeout";
    public static final long DEFAULT_SESSION_TIMEOUT = 28800000L;
    public static final long DEFAULT_PER_GRAPH_CLOSE_TIMEOUT = 10000L;
    static final Settings.ProcessorSettings DEFAULT_SETTINGS;

    public SessionOpProcessor() {
        super(false);
    }

    @Override
    public String getName() {
        return OP_PROCESSOR_NAME;
    }

    @Override
    public void init(Settings settings) {
        this.maxParameters = (Integer)settings.optionalProcessor(SessionOpProcessor.class).orElse((Settings.ProcessorSettings)SessionOpProcessor.DEFAULT_SETTINGS).config.getOrDefault("maxParameters", 16);
    }

    @Override
    public Optional<ThrowingConsumer<Context>> selectOther(RequestMessage requestMessage) throws OpProcessorException {
        if (requestMessage.getOp().equals("close")) {
            if (!requestMessage.optionalArgs(OP_PROCESSOR_NAME).isPresent()) {
                String msg = String.format("A message with an [%s] op code requires a [%s] argument", "close", OP_PROCESSOR_NAME);
                throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)requestMessage).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
            }
            boolean force = requestMessage.optionalArgs("force").orElse(false);
            return Optional.of(ctx -> {
                Session sessionToClose = sessions.get(requestMessage.getArgs().get(OP_PROCESSOR_NAME).toString());
                if (null == sessionToClose) {
                    String msg = String.format("There was no session named %s to close", requestMessage.getArgs().get(OP_PROCESSOR_NAME).toString());
                    throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)requestMessage).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
                }
                sessionToClose.manualKill(force);
                ctx.getChannelHandlerContext().writeAndFlush((Object)ResponseMessage.build((RequestMessage)requestMessage).code(ResponseStatusCode.NO_CONTENT).create());
            });
        }
        return Optional.empty();
    }

    @Override
    public ThrowingConsumer<Context> getEvalOp() {
        return this::evalOp;
    }

    @Override
    protected Optional<ThrowingConsumer<Context>> validateEvalMessage(RequestMessage message) throws OpProcessorException {
        super.validateEvalMessage(message);
        if (!message.optionalArgs(OP_PROCESSOR_NAME).isPresent()) {
            String msg = String.format("A message with an [%s] op code requires a [%s] argument", "eval", OP_PROCESSOR_NAME);
            throw new OpProcessorException(msg, ResponseMessage.build((RequestMessage)message).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(msg).create());
        }
        return Optional.empty();
    }

    @Override
    public void close() throws Exception {
        sessions.values().forEach(Session::manualKill);
    }

    protected void evalOp(Context context) throws OpProcessorException {
        RequestMessage msg = context.getRequestMessage();
        Session session = SessionOpProcessor.getSession(context, msg);
        if (!session.acceptingRequests()) {
            String sessionClosedMessage = String.format("Session %s is no longer accepting requests as it has been closed", session.getSessionId());
            ResponseMessage response = ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.SERVER_ERROR).statusMessage(sessionClosedMessage).create();
            throw new OpProcessorException(sessionClosedMessage, response);
        }
        context.getChannelHandlerContext().channel().attr(StateKey.SESSION).set((Object)session);
        this.evalOpInternal(context, session::getGremlinExecutor, this.getBindingMaker(session).apply(context));
    }

    protected static Session getSession(Context context, RequestMessage msg) {
        String sessionId = (String)msg.getArgs().get(OP_PROCESSOR_NAME);
        logger.debug("In-session request {} for eval for session {} in thread {}", new Object[]{msg.getRequestId(), sessionId, Thread.currentThread().getName()});
        Session session = sessions.computeIfAbsent(sessionId, k -> new Session((String)k, context, sessions));
        session.touch();
        return session;
    }

    protected Function<Context, AbstractEvalOpProcessor.BindingSupplier> getBindingMaker(Session session) {
        return context -> () -> {
            String rebindingOrAliasParameter;
            RequestMessage msg = context.getRequestMessage();
            Bindings bindings = session.getBindings();
            boolean hasRebindings = msg.getArgs().containsKey("rebindings");
            boolean hasAliases = msg.getArgs().containsKey("aliases");
            if (hasRebindings && hasAliases) {
                String error = "Prefer use of the 'aliases' parameter over 'rebindings' and do not use both";
                throw new OpProcessorException("Prefer use of the 'aliases' parameter over 'rebindings' and do not use both", ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage("Prefer use of the 'aliases' parameter over 'rebindings' and do not use both").create());
            }
            String string = rebindingOrAliasParameter = hasRebindings ? "rebindings" : "aliases";
            if (msg.getArgs().containsKey(rebindingOrAliasParameter)) {
                Map aliases = (Map)msg.getArgs().get(rebindingOrAliasParameter);
                for (Map.Entry aliasKv : aliases.entrySet()) {
                    TraversalSource ts;
                    boolean found = false;
                    Graph graph = context.getGraphManager().getGraph((String)aliasKv.getValue());
                    if (null != graph) {
                        bindings.put((String)aliasKv.getKey(), (Object)graph);
                        found = true;
                    }
                    if (!found && null != (ts = context.getGraphManager().getTraversalSource((String)aliasKv.getValue()))) {
                        bindings.put((String)aliasKv.getKey(), (Object)ts);
                        found = true;
                    }
                    if (found) continue;
                    String error = String.format("Could not alias [%s] to [%s] as [%s] not in the Graph or TraversalSource global bindings", aliasKv.getKey(), aliasKv.getValue(), aliasKv.getValue());
                    throw new OpProcessorException(error, ResponseMessage.build((RequestMessage)msg).code(ResponseStatusCode.REQUEST_ERROR_INVALID_REQUEST_ARGUMENTS).statusMessage(error).create());
                }
            }
            Optional.ofNullable((Map)msg.getArgs().get("bindings")).ifPresent(bindings::putAll);
            return bindings;
        };
    }

    static {
        MetricManager.INSTANCE.getGuage(sessions::size, MetricRegistry.name(GremlinServer.class, (String[])new String[]{"sessions"}));
        DEFAULT_SETTINGS = new Settings.ProcessorSettings();
        SessionOpProcessor.DEFAULT_SETTINGS.className = SessionOpProcessor.class.getCanonicalName();
        SessionOpProcessor.DEFAULT_SETTINGS.config = new HashMap<String, Object>(){
            {
                this.put(SessionOpProcessor.CONFIG_SESSION_TIMEOUT, 28800000L);
                this.put(SessionOpProcessor.CONFIG_PER_GRAPH_CLOSE_TIMEOUT, 10000L);
                this.put("maxParameters", 16);
            }
        };
    }
}

