/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.op.session;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.groovy.engine.ScriptEngines;
import org.apache.tinkerpop.gremlin.jsr223.GremlinScriptEngine;
import org.apache.tinkerpop.gremlin.server.Context;
import org.apache.tinkerpop.gremlin.server.GraphManager;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.op.session.SessionOpProcessor;
import org.apache.tinkerpop.gremlin.server.util.LifeCycleHook;
import org.apache.tinkerpop.gremlin.server.util.MetricManager;
import org.apache.tinkerpop.gremlin.server.util.ThreadFactoryUtil;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    private static final Logger logger = LoggerFactory.getLogger(Session.class);
    private final Bindings bindings;
    private final Settings settings;
    private final GraphManager graphManager;
    private final String session;
    private final ScheduledExecutorService scheduledExecutorService;
    private final long configuredSessionTimeout;
    private final long configuredPerGraphCloseTimeout;
    private AtomicBoolean killing = new AtomicBoolean(false);
    private AtomicReference<ScheduledFuture> kill = new AtomicReference();
    private final GremlinExecutor gremlinExecutor;
    private final ThreadFactory threadFactoryWorker = ThreadFactoryUtil.create("session-%d");
    private final ExecutorService executor = Executors.newSingleThreadExecutor(this.threadFactoryWorker);
    private final ConcurrentHashMap<String, Session> sessions;

    public Session(String session, Context context, ConcurrentHashMap<String, Session> sessions) {
        logger.info("New session established for {}", (Object)session);
        this.session = session;
        this.bindings = new SimpleBindings();
        this.settings = context.getSettings();
        this.graphManager = context.getGraphManager();
        this.scheduledExecutorService = context.getScheduledExecutorService();
        this.sessions = sessions;
        Settings.ProcessorSettings processorSettings = this.settings.optionalProcessor(SessionOpProcessor.class).orElse(SessionOpProcessor.DEFAULT_SETTINGS);
        this.configuredSessionTimeout = Long.parseLong(processorSettings.config.getOrDefault("sessionTimeout", 28800000L).toString());
        this.configuredPerGraphCloseTimeout = Long.parseLong(processorSettings.config.getOrDefault("perGraphCloseTimeout", 10000L).toString());
        this.gremlinExecutor = this.initializeGremlinExecutor().create();
        this.settings.scriptEngines.keySet().forEach(engineName -> {
            try {
                this.gremlinExecutor.eval("1+1", engineName, Collections.emptyMap()).join();
                this.registerMetrics((String)engineName);
            }
            catch (Exception ex) {
                logger.warn(String.format("Could not initialize {} ScriptEngine as script could not be evaluated - %s", engineName), (Throwable)ex);
            }
        });
    }

    public GremlinExecutor getGremlinExecutor() {
        return this.gremlinExecutor;
    }

    public Bindings getBindings() {
        return this.bindings;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public String getSessionId() {
        return this.session;
    }

    public boolean acceptingRequests() {
        return !this.killing.get();
    }

    public void touch() {
        this.kill.updateAndGet(future -> {
            if (null == future || !future.isDone()) {
                if (future != null) {
                    future.cancel(false);
                }
                return this.scheduledExecutorService.schedule(() -> {
                    logger.info("Session {} has been idle for more than {} milliseconds - preparing to close", (Object)this.session, (Object)this.configuredSessionTimeout);
                    this.kill();
                }, this.configuredSessionTimeout, TimeUnit.MILLISECONDS);
            }
            return future;
        });
    }

    @Deprecated
    public void manualKill() {
        this.manualKill(false);
    }

    public void manualKill(boolean force) {
        this.kill.get().cancel(true);
        this.kill(force);
    }

    @Deprecated
    public synchronized void kill() {
        this.kill(false);
    }

    public synchronized void kill(boolean force) {
        this.killing.set(true);
        if (!this.sessions.containsKey(this.session)) {
            return;
        }
        if (!force) {
            this.graphManager.getGraphNames().forEach(gName -> {
                Graph g = this.graphManager.getGraph((String)gName);
                if (g.features().graph().supportsTransactions()) {
                    try {
                        this.executor.submit(() -> {
                            if (g.tx().isOpen()) {
                                logger.info("Rolling back open transactions on {} before killing session: {}", gName, (Object)this.session);
                                g.tx().rollback();
                            }
                        }).get(this.configuredPerGraphCloseTimeout, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception ex) {
                        logger.warn(String.format("An error occurred while attempting rollback on %s when closing session: %s", gName, this.session), (Throwable)ex);
                    }
                }
            });
        } else {
            logger.info("Skipped attempt to close open graph transactions on {} - close was forced", (Object)this.session);
        }
        this.executor.shutdownNow();
        this.sessions.remove(this.session);
        MetricManager.INSTANCE.getRegistry().removeMatching((s, metric) -> s.contains(this.session));
        logger.info("Session {} closed", (Object)this.session);
    }

    private GremlinExecutor.Builder initializeGremlinExecutor() {
        GremlinExecutor.Builder gremlinExecutorBuilder = GremlinExecutor.build().scriptEvaluationTimeout(this.settings.scriptEvaluationTimeout).afterTimeout(b -> {
            this.graphManager.rollbackAll();
            this.bindings.clear();
            this.bindings.putAll((Map<? extends String, ? extends Object>)b);
        }).afterSuccess(b -> {
            this.bindings.clear();
            this.bindings.putAll((Map<? extends String, ? extends Object>)b);
        }).enabledPlugins(new HashSet<String>(this.settings.plugins)).globalBindings(this.graphManager.getAsBindings()).executorService(this.executor).scheduledExecutorService(this.scheduledExecutorService);
        this.settings.scriptEngines.forEach((k, v) -> {
            if (v.plugins.isEmpty()) {
                v.imports.add(LifeCycleHook.class.getCanonicalName());
                v.imports.add(LifeCycleHook.Context.class.getCanonicalName());
                gremlinExecutorBuilder.addEngineSettings(k, v.imports, v.staticImports, v.scripts, v.config);
            } else {
                gremlinExecutorBuilder.addPlugins(k, v.plugins);
            }
        });
        return gremlinExecutorBuilder;
    }

    private void registerMetrics(String engineName) {
        ScriptEngines scriptEngines = this.gremlinExecutor.getScriptEngines();
        GremlinScriptEngine engine = null == scriptEngines ? this.gremlinExecutor.getScriptEngineManager().getEngineByName(engineName) : scriptEngines.getEngineByName(engineName);
        MetricManager.INSTANCE.registerGremlinScriptEngineMetrics(engine, engineName, "session", this.session, "class-cache");
    }
}

