/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy;

import groovy.grape.Grape;
import groovy.json.JsonBuilder;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.groovy.ImportCustomizerProvider;
import org.apache.tinkerpop.gremlin.groovy.function.GFunction;
import org.apache.tinkerpop.gremlin.groovy.loaders.GremlinLoader;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.computer.bulkloading.BulkLoaderVertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.clustering.peerpressure.PeerPressureVertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.ranking.pagerank.PageRankVertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.traversal.TraversalVertexProgram;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.process.traversal.Order;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Pop;
import org.apache.tinkerpop.gremlin.process.traversal.SackFunctions;
import org.apache.tinkerpop.gremlin.process.traversal.Scope;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.engine.ComputerTraversalEngine;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalOptionParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.event.Event;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.PartitionStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.finalization.ProfileStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.optimization.IdentityRemovalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.ReadOnlyStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalMetrics;
import org.apache.tinkerpop.gremlin.structure.Column;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.GraphReader;
import org.apache.tinkerpop.gremlin.structure.io.IoCore;
import org.apache.tinkerpop.gremlin.structure.io.graphml.GraphMLReader;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONReader;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoReader;
import org.apache.tinkerpop.gremlin.structure.util.GraphFactory;
import org.apache.tinkerpop.gremlin.structure.util.detached.DetachedElement;
import org.apache.tinkerpop.gremlin.util.Gremlin;
import org.apache.tinkerpop.gremlin.util.TimeUtil;
import org.apache.tinkerpop.gremlin.util.function.FunctionUtils;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public abstract class AbstractImportCustomizerProvider
implements ImportCustomizerProvider {
    protected static final String DOT_STAR = ".*";
    protected static final String EMPTY_STRING = "";
    protected static final String PERIOD = ".";
    protected final Set<String> extraImports = new HashSet<String>();
    protected final Set<String> extraStaticImports = new HashSet<String>();
    private static final Set<String> imports = new HashSet<String>();
    private static final Set<String> staticImports = new HashSet<String>();

    @Override
    public CompilationCustomizer create() {
        ImportCustomizer ic = new ImportCustomizer();
        AbstractImportCustomizerProvider.processImports(ic, imports);
        AbstractImportCustomizerProvider.processStaticImports(ic, staticImports);
        AbstractImportCustomizerProvider.processImports(ic, this.extraImports);
        AbstractImportCustomizerProvider.processStaticImports(ic, this.extraStaticImports);
        return ic;
    }

    @Override
    public Set<String> getImports() {
        return imports;
    }

    @Override
    public Set<String> getStaticImports() {
        return staticImports;
    }

    @Override
    public Set<String> getExtraImports() {
        return this.extraImports;
    }

    @Override
    public Set<String> getExtraStaticImports() {
        return this.extraStaticImports;
    }

    public Set<String> getAllImports() {
        HashSet<String> allImports = new HashSet<String>();
        allImports.addAll(imports);
        allImports.addAll(staticImports);
        allImports.addAll(this.extraImports);
        allImports.addAll(this.extraStaticImports);
        return allImports;
    }

    protected static void processStaticImports(ImportCustomizer ic, Set<String> staticImports) {
        for (String staticImport : staticImports) {
            if (staticImport.endsWith(DOT_STAR)) {
                ic.addStaticStars(new String[]{staticImport.replace(DOT_STAR, EMPTY_STRING)});
                continue;
            }
            int place = staticImport.lastIndexOf(PERIOD);
            ic.addStaticImport(staticImport.substring(0, place), staticImport.substring(place + 1));
        }
    }

    protected static void processImports(ImportCustomizer ic, Set<String> imports) {
        for (String imp : imports) {
            if (imp.endsWith(DOT_STAR)) {
                ic.addStarImports(new String[]{imp.replace(DOT_STAR, EMPTY_STRING)});
                continue;
            }
            ic.addImports(new String[]{imp});
        }
    }

    static {
        imports.add(Graph.class.getPackage().getName() + DOT_STAR);
        imports.add(GraphFactory.class.getPackage().getName() + DOT_STAR);
        imports.add(DetachedElement.class.getPackage().getName() + DOT_STAR);
        staticImports.add(T.class.getCanonicalName() + DOT_STAR);
        staticImports.add(Direction.class.getCanonicalName() + DOT_STAR);
        staticImports.add(VertexProperty.Cardinality.class.getCanonicalName() + DOT_STAR);
        imports.add(Traversal.class.getPackage().getName() + DOT_STAR);
        imports.add(GraphComputer.class.getPackage().getName() + DOT_STAR);
        imports.add(GraphTraversal.class.getPackage().getName() + DOT_STAR);
        imports.add(ComputerTraversalEngine.class.getPackage().getName() + DOT_STAR);
        imports.add(PartitionStrategy.class.getPackage().getName() + DOT_STAR);
        imports.add(IdentityRemovalStrategy.class.getPackage().getName() + DOT_STAR);
        imports.add(ProfileStrategy.class.getPackage().getName() + DOT_STAR);
        imports.add(ReadOnlyStrategy.class.getPackage().getName() + DOT_STAR);
        imports.add(Event.class.getPackage().getName() + DOT_STAR);
        staticImports.add(P.class.getCanonicalName() + DOT_STAR);
        staticImports.add(Order.class.getCanonicalName() + DOT_STAR);
        staticImports.add(Column.class.getCanonicalName() + DOT_STAR);
        staticImports.add(Operator.class.getCanonicalName() + DOT_STAR);
        staticImports.add(Scope.class.getCanonicalName() + DOT_STAR);
        staticImports.add(Pop.class.getCanonicalName() + DOT_STAR);
        staticImports.add(__.class.getCanonicalName() + DOT_STAR);
        staticImports.add(SackFunctions.Barrier.class.getCanonicalName() + DOT_STAR);
        staticImports.add(TraversalOptionParent.Pick.class.getCanonicalName() + DOT_STAR);
        staticImports.add(GraphTraversalSource.class.getCanonicalName() + DOT_STAR);
        imports.add(Gremlin.class.getPackage().getName() + DOT_STAR);
        imports.add(GremlinLoader.class.getPackage().getName() + DOT_STAR);
        imports.add(FunctionUtils.class.getPackage().getName() + DOT_STAR);
        imports.add(GFunction.class.getPackage().getName() + DOT_STAR);
        imports.add(TraversalMetrics.class.getPackage().getName() + DOT_STAR);
        staticImports.add(TimeUtil.class.getCanonicalName() + DOT_STAR);
        imports.add(GraphReader.class.getPackage().getName() + DOT_STAR);
        imports.add(GraphMLReader.class.getPackage().getName() + DOT_STAR);
        imports.add(GraphSONReader.class.getPackage().getName() + DOT_STAR);
        imports.add(GryoReader.class.getPackage().getName() + DOT_STAR);
        staticImports.add(IoCore.class.getCanonicalName() + DOT_STAR);
        imports.add(PeerPressureVertexProgram.class.getPackage().getName() + DOT_STAR);
        imports.add(PageRankVertexProgram.class.getPackage().getName() + DOT_STAR);
        imports.add(TraversalVertexProgram.class.getPackage().getName() + DOT_STAR);
        imports.add(BulkLoaderVertexProgram.class.getPackage().getName() + DOT_STAR);
        imports.add(Grape.class.getCanonicalName());
        imports.add(JsonBuilder.class.getPackage().getName() + DOT_STAR);
        imports.add(Configuration.class.getPackage().getName() + DOT_STAR);
    }
}

