/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.engine;

import com.carrotsearch.junitbenchmarks.BenchmarkOptions;
import com.carrotsearch.junitbenchmarks.BenchmarkRule;
import com.carrotsearch.junitbenchmarks.annotation.AxisRange;
import com.carrotsearch.junitbenchmarks.annotation.BenchmarkHistoryChart;
import com.carrotsearch.junitbenchmarks.annotation.BenchmarkMethodChart;
import com.carrotsearch.junitbenchmarks.annotation.LabelType;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.configuration.Configuration;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.groovy.engine.GremlinExecutor;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.rules.TestRule;

@AxisRange(min=0.0, max=1.0)
@BenchmarkMethodChart(filePrefix="gremlin-executor")
@BenchmarkHistoryChart(labelWith=LabelType.CUSTOM_KEY, maxRuns=20, filePrefix="hx-gremlin-executor")
@Deprecated
public class GremlinExecutorPerformanceTest
extends AbstractGremlinTest {
    private static final Random rand = new Random(9585834534L);
    private static final GremlinExecutor gremlinExecutor = GremlinExecutor.build().create();
    private GremlinGenerator generator;
    private Graph syntaxGraph = null;
    private Configuration syntaxGraphConfig = null;
    @Rule
    public TestRule benchmarkRun = new BenchmarkRule();
    @Rule
    public TestName testName = new TestName();
    public static final int DEFAULT_BENCHMARK_ROUNDS = 500;
    public static final int DEFAULT_WARMUP_ROUNDS = 10;

    public void setup() throws Exception {
        super.setup();
        this.syntaxGraphConfig = this.graphProvider.newGraphConfiguration("gremlin-executor-test", GremlinExecutorPerformanceTest.class, this.testName.getMethodName(), null);
        this.syntaxGraph = this.graphProvider.openTestGraph(this.syntaxGraphConfig);
        this.generator = new GremlinGenerator(this.syntaxGraph, rand);
    }

    public void tearDown() throws Exception {
        if (this.syntaxGraph != null) {
            this.graphProvider.clear(this.syntaxGraph, this.syntaxGraphConfig);
        }
        super.tearDown();
    }

    @BenchmarkOptions(benchmarkRounds=500, warmupRounds=10, concurrency=-1)
    @LoadGraphWith(value=LoadGraphWith.GraphData.GRATEFUL)
    @Test
    public void executorEval() throws Exception {
        HashMap<String, GraphTraversalSource> params = new HashMap<String, GraphTraversalSource>();
        params.put("g", this.g);
        String traversal = this.generator.generateGremlin();
        int resultsToNextOut = rand.nextInt(512) + 1;
        String nextedTraversal = traversal + ".next(" + resultsToNextOut + ")";
        CompletableFuture future1 = gremlinExecutor.eval(nextedTraversal, params);
        future1.join();
    }

    public static class GremlinGenerator {
        private final Random rand;
        private final Graph syntaxGraph;

        public GremlinGenerator(Graph syntaxGraph, Random rand) {
            this.rand = rand;
            this.syntaxGraph = syntaxGraph;
            GremlinGenerator.loadGraph(this.syntaxGraph);
        }

        public String generateGremlin() {
            int targetStepCount = this.rand.nextInt(10);
            StringBuilder sb = new StringBuilder("g.V()");
            Vertex start = (Vertex)this.syntaxGraph.traversal().V(new Object[0]).has("starter", (Object)true).order().by(this::shuffle).next();
            sb.append((String)start.value("step"));
            this.syntaxGraph.traversal().V(new Object[]{start}).times(targetStepCount - 1).repeat((Traversal)__.local((Traversal)__.outE((String[])new String[0]).has("weight", P.gte((Object)this.rand.nextDouble())).inV().order().by(this::shuffle).limit(1L)).sideEffect(t -> sb.append((String)((Vertex)t.get()).value("step")))).iterate();
            return sb.toString();
        }

        private int shuffle(Object o1, Object o2) {
            return this.rand.nextBoolean() ? -1 : 1;
        }

        private static void loadGraph(Graph syntaxGraph) {
            Vertex vOutStep = syntaxGraph.addVertex(new Object[]{"step", ".out()", "starter", true});
            Vertex vInStep = syntaxGraph.addVertex(new Object[]{"step", ".in()", "starter", true});
            Vertex vBothStep = syntaxGraph.addVertex(new Object[]{"step", ".both()", "starter", true});
            Vertex vInEStep = syntaxGraph.addVertex(new Object[]{"step", ".inE()", "starter", true});
            Vertex vOutEStep = syntaxGraph.addVertex(new Object[]{"step", ".outE()", "starter", true});
            Vertex vBothEStep = syntaxGraph.addVertex(new Object[]{"step", ".bothE()", "starter", true});
            Vertex vInVStep = syntaxGraph.addVertex(new Object[]{"step", ".inV()", "starter", false});
            Vertex vOutVStep = syntaxGraph.addVertex(new Object[]{"step", ".outV()", "starter", false});
            Vertex vOtherVStep = syntaxGraph.addVertex(new Object[]{"step", ".otherV()", "starter", false});
            vOutStep.addEdge("followedBy", vOutStep, new Object[]{"weight", 1.0});
            vOutStep.addEdge("followedBy", vInStep, new Object[]{"weight", 0.15});
            vOutStep.addEdge("followedBy", vBothStep, new Object[]{"weight", 0.15});
            vOutStep.addEdge("followedBy", vOutEStep, new Object[]{"weight", 0.75});
            vOutStep.addEdge("followedBy", vInEStep, new Object[]{"weight", 0.1});
            vOutStep.addEdge("followedBy", vBothEStep, new Object[]{"weight", 0.1});
            vInStep.addEdge("followedBy", vOutStep, new Object[]{"weight", 0.15});
            vInStep.addEdge("followedBy", vInStep, new Object[]{"weight", 1.0});
            vInStep.addEdge("followedBy", vBothStep, new Object[]{"weight", 0.15});
            vInStep.addEdge("followedBy", vOutEStep, new Object[]{"weight", 0.1});
            vInStep.addEdge("followedBy", vInEStep, new Object[]{"weight", 0.75});
            vInStep.addEdge("followedBy", vBothEStep, new Object[]{"weight", 0.1});
            vOtherVStep.addEdge("followedBy", vOutStep, new Object[]{"weight", 0.15});
            vOtherVStep.addEdge("followedBy", vInStep, new Object[]{"weight", 1.0});
            vOtherVStep.addEdge("followedBy", vBothStep, new Object[]{"weight", 0.15});
            vOtherVStep.addEdge("followedBy", vOutEStep, new Object[]{"weight", 0.1});
            vOtherVStep.addEdge("followedBy", vInEStep, new Object[]{"weight", 0.75});
            vOtherVStep.addEdge("followedBy", vBothEStep, new Object[]{"weight", 0.1});
            vBothStep.addEdge("followedBy", vOutStep, new Object[]{"weight", 1.0});
            vBothStep.addEdge("followedBy", vInStep, new Object[]{"weight", 1.0});
            vBothStep.addEdge("followedBy", vBothStep, new Object[]{"weight", 0.1});
            vBothStep.addEdge("followedBy", vOutEStep, new Object[]{"weight", 0.15});
            vBothStep.addEdge("followedBy", vInEStep, new Object[]{"weight", 0.15});
            vBothStep.addEdge("followedBy", vBothEStep, new Object[]{"weight", 0.1});
            vInEStep.addEdge("followedBy", vOutVStep, new Object[]{"weight", 1.0});
            vInEStep.addEdge("followedBy", vInVStep, new Object[]{"weight", 0.1});
            vOutEStep.addEdge("followedBy", vInVStep, new Object[]{"weight", 1.0});
            vInEStep.addEdge("followedBy", vOutVStep, new Object[]{"weight", 0.1});
            vBothEStep.addEdge("followedBy", vOtherVStep, new Object[]{"weight", 1.0});
            vInVStep.addEdge("followedBy", vOutStep, new Object[]{"weight", 1.0});
            vInVStep.addEdge("followedBy", vInStep, new Object[]{"weight", 0.25});
            vInVStep.addEdge("followedBy", vBothStep, new Object[]{"weight", 0.1});
            vInVStep.addEdge("followedBy", vOutEStep, new Object[]{"weight", 1.0});
            vInVStep.addEdge("followedBy", vInEStep, new Object[]{"weight", 0.25});
            vInVStep.addEdge("followedBy", vBothEStep, new Object[]{"weight", 0.1});
            vOutVStep.addEdge("followedBy", vOutStep, new Object[]{"weight", 0.25});
            vOutVStep.addEdge("followedBy", vInStep, new Object[]{"weight", 1.0});
            vOutVStep.addEdge("followedBy", vBothStep, new Object[]{"weight", 0.1});
            vOutVStep.addEdge("followedBy", vOutEStep, new Object[]{"weight", 0.25});
            vOutVStep.addEdge("followedBy", vInEStep, new Object[]{"weight", 1.0});
            vOutVStep.addEdge("followedBy", vBothEStep, new Object[]{"weight", 0.1});
        }
    }
}

