/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.groovy.jsr223;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.tinkerpop.gremlin.AbstractGremlinTest;
import org.apache.tinkerpop.gremlin.LoadGraphWith;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngine;
import org.apache.tinkerpop.gremlin.groovy.jsr223.GroovyTranslator;
import org.apache.tinkerpop.gremlin.process.traversal.Translator;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.SubgraphStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.decoration.TranslationStrategy;
import org.apache.tinkerpop.gremlin.process.traversal.strategy.verification.ReadOnlyStrategy;
import org.apache.tinkerpop.gremlin.util.function.Lambda;
import org.junit.Assert;
import org.junit.Test;

public class GroovyTranslatorTest
extends AbstractGremlinTest {
    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHandleStrategies() throws Exception {
        GraphTraversalSource g = this.graph.traversal();
        g = g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.create((Configuration)new MapConfiguration((Map)new HashMap<String, Object>(){
            {
                this.put("vertices", __.has((String)"name", (Object)"marko"));
            }
        }))});
        SimpleBindings bindings = new SimpleBindings();
        bindings.put("g", (Object)g);
        Traversal.Admin traversal = new GremlinGroovyScriptEngine().eval(g.V(new Object[0]).values(new String[]{"name"}).asAdmin().getBytecode(), (Bindings)bindings);
        Assert.assertEquals((Object)"marko", (Object)traversal.next());
        Assert.assertFalse((boolean)traversal.hasNext());
        traversal = new GremlinGroovyScriptEngine().eval(g.withoutStrategies(new Class[]{SubgraphStrategy.class}).V(new Object[0]).count().asAdmin().getBytecode(), (Bindings)bindings);
        Assert.assertEquals((Object)new Long(6L), (Object)traversal.next());
        Assert.assertFalse((boolean)traversal.hasNext());
        traversal = new GremlinGroovyScriptEngine().eval(g.withStrategies(new TraversalStrategy[]{SubgraphStrategy.create((Configuration)new MapConfiguration((Map)new HashMap<String, Object>(){
            {
                this.put("vertices", __.has((String)"name", (Object)"marko"));
            }
        })), ReadOnlyStrategy.instance()}).V(new Object[0]).values(new String[]{"name"}).asAdmin().getBytecode(), (Bindings)bindings);
        Assert.assertEquals((Object)"marko", (Object)traversal.next());
        Assert.assertFalse((boolean)traversal.hasNext());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldSupportStringSupplierLambdas() throws Exception {
        GraphTraversalSource g = this.graph.traversal();
        g = g.withStrategies(new TraversalStrategy[]{new TranslationStrategy((TraversalSource)g, (Translator)GroovyTranslator.of((String)"g"))});
        GraphTraversal.Admin t = g.withSideEffect("lengthSum", (Object)0).withSack((Object)1).V(new Object[0]).filter(Lambda.predicate((String)"it.get().label().equals('person')")).flatMap(Lambda.function((String)"it.get().vertices(Direction.OUT)")).map(Lambda.function((String)"it.get().value('name').length()")).sideEffect(Lambda.consumer((String)"{ x -> x.sideEffects(\"lengthSum\", x.<Integer>sideEffects('lengthSum') + x.get()) }")).order().by(Lambda.comparator((String)"a,b -> a <=> b")).sack(Lambda.biFunction((String)"{ a,b -> a + b }")).asAdmin();
        ArrayList<Object> sacks = new ArrayList<Object>();
        ArrayList<Object> lengths = new ArrayList<Object>();
        while (t.hasNext()) {
            Traverser.Admin traverser = t.nextTraverser();
            sacks.add(traverser.sack());
            lengths.add(traverser.get());
        }
        Assert.assertFalse((boolean)t.hasNext());
        Assert.assertEquals((long)6L, (long)lengths.size());
        Assert.assertEquals((long)3L, (long)((Integer)lengths.get(0)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)lengths.get(1)).intValue());
        Assert.assertEquals((long)3L, (long)((Integer)lengths.get(2)).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)lengths.get(3)).intValue());
        Assert.assertEquals((long)5L, (long)((Integer)lengths.get(4)).intValue());
        Assert.assertEquals((long)6L, (long)((Integer)lengths.get(5)).intValue());
        Assert.assertEquals((long)6L, (long)sacks.size());
        Assert.assertEquals((long)4L, (long)((Integer)sacks.get(0)).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)sacks.get(1)).intValue());
        Assert.assertEquals((long)4L, (long)((Integer)sacks.get(2)).intValue());
        Assert.assertEquals((long)5L, (long)((Integer)sacks.get(3)).intValue());
        Assert.assertEquals((long)6L, (long)((Integer)sacks.get(4)).intValue());
        Assert.assertEquals((long)7L, (long)((Integer)sacks.get(5)).intValue());
        Assert.assertEquals((long)24L, (long)((Number)t.getSideEffects().get("lengthSum")).intValue());
    }

    @Test
    @LoadGraphWith(value=LoadGraphWith.GraphData.MODERN)
    public void shouldHandleMaps() {
        GraphTraversalSource g = this.graph.traversal();
        String script = GroovyTranslator.of((String)"g").translate(g.V(new Object[0]).id().is((Object)new LinkedHashMap(){
            {
                this.put(3, "32");
                this.put(Arrays.asList(1, 2, 3.1), 4);
            }
        }).asAdmin().getBytecode());
        Assert.assertEquals((Object)script, (Object)"g.V().id().is([((int) 3):(\"32\"),([(int) 1, (int) 2, 3.1d]):((int) 4)])");
    }

    @Test
    public void shouldHaveValidToString() {
        Assert.assertEquals((Object)"translator[h:gremlin-groovy]", (Object)GroovyTranslator.of((String)"h").toString());
    }
}

