/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class ZonedDateTimeSerializer
extends SimpleTypeSerializer<ZonedDateTime> {
    public ZonedDateTimeSerializer() {
        super(DataType.ZONEDATETIME);
    }

    @Override
    protected ZonedDateTime readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        LocalDateTime ldt = context.readValue(buffer, LocalDateTime.class, false);
        ZoneOffset zo = context.readValue(buffer, ZoneOffset.class, false);
        return ZonedDateTime.of(ldt, zo);
    }

    @Override
    protected void writeValue(ZonedDateTime value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        context.writeValue(value.toLocalDateTime(), buffer, false);
        context.writeValue(value.getOffset(), buffer, false);
    }
}

