/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseResult;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatus;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;

public class ResponseMessageSerializer {
    public ResponseMessage readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        int version = buffer.readByte() & 0xFF;
        if (version >>> 7 != 1) {
            throw new SerializationException("The most significant bit should be set according to the format");
        }
        return ResponseMessage.build(context.readValue(buffer, UUID.class, true)).code(ResponseStatusCode.getFromValue(context.readValue(buffer, Integer.class, false))).statusMessage(context.readValue(buffer, String.class, true)).statusAttributes(context.readValue(buffer, Map.class, false)).responseMetaData(context.readValue(buffer, Map.class, false)).result(context.read(buffer)).create();
    }

    public void writeValue(ResponseMessage value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        ResponseResult result = value.getResult();
        ResponseStatus status = value.getStatus();
        buffer.writeByte(-127);
        context.writeValue(value.getRequestId(), buffer, true);
        context.writeValue(status.getCode().getValue(), buffer, false);
        context.writeValue(status.getMessage(), buffer, true);
        context.writeValue(status.getAttributes(), buffer, false);
        context.writeValue(result.getMeta(), buffer, false);
        context.write(result.getData(), buffer);
    }
}

