/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class OffsetDateTimeSerializer
extends SimpleTypeSerializer<OffsetDateTime> {
    public OffsetDateTimeSerializer() {
        super(DataType.OFFSETDATETIME);
    }

    @Override
    protected OffsetDateTime readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        LocalDateTime ldt = context.readValue(buffer, LocalDateTime.class, false);
        ZoneOffset zo = context.readValue(buffer, ZoneOffset.class, false);
        return OffsetDateTime.of(ldt, zo);
    }

    @Override
    protected void writeValue(OffsetDateTime value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        context.writeValue(value.toLocalDateTime(), buffer, false);
        context.writeValue(value.getOffset(), buffer, false);
    }
}

