/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.time.LocalTime;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class LocalTimeSerializer
extends SimpleTypeSerializer<LocalTime> {
    public LocalTimeSerializer() {
        super(DataType.LOCALTIME);
    }

    @Override
    protected LocalTime readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        return LocalTime.ofNanoOfDay(buffer.readLong());
    }

    @Override
    protected void writeValue(LocalTime value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        buffer.writeLong(value.toNanoOfDay());
    }
}

