/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary.types;

import io.netty.buffer.ByteBuf;
import java.math.BigInteger;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.DataType;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.driver.ser.binary.types.SimpleTypeSerializer;

public class BigIntegerSerializer
extends SimpleTypeSerializer<BigInteger> {
    public BigIntegerSerializer() {
        super(DataType.BIGINTEGER);
    }

    @Override
    protected BigInteger readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        byte[] bigIntBytes = new byte[buffer.readInt()];
        buffer.readBytes(bigIntBytes);
        return new BigInteger(bigIntBytes);
    }

    @Override
    protected void writeValue(BigInteger value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        byte[] twosComplement = value.toByteArray();
        buffer.writeInt(twosComplement.length).writeBytes(twosComplement);
    }
}

