/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser.binary;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.ser.SerializationException;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.driver.ser.binary.GraphBinaryWriter;

public class RequestMessageSerializer {
    public RequestMessage readValue(ByteBuf buffer, GraphBinaryReader context) throws SerializationException {
        int version = buffer.readByte() & 0xFF;
        if (version >>> 7 != 1) {
            throw new SerializationException("The most significant bit should be set according to the format");
        }
        UUID id = context.readValue(buffer, UUID.class, false);
        String op = context.readValue(buffer, String.class, false);
        String processor = context.readValue(buffer, String.class, false);
        RequestMessage.Builder builder = RequestMessage.build(op).overrideRequestId(id).processor(processor);
        Map args = context.readValue(buffer, Map.class, false);
        args.forEach(builder::addArg);
        return builder.create();
    }

    public void writeValue(RequestMessage value, ByteBuf buffer, GraphBinaryWriter context) throws SerializationException {
        buffer.writeByte(-127);
        context.writeValue(value.getRequestId(), buffer, false);
        context.writeValue(value.getOp(), buffer, false);
        context.writeValue(value.getProcessor(), buffer, false);
        context.writeValue(value.getArgs(), buffer, false);
    }
}

