/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.simple;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.tinkerpop.gremlin.driver.message.RequestMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseMessage;
import org.apache.tinkerpop.gremlin.driver.message.ResponseStatusCode;
import org.apache.tinkerpop.gremlin.driver.simple.SimpleClient;

public abstract class AbstractClient
implements SimpleClient {
    protected final CallbackResponseHandler callbackResponseHandler = new CallbackResponseHandler();
    protected final EventLoopGroup group;

    public AbstractClient(String threadPattern) {
        BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern(threadPattern).build();
        this.group = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors(), (ThreadFactory)threadFactory);
    }

    public abstract void writeAndFlush(RequestMessage var1) throws Exception;

    @Override
    public void submit(RequestMessage requestMessage, Consumer<ResponseMessage> callback) throws Exception {
        this.callbackResponseHandler.callback = callback;
        this.writeAndFlush(requestMessage);
    }

    @Override
    public List<ResponseMessage> submit(RequestMessage requestMessage) throws Exception {
        return this.submitAsync(requestMessage).get();
    }

    @Override
    public CompletableFuture<List<ResponseMessage>> submitAsync(RequestMessage requestMessage) throws Exception {
        ArrayList results = new ArrayList();
        CompletableFuture<List<ResponseMessage>> f = new CompletableFuture<List<ResponseMessage>>();
        this.callbackResponseHandler.callback = response -> {
            if (f.isDone()) {
                throw new RuntimeException("A terminating message was already encountered - no more messages should have been received");
            }
            results.add(response);
            if (!response.getStatus().getCode().equals((Object)ResponseStatusCode.PARTIAL_CONTENT)) {
                f.complete(results);
            }
        };
        this.writeAndFlush(requestMessage);
        return f;
    }

    static class CallbackResponseHandler
    extends SimpleChannelInboundHandler<ResponseMessage> {
        public Consumer<ResponseMessage> callback;

        CallbackResponseHandler() {
        }

        protected void channelRead0(ChannelHandlerContext channelHandlerContext, ResponseMessage response) throws Exception {
            this.callback.accept(response);
        }
    }
}

