/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.driver.ser;

import java.util.Map;
import org.apache.tinkerpop.gremlin.driver.ser.AbstractGryoMessageSerializerV1d0;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.VertexProperty;
import org.apache.tinkerpop.gremlin.structure.io.gryo.GryoMapper;
import org.apache.tinkerpop.gremlin.structure.util.reference.ReferenceFactory;
import org.apache.tinkerpop.shaded.kryo.Kryo;
import org.apache.tinkerpop.shaded.kryo.Serializer;
import org.apache.tinkerpop.shaded.kryo.io.Input;
import org.apache.tinkerpop.shaded.kryo.io.Output;

public class GryoLiteMessageSerializerV1d0
extends AbstractGryoMessageSerializerV1d0 {
    private static final String MIME_TYPE = "application/vnd.gremlin-v1.0+gryo-lite";
    private static final String MIME_TYPE_STRINGD = "application/vnd.gremlin-v1.0+gryo-lite-stringd";

    public GryoLiteMessageSerializerV1d0() {
        super(GryoLiteMessageSerializerV1d0.overrideWithLite(GryoMapper.build()).create());
    }

    public GryoLiteMessageSerializerV1d0(GryoMapper.Builder kryo) {
        super(GryoLiteMessageSerializerV1d0.overrideWithLite(kryo).create());
    }

    @Override
    public String[] mimeTypesSupported() {
        return new String[]{this.serializeToString ? MIME_TYPE_STRINGD : MIME_TYPE};
    }

    @Override
    GryoMapper.Builder configureBuilder(GryoMapper.Builder builder, Map<String, Object> config, Map<String, Graph> graphs) {
        return GryoLiteMessageSerializerV1d0.overrideWithLite(builder);
    }

    private static GryoMapper.Builder overrideWithLite(GryoMapper.Builder builder) {
        builder.addCustom(Edge.class, (Serializer)new EdgeLiteSerializer());
        builder.addCustom(Vertex.class, (Serializer)new VertexLiteSerializer());
        builder.addCustom(VertexProperty.class, (Serializer)new VertexPropertyLiteSerializer());
        builder.addCustom(Property.class, (Serializer)new PropertyLiteSerializer());
        builder.addCustom(Path.class, (Serializer)new PathLiteSerializer());
        return builder;
    }

    static final class PathLiteSerializer
    extends Serializer<Path> {
        PathLiteSerializer() {
        }

        public void write(Kryo kryo, Output output, Path path) {
            kryo.writeClassAndObject(output, (Object)ReferenceFactory.detach((Path)path));
        }

        public Path read(Kryo kryo, Input input, Class<Path> pathClass) {
            return (Path)kryo.readClassAndObject(input);
        }
    }

    static final class VertexPropertyLiteSerializer
    extends Serializer<VertexProperty> {
        VertexPropertyLiteSerializer() {
        }

        public void write(Kryo kryo, Output output, VertexProperty vertexProperty) {
            kryo.writeClassAndObject(output, (Object)ReferenceFactory.detach((VertexProperty)vertexProperty));
        }

        public VertexProperty read(Kryo kryo, Input input, Class<VertexProperty> vertexPropertyClass) {
            return (VertexProperty)kryo.readClassAndObject(input);
        }
    }

    static final class PropertyLiteSerializer
    extends Serializer<Property> {
        PropertyLiteSerializer() {
        }

        public void write(Kryo kryo, Output output, Property property) {
            kryo.writeClassAndObject(output, property instanceof VertexProperty ? ReferenceFactory.detach((VertexProperty)((VertexProperty)property)) : ReferenceFactory.detach((Property)property));
        }

        public Property read(Kryo kryo, Input input, Class<Property> propertyClass) {
            return (Property)kryo.readClassAndObject(input);
        }
    }

    static final class VertexLiteSerializer
    extends Serializer<Vertex> {
        VertexLiteSerializer() {
        }

        public void write(Kryo kryo, Output output, Vertex vertex) {
            kryo.writeClassAndObject(output, (Object)ReferenceFactory.detach((Vertex)vertex));
        }

        public Vertex read(Kryo kryo, Input input, Class<Vertex> vertexClass) {
            return (Vertex)kryo.readClassAndObject(input);
        }
    }

    static final class EdgeLiteSerializer
    extends Serializer<Edge> {
        EdgeLiteSerializer() {
        }

        public void write(Kryo kryo, Output output, Edge edge) {
            kryo.writeClassAndObject(output, (Object)ReferenceFactory.detach((Edge)edge));
        }

        public Edge read(Kryo kryo, Input input, Class<Edge> edgeClass) {
            Object o = kryo.readClassAndObject(input);
            return (Edge)o;
        }
    }
}

