/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.builders;

import java.util.Map;
import org.apache.tika.batch.builders.IContentHandlerFactoryBuilder;
import org.apache.tika.sax.BasicContentHandlerFactory;
import org.apache.tika.sax.ContentHandlerFactory;
import org.apache.tika.util.XMLDOMUtil;
import org.w3c.dom.Node;

public class DefaultContentHandlerFactoryBuilder
implements IContentHandlerFactoryBuilder {
    @Override
    public ContentHandlerFactory build(Node node, Map<String, String> runtimeAttributes) {
        Map<String, String> attributes = XMLDOMUtil.mapifyAttrs(node, runtimeAttributes);
        BasicContentHandlerFactory.HANDLER_TYPE type = null;
        String handlerTypeString = attributes.get("basicHandlerType");
        type = BasicContentHandlerFactory.parseHandlerType((String)handlerTypeString, (BasicContentHandlerFactory.HANDLER_TYPE)BasicContentHandlerFactory.HANDLER_TYPE.TEXT);
        int writeLimit = -1;
        String writeLimitString = attributes.get("writeLimit");
        if (writeLimitString != null) {
            try {
                writeLimit = Integer.parseInt(attributes.get("writeLimit"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new BasicContentHandlerFactory(type, writeLimit);
    }
}

